/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionType;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.ChangeAdapter;
import org.eclipse.buckminster.ui.editor.VersionDesignatorEvent;
import org.eclipse.buckminster.ui.editor.VersionDesignatorListener;
import org.eclipse.buckminster.ui.general.editor.simple.Widgetin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionFormat;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VersionDesignator
extends Widgetin {
    ChangeAdapter m_notifier = new ChangeAdapter(){

        protected void onChange(TypedEvent te) {
            VersionDesignatorEvent e = new VersionDesignatorEvent(VersionDesignator.this, te.widget, te.data);
            for (VersionDesignatorListener listener : VersionDesignator.this.m_listeners) {
                listener.modifyVersionDesignator(e);
            }
        }
    };
    private final Composite m_parentComposite;
    private final Label m_versionDsTypeLabel;
    private final Combo m_versionDsType;
    private final Label m_rangeLabel;
    private final Text m_fromVersion;
    private final Composite m_toComposite;
    private final StackLayout m_toStackLayout;
    private final Label m_toEmptyLabel;
    private final Text m_toVersion;
    private final Combo m_versionType;
    private final ArrayList<VersionDesignatorListener> m_listeners = new ArrayList();

    public VersionDesignator(Composite parent) {
        this(parent, false);
    }

    public VersionDesignator(Composite parent, boolean readOnly) {
        this.m_parentComposite = parent;
        this.m_versionDsTypeLabel = UiUtils.createGridLabel(this.m_parentComposite, Messages.designator_with_colon, 1, 0, 0);
        SelectionAdapter versionDSListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionDesignator.this.dsTypeIndexChanged(((Combo)e.getSource()).getSelectionIndex());
            }
        };
        this.m_versionDsType = UiUtils.createGridEnumCombo(this.m_parentComposite, 1, 0, DesignatorType.values(), readOnly, (SelectionListener)(readOnly ? null : versionDSListener), null, 76);
        this.m_versionDsType.addSelectionListener((SelectionListener)this.m_notifier);
        UiUtils.createEmptyLabel(this.m_parentComposite);
        this.m_rangeLabel = UiUtils.createGridLabel(this.m_parentComposite, Messages.version_with_colon, 1, 0, 0);
        this.m_fromVersion = UiUtils.createGridText(this.m_parentComposite, 1, 0, readOnly, 0, this.m_notifier);
        this.m_toComposite = new Composite(this.m_parentComposite, 0);
        this.m_toComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_toStackLayout = new StackLayout();
        this.m_toComposite.setLayout((Layout)this.m_toStackLayout);
        this.m_toEmptyLabel = UiUtils.createEmptyLabel(this.m_toComposite);
        this.m_toVersion = UiUtils.createGridText(this.m_toComposite, 1, 0, readOnly, 0, this.m_notifier);
        UiUtils.createGridLabel(this.m_parentComposite, Messages.type_with_colon, 1, 0, 0);
        this.m_versionType = UiUtils.createGridCombo(this.m_parentComposite, 1, 0, readOnly, null, null, 76);
        List knownTypes = VersionHelper.getKnownTypes();
        int idx = knownTypes.size();
        String[] versionTypes = new String[idx];
        while (--idx >= 0) {
            versionTypes[idx] = ((VersionType)knownTypes.get(idx)).getId();
        }
        this.m_versionType.setItems(versionTypes);
        this.m_versionType.select(this.m_versionType.indexOf("OSGi"));
        this.m_versionType.addSelectionListener((SelectionListener)this.m_notifier);
        UiUtils.createEmptyLabel(this.m_parentComposite);
        this.dsTypeIndexChanged(DesignatorType.GREATER_OR_EQUAL.ordinal());
    }

    public void addVersionDesignatorListener(VersionDesignatorListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public VersionRange getDirectVersionDesignator() throws CoreException {
        int vdIndex = this.m_versionDsType.getSelectionIndex();
        if (vdIndex < 0) {
            return null;
        }
        return DesignatorType.values()[vdIndex].createDesignator(this.getVersionType(), this.m_fromVersion, this.m_fromVersion, this.m_toVersion);
    }

    public Display getDisplay() {
        return this.m_parentComposite.getDisplay();
    }

    public VersionRange getVersionDesignator() {
        try {
            return this.getDirectVersionDesignator();
        }
        catch (CoreException e) {
            CorePlugin.getLogger().error((Throwable)e, e.getMessage(), new Object[0]);
            ErrorDialog.openError((Shell)this.m_parentComposite.getShell(), null, null, (IStatus)e.getStatus());
            return null;
        }
    }

    public Combo getVersionDsTypeCombo() {
        return this.m_versionDsType;
    }

    public Label getVersionDsTypeLabel() {
        return this.m_versionDsTypeLabel;
    }

    public String getVersionType() {
        int vtIndex = this.m_versionType.getSelectionIndex();
        return vtIndex < 0 ? null : this.m_versionType.getItem(vtIndex);
    }

    public void refreshValues(VersionRange versionDesignator) {
        if (versionDesignator != null) {
            String vds;
            DesignatorType dsType = versionDesignator.getMinimum().equals((Object)versionDesignator.getMaximum()) ? DesignatorType.EQUALS : (!(vds = versionDesignator.toString()).startsWith("[") && !vds.startsWith("(") && !vds.startsWith("raw:[") && !vds.startsWith("raw:(") ? DesignatorType.GREATER_OR_EQUAL : (versionDesignator.getIncludeMinimum() ? (versionDesignator.getIncludeMaximum() ? DesignatorType.RANGE_II : DesignatorType.RANGE_IE) : (versionDesignator.getIncludeMaximum() ? DesignatorType.RANGE_EI : DesignatorType.RANGE_EE)));
            this.m_versionDsType.select(dsType.ordinal());
            this.dsTypeIndexChanged(dsType.ordinal());
            if (versionDesignator.getFormat() == VersionFormat.OSGI_FORMAT) {
                this.m_fromVersion.setText(versionDesignator.getMinimum().toString());
                this.m_toVersion.setText(TextUtils.notNullString((Object)versionDesignator.getMaximum()));
            } else {
                this.m_fromVersion.setText(versionDesignator.getMinimum().getOriginal());
                Version maxVer = versionDesignator.getMaximum();
                if (maxVer == null) {
                    this.m_toVersion.setText("");
                } else {
                    this.m_toVersion.setText(TextUtils.notNullString((Object)maxVer.getOriginal()));
                }
            }
            this.m_versionType.select(this.m_versionType.indexOf(VersionHelper.getVersionType((VersionRange)versionDesignator).getId()));
        } else {
            this.m_fromVersion.setText("");
            this.m_toVersion.setText("");
            this.m_versionType.select(-1);
        }
    }

    public void removeVersionDesignatorListener(VersionDesignatorListener listener) {
        this.m_listeners.remove(listener);
    }

    public void setEnabled(boolean flag) {
        this.m_versionDsType.setEnabled(flag);
        this.m_fromVersion.setEnabled(flag);
        this.m_toVersion.setEnabled(flag);
        this.m_versionType.setEnabled(flag);
    }

    private void dsTypeIndexChanged(int idx) {
        Label toBe;
        if (idx < 0) {
            return;
        }
        Control current = this.m_toStackLayout.topControl;
        Object object = toBe = idx < 2 ? this.m_toEmptyLabel : this.m_toVersion;
        if (current != toBe) {
            if (current != null) {
                if (idx < 2) {
                    this.m_rangeLabel.setText(Messages.version_with_colon);
                } else {
                    this.m_rangeLabel.setText(Messages.from_to_with_colon);
                }
            }
            this.m_toStackLayout.topControl = toBe;
            this.m_toComposite.layout();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DesignatorType {
        EQUALS{

            public String toString() {
                return Messages.equal_to_version;
            }

            VersionRange createDesignator(String versionType, Text version, Text from, Text to) throws CoreException {
                Version tmp = VersionHelper.createVersion((String)versionType, (String)UiUtils.trimmedValue(version));
                return tmp == null ? null : VersionHelper.exactRange((Version)tmp);
            }
        }
        ,
        GREATER_OR_EQUAL{

            public String toString() {
                return Messages.grater_or_equal_to_version;
            }

            VersionRange createDesignator(String versionType, Text version, Text from, Text to) throws CoreException {
                Version tmp = VersionHelper.createVersion((String)versionType, (String)UiUtils.trimmedValue(version));
                return tmp == null ? null : VersionHelper.greaterOrEqualRange((Version)tmp);
            }
        }
        ,
        RANGE_IE{

            public String toString() {
                return Messages.from_incl_to_excl_version;
            }

            VersionRange createDesignator(String versionType, Text version, Text from, Text to) throws CoreException {
                return DesignatorType.createRange(from, to, versionType, '[', ')');
            }
        }
        ,
        RANGE_II{

            public String toString() {
                return Messages.from_incl_to_incl_version;
            }

            VersionRange createDesignator(String versionType, Text version, Text from, Text to) throws CoreException {
                return DesignatorType.createRange(from, to, versionType, '[', ']');
            }
        }
        ,
        RANGE_EE{

            public String toString() {
                return Messages.from_excl_to_excl_version;
            }

            VersionRange createDesignator(String versionType, Text version, Text from, Text to) throws CoreException {
                return DesignatorType.createRange(from, to, versionType, '(', ')');
            }
        }
        ,
        RANGE_EI{

            public String toString() {
                return Messages.from_excl_to_incl_version;
            }

            VersionRange createDesignator(String versionType, Text version, Text from, Text to) throws CoreException {
                return DesignatorType.createRange(from, to, versionType, '(', ']');
            }
        };


        static String[] getStrings() {
            DesignatorType[] dsTypes = DesignatorType.values();
            int idx = dsTypes.length;
            String[] strings = new String[idx];
            while (--idx >= 0) {
                strings[idx] = dsTypes[idx].toString();
            }
            return strings;
        }

        private static VersionRange createRange(Text from, Text to, String versionType, char start, char end) throws CoreException {
            String tmp = UiUtils.trimmedValue(from);
            String tmp2 = UiUtils.trimmedValue(to);
            if (tmp == null || tmp2 == null) {
                return null;
            }
            return VersionHelper.createRange((String)versionType, (String)(String.valueOf(start) + tmp + ',' + tmp2 + end));
        }

        abstract VersionRange createDesignator(String var1, Text var2, Text var3, Text var4) throws CoreException;
    }
}

