/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.cspec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.ActionArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisitesBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.UpToDatePolicy;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.EditorUtils;
import org.eclipse.buckminster.ui.editor.cspec.ArtifactsTable;
import org.eclipse.buckminster.ui.editor.cspec.AttributesTable;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditor;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditorUtils;
import org.eclipse.buckminster.ui.editor.cspec.PathWrapper;
import org.eclipse.buckminster.ui.editor.cspec.PathsTable;
import org.eclipse.buckminster.ui.editor.cspec.PrerequisitesTable;
import org.eclipse.buckminster.ui.editor.cspec.PropertiesTable;
import org.eclipse.buckminster.ui.editor.cspec.Property;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.simple.SimpleTableEditor;
import org.eclipse.buckminster.ui.general.editor.structured.FieldModifyEvent;
import org.eclipse.buckminster.ui.general.editor.structured.IFieldModifyListener;
import org.eclipse.buckminster.ui.general.editor.structured.TwoPagesTableEditor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionsTable
extends AttributesTable<ActionBuilder> {
    private Map<ActionBuilder, List<ActionArtifactBuilder>> m_actionArtifacts;
    private Text m_actorNameText;
    private Button m_alwaysCheck;
    private Button m_assignConsoleSupportCheck;
    private Text m_actionFilter;
    private Combo m_upToDatePolicy;
    private Text m_fileCountText;
    private Text m_additionalFileCountText;
    private Text m_prodAliasText;
    private Text m_prodBaseText;
    private List<Property> m_actorProperties = new ArrayList<Property>();
    private SimpleTableEditor<Property> m_actorPropertiesEditor;
    private Button m_pathsButton;
    private List<PathWrapper> m_productPaths = new ArrayList<PathWrapper>();
    private SimpleTableEditor<PathWrapper> m_productPathsEditor;
    private Button m_artifactsButton;
    private List<ArtifactBuilder> m_productArtifacts = new ArrayList<ArtifactBuilder>();
    private TwoPagesTableEditor<ArtifactBuilder> m_productArtifactsEditor;
    private List<Property> m_properties = new ArrayList<Property>();
    private SimpleTableEditor<Property> m_propertiesEditor;
    private Text m_prereqNameText;
    private Text m_prereqRebasePathText;
    private List<PrerequisiteBuilder> m_prerequisites = new ArrayList<PrerequisiteBuilder>();
    private SimpleTableEditor<PrerequisiteBuilder> m_prerequisitesEditor;

    public ActionsTable(CSpecEditor editor, List<ActionBuilder> data, Map<ActionBuilder, List<ActionArtifactBuilder>> actionArtifacts, CSpecBuilder cspec, boolean readOnly) {
        super(editor, data, cspec, readOnly);
        this.m_actionArtifacts = actionArtifacts;
    }

    @Override
    public void enableFields(boolean enabled) {
        super.enableFields(enabled);
        this.m_actorNameText.setEnabled(enabled);
        this.m_alwaysCheck.setEnabled(enabled);
        this.m_assignConsoleSupportCheck.setEnabled(enabled);
        this.m_actionFilter.setEnabled(enabled);
        this.m_upToDatePolicy.setEnabled(enabled);
        this.refreshFileCountFields();
        this.m_prodAliasText.setEnabled(enabled);
        this.m_prodBaseText.setEnabled(enabled);
        this.m_actorPropertiesEditor.setEnabled(enabled);
        this.m_pathsButton.setEnabled(enabled);
        this.m_productPathsEditor.setEnabled(enabled && this.m_pathsButton.getSelection());
        this.m_artifactsButton.setEnabled(enabled);
        this.m_productArtifactsEditor.setEnabled(enabled && this.m_artifactsButton.getSelection());
        this.m_propertiesEditor.setEnabled(enabled);
        this.m_prereqNameText.setEnabled(enabled);
        this.m_prereqRebasePathText.setEnabled(enabled);
        this.m_prerequisitesEditor.setEnabled(enabled);
    }

    @Override
    public void fillStack(Composite stackComposite) {
        this.addStackMapping(Messages.general, this.createGeneralStackLayer(stackComposite));
        this.addStackMapping(Messages.properties, this.createPropertiesStackLayer(stackComposite));
        this.addStackMapping(Messages.products, this.createProductsStackLayer(stackComposite));
        this.addStackMapping(Messages.documentation, this.createDocumentationStackLayer(stackComposite));
    }

    @Override
    protected ActionBuilder createNewRow() {
        return this.getCSpecBuilder().createActionBuilder();
    }

    @Override
    protected void refreshRow(ActionBuilder builder) {
        super.refreshRow(builder);
        this.m_actorNameText.setText(TextUtils.notNullString((Object)builder.getActorName()));
        this.m_alwaysCheck.setSelection(builder.isAlways());
        this.m_assignConsoleSupportCheck.setSelection(builder.isAssignConsoleSupport());
        this.m_actionFilter.setText(TextUtils.notNullString((Object)builder.getFilter()));
        this.m_upToDatePolicy.select(builder.getUpToDatePolicy().ordinal());
        switch (builder.getUpToDatePolicy()) {
            case COUNT: {
                this.m_fileCountText.setText(String.valueOf(builder.getProductFileCount()));
                this.m_additionalFileCountText.setText("");
                break;
            }
            case MAPPER: {
                this.m_fileCountText.setText("");
                this.m_additionalFileCountText.setText(String.valueOf(builder.getProductFileCount()));
                break;
            }
            default: {
                this.m_fileCountText.setText("");
                this.m_additionalFileCountText.setText("");
            }
        }
        this.refreshFileCountFields();
        this.m_prodAliasText.setText(TextUtils.notNullString((Object)builder.getProductAlias()));
        IPath prodBasePath = builder.getProductBase();
        this.m_prodBaseText.setText(TextUtils.notNullString((Object)(prodBasePath == null ? null : prodBasePath.toOSString())));
        CSpecEditorUtils.copyAndSortItems((Map<String, String>)builder.getActorProperties(), this.m_actorProperties);
        this.m_actorPropertiesEditor.refresh();
        CSpecEditorUtils.copyAndSortItems(builder.getProductPaths(), this.m_productPaths);
        this.m_productPathsEditor.refresh();
        CSpecEditorUtils.copyAndSortItems((Collection)this.m_actionArtifacts.get(builder), this.m_productArtifacts, CSpecEditorUtils.getAttributeComparator());
        this.createProductArtifactsCopy();
        this.m_productArtifactsEditor.refresh();
        this.chooseProductPathsButton(this.m_productPaths.size() > 0 || this.m_productArtifacts.size() == 0);
        CSpecEditorUtils.copyAndSortItems((Map<String, String>)builder.getProperties(), this.m_properties);
        this.m_propertiesEditor.refresh();
        PrerequisitesBuilder prereqBuilder = builder.getPrerequisitesBuilder();
        this.m_prereqNameText.setText(TextUtils.notNullString((Object)prereqBuilder.getName()));
        IPath rebasePath = prereqBuilder.getPrerequisiteRebase();
        this.m_prereqRebasePathText.setText(TextUtils.notNullString((Object)(rebasePath == null ? null : rebasePath.toOSString())));
        CSpecEditorUtils.copyAndSortItems(prereqBuilder.getPrerequisites(), this.m_prerequisites, CSpecEditorUtils.getPrerequisiteComparator());
        this.m_prerequisitesEditor.refresh();
    }

    @Override
    protected void setRowValues(ActionBuilder builder) throws ValidatorException {
        super.setRowValues(builder);
        builder.setActorName(UiUtils.trimmedValue(this.m_actorNameText));
        builder.setAlways(this.m_alwaysCheck.getSelection());
        builder.setAssignConsoleSupport(this.m_assignConsoleSupportCheck.getSelection());
        String filterStr = UiUtils.trimmedValue(this.m_actionFilter);
        if (filterStr != null) {
            try {
                builder.setFilter(FilterFactory.newInstance((String)filterStr));
            }
            catch (InvalidSyntaxException e) {
                throw new ValidatorException(e.getMessage());
            }
        } else {
            builder.setFilter(null);
        }
        builder.setUpToDatePolicy(UpToDatePolicy.values()[this.m_upToDatePolicy.getSelectionIndex()]);
        Text validFileCountField = null;
        switch (builder.getUpToDatePolicy()) {
            case COUNT: {
                validFileCountField = this.m_fileCountText;
                break;
            }
            case MAPPER: {
                validFileCountField = this.m_additionalFileCountText;
            }
        }
        String fileCount = UiUtils.trimmedValue(validFileCountField);
        if (fileCount != null) {
            try {
                builder.setProductFileCount(Integer.valueOf(fileCount).intValue());
            }
            catch (NumberFormatException e) {
                throw new ValidatorException(String.valueOf(Messages.invalid_number) + ": " + fileCount);
            }
        }
        builder.setProductAlias(UiUtils.trimmedValue(this.m_prodAliasText));
        String prodBasePathString = UiUtils.trimmedValue(this.m_prodBaseText);
        IPath prodBasePath = null;
        if (prodBasePathString != null) {
            prodBasePath = Path.fromOSString((String)prodBasePathString);
        }
        builder.setProductBase(prodBasePath);
        ExpandingProperties properties = builder.getActorProperties();
        if (properties != null) {
            properties.clear();
        }
        for (Property property : this.m_actorProperties) {
            builder.addActorProperty(property.getKey(), property.getValue(), true);
        }
        HashSet paths = builder.getProductPaths();
        if (paths != null) {
            paths.clear();
        }
        if (this.m_pathsButton.getSelection()) {
            for (PathWrapper path : this.m_productPaths) {
                IPath p = path.getPath();
                if (p == null) continue;
                builder.addProductPath(p);
            }
        }
        this.m_actionArtifacts.remove(builder);
        if (this.m_artifactsButton.getSelection() && this.m_productArtifacts.size() > 0) {
            ArrayList<ActionArtifactBuilder> list = new ArrayList<ActionArtifactBuilder>();
            for (ArtifactBuilder artifactBuilder : this.m_productArtifacts) {
                ((ActionArtifactBuilder)artifactBuilder).setActionName(builder.getName());
                list.add((ActionArtifactBuilder)artifactBuilder);
            }
            this.m_actionArtifacts.put(builder, list);
        }
        if ((properties = builder.getProperties()) != null) {
            properties.clear();
        }
        for (Property property : this.m_properties) {
            builder.addProperty(property.getKey(), property.getValue(), true);
        }
        PrerequisitesBuilder prereqBuilder = builder.getPrerequisitesBuilder();
        prereqBuilder.setName(UiUtils.trimmedValue(this.m_prereqNameText));
        String rebasePathString = UiUtils.trimmedValue(this.m_prereqRebasePathText);
        IPath rebasePath = null;
        if (rebasePathString != null) {
            rebasePath = Path.fromOSString((String)rebasePathString);
        }
        prereqBuilder.setPrerequisiteRebase(rebasePath);
        List prerequisites = prereqBuilder.getPrerequisites();
        if (prerequisites != null) {
            prerequisites.clear();
        }
        for (PrerequisiteBuilder prerequisite : this.m_prerequisites) {
            PrerequisiteBuilder newPrerequisite = prereqBuilder.createPrerequisiteBuilder();
            newPrerequisite.initFrom((IPrerequisite)prerequisite.createPrerequisite());
            try {
                prereqBuilder.addPrerequisite(newPrerequisite);
            }
            catch (PrerequisiteAlreadyDefinedException e) {
                throw new ValidatorException(e.getMessage());
            }
        }
    }

    void showProductArtifact(ArtifactBuilder builder) {
        ArtifactBuilder foundBuilder = null;
        for (ArtifactBuilder item : this.m_productArtifacts) {
            if (!item.getName().equals(builder.getName())) continue;
            foundBuilder = item;
            break;
        }
        if (foundBuilder != null) {
            this.m_productArtifactsEditor.setFocus();
            this.m_productArtifactsEditor.show(foundBuilder);
        }
    }

    private void chooseProductPathsButton(boolean choose) {
        this.m_pathsButton.setSelection(choose);
        this.m_artifactsButton.setSelection(!choose);
        if (this.m_pathsButton.getEnabled()) {
            this.enableProductPathsEditor(choose);
        }
    }

    private Control createGeneralStackLayer(Composite stackComposite) {
        Composite geComposite = new Composite(stackComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        geComposite.setLayout((Layout)layout);
        EditorUtils.createHeaderLabel(geComposite, Messages.general, 2);
        UiUtils.createGridLabel(geComposite, Messages.name_with_colon, 1, 0, 0);
        this.setNameText(UiUtils.createGridText(geComposite, 1, 0, this.isReadOnly(), 0));
        UiUtils.createGridLabel(geComposite, Messages.public_with_colon, 1, 0, 0);
        this.setPublicCheck(UiUtils.createCheckButton(geComposite, null, this.isReadOnly(), null));
        UiUtils.createGridLabel(geComposite, Messages.actor_name_with_colon, 1, 0, 0);
        this.m_actorNameText = UiUtils.createGridText(geComposite, 1, 0, this.isReadOnly(), 0);
        this.m_actorNameText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createGridLabel(geComposite, Messages.always_with_colon, 1, 0, 0);
        this.m_alwaysCheck = UiUtils.createCheckButton(geComposite, null, this.isReadOnly(), null);
        this.m_alwaysCheck.addSelectionListener((SelectionListener)this.FIELD_LISTENER);
        UiUtils.createGridLabel(geComposite, Messages.assign_console_support_with_colon, 1, 0, 0);
        this.m_assignConsoleSupportCheck = UiUtils.createCheckButton(geComposite, null, this.isReadOnly(), null);
        this.m_assignConsoleSupportCheck.addSelectionListener((SelectionListener)this.FIELD_LISTENER);
        UiUtils.createGridLabel(geComposite, Messages.filter_with_colon, 1, 0, 0);
        this.m_actionFilter = UiUtils.createGridText(geComposite, 1, 0, this.isReadOnly(), 0);
        this.m_actionFilter.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createGridLabel(geComposite, Messages.uptodate_policy, 1, 0, 0);
        this.m_upToDatePolicy = UiUtils.createGridEnumCombo(geComposite, 1, 0, UpToDatePolicy.values(), this.isReadOnly(), null, this.FIELD_LISTENER, 12);
        this.addFieldModifyListener(new IFieldModifyListener(){

            public void modifyField(FieldModifyEvent e) {
                if (e.getOriginalEvent() instanceof ModifyEvent && ((ModifyEvent)e.getOriginalEvent()).getSource() == ActionsTable.this.m_upToDatePolicy) {
                    ActionsTable.this.refreshFileCountFields();
                }
            }
        });
        this.m_fileCountText = UiUtils.createLabeledText(geComposite, Messages.file_count, this.isReadOnly(), 0);
        this.m_fileCountText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        this.m_additionalFileCountText = UiUtils.createLabeledText(geComposite, Messages.additional_file_count, this.isReadOnly(), 0);
        this.m_additionalFileCountText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createGridLabel(geComposite, Messages.prerequisites_alias_with_colon, 1, 0, 0);
        this.m_prereqNameText = UiUtils.createGridText(geComposite, 1, 0, this.isReadOnly(), 0);
        this.m_prereqNameText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createGridLabel(geComposite, Messages.prerequisites_rebase_path_with_colon, 1, 0, 0);
        this.m_prereqRebasePathText = UiUtils.createGridText(geComposite, 1, 0, this.isReadOnly(), 0);
        this.m_prereqRebasePathText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createEmptyLabel(geComposite);
        UiUtils.createEmptyLabel(geComposite);
        Label label = UiUtils.createGridLabel(geComposite, Messages.prerequisites_with_colon, 1, 0, 0);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        PrerequisitesTable preTable = new PrerequisitesTable(this.getCSpecEditor(), this, this.m_prerequisites, (TopLevelAttributeBuilder)this.createNewRow().getPrerequisitesBuilder(), this.isReadOnly());
        preTable.addTableModifyListener(this.FIELD_LISTENER);
        this.m_prerequisitesEditor = new SimpleTableEditor<PrerequisiteBuilder>(geComposite, preTable, null, Messages.action_prerequisite_with_dash, null, null, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.m_prerequisitesEditor.setLayoutData(gridData);
        geComposite.setData("focusControl", (Object)this.getNameText());
        return geComposite;
    }

    private void createProductArtifactsCopy() {
        int i = 0;
        while (i < this.m_productArtifacts.size()) {
            ActionArtifactBuilder builder = (ActionArtifactBuilder)this.m_productArtifacts.get(i);
            ActionArtifactBuilder newBuilder = this.getCSpecBuilder().createActionArtifactBuilder();
            newBuilder.initFrom((IAttribute)builder.createAttribute());
            this.m_productArtifacts.set(i, (ArtifactBuilder)newBuilder);
            ++i;
        }
    }

    private Control createProductsStackLayer(Composite stackComposite) {
        Composite composite = new Composite(stackComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        EditorUtils.createHeaderLabel(composite, Messages.products, 2);
        UiUtils.createGridLabel(composite, Messages.product_alias_with_colon, 1, 0, 0);
        this.m_prodAliasText = UiUtils.createGridText(composite, 1, 0, this.isReadOnly(), 0);
        this.m_prodAliasText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createGridLabel(composite, Messages.product_base_path_with_colon, 1, 0, 0);
        this.m_prodBaseText = UiUtils.createGridText(composite, 1, 0, this.isReadOnly(), 0);
        this.m_prodBaseText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createEmptyLabel(composite);
        UiUtils.createEmptyLabel(composite);
        this.m_pathsButton = new Button(composite, 16);
        this.m_pathsButton.setText(Messages.product_paths_with_colon);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.horizontalSpan = 2;
        this.m_pathsButton.setLayoutData((Object)gridData);
        this.m_pathsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionsTable.this.enableProductPathsEditor(true);
            }
        });
        PathsTable table = new PathsTable(this.m_productPaths, this.isReadOnly());
        table.addTableModifyListener(this.FIELD_LISTENER);
        this.m_productPathsEditor = new SimpleTableEditor<PathWrapper>(composite, table, null, Messages.action_product_path_with_dash, null, null, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.m_productPathsEditor.setLayoutData(gridData);
        UiUtils.createEmptyLabel(composite);
        UiUtils.createEmptyLabel(composite);
        this.m_artifactsButton = new Button(composite, 16);
        this.m_artifactsButton.setText(Messages.product_artifacts);
        gridData = new GridData(1, 1, false, false);
        gridData.horizontalSpan = 2;
        this.m_artifactsButton.setLayoutData((Object)gridData);
        this.m_artifactsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionsTable.this.enableProductPathsEditor(false);
            }
        });
        ArtifactsTable artifactsTable = new ArtifactsTable(this.getCSpecEditor(), this.m_productArtifacts, this.getCSpecBuilder(), this.isReadOnly()){

            protected ArtifactBuilder createNewRow() {
                return this.getCSpecBuilder().createActionArtifactBuilder();
            }
        };
        artifactsTable.addTableModifyListener(this.FIELD_LISTENER);
        this.m_productArtifactsEditor = new TwoPagesTableEditor<ArtifactBuilder>(composite, artifactsTable, false, null, Messages.action_product_artifact_with_dash, null, null, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.m_productArtifactsEditor.setLayoutData(gridData);
        composite.setData("focusControl", (Object)this.m_prodAliasText);
        return composite;
    }

    private Control createPropertiesStackLayer(Composite stackComposite) {
        Composite composite = new Composite(stackComposite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        EditorUtils.createHeaderLabel(composite, Messages.general_properties, 1);
        PropertiesTable table = new PropertiesTable(this.m_properties, this.isReadOnly());
        table.addTableModifyListener(this.FIELD_LISTENER);
        this.m_propertiesEditor = new SimpleTableEditor<Property>(composite, table, null, Messages.action_properties_with_dash, null, null, 0);
        UiUtils.createEmptyLabel(composite);
        EditorUtils.createHeaderLabel(composite, Messages.actor_properties, 1);
        table = new PropertiesTable(this.m_actorProperties, this.isReadOnly());
        table.addTableModifyListener(this.FIELD_LISTENER);
        this.m_actorPropertiesEditor = new SimpleTableEditor<Property>(composite, table, null, Messages.action_actor_properties_with_dash, null, null, 0);
        return composite;
    }

    private void enableProductPathsEditor(boolean enable) {
        this.m_productPathsEditor.setEnabled(enable);
        this.m_productArtifactsEditor.setEnabled(!enable);
    }

    private void refreshFileCountFields() {
        boolean fileCountEnabled = false;
        boolean additionalFileCountEnabled = false;
        if (this.m_upToDatePolicy.isEnabled()) {
            switch (UpToDatePolicy.values()[this.m_upToDatePolicy.getSelectionIndex()]) {
                case COUNT: {
                    fileCountEnabled = true;
                    break;
                }
                case MAPPER: {
                    additionalFileCountEnabled = true;
                }
            }
        }
        this.m_fileCountText.setEnabled(fileCountEnabled);
        this.m_additionalFileCountText.setEnabled(additionalFileCountEnabled);
    }
}

