/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.cspec;

import java.util.List;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.EditorUtils;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditor;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.structured.StructuredTable;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttributesTable<T extends TopLevelAttributeBuilder>
extends StructuredTable<T> {
    private static final String ERROR_MESSAGE_EMPTY_NAME = Messages.name_cannnot_be_empty;
    private CSpecEditor m_editor;
    private CSpecBuilder m_cspec;
    private Text m_nameText;
    private Button m_publicCheck;
    private Text m_documentationText;
    private T m_currentBuilder;

    public AttributesTable(CSpecEditor editor, List<T> data, CSpecBuilder cspec, boolean readOnly) {
        super(data, readOnly);
        this.m_editor = editor;
        this.m_cspec = cspec;
    }

    @Override
    public void enableFields(boolean enabled) {
        this.m_nameText.setEnabled(enabled);
        this.m_publicCheck.setEnabled(enabled);
        this.m_documentationText.setEnabled(enabled);
    }

    public CSpecEditor getCSpecEditor() {
        return this.m_editor;
    }

    public T getCurrentBuilder() {
        return this.m_currentBuilder;
    }

    @Override
    public String[] getTableViewerColumnHeaders() {
        return new String[]{Messages.name, Messages.public_label};
    }

    @Override
    public int[] getTableViewerColumnWeights() {
        return new int[]{80, 20};
    }

    @Override
    public Object getTableViewerField(T builder, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return builder.getName();
            }
            case 1: {
                return builder.isPublic();
            }
        }
        return null;
    }

    protected Control createDocumentationStackLayer(Composite stackComposite) {
        Composite docComposite = new Composite(stackComposite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        docComposite.setLayout((Layout)layout);
        EditorUtils.createHeaderLabel(docComposite, Messages.documentation, 1);
        this.m_documentationText = UiUtils.createGridText(docComposite, 1, 0, this.isReadOnly(), 2);
        this.m_documentationText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_documentationText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        docComposite.setData("focusControl", (Object)this.m_documentationText);
        return docComposite;
    }

    protected CSpecBuilder getCSpecBuilder() {
        return this.m_cspec;
    }

    protected Text getNameText() {
        return this.m_nameText;
    }

    @Override
    protected void refreshRow(T builder) {
        this.m_currentBuilder = builder;
        this.m_nameText.setText(TextUtils.notNullString((Object)builder.getName()));
        this.m_publicCheck.setSelection(builder.isPublic());
        Documentation doc = builder.getDocumentation();
        this.m_documentationText.setText(TextUtils.notNullString((Object)(doc == null ? null : doc.toString())));
    }

    protected void setNameText(Text nameText) {
        this.m_nameText = nameText;
        this.m_nameText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
    }

    protected void setPublicCheck(Button publicCheck) {
        this.m_publicCheck = publicCheck;
        this.m_publicCheck.addSelectionListener((SelectionListener)this.FIELD_LISTENER);
    }

    @Override
    protected void setRowValues(T builder) throws ValidatorException {
        if (UiUtils.trimmedValue(this.m_nameText) == null) {
            throw new ValidatorException(ERROR_MESSAGE_EMPTY_NAME);
        }
        builder.setName(UiUtils.trimmedValue(this.m_nameText));
        builder.setPublic(this.m_publicCheck.getSelection());
        String doc = UiUtils.trimmedValue(this.m_documentationText);
        try {
            builder.setDocumentation(doc == null ? null : Documentation.parse((String)doc));
        }
        catch (Exception e) {
            throw new ValidatorException(e.getMessage());
        }
    }
}

