/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.cspec;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.builder.ActionArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.GeneratorBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.model.AttributeAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.GeneratorAlreadyDefinedException;
import org.eclipse.buckminster.core.ctype.AbstractComponentType;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.parser.IParser;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.SaveRunnable;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.ArtifactType;
import org.eclipse.buckminster.ui.editor.EditorUtils;
import org.eclipse.buckminster.ui.editor.IDerivedEditorInput;
import org.eclipse.buckminster.ui.editor.cspec.ActionsTable;
import org.eclipse.buckminster.ui.editor.cspec.AllAttributesView;
import org.eclipse.buckminster.ui.editor.cspec.ArtifactsTable;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditorUtils;
import org.eclipse.buckminster.ui.editor.cspec.DependenciesTable;
import org.eclipse.buckminster.ui.editor.cspec.GeneratorsTable;
import org.eclipse.buckminster.ui.editor.cspec.GroupsTable;
import org.eclipse.buckminster.ui.general.editor.ITableModifyListener;
import org.eclipse.buckminster.ui.general.editor.TableModifyEvent;
import org.eclipse.buckminster.ui.general.editor.simple.SimpleTableEditor;
import org.eclipse.buckminster.ui.general.editor.structured.FieldModifyEvent;
import org.eclipse.buckminster.ui.general.editor.structured.IActivator;
import org.eclipse.buckminster.ui.general.editor.structured.IFieldModifyListener;
import org.eclipse.buckminster.ui.general.editor.structured.OnePageTableEditor;
import org.eclipse.buckminster.ui.internal.CSpecEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.EditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSpecEditor
extends EditorPart
implements IEditorMatchingStrategy {
    private static final String SAVEABLE_CSPEC_NAME = "buckminster.cspec";
    private CSpecBuilder m_cspec;
    private List<ActionBuilder> m_actionBuilders = new ArrayList<ActionBuilder>();
    private Map<ActionBuilder, List<ActionArtifactBuilder>> m_actionArtifactBuilders = new HashMap<ActionBuilder, List<ActionArtifactBuilder>>();
    private List<ArtifactBuilder> m_artifactBuilders = new ArrayList<ArtifactBuilder>();
    private List<GroupBuilder> m_groupBuilders = new ArrayList<GroupBuilder>();
    private List<ComponentRequestBuilder> m_dependencyBuilders = new ArrayList<ComponentRequestBuilder>();
    private List<GeneratorBuilder> m_generatorBuilders = new ArrayList<GeneratorBuilder>();
    private CompoundModifyListener m_compoundModifyListener;
    private boolean m_hasChanges = false;
    private boolean m_mute = false;
    private boolean m_needsRefresh = false;
    private boolean m_readOnly = true;
    private CTabFolder m_tabFolder;
    private CTabItem m_mainTab;
    private CTabItem m_actionsTab;
    private CTabItem m_artifactsTab;
    private CTabItem m_groupsTab;
    private CTabItem m_attributesTab;
    private CTabItem m_dependenciesTab;
    private CTabItem m_generatorsTab;
    private CTabItem m_documentationTab;
    private CTabItem m_xmlTab;
    private Text m_componentName;
    private Combo m_componentType;
    private Text m_versionString;
    private Combo m_versionType;
    private ActionsTable m_actionsTable;
    private OnePageTableEditor<ActionBuilder> m_actionsEditor;
    private OnePageTableEditor<ArtifactBuilder> m_artifactsEditor;
    private OnePageTableEditor<GroupBuilder> m_groupsEditor;
    private AllAttributesView m_attributesView;
    private SimpleTableEditor<ComponentRequestBuilder> m_dependenciesEditor;
    private SimpleTableEditor<GeneratorBuilder> m_generatorsEditor;
    private Text m_shortDesc;
    private Text m_documentation;
    private Text m_xml;
    private Button m_externalSaveAsButton;

    public void createPartControl(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        topComposite.setLayout((Layout)layout);
        this.m_tabFolder = new CTabFolder(topComposite, 1024);
        this.m_tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_mainTab = new CTabItem(this.m_tabFolder, 0);
        this.m_mainTab.setText(Messages.main);
        this.m_mainTab.setControl(this.getMainTabControl(this.m_tabFolder));
        this.m_mainTab.setData((Object)CSpecEditorTab.MAIN);
        this.m_actionsTab = new CTabItem(this.m_tabFolder, 0);
        this.m_actionsTab.setText(Messages.actions);
        this.m_actionsTab.setControl(this.getActionsTabControl((Composite)this.m_tabFolder));
        this.m_actionsTab.setData((Object)CSpecEditorTab.ACTIONS);
        this.m_artifactsTab = new CTabItem(this.m_tabFolder, 0);
        this.m_artifactsTab.setText(Messages.artifacts);
        this.m_artifactsTab.setControl(this.getArtifactsTabControl((Composite)this.m_tabFolder));
        this.m_artifactsTab.setData((Object)CSpecEditorTab.ARTIFACTS);
        this.m_groupsTab = new CTabItem(this.m_tabFolder, 0);
        this.m_groupsTab.setText(Messages.groups);
        this.m_groupsTab.setControl(this.getGroupsTabControl((Composite)this.m_tabFolder));
        this.m_groupsTab.setData((Object)CSpecEditorTab.GROUPS);
        this.m_attributesTab = new CTabItem(this.m_tabFolder, 0);
        this.m_attributesTab.setText(Messages.all_attributes);
        this.m_attributesTab.setControl(this.getAttributesTabControl((Composite)this.m_tabFolder));
        this.m_attributesTab.setData((Object)CSpecEditorTab.ATTRIBUTES);
        this.m_dependenciesTab = new CTabItem(this.m_tabFolder, 0);
        this.m_dependenciesTab.setText(Messages.dependencies);
        this.m_dependenciesTab.setControl(this.getDependenciesTabControl((Composite)this.m_tabFolder));
        this.m_dependenciesTab.setData((Object)CSpecEditorTab.DEPENDENCIES);
        this.m_generatorsTab = new CTabItem(this.m_tabFolder, 0);
        this.m_generatorsTab.setText(Messages.generators);
        this.m_generatorsTab.setControl(this.getGeneratorsTabControl((Composite)this.m_tabFolder));
        this.m_generatorsTab.setData((Object)CSpecEditorTab.GENERATORS);
        this.m_documentationTab = new CTabItem(this.m_tabFolder, 0);
        this.m_documentationTab.setText(Messages.documentation);
        this.m_documentationTab.setControl(this.getDocumentationTabControl((Composite)this.m_tabFolder));
        this.m_documentationTab.setData((Object)CSpecEditorTab.DOCUMENTATION);
        this.m_xmlTab = new CTabItem(this.m_tabFolder, 0);
        this.m_xmlTab.setText(Messages.xml_content);
        this.m_xmlTab.setControl(this.getXMLTabControl((Composite)this.m_tabFolder));
        this.m_xmlTab.setData((Object)CSpecEditorTab.XML);
        this.m_tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private final IActivator ACTIONS_ACTIVATOR = new IActivator(){

                public void activate() {
                    CSpecEditor.this.switchTab(CSpecEditorTab.ACTIONS);
                }
            };
            private final IActivator ARTIFACTS_ACTIVATOR = new IActivator(){

                public void activate() {
                    CSpecEditor.this.switchTab(CSpecEditorTab.ARTIFACTS);
                }
            };
            private final IActivator GROUPS_ACTIVATOR = new IActivator(){

                public void activate() {
                    CSpecEditor.this.switchTab(CSpecEditorTab.GROUPS);
                }
            };
            private CTabItem m_lastTab;
            {
                this.m_lastTab = CSpecEditor.this.m_mainTab;
            }

            public void widgetSelected(SelectionEvent e) {
                if (this.m_lastTab != e.item) {
                    if (this.m_lastTab == CSpecEditor.this.m_actionsTab && !CSpecEditor.this.m_actionsEditor.save(this.ACTIONS_ACTIVATOR)) {
                        return;
                    }
                    if (this.m_lastTab == CSpecEditor.this.m_artifactsTab && !CSpecEditor.this.m_artifactsEditor.save(this.ARTIFACTS_ACTIVATOR)) {
                        return;
                    }
                    if (this.m_lastTab == CSpecEditor.this.m_groupsTab && !CSpecEditor.this.m_groupsEditor.save(this.GROUPS_ACTIVATOR)) {
                        return;
                    }
                }
                if (CSpecEditor.this.m_mainTab == e.item) {
                    CSpecEditor.this.m_componentName.setFocus();
                } else if (CSpecEditor.this.m_actionsTab == e.item) {
                    CSpecEditor.this.m_actionsEditor.setFocus();
                } else if (CSpecEditor.this.m_artifactsTab == e.item) {
                    CSpecEditor.this.m_artifactsEditor.setFocus();
                } else if (CSpecEditor.this.m_groupsTab == e.item) {
                    CSpecEditor.this.m_groupsEditor.setFocus();
                } else if (CSpecEditor.this.m_attributesTab == e.item) {
                    CSpecEditor.this.m_attributesView.setFocus();
                } else if (CSpecEditor.this.m_dependenciesTab == e.item) {
                    CSpecEditor.this.m_dependenciesEditor.setFocus();
                } else if (CSpecEditor.this.m_generatorsTab == e.item) {
                    CSpecEditor.this.m_generatorsEditor.setFocus();
                } else if (CSpecEditor.this.m_documentationTab == e.item) {
                    CSpecEditor.this.m_shortDesc.setFocus();
                } else if (CSpecEditor.this.m_xmlTab == e.item) {
                    if (!CSpecEditor.this.commitChanges()) {
                        MessageDialog.openWarning((Shell)CSpecEditor.this.getSite().getShell(), null, (String)Messages.xml_content_was_not_updated_due_to_errors);
                    } else {
                        CSpecEditor.this.m_xml.setText(CSpecEditor.this.getCSpecXML());
                    }
                }
                this.m_lastTab = (CTabItem)e.item;
            }
        });
        this.createActionButtons(topComposite);
    }

    public void doExternalSaveAs() {
        if (!this.commitChanges()) {
            return;
        }
        FileDialog dlg = new FileDialog(this.getSite().getShell(), 8192);
        dlg.setFilterExtensions(new String[]{"*.cspec"});
        String location = dlg.open();
        if (location == null) {
            return;
        }
        this.saveToPath((IPath)new Path(location));
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.commitChanges()) {
            return;
        }
        IEditorInput input = this.getEditorInput();
        if (input == null) {
            return;
        }
        IPath path = input instanceof ILocationProvider ? ((ILocationProvider)input).getPath((Object)input) : ((IPathEditorInput)input).getPath();
        this.saveToPath(path);
    }

    public void doSaveAs() {
        IFile original;
        if (!this.commitChanges()) {
            return;
        }
        IEditorInput input = this.getEditorInput();
        if (input == null) {
            return;
        }
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getShell());
        IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        if (original != null) {
            dialog.setOriginalFile(original);
        }
        if (dialog.open() == 1) {
            return;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        this.saveToPath(file.getLocation());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof ILocationProvider || input instanceof IPathEditorInput || input instanceof IURIEditorInput || input instanceof CSpecEditorInput)) {
            throw new PartInitException(Messages.invalid_input);
        }
        this.setSite((IWorkbenchPartSite)site);
        if (input instanceof IURIEditorInput) {
            try {
                input = EditorUtils.getExternalFileEditorInput((IURIEditorInput)input, ArtifactType.CSPEC);
            }
            catch (Exception e) {
                throw new PartInitException(Messages.unable_to_open_editor, (Throwable)e);
            }
        }
        FileInputStream stream = null;
        try {
            try {
                this.m_cspec = new CSpecBuilder();
                if (input instanceof CSpecEditorInput) {
                    this.m_readOnly = true;
                    this.m_cspec.initFrom(((CSpecEditorInput)input).getCSpec());
                } else {
                    IPath path = input instanceof ILocationProvider ? ((ILocationProvider)input).getPath(input) : ((IPathEditorInput)input).getPath();
                    this.m_readOnly = !SAVEABLE_CSPEC_NAME.equalsIgnoreCase(path.lastSegment());
                    File file = path.toFile();
                    if (file.length() != 0L) {
                        String systemId = file.toString();
                        stream = new FileInputStream(file);
                        IParser parser = CorePlugin.getDefault().getParserFactory().getCSpecParser(true);
                        this.m_cspec.initFrom((ICSpecData)parser.parse(systemId, (InputStream)stream));
                    }
                }
                this.m_needsRefresh = true;
                if (this.m_componentName != null) {
                    this.refreshValues();
                }
                this.setInputWithNotify((IEditorInput)input);
                this.setPartName(String.valueOf(input.getName()) + (this.m_readOnly ? Messages.read_only_in_paranthesis : ""));
            }
            catch (Exception e) {
                throw new PartInitException(BuckminsterException.wrap((Throwable)e).getMessage());
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(stream);
            throw throwable;
        }
        IOUtils.close((Closeable)stream);
        this.m_compoundModifyListener = new CompoundModifyListener();
    }

    public boolean isDirty() {
        return this.m_hasChanges;
    }

    public boolean isSaveAsAllowed() {
        return !this.m_readOnly;
    }

    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        IEditorInput editorInput;
        IEditorPart part = (IEditorPart)editorRef.getPart(false);
        if (part != null && (editorInput = part.getEditorInput()) != null) {
            IEditorInput originalEditorInput;
            if (editorInput.equals(input)) {
                return true;
            }
            if (editorInput instanceof IDerivedEditorInput && (originalEditorInput = ((IDerivedEditorInput)editorInput).getOriginalInput()).equals(input)) {
                return true;
            }
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        this.m_componentName.setEnabled(enabled);
        this.m_componentType.setEnabled(enabled);
        this.m_versionString.setEnabled(enabled);
        this.m_versionType.setEnabled(enabled);
        this.m_actionsEditor.setEnabled(enabled);
        this.m_artifactsEditor.setEnabled(enabled);
        this.m_groupsEditor.setEnabled(enabled);
        this.m_dependenciesEditor.setEnabled(enabled);
        this.m_generatorsEditor.setEnabled(enabled);
        this.m_shortDesc.setEnabled(enabled);
        this.m_documentation.setEnabled(enabled);
    }

    public void setFocus() {
        this.m_tabFolder.setFocus();
        if (this.m_needsRefresh) {
            this.refreshValues();
        }
    }

    Map<ActionBuilder, List<ActionArtifactBuilder>> getActionArtifactBuilders() {
        return this.m_actionArtifactBuilders;
    }

    List<ActionBuilder> getActionBuilders() {
        return this.m_actionBuilders;
    }

    OnePageTableEditor<ActionBuilder> getActionsEditor() {
        return this.m_actionsEditor;
    }

    ActionsTable getActionsTable() {
        return this.m_actionsTable;
    }

    List<ArtifactBuilder> getArtifactBuilders() {
        return this.m_artifactBuilders;
    }

    OnePageTableEditor<ArtifactBuilder> getArtifactsEditor() {
        return this.m_artifactsEditor;
    }

    String[] getAttributeNames(String excludeName) {
        ArrayList<String> nameList = new ArrayList<String>();
        for (ActionBuilder actionBuilder : this.m_actionBuilders) {
            if (actionBuilder.getName() == null) continue;
            nameList.add(actionBuilder.getName());
        }
        for (List list : this.m_actionArtifactBuilders.values()) {
            for (ActionArtifactBuilder builder : list) {
                nameList.add(builder.getName());
            }
        }
        for (ArtifactBuilder artifactBuilder : this.m_artifactBuilders) {
            if (artifactBuilder.getName() == null) continue;
            nameList.add(artifactBuilder.getName());
        }
        for (GroupBuilder groupBuilder : this.m_groupBuilders) {
            if (groupBuilder.getName() == null) continue;
            nameList.add(groupBuilder.getName());
        }
        if (excludeName != null) {
            nameList.remove(excludeName);
        }
        String[] stringArray = nameList.toArray(new String[0]);
        Arrays.sort(stringArray, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        return stringArray;
    }

    String[] getComponentNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (ComponentRequestBuilder builder : this.m_dependencyBuilders) {
            if (builder.getName() == null) continue;
            list.add(builder.getName());
        }
        String[] array = list.toArray(new String[0]);
        Arrays.sort(array, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        return array;
    }

    ComponentRequestBuilder getDependencyBuilder(String componentName) {
        if (componentName == null) {
            return null;
        }
        for (ComponentRequestBuilder builder : this.m_dependencyBuilders) {
            if (!componentName.equals(builder.getName())) continue;
            return builder;
        }
        return null;
    }

    List<ComponentRequestBuilder> getDependencyBuilders() {
        return this.m_dependencyBuilders;
    }

    List<GeneratorBuilder> getGeneratorBuilders() {
        return this.m_generatorBuilders;
    }

    List<GroupBuilder> getGroupBuilders() {
        return this.m_groupBuilders;
    }

    OnePageTableEditor<GroupBuilder> getGroupsEditor() {
        return this.m_groupsEditor;
    }

    void switchTab(CSpecEditorTab tab) {
        this.m_tabFolder.setSelection(tab.getSeqNum());
    }

    private void addToActionArtifactBuilderMap(ActionArtifactBuilder actionArtifactbuilder) {
        if (actionArtifactbuilder.getActionName() == null) {
            return;
        }
        ActionBuilder actionBuilder = this.findActionBuilder(actionArtifactbuilder.getActionName());
        if (actionBuilder != null) {
            List<ActionArtifactBuilder> list = this.m_actionArtifactBuilders.get(actionBuilder);
            if (list == null) {
                list = new ArrayList<ActionArtifactBuilder>();
                this.m_actionArtifactBuilders.put(actionBuilder, list);
            }
            list.add(actionArtifactbuilder);
        }
    }

    private boolean commitChanges() {
        if (this.m_actionsEditor.isVisible() && !this.m_actionsEditor.save()) {
            return false;
        }
        if (this.m_artifactsEditor.isVisible() && !this.m_artifactsEditor.save()) {
            return false;
        }
        if (this.m_groupsEditor.isVisible() && !this.m_groupsEditor.save()) {
            return false;
        }
        String name = UiUtils.trimmedValue(this.m_componentName);
        if (name == null) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)Messages.the_component_must_have_a_name);
            return false;
        }
        this.m_cspec.setName(name);
        String componentType = this.m_componentType.getItem(this.m_componentType.getSelectionIndex());
        if (componentType.length() == 0) {
            componentType = null;
        }
        this.m_cspec.setComponentTypeID(componentType);
        try {
            this.m_cspec.setVersion(VersionHelper.createVersion((String)this.m_versionType.getItem(this.m_versionType.getSelectionIndex()), (String)UiUtils.trimmedValue(this.m_versionString)));
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
            return false;
        }
        try {
            Map attributesMap = this.m_cspec.getAttributes();
            if (attributesMap != null) {
                attributesMap.clear();
            }
            for (ActionBuilder actionBuilder : this.m_actionBuilders) {
                this.m_cspec.addAttribute((IAttribute)actionBuilder);
            }
            for (List list : this.m_actionArtifactBuilders.values()) {
                for (ActionArtifactBuilder item : list) {
                    this.m_cspec.addAttribute((IAttribute)item);
                }
            }
            for (ArtifactBuilder artifactBuilder : this.m_artifactBuilders) {
                this.m_cspec.addAttribute((IAttribute)artifactBuilder);
            }
            for (GroupBuilder groupBuilder : this.m_groupBuilders) {
                this.m_cspec.addAttribute((IAttribute)groupBuilder);
            }
        }
        catch (AttributeAlreadyDefinedException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
            return false;
        }
        try {
            Map dependeciesMap = this.m_cspec.getDependencyMap();
            if (dependeciesMap != null) {
                dependeciesMap.clear();
            }
            for (ComponentRequestBuilder componentRequestBuilder : this.m_dependencyBuilders) {
                this.m_cspec.addDependency((IComponentRequest)componentRequestBuilder);
            }
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
            return false;
        }
        try {
            Collection generators = this.m_cspec.getGeneratorList();
            if (generators.size() > 0) {
                generators.clear();
            }
            for (GeneratorBuilder generatorBuilder : this.m_generatorBuilders) {
                this.m_cspec.addGenerator((IGenerator)generatorBuilder);
            }
        }
        catch (GeneratorAlreadyDefinedException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
            return false;
        }
        String doc = UiUtils.trimmedValue(this.m_shortDesc);
        this.m_cspec.setShortDesc(doc);
        doc = UiUtils.trimmedValue(this.m_documentation);
        try {
            this.m_cspec.setDocumentation(doc == null ? null : Documentation.parse((String)doc));
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)coreException.getMessage());
            return false;
        }
        try {
            this.m_cspec.createCSpec().verifyConsistency();
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)coreException.getMessage());
            return false;
        }
        return true;
    }

    private void createActionButtons(Composite parent) {
        Composite allButtonsBox = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        allButtonsBox.setLayout((Layout)layout);
        allButtonsBox.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite pressButtonsBox = new Composite(allButtonsBox, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pressButtonsBox.setLayout((Layout)layout);
        pressButtonsBox.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.m_externalSaveAsButton = UiUtils.createPushButton(pressButtonsBox, Messages.external_save_as, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSpecEditor.this.doExternalSaveAs();
            }
        });
        this.m_externalSaveAsButton.setLayoutData((Object)new GridData(4, 4, false, false));
    }

    private ActionBuilder findActionBuilder(String actionName) {
        for (ActionBuilder builder : this.m_actionBuilders) {
            if (!actionName.equals(builder.getName())) continue;
            return builder;
        }
        return null;
    }

    private Control getActionsTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.actions);
        ActionsTable table = new ActionsTable(this, this.m_actionBuilders, this.m_actionArtifactBuilders, this.m_cspec, !this.isSaveAsAllowed());
        table.addFieldModifyListener(this.m_compoundModifyListener);
        this.m_actionsEditor = new OnePageTableEditor<ActionBuilder>(tabComposite, table, false, 0);
        this.m_actionsTable = table;
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getArtifactsTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.artifacts);
        ArtifactsTable table = new ArtifactsTable(this, this.m_artifactBuilders, this.m_cspec, !this.isSaveAsAllowed());
        table.addFieldModifyListener(this.m_compoundModifyListener);
        this.m_artifactsEditor = new OnePageTableEditor<ArtifactBuilder>(tabComposite, table, false, 0);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getAttributesTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.all_attributes);
        this.m_attributesView = new AllAttributesView(tabComposite, 0, this);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private String getCSpecXML() {
        String cspecXML = "";
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Utils.serialize((ISaxable)this.m_cspec.createCSpec(), (OutputStream)baos);
            cspecXML = baos.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cspecXML;
    }

    private Control getDependenciesTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.dependencies);
        DependenciesTable table = new DependenciesTable(this.m_dependencyBuilders, this.m_cspec, !this.isSaveAsAllowed());
        table.addTableModifyListener(this.m_compoundModifyListener);
        this.m_dependenciesEditor = new SimpleTableEditor<ComponentRequestBuilder>(tabComposite, table, null, Messages.cspec_editor_dependency, null, null, 0);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getDocumentationTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.documentation);
        Composite descComposite = new Composite(tabComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        descComposite.setLayout((Layout)layout);
        descComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        UiUtils.createGridLabel(descComposite, Messages.short_description_with_colon, 1, 0, 0);
        this.m_shortDesc = UiUtils.createGridText(descComposite, 1, 0, this.isSaveAsAllowed() ? 0 : 8, this.m_compoundModifyListener);
        Label label = UiUtils.createGridLabel(descComposite, Messages.documentation_with_colon, 1, 0, 0);
        label.setLayoutData((Object)new GridData(4, 1, false, false));
        this.m_documentation = UiUtils.createGridText(descComposite, 1, 0, (this.isSaveAsAllowed() ? 0 : 8) | 2 | 0x200, this.m_compoundModifyListener);
        this.m_documentation.setLayoutData((Object)new GridData(4, 4, true, true));
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getGeneratorsTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.generators);
        GeneratorsTable table = new GeneratorsTable(this, this.m_generatorBuilders, this.m_cspec, !this.isSaveAsAllowed());
        table.addTableModifyListener(this.m_compoundModifyListener);
        this.m_generatorsEditor = new SimpleTableEditor<GeneratorBuilder>(tabComposite, table, null, Messages.cspec_editor_generator, null, null, 0);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getGroupsTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.groups);
        GroupsTable table = new GroupsTable(this, this.m_groupBuilders, this.m_cspec, !this.isSaveAsAllowed());
        table.addFieldModifyListener(this.m_compoundModifyListener);
        this.m_groupsEditor = new OnePageTableEditor<GroupBuilder>(tabComposite, table, false, 0);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getMainTabControl(CTabFolder parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite((Composite)parent, Messages.main);
        Composite nameComposite = new Composite(tabComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginRight = 8;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        nameComposite.setLayout((Layout)layout);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = UiUtils.createGridLabel(nameComposite, Messages.component_name_with_colon, 1, 0, 0);
        int labelWidth = label.computeSize((int)-1, (int)-1).x + 5;
        GridData gridData = new GridData(4, 4, false, false);
        gridData.widthHint = labelWidth;
        label.setLayoutData((Object)gridData);
        this.m_componentName = UiUtils.createGridText(nameComposite, 1, 0, this.isSaveAsAllowed() ? 0 : 8, this.m_compoundModifyListener);
        UiUtils.createGridLabel(nameComposite, Messages.component_type_with_colon, 1, 0, 0);
        this.m_componentType = UiUtils.createGridCombo(nameComposite, 1, 0, !this.isSaveAsAllowed(), null, null, 76);
        this.m_componentType.setItems(AbstractComponentType.getComponentTypeIDs((boolean)true));
        this.m_componentType.addModifyListener((ModifyListener)this.m_compoundModifyListener);
        Group versionGroup = new Group(tabComposite, 0);
        versionGroup.setText(Messages.version);
        layout = new GridLayout(2, false);
        versionGroup.setLayout((Layout)layout);
        versionGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Label versionLabel = UiUtils.createGridLabel((Composite)versionGroup, Messages.version_with_colon, 1, 0, 0);
        gridData = (GridData)versionLabel.getLayoutData();
        gridData.widthHint = labelWidth - layout.marginWidth - 3;
        versionLabel.setLayoutData((Object)gridData);
        this.m_versionString = UiUtils.createGridText((Composite)versionGroup, 1, 0, this.isSaveAsAllowed() ? 0 : 8, this.m_compoundModifyListener);
        UiUtils.createGridLabel((Composite)versionGroup, Messages.type_with_colon, 1, 0, 0);
        this.m_versionType = UiUtils.createGridCombo((Composite)versionGroup, 1, 0, !this.isSaveAsAllowed(), null, null, 76);
        List knownTypes = VersionHelper.getKnownTypes();
        int idx = knownTypes.size();
        String[] versionTypes = new String[idx];
        while (--idx >= 0) {
            versionTypes[idx] = ((VersionType)knownTypes.get(idx)).getId();
        }
        this.m_versionType.setItems(versionTypes);
        this.m_versionType.select(this.m_versionType.indexOf("OSGi"));
        this.m_versionType.addModifyListener((ModifyListener)this.m_compoundModifyListener);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getXMLTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.xml_content);
        Composite xmlComposite = new Composite(tabComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        xmlComposite.setLayout((Layout)layout);
        xmlComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_xml = UiUtils.createGridText(xmlComposite, 1, 0, 778, null);
        this.m_xml.setLayoutData((Object)new GridData(4, 4, true, true));
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private void refreshValues() {
        this.setDirty(false);
        this.m_mute = true;
        try {
            int n;
            AttributeBuilder[] attributeBuilderArray;
            this.m_componentName.setText(TextUtils.notNullString((Object)this.m_cspec.getName()));
            this.m_componentType.select(this.m_componentType.indexOf(TextUtils.notNullString((Object)this.m_cspec.getComponentTypeID())));
            Version version = this.m_cspec.getVersion();
            if (version == null) {
                this.m_versionString.setText("");
                this.m_versionType.select(this.m_versionType.indexOf("OSGi"));
            } else {
                this.m_versionString.setText(TextUtils.notNullString((Object)VersionHelper.getHumanReadable((Version)version)));
                this.m_versionType.select(this.m_versionType.indexOf(VersionHelper.getVersionType((Version)version).getId()));
            }
            this.m_actionBuilders.clear();
            this.m_actionArtifactBuilders.clear();
            this.m_artifactBuilders.clear();
            this.m_groupBuilders.clear();
            Map attributesMap = this.m_cspec.getAttributes();
            if (attributesMap != null) {
                AttributeBuilder[] builders = attributesMap.values().toArray(new AttributeBuilder[0]);
                Arrays.sort(builders, CSpecEditorUtils.getAttributeComparator());
                ArrayList<ActionArtifactBuilder> tmp_actionArtifactBuilders = new ArrayList<ActionArtifactBuilder>();
                attributeBuilderArray = builders;
                n = builders.length;
                int n2 = 0;
                while (n2 < n) {
                    AttributeBuilder attribute = attributeBuilderArray[n2];
                    if (attribute instanceof ActionBuilder) {
                        this.m_actionBuilders.add((ActionBuilder)attribute);
                    } else if (attribute instanceof ActionArtifactBuilder) {
                        tmp_actionArtifactBuilders.add((ActionArtifactBuilder)attribute);
                    } else if (attribute instanceof ArtifactBuilder) {
                        this.m_artifactBuilders.add((ArtifactBuilder)attribute);
                    } else if (attribute instanceof GroupBuilder) {
                        this.m_groupBuilders.add((GroupBuilder)attribute);
                    }
                    ++n2;
                }
                for (ActionArtifactBuilder builder : tmp_actionArtifactBuilders) {
                    this.addToActionArtifactBuilderMap(builder);
                }
            }
            this.m_dependencyBuilders.clear();
            Collection dependencies = this.m_cspec.getDependencies();
            if (dependencies != null) {
                ComponentRequestBuilder[] builders = dependencies.toArray(new ComponentRequestBuilder[0]);
                Arrays.sort(builders, CSpecEditorUtils.getComponentComparator());
                attributeBuilderArray = builders;
                n = builders.length;
                int n3 = 0;
                while (n3 < n) {
                    AttributeBuilder dependency = attributeBuilderArray[n3];
                    this.m_dependencyBuilders.add((ComponentRequestBuilder)dependency);
                    ++n3;
                }
            }
            this.m_generatorBuilders.clear();
            Collection generatorsSet = this.m_cspec.getGeneratorList();
            if (generatorsSet != null) {
                GeneratorBuilder[] generators = generatorsSet.toArray(new GeneratorBuilder[0]);
                Arrays.sort(generators, CSpecEditorUtils.getCSpecElementComparator());
                GeneratorBuilder[] generatorBuilderArray = generators;
                int n4 = generators.length;
                n = 0;
                while (n < n4) {
                    GeneratorBuilder generator = generatorBuilderArray[n];
                    this.m_generatorBuilders.add(generator);
                    ++n;
                }
            }
            this.m_shortDesc.setText(TextUtils.notNullString((Object)this.m_cspec.getShortDesc()));
            Documentation doc = this.m_cspec.getDocumentation();
            this.m_documentation.setText(TextUtils.notNullString((Object)(doc == null ? "" : doc.toString())));
            this.m_xml.setText(this.getCSpecXML());
            this.m_actionsEditor.refresh();
            this.m_artifactsEditor.refresh();
            this.m_groupsEditor.refresh();
            this.m_dependenciesEditor.refresh();
            this.m_generatorsEditor.refresh();
            this.m_needsRefresh = false;
        }
        finally {
            this.m_mute = false;
        }
    }

    private void saveToPath(IPath path) {
        try {
            SaveRunnable sr = new SaveRunnable((ISaxable)this.m_cspec.createCSpec(), path);
            this.getSite().getWorkbenchWindow().run(true, true, (IRunnableWithProgress)sr);
            this.setInputWithNotify(sr.getSavedInput());
            this.setDirty(false);
            this.setPartName(path.lastSegment());
            this.firePropertyChange(1);
        }
        catch (InvocationTargetException e) {
            CoreException t = BuckminsterException.wrap((Throwable)e);
            String msg = NLS.bind((String)Messages.unable_to_save_file_0, (Object)path);
            CorePlugin.getLogger().error((Throwable)t, msg, new Object[0]);
            ErrorDialog.openError((Shell)this.getSite().getShell(), null, (String)msg, (IStatus)t.getStatus());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void setDirty(boolean flag) {
        if (this.m_readOnly || this.m_mute || this.m_hasChanges == flag) {
            return;
        }
        this.m_hasChanges = flag;
        this.firePropertyChange(257);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CSpecEditorTab {
        MAIN(0),
        ACTIONS(1),
        ARTIFACTS(2),
        GROUPS(3),
        ATTRIBUTES(4),
        DEPENDENCIES(5),
        GENERATORS(6),
        DOCUMENTATION(6),
        XML(8);

        private int m_seqNum;

        private CSpecEditorTab(int seqNum) {
            this.m_seqNum = seqNum;
        }

        public int getSeqNum() {
            return this.m_seqNum;
        }
    }

    class CompoundModifyListener
    implements ModifyListener,
    ITableModifyListener,
    IFieldModifyListener {
        CompoundModifyListener() {
        }

        public void modifyField(FieldModifyEvent e) {
            CSpecEditor.this.setDirty(true);
        }

        public void modifyTable(TableModifyEvent e) {
            CSpecEditor.this.setDirty(true);
        }

        public void modifyText(ModifyEvent e) {
            CSpecEditor.this.setDirty(true);
        }
    }
}

