/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.cspec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.cspec.IComponentName;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecElementBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.ui.editor.EditorUtils;
import org.eclipse.buckminster.ui.editor.cspec.PathWrapper;
import org.eclipse.buckminster.ui.editor.cspec.Property;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSpecEditorUtils {
    private static Comparator<CSpecElementBuilder> s_cspecElementComparator = new CSpecElementComparator();
    private static Comparator<IComponentName> s_componentComparator = new ComponentComparator();
    private static Comparator<AttributeBuilder> s_attributeComparator = new AttributeComparator();
    private static Comparator<PrerequisiteBuilder> s_prerequisiteComparator = new PrerequisiteComparator();
    private static Comparator<Property> s_propertyComparator = new PropertyComparator();

    public static void copyAndSortItems(Collection<IPath> src, List<PathWrapper> trgt) {
        trgt.clear();
        if (src != null) {
            ArrayList<IPath> hlpList = new ArrayList<IPath>();
            for (IPath path : src) {
                hlpList.add(path);
            }
            IPath[] pathArray = hlpList.toArray(new IPath[0]);
            Arrays.sort(pathArray, EditorUtils.getPathComparator());
            IPath[] iPathArray = pathArray;
            int n = pathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                trgt.add(new PathWrapper(path));
                ++n2;
            }
        }
    }

    public static <T> void copyAndSortItems(Collection<T> src, List<? super T> trgt, Comparator<? super T> comparator) {
        trgt.clear();
        if (src != null) {
            Object[] pathArray = src.toArray();
            Arrays.sort(pathArray, comparator);
            Object[] objectArray = pathArray;
            int n = pathArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object path = objectArray[n2];
                trgt.add(path);
                ++n2;
            }
        }
    }

    public static void copyAndSortItems(Map<String, String> src, List<Property> trgt) {
        trgt.clear();
        if (src != null) {
            ArrayList<Property> hlpList = new ArrayList<Property>();
            for (String key : src.keySet()) {
                hlpList.add(new Property(key, src.get(key)));
            }
            Property[] propertyArray = hlpList.toArray(new Property[0]);
            Arrays.sort(propertyArray, CSpecEditorUtils.getPropertyComparator());
            Property[] propertyArray2 = propertyArray;
            int n = propertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Property property = propertyArray2[n2];
                trgt.add(property);
                ++n2;
            }
        }
    }

    public static Comparator<AttributeBuilder> getAttributeComparator() {
        return s_attributeComparator;
    }

    public static Comparator<IComponentName> getComponentComparator() {
        return s_componentComparator;
    }

    public static Comparator<CSpecElementBuilder> getCSpecElementComparator() {
        return s_cspecElementComparator;
    }

    public static Comparator<PrerequisiteBuilder> getPrerequisiteComparator() {
        return s_prerequisiteComparator;
    }

    public static Comparator<Property> getPropertyComparator() {
        return s_propertyComparator;
    }

    private CSpecEditorUtils() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AttributeComparator
    implements Comparator<AttributeBuilder> {
        AttributeComparator() {
        }

        @Override
        public int compare(AttributeBuilder o1, AttributeBuilder o2) {
            if (o1.isPublic() && !o2.isPublic()) {
                return -1;
            }
            if (!o1.isPublic() && o2.isPublic()) {
                return 1;
            }
            return Trivial.compareAllowNull((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CSpecElementComparator
    implements Comparator<CSpecElementBuilder> {
        CSpecElementComparator() {
        }

        @Override
        public int compare(CSpecElementBuilder o1, CSpecElementBuilder o2) {
            return Trivial.compareAllowNull((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComponentComparator
    implements Comparator<IComponentName> {
        ComponentComparator() {
        }

        @Override
        public int compare(IComponentName o1, IComponentName o2) {
            return Trivial.compareAllowNull((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrerequisiteComparator
    implements Comparator<PrerequisiteBuilder> {
        PrerequisiteComparator() {
        }

        @Override
        public int compare(PrerequisiteBuilder o1, PrerequisiteBuilder o2) {
            int result = Trivial.compareAllowNull((Comparable)((Object)o1.getComponentName()), (Comparable)((Object)o2.getComponentName()));
            if (result != 0) {
                return result;
            }
            result = Trivial.compareAllowNull((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
            if (result != 0) {
                return result;
            }
            result = Trivial.compareAllowNull((Comparable)((Object)o1.getAlias()), (Comparable)((Object)o2.getAlias()));
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyComparator
    implements Comparator<Property> {
        PropertyComparator() {
        }

        @Override
        public int compare(Property o1, Property o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    }
}

