/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.cspec;

import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.cspec.AttributesTable;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditor;
import org.eclipse.buckminster.ui.general.editor.IValidator;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.simple.IWidgetin;
import org.eclipse.buckminster.ui.general.editor.simple.SimpleTable;
import org.eclipse.buckminster.ui.general.editor.simple.WidgetWrapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrerequisitesTable
extends SimpleTable<PrerequisiteBuilder> {
    private CSpecEditor m_editor;
    private AttributesTable<?> m_parentAttributesTable;
    private TopLevelAttributeBuilder m_attributeBuilder;
    private IWidgetin m_componentWidgetin = null;
    private IWidgetin m_attributeWidgetin = null;

    public PrerequisitesTable(CSpecEditor editor, AttributesTable<?> parentAttributesTable, List<PrerequisiteBuilder> data, TopLevelAttributeBuilder attributeBuilder, boolean readOnly) {
        super(data, readOnly);
        this.m_editor = editor;
        this.m_parentAttributesTable = parentAttributesTable;
        this.m_attributeBuilder = attributeBuilder;
    }

    @Override
    public PrerequisiteBuilder createRowClass() {
        return this.m_attributeBuilder.createPrerequisiteBuilder();
    }

    @Override
    public String[] getColumnHeaders() {
        return new String[]{Messages.component, Messages.attribute, Messages.alias, Messages.contributor, Messages.filter, Messages.include_pattern, Messages.exclude_pattern};
    }

    @Override
    public int[] getColumnWeights() {
        int[] nArray = new int[7];
        nArray[0] = 20;
        nArray[1] = 10;
        nArray[2] = 10;
        return nArray;
    }

    @Override
    public IValidator getRowValidator() {
        return new IValidator(){

            public void validate(Object ... arg) throws ValidatorException {
                PrerequisiteBuilder prerequisite = (PrerequisiteBuilder)PrerequisitesTable.this.toRowClass((Object[])arg[1]);
                if (!(prerequisite.getName() != null && prerequisite.getName().length() != 0 || prerequisite.getComponentName() != null && prerequisite.getComponentName().length() != 0)) {
                    throw new ValidatorException(Messages.name_or_component_has_to_be_entered);
                }
            }
        };
    }

    @Override
    public IWidgetin getWidgetin(Composite parent, int idx, Object value) {
        switch (idx) {
            case 0: {
                this.m_componentWidgetin = this.getComponentWidgetin(parent, idx, value, this.m_editor.getComponentNames(), 0);
                return this.m_componentWidgetin;
            }
            case 1: {
                this.m_attributeWidgetin = this.getAttributeWidgetin(parent, idx, value, this.m_editor.getAttributeNames(this.m_parentAttributesTable.getCurrentBuilder().getName()), 0);
                this.setAttributeItems();
                return this.m_attributeWidgetin;
            }
            case 3: {
                return this.getBooleanCheckBoxWidgetin(parent, idx, (Boolean)value, Boolean.TRUE);
            }
        }
        return this.getTextWidgetin(parent, idx, value);
    }

    @Override
    public Object[] toRowArray(PrerequisiteBuilder t) {
        return new Object[]{t.getComponentName(), t.getName(), t.getAlias(), t.isContributor(), TextUtils.notNullString((Object)t.getFilter()), TextUtils.notNullString((Object)t.getIncludePattern()), TextUtils.notNullString((Object)t.getExcludePattern())};
    }

    @Override
    public void updateRowClass(PrerequisiteBuilder builder, Object[] args) throws ValidatorException {
        builder.setComponentName(TextUtils.notEmptyString((String)((String)args[0])));
        builder.setName(TextUtils.notEmptyString((String)((String)args[1])));
        builder.setAlias(TextUtils.notEmptyString((String)((String)args[2])));
        builder.setContributor(((Boolean)args[3]).booleanValue());
        String filterStr = TextUtils.notEmptyString((String)((String)args[4]));
        if (filterStr != null) {
            try {
                builder.setFilter(FilterFactory.newInstance((String)filterStr));
            }
            catch (InvalidSyntaxException e) {
                throw new ValidatorException(e.getMessage());
            }
        } else {
            builder.setFilter(null);
        }
        String includePatternStr = TextUtils.notEmptyString((String)((String)args[5]));
        if (includePatternStr != null) {
            try {
                builder.setIncludePattern(Pattern.compile(includePatternStr));
            }
            catch (PatternSyntaxException e) {
                throw new ValidatorException(e.getMessage());
            }
        } else {
            builder.setIncludePattern(null);
        }
        String excludePatternStr = TextUtils.notEmptyString((String)((String)args[6]));
        if (excludePatternStr != null) {
            try {
                builder.setExcludePattern(Pattern.compile(excludePatternStr));
            }
            catch (PatternSyntaxException e) {
                throw new ValidatorException(e.getMessage());
            }
        } else {
            builder.setExcludePattern(null);
        }
    }

    protected IWidgetin getAttributeWidgetin(Composite parent, final int idx, Object value, String[] items, int style) {
        String ITEMS_KEY = "items";
        final Combo combo = UiUtils.createGridCombo(parent, 0, 0, this.isReadOnly(), null, null, style);
        final WidgetWrapper widgetin = new WidgetWrapper((Widget)combo);
        String stringValue = value == null ? "" : value.toString();
        combo.setText(stringValue);
        combo.setData((Object)stringValue);
        combo.setData("items", (Object)items);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                combo.setData((Object)combo.getText());
                PrerequisitesTable.this.validateFieldInFieldListener(widgetin, PrerequisitesTable.this.getFieldValidator(idx), combo.getText());
            }
        });
        return widgetin;
    }

    protected IWidgetin getComponentWidgetin(Composite parent, final int idx, Object value, String[] items, int style) {
        final Combo combo = UiUtils.createGridCombo(parent, 0, 0, this.isReadOnly(), null, null, style);
        final WidgetWrapper widgetin = new WidgetWrapper((Widget)combo);
        combo.setItems(items);
        String stringValue = value == null ? "" : value.toString();
        combo.setText(stringValue);
        combo.setData((Object)stringValue);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                combo.setData((Object)combo.getText());
                PrerequisitesTable.this.validateFieldInFieldListener(widgetin, PrerequisitesTable.this.getFieldValidator(idx), combo.getText());
                PrerequisitesTable.this.setAttributeItems();
            }
        });
        return widgetin;
    }

    private void setAttributeItems() {
        if (this.m_componentWidgetin == null || this.m_attributeWidgetin == null) {
            return;
        }
        Combo componentCombo = (Combo)((WidgetWrapper)this.m_componentWidgetin).getWidget();
        Combo attributeCombo = (Combo)((WidgetWrapper)this.m_attributeWidgetin).getWidget();
        String currentAttribute = attributeCombo.getText();
        if (componentCombo.getText() == null || componentCombo.getText().length() == 0) {
            attributeCombo.setItems((String[])attributeCombo.getData("items"));
        } else {
            ComponentRequestBuilder builder = this.m_editor.getDependencyBuilder(componentCombo.getText());
            ComponentRequest cr = new ComponentRequest(builder.getName(), builder.getComponentTypeID(), builder.getVersionRange());
            TreeSet<String> prereqAttributes = new TreeSet<String>();
            try {
                Resolution prereqResolution = WorkspaceInfo.getResolution((ComponentRequest)cr, (boolean)false);
                CSpec prereqCSpec = prereqResolution.getCSpec();
                for (Attribute attribute : prereqCSpec.getAttributes().values()) {
                    if (!attribute.isPublic()) continue;
                    prereqAttributes.add(attribute.getName());
                }
            }
            catch (MissingComponentException prereqResolution) {
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.m_editor.getSite().getShell(), null, (String)Messages.cannot_get_attribute_names_for_the_selected_component, (IStatus)e.getStatus());
            }
            attributeCombo.setItems(prereqAttributes.toArray(new String[0]));
        }
        attributeCombo.setText(currentAttribute);
        attributeCombo.update();
    }
}

