/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.query;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.AbstractComponentType;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.query.IComponentQuery;
import org.eclipse.buckminster.core.query.builder.AdvisorNodeBuilder;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.query.model.MutableLevel;
import org.eclipse.buckminster.core.query.model.SourceLevel;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.SaveRunnable;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.ArtifactType;
import org.eclipse.buckminster.ui.editor.EditorUtils;
import org.eclipse.buckminster.ui.editor.IDerivedEditorInput;
import org.eclipse.buckminster.ui.editor.Properties;
import org.eclipse.buckminster.ui.editor.PropertiesModifyEvent;
import org.eclipse.buckminster.ui.editor.PropertiesModifyListener;
import org.eclipse.buckminster.ui.editor.VersionDesignator;
import org.eclipse.buckminster.ui.editor.VersionDesignatorEvent;
import org.eclipse.buckminster.ui.editor.VersionDesignatorListener;
import org.eclipse.buckminster.ui.general.editor.structured.IActivator;
import org.eclipse.buckminster.ui.internal.DynamicTableLayout;
import org.eclipse.buckminster.ui.internal.ResolveJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.EditorPart;
import org.osgi.framework.InvalidSyntaxException;

public class QueryEditor
extends EditorPart
implements IEditorMatchingStrategy {
    private static final IActivator EMPTY_ACTIVATOR = new IActivator(){

        public void activate() {
        }
    };
    private static final int DONT_SAVE = -99;
    private CTabFolder m_tabFolder;
    private Text m_componentName;
    private Combo m_componentType;
    private VersionDesignator m_versionDesignator;
    private ComponentQueryBuilder m_componentQuery;
    private Button m_enableOverride;
    private boolean m_hasChanges;
    private Button m_resolveButton;
    private Button m_materializeButton;
    private Button m_externalSaveAsButton;
    private Button m_moveDownButton;
    private Button m_moveUpButton;
    private boolean m_mute;
    private Combo m_mutableLevel;
    private Text m_namePattern;
    private Text m_filter;
    private Combo m_category;
    private Text m_overlayFolder;
    private Button m_overlayBrowseButton;
    private Text m_wantedAttributes;
    private Button m_prune;
    private boolean m_needsRefresh;
    private Button m_newButton;
    private TableViewer m_nodeTable;
    private Button m_removeButton;
    private Button m_requestURLCheckbox;
    private Text m_requestURL;
    private Button m_propertyURLCheckbox;
    private Text m_propertyURL;
    private Tree m_nodeTree;
    private Combo m_sourceLevel;
    private Button m_skipComponent;
    private Button m_allowCircular;
    private Composite m_nodesStackComposite;
    private StackLayout m_nodesStackLayout;
    private HashMap<String, Control> m_nodesHash;
    private Button m_useTargetPlatform;
    private Button m_useWorkspace;
    private Button m_useMaterialization;
    private Button m_useResolutionService;
    private Text m_branchTagPath;
    private Text m_timestamp;
    private Text m_revision;
    private VersionDesignator m_versionOverride;
    private boolean m_continueOnError;
    private Properties m_nodeProperties;
    private Text m_nodeDocumentation;
    private Properties m_properties;
    private Text m_shortDesc;
    private Text m_documentation;
    private CTabItem m_xmlTab;
    private Text m_xml;
    private CompoundModifyListener m_compoundModifyListener;
    private final SimpleDateFormat m_timestampFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3);
    private int m_lastSelectedNode = -1;
    private int m_lastEditedNode = -1;
    private boolean m_suppressModifyListener = false;

    public String commitChanges(IComponentRequest[] requestRet) {
        String name = UiUtils.trimmedValue(this.m_componentName);
        if (name == null) {
            return Messages.the_component_must_have_a_name;
        }
        String category = null;
        int idx = this.m_componentType.getSelectionIndex();
        if (idx >= 0 && (category = this.m_componentType.getItem(idx)).length() == 0) {
            category = null;
        }
        requestRet[0] = new ComponentRequest(name, category, this.m_versionDesignator.getVersionDesignator());
        return null;
    }

    public void createPartControl(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        topComposite.setLayout((Layout)layout);
        this.m_tabFolder = new CTabFolder(topComposite, 1024);
        this.m_tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem mainTab = new CTabItem(this.m_tabFolder, 0);
        mainTab.setText(Messages.main);
        mainTab.setControl(this.getMainTabControl(this.m_tabFolder));
        final CTabItem advisorTab = new CTabItem(this.m_tabFolder, 0);
        advisorTab.setText(Messages.advisor_nodes);
        advisorTab.setControl(this.getAdvisorTabControl((Composite)this.m_tabFolder));
        CTabItem propertiesTab = new CTabItem(this.m_tabFolder, 0);
        propertiesTab.setText(Messages.properties);
        propertiesTab.setControl(this.getPropertiesTabControl((Composite)this.m_tabFolder));
        CTabItem documentationTab = new CTabItem(this.m_tabFolder, 0);
        documentationTab.setText(Messages.documentation);
        documentationTab.setControl(this.getDocumentationTabControl((Composite)this.m_tabFolder));
        this.m_xmlTab = new CTabItem(this.m_tabFolder, 0);
        this.m_xmlTab.setText(Messages.xml_content);
        this.m_xmlTab.setControl(this.getXMLTabControl((Composite)this.m_tabFolder));
        this.m_tabFolder.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (QueryEditor.this.m_tabFolder.getSelection() == null) {
                    QueryEditor.this.m_tabFolder.setSelection(0);
                }
            }
        });
        this.m_tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(mainTab){
            private final IActivator NODE_TAB_ACTIVATOR;
            private CTabItem m_lastTab;
            {
                this.NODE_TAB_ACTIVATOR = new IActivator(){

                    public void activate() {
                        QueryEditor.this.m_tabFolder.setSelection(cTabItem2);
                    }
                };
                this.m_lastTab = cTabItem;
            }

            public void widgetSelected(SelectionEvent e) {
                if (this.m_lastTab != e.item && this.m_lastTab == advisorTab && !QueryEditor.this.saveLastNode(this.NODE_TAB_ACTIVATOR)) {
                    return;
                }
                if (QueryEditor.this.m_xmlTab == e.item) {
                    if (!QueryEditor.this.commitChangesToQuery()) {
                        MessageDialog.openWarning((Shell)QueryEditor.this.getSite().getShell(), null, (String)Messages.xml_content_was_not_updated_due_to_errors);
                    } else {
                        QueryEditor.this.m_xml.setText(QueryEditor.this.getCQueryXML());
                    }
                }
                this.m_lastTab = (CTabItem)e.item;
            }
        });
        this.createActionButtons(topComposite);
    }

    public void doExternalSaveAs() {
        if (!this.commitChangesToQuery()) {
            return;
        }
        FileDialog dlg = new FileDialog(this.getSite().getShell(), 8192);
        dlg.setFilterExtensions(new String[]{"*.cquery"});
        String location = dlg.open();
        if (location == null) {
            return;
        }
        this.saveToPath((IPath)new Path(location));
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.commitChangesToQuery()) {
            return;
        }
        IEditorInput input = this.getEditorInput();
        if (input == null) {
            return;
        }
        IPath path = input instanceof ILocationProvider ? ((ILocationProvider)input).getPath((Object)input) : ((IPathEditorInput)input).getPath();
        this.saveToPath(path);
    }

    public void doSaveAs() {
        IFile original;
        if (!this.commitChangesToQuery()) {
            return;
        }
        IEditorInput input = this.getEditorInput();
        if (input == null) {
            return;
        }
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getShell());
        IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        if (original != null) {
            dialog.setOriginalFile(original);
        }
        if (dialog.open() == 1) {
            return;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        this.saveToPath(file.getLocation());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof ILocationProvider || input instanceof IPathEditorInput || input instanceof IURIEditorInput)) {
            throw new PartInitException(Messages.invalid_input);
        }
        this.setSite((IWorkbenchPartSite)site);
        if (input instanceof IURIEditorInput) {
            try {
                input = EditorUtils.getExternalFileEditorInput((IURIEditorInput)input, ArtifactType.CQUERY);
            }
            catch (Exception e) {
                throw new PartInitException(Messages.unable_to_open_editor, (Throwable)e);
            }
        }
        FileInputStream stream = null;
        try {
            try {
                IPath path = input instanceof ILocationProvider ? ((ILocationProvider)input).getPath(input) : ((IPathEditorInput)input).getPath();
                File file = path.toFile();
                this.m_componentQuery = new ComponentQueryBuilder();
                if (file.length() == 0L) {
                    String defaultName = file.getName();
                    if (defaultName.startsWith("bmqtmp-")) {
                        defaultName = "";
                    } else {
                        int lastDot = defaultName.lastIndexOf(46);
                        if (lastDot > 0) {
                            defaultName = defaultName.substring(0, lastDot);
                        }
                    }
                    this.m_componentQuery.setRootRequest((IComponentRequest)new ComponentRequest(defaultName, null, null));
                } else {
                    URL contextURL;
                    stream = new FileInputStream(file);
                    try {
                        contextURL = URLUtils.normalizeToURL((String)input.getToolTipText());
                    }
                    catch (MalformedURLException e) {
                        contextURL = file.toURI().toURL();
                    }
                    this.m_componentQuery.initFrom((IComponentQuery)ComponentQuery.fromStream((URL)contextURL, null, (InputStream)stream, (boolean)true));
                    CorePlugin.getLogger().debug("CQUERY Context URL set to %s", new Object[]{this.m_componentQuery.getContextURL()});
                }
                this.m_needsRefresh = true;
                if (this.m_componentName != null) {
                    this.refreshQuery();
                }
                this.setInputWithNotify((IEditorInput)input);
                this.setPartName(input.getName());
            }
            catch (Throwable e) {
                CoreException ce = BuckminsterException.wrap((Throwable)e);
                throw new PartInitException(Messages.unable_to_open_editor, (Throwable)ce);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(stream);
            throw throwable;
        }
        IOUtils.close((Closeable)stream);
        this.m_compoundModifyListener = new CompoundModifyListener();
    }

    public boolean isDirty() {
        return this.m_hasChanges;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        IEditorInput editorInput;
        IEditorPart part = (IEditorPart)editorRef.getPart(false);
        if (part != null && (editorInput = part.getEditorInput()) != null) {
            IEditorInput originalEditorInput;
            if (editorInput.equals(input)) {
                return true;
            }
            if (editorInput instanceof IDerivedEditorInput && (originalEditorInput = ((IDerivedEditorInput)editorInput).getOriginalInput()).equals(input)) {
                return true;
            }
        }
        return false;
    }

    public void setFocus() {
        this.m_tabFolder.setFocus();
        if (this.m_needsRefresh) {
            this.refreshQuery();
        }
    }

    private AdvisorNodeBuilder addEmptyNode() {
        AdvisorNodeBuilder node = new AdvisorNodeBuilder();
        node.setNamePattern(Pattern.compile(""));
        this.m_componentQuery.addAdvisorNode(node);
        return node;
    }

    private void changeNodeSelection() {
        if (!this.saveLastNode()) {
            if (this.m_lastSelectedNode != -1) {
                this.m_nodeTable.getTable().setSelection(this.m_lastSelectedNode);
            }
            return;
        }
        this.nodeSelectionEvent();
    }

    private boolean commitChangesToQuery() {
        if (this.m_nodeTable.getControl().isVisible() && !this.saveLastNode()) {
            return false;
        }
        this.m_componentQuery.setResourceMapURL(UiUtils.trimmedValue(this.m_requestURL));
        this.m_componentQuery.setPropertiesURL(UiUtils.trimmedValue(this.m_propertyURL));
        this.m_properties.fillProperties(this.m_componentQuery.getDeclaredProperties());
        String doc = UiUtils.trimmedValue(this.m_shortDesc);
        this.m_componentQuery.setShortDesc(doc);
        doc = UiUtils.trimmedValue(this.m_documentation);
        try {
            this.m_componentQuery.setDocumentation(doc == null ? null : Documentation.parse((String)doc));
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
            return false;
        }
        ComponentRequest[] requestRet = new ComponentRequest[1];
        String error = this.commitChanges((IComponentRequest[])requestRet);
        if (error != null) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)error);
            return false;
        }
        this.m_componentQuery.setRootRequest((IComponentRequest)requestRet[0]);
        return true;
    }

    private void createActionButtons(Composite parent) {
        Composite allButtonsBox = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        allButtonsBox.setLayout((Layout)layout);
        allButtonsBox.setLayoutData((Object)new GridData(4, 4, true, false));
        UiUtils.createCheckButton(allButtonsBox, Messages.continue_on_error, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.m_continueOnError = ((Button)e.getSource()).getSelection();
            }
        });
        Composite pressButtonsBox = new Composite(allButtonsBox, 0);
        layout = new GridLayout(3, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pressButtonsBox.setLayout((Layout)layout);
        pressButtonsBox.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.m_resolveButton = UiUtils.createPushButton(pressButtonsBox, Messages.resolve_to_wizard, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.loadComponent(false);
            }
        });
        this.m_resolveButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_materializeButton = UiUtils.createPushButton(pressButtonsBox, Messages.resolve_and_materialize, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.loadComponent(true);
            }
        });
        this.m_materializeButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_externalSaveAsButton = UiUtils.createPushButton(pressButtonsBox, Messages.external_save_as, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.doExternalSaveAs();
            }
        });
        this.m_externalSaveAsButton.setLayoutData((Object)new GridData(4, 4, false, false));
    }

    private void createButtonBox(Composite parent) {
        Composite buttonBox = new Composite(parent, 0);
        buttonBox.setLayoutData((Object)new GridData(4, 4, false, false));
        FillLayout layout = new FillLayout(512);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.spacing = 3;
        buttonBox.setLayout((Layout)layout);
        Composite buttonBox1 = new Composite(buttonBox, 0);
        layout = new FillLayout(256);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonBox1.setLayout((Layout)layout);
        Composite buttonBox2 = new Composite(buttonBox, 0);
        layout = new FillLayout(256);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonBox2.setLayout((Layout)layout);
        this.m_newButton = UiUtils.createPushButton(buttonBox1, Messages.new_label, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.newNode();
            }
        });
        this.m_removeButton = UiUtils.createPushButton(buttonBox1, Messages.remove, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.removeNode();
            }
        });
        this.m_moveUpButton = UiUtils.createPushButton(buttonBox2, Messages.move_up, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.swapAndReselect(0, -1);
            }
        });
        this.m_moveDownButton = UiUtils.createPushButton(buttonBox2, Messages.move_down, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.swapAndReselect(1, 0);
            }
        });
    }

    private void createNodeFields(Composite parent) {
        this.createNodeTree(parent);
        this.createNodeStack(parent);
    }

    private void createNodeStack(Composite parent) {
        this.m_nodesStackComposite = new Composite(parent, 0);
        this.m_nodesStackComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_nodesStackLayout = new StackLayout();
        this.m_nodesStackLayout.marginWidth = 0;
        this.m_nodesStackLayout.marginHeight = 0;
        this.m_nodesStackComposite.setLayout((Layout)this.m_nodesStackLayout);
        this.m_nodesHash = new HashMap();
        Composite geComposite = new Composite(this.m_nodesStackComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        geComposite.setLayout((Layout)layout);
        this.m_nodesHash.put(Messages.general, (Control)geComposite);
        EditorUtils.createHeaderLabel(geComposite, Messages.general, 2);
        UiUtils.createGridLabel(geComposite, Messages.name_pattern_with_colon, 1, 0, 0);
        this.m_namePattern = UiUtils.createGridText(geComposite, 1, 0, 0);
        this.m_namePattern.addModifyListener((ModifyListener)this.m_compoundModifyListener);
        UiUtils.createGridLabel(geComposite, Messages.matched_component_type_with_colon, 1, 0, 0);
        this.m_category = UiUtils.createGridCombo(geComposite, 1, 0, null, null, 76);
        this.m_category.setItems(AbstractComponentType.getComponentTypeIDs((boolean)true));
        this.m_category.addModifyListener((ModifyListener)this.m_compoundModifyListener);
        UiUtils.createGridLabel(geComposite, Messages.filter_with_colon, 1, 0, 0);
        this.m_filter = UiUtils.createGridText(geComposite, 1, 0, 0);
        this.m_filter.addModifyListener((ModifyListener)this.m_compoundModifyListener);
        UiUtils.createGridLabel(geComposite, Messages.skip_component_with_colon, 1, 0, 0);
        this.m_skipComponent = UiUtils.createCheckButton(geComposite, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditor.this.enableDisableSkipSensitive(false);
            }
        });
        this.m_skipComponent.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_skipComponent.addSelectionListener((SelectionListener)this.m_compoundModifyListener);
        UiUtils.createGridLabel(geComposite, Messages.allow_circular_dependency_with_colon, 1, 0, 0);
        this.m_allowCircular = UiUtils.createCheckButton(geComposite, null, null);
        this.m_allowCircular.addSelectionListener((SelectionListener)this.m_compoundModifyListener);
        Composite aqComposite = new Composite(this.m_nodesStackComposite, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        aqComposite.setLayout((Layout)layout);
        this.m_nodesHash.put(Messages.attribute_qualification, (Control)aqComposite);
        EditorUtils.createHeaderLabel(aqComposite, Messages.attribute_qualification, 2);
        UiUtils.createGridLabel(aqComposite, Messages.attributes_with_colon, 1, 0, 0);
        this.m_wantedAttributes = UiUtils.createGridText(aqComposite, 0, 0, 0);
        this.m_wantedAttributes.addModifyListener((ModifyListener)this.m_compoundModifyListener);
        UiUtils.createGridLabel(aqComposite, Messages.prune_according_to_attributes_with_colon, 1, 0, 0);
        this.m_prune = UiUtils.createCheckButton(aqComposite, null, null);
        this.m_prune.addSelectionListener((SelectionListener)this.m_compoundModifyListener);
        Composite srComposite = new Composite(this.m_nodesStackComposite, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        srComposite.setLayout((Layout)layout);
        this.m_nodesHash.put(Messages.special_requirements, (Control)srComposite);
        EditorUtils.createHeaderLabel(srComposite, Messages.special_requirements, 2);
        UiUtils.createGridLabel(srComposite, Messages.mutable_level_with_colon, 1, 0, 0);
        this.m_mutableLevel = UiUtils.createGridEnumCombo(srComposite, 0, 0, MutableLevel.values(), null, null, 0);
        this.m_mutableLevel.addModifyListener((ModifyListener)this.m_compoundModifyListener);
        UiUtils.createGridLabel(srComposite, Messages.source_level_with_colon, 1, 0, 0);
        this.m_sourceLevel = UiUtils.createGridEnumCombo(srComposite, 0, 0, SourceLevel.values(), null, null, 0);
        this.m_sourceLevel.addModifyListener((ModifyListener)this.m_compoundModifyListener);
        Composite kuComposite = new Composite(this.m_nodesStackComposite, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        kuComposite.setLayout((Layout)layout);
        this.m_nodesHash.put(Messages.resolution_scope, (Control)kuComposite);
        EditorUtils.createHeaderLabel(kuComposite, Messages.resolution_scope, 2);
        UiUtils.createGridLabel(kuComposite, Messages.target_platform_with_colon, 1, 0, 0);
        this.m_useTargetPlatform = UiUtils.createCheckButton(kuComposite, null, null);
        this.m_useTargetPlatform.addSelectionListener((SelectionListener)this.m_compoundModifyListener);
        UiUtils.createGridLabel(kuComposite, Messages.workspace_with_colon, 1, 0, 0);
        this.m_useWorkspace = UiUtils.createCheckButton(kuComposite, null, null);
        this.m_useWorkspace.addSelectionListener((SelectionListener)this.m_compoundModifyListener);
        UiUtils.createGridLabel(kuComposite, Messages.materialization_with_colon, 1, 0, 0);
        this.m_useMaterialization = UiUtils.createCheckButton(kuComposite, null, null);
        this.m_useMaterialization.addSelectionListener((SelectionListener)this.m_compoundModifyListener);
        UiUtils.createGridLabel(kuComposite, Messages.resolution_service_with_colon, 1, 0, 0);
        this.m_useResolutionService = UiUtils.createCheckButton(kuComposite, null, null);
        this.m_useResolutionService.addSelectionListener((SelectionListener)this.m_compoundModifyListener);
        Composite scComposite = new Composite(this.m_nodesStackComposite, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        scComposite.setLayout((Layout)layout);
        this.m_nodesHash.put(Messages.selection_criteria, (Control)scComposite);
        EditorUtils.createHeaderLabel(scComposite, Messages.selection_criteria, 2);
        UiUtils.createGridLabel(scComposite, Messages.branch_or_tag_path_with_colon, 1, 0, 0);
        this.m_branchTagPath = UiUtils.createGridText(scComposite, 1, 0, 0);
        this.m_branchTagPath.addModifyListener((ModifyListener)this.m_compoundModifyListener);
        UiUtils.createGridLabel(scComposite, Messages.timestamp_with_colon, 1, 0, 0);
        this.m_timestamp = UiUtils.createGridText(scComposite, 1, 0, 0);
        this.m_timestamp.addModifyListener((ModifyListener)this.m_compoundModifyListener);
        UiUtils.createGridLabel(scComposite, Messages.revision_with_colon, 1, 0, 0);
        this.m_revision = UiUtils.createGridText(scComposite, 1, 0, 0);
        this.m_revision.addModifyListener((ModifyListener)this.m_compoundModifyListener);
        Composite ovComposite = new Composite(this.m_nodesStackComposite, 0);
        layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        ovComposite.setLayout((Layout)layout);
        this.m_nodesHash.put(Messages.override, (Control)ovComposite);
        EditorUtils.createHeaderLabel(ovComposite, Messages.override, 3);
        UiUtils.createGridLabel(ovComposite, Messages.override_version, 1, 0, 0);
        this.m_enableOverride = UiUtils.createCheckButton(ovComposite, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ((Button)e.getSource()).getSelection();
                QueryEditor.this.m_versionOverride.setEnabled(selected);
            }
        });
        this.m_enableOverride.addSelectionListener((SelectionListener)this.m_compoundModifyListener);
        UiUtils.createEmptyLabel(ovComposite);
        this.m_versionOverride = new VersionDesignator(ovComposite);
        this.m_versionOverride.addVersionDesignatorListener(this.m_compoundModifyListener);
        Composite ofComposite = new Composite(this.m_nodesStackComposite, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        ofComposite.setLayout((Layout)layout);
        this.m_nodesHash.put(Messages.overlay_folder, (Control)ofComposite);
        EditorUtils.createHeaderLabel(ofComposite, Messages.overlay_folder_for_prototyping, 2);
        UiUtils.createGridLabel(ofComposite, Messages.folder_with_colon, 1, 0, 0);
        this.m_overlayFolder = UiUtils.createGridText(ofComposite, 1, 0, 0);
        this.m_overlayFolder.addModifyListener((ModifyListener)this.m_compoundModifyListener);
        Label label = UiUtils.createEmptyLabel(ofComposite);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_overlayBrowseButton = new Button(ofComposite, 8);
        this.m_overlayBrowseButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.m_overlayBrowseButton.setText(Messages.browse_with_dots);
        this.m_overlayBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dlg = new DirectoryDialog(QueryEditor.this.getSite().getShell());
                QueryEditor.this.m_overlayFolder.setText(TextUtils.notNullString((Object)dlg.open()));
            }
        });
        Composite prComposite = new Composite(this.m_nodesStackComposite, 0);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        prComposite.setLayout((Layout)layout);
        this.m_nodesHash.put(Messages.properties, (Control)prComposite);
        EditorUtils.createHeaderLabel(prComposite, Messages.properties, 1);
        this.m_nodeProperties = new Properties(prComposite, 0);
        this.m_nodeProperties.setLayoutData(new GridData(4, 4, true, true));
        this.m_nodeProperties.addPropertiesModifyListener(this.m_compoundModifyListener);
        Composite docComposite = new Composite(this.m_nodesStackComposite, 0);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        docComposite.setLayout((Layout)layout);
        this.m_nodesHash.put(Messages.documentation, (Control)docComposite);
        EditorUtils.createHeaderLabel(docComposite, Messages.documentation, 1);
        this.m_nodeDocumentation = UiUtils.createGridText(docComposite, 1, 0, 2);
        this.m_nodeDocumentation.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_nodeDocumentation.addModifyListener((ModifyListener)this.m_compoundModifyListener);
        this.initStackControl();
    }

    private void createNodeTableGroup(Composite parent) {
        Composite componentTableGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        componentTableGroup.setLayout((Layout)gl);
        componentTableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Table table = new Table(componentTableGroup, 68356);
        table.setHeaderVisible(false);
        String[] columnNames = new String[]{Messages.name_pattern, Messages.component_type, Messages.filter};
        int[] columnWeights = new int[]{10, 5, 5};
        table.setHeaderVisible(true);
        DynamicTableLayout layout = new DynamicTableLayout(50);
        int idx = 0;
        while (idx < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, 16384, idx);
            tableColumn.setText(columnNames[idx]);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(columnWeights[idx], true));
            ++idx;
        }
        table.setLayout((Layout)layout);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_nodeTable = new TableViewer(table);
        this.m_nodeTable.setLabelProvider((IBaseLabelProvider)new AdvisorNodeLabelProvider());
        this.m_nodeTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_nodeTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                QueryEditor.this.changeNodeSelection();
            }
        });
        this.createButtonBox(componentTableGroup);
    }

    private void createNodeTree(Composite parent) {
        this.m_nodeTree = new Tree(parent, 2048);
        this.m_nodeTree.setLayoutData((Object)new GridData(4, 4, false, true));
        this.m_nodeTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item != null) {
                    TreeItem item = (TreeItem)e.item;
                    ((QueryEditor)QueryEditor.this).m_nodesStackLayout.topControl = (Control)QueryEditor.this.m_nodesHash.get(item.getText());
                    QueryEditor.this.m_nodesStackComposite.layout();
                }
            }
        });
        TreeItem item = new TreeItem(this.m_nodeTree, 0);
        item.setText(Messages.general);
        item = new TreeItem(this.m_nodeTree, 0);
        item.setText(Messages.attribute_qualification);
        item = new TreeItem(this.m_nodeTree, 0);
        item.setText(Messages.special_requirements);
        item = new TreeItem(this.m_nodeTree, 0);
        item.setText(Messages.resolution_scope);
        item = new TreeItem(this.m_nodeTree, 0);
        item.setText(Messages.selection_criteria);
        item = new TreeItem(this.m_nodeTree, 0);
        item.setText(Messages.override);
        item = new TreeItem(this.m_nodeTree, 0);
        item.setText(Messages.overlay_folder);
        item = new TreeItem(this.m_nodeTree, 0);
        item.setText(Messages.properties);
        item = new TreeItem(this.m_nodeTree, 0);
        item.setText(Messages.documentation);
    }

    private void enableDisableButtonGroup() {
        Table table = this.m_nodeTable.getTable();
        int top = table.getItemCount();
        int idx = table.getSelectionIndex();
        this.m_newButton.setText(Messages.new_label);
        this.m_removeButton.setEnabled(idx >= 0);
        this.m_moveUpButton.setEnabled(idx > 0);
        this.m_moveDownButton.setEnabled(idx >= 0 && idx < top - 1);
        boolean disableFields = this.getSelectionIndex() == -1;
        this.m_namePattern.setEnabled(!disableFields);
        this.m_filter.setEnabled(!disableFields);
        this.m_category.setEnabled(!disableFields);
        this.m_skipComponent.setEnabled(!disableFields);
        this.m_nodeDocumentation.setEnabled(!disableFields);
        this.enableDisableSkipSensitive(disableFields);
    }

    private void enableDisableSkipSensitive(boolean forceDisable) {
        boolean enableRest = !forceDisable && !this.m_skipComponent.getSelection();
        this.m_allowCircular.setEnabled(enableRest);
        this.m_overlayFolder.setEnabled(enableRest);
        this.m_overlayBrowseButton.setEnabled(enableRest);
        this.m_wantedAttributes.setEnabled(enableRest);
        this.m_prune.setEnabled(enableRest);
        this.m_mutableLevel.setEnabled(enableRest);
        this.m_sourceLevel.setEnabled(enableRest);
        this.m_useTargetPlatform.setEnabled(enableRest);
        this.m_useWorkspace.setEnabled(enableRest);
        this.m_useMaterialization.setEnabled(enableRest);
        this.m_useResolutionService.setEnabled(enableRest);
        this.m_branchTagPath.setEnabled(enableRest);
        this.m_timestamp.setEnabled(enableRest);
        this.m_revision.setEnabled(enableRest);
        this.m_enableOverride.setEnabled(enableRest);
        this.m_versionOverride.setEnabled(enableRest && this.m_enableOverride.getSelection());
        this.m_nodeProperties.setEnabled(enableRest);
    }

    private Control getAdvisorTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.advisor_nodes);
        Composite advisorComposite = new Composite(tabComposite, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        advisorComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        advisorComposite.setLayoutData((Object)gridData);
        this.createNodeTableGroup(advisorComposite);
        this.createNodeFields(advisorComposite);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private String getCQueryXML() {
        String cqueryXML = "";
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Utils.serialize((ISaxable)this.m_componentQuery.createComponentQuery(), (OutputStream)baos);
            cqueryXML = baos.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cqueryXML;
    }

    private Control getDocumentationTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.documentation);
        Composite descComposite = new Composite(tabComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        descComposite.setLayout((Layout)layout);
        descComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        UiUtils.createGridLabel(descComposite, Messages.short_description_with_colon, 1, 0, 0);
        this.m_shortDesc = UiUtils.createGridText(descComposite, 1, 0, 0, this.m_compoundModifyListener);
        Label label = UiUtils.createGridLabel(descComposite, Messages.documentation_with_colon, 1, 0, 0);
        label.setLayoutData((Object)new GridData(4, 1, false, false));
        this.m_documentation = UiUtils.createGridText(descComposite, 1, 0, 514, this.m_compoundModifyListener);
        this.m_documentation.setLayoutData((Object)new GridData(4, 4, true, true));
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getMainTabControl(CTabFolder parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite((Composite)parent, Messages.main);
        Composite nameComposite = new Composite(tabComposite, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginRight = 8;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        nameComposite.setLayout((Layout)layout);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = UiUtils.createGridLabel(nameComposite, Messages.component_name_with_colon, 1, 0, 0);
        int labelWidth = label.computeSize((int)-1, (int)-1).x + 5;
        GridData gridData = new GridData(4, 4, false, false);
        gridData.widthHint = labelWidth;
        label.setLayoutData((Object)gridData);
        this.m_componentName = UiUtils.createGridText(nameComposite, 2, 0, 0, this.m_compoundModifyListener);
        UiUtils.createGridLabel(nameComposite, Messages.component_type_with_colon, 1, 0, 0);
        this.m_componentType = UiUtils.createGridCombo(nameComposite, 1, 0, null, null, 76);
        this.m_componentType.setItems(AbstractComponentType.getComponentTypeIDs((boolean)true));
        this.m_componentType.addModifyListener((ModifyListener)this.m_compoundModifyListener);
        UiUtils.createEmptyPanel(nameComposite);
        int textWidth = this.m_componentType.computeSize((int)-1, (int)-1).x;
        gridData = (GridData)this.m_componentType.getLayoutData();
        gridData.widthHint = textWidth;
        this.m_componentType.setLayoutData((Object)gridData);
        Group versionGroup = new Group(tabComposite, 0);
        versionGroup.setText(Messages.version);
        layout = new GridLayout(3, false);
        versionGroup.setLayout((Layout)layout);
        versionGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_versionDesignator = new VersionDesignator((Composite)versionGroup);
        this.m_versionDesignator.addVersionDesignatorListener(this.m_compoundModifyListener);
        Label control = this.m_versionDesignator.getVersionDsTypeLabel();
        gridData = (GridData)control.getLayoutData();
        gridData.widthHint = labelWidth - layout.marginWidth - 3;
        control.setLayoutData((Object)gridData);
        control = this.m_versionDesignator.getVersionDsTypeCombo();
        gridData = (GridData)control.getLayoutData();
        gridData.widthHint = textWidth;
        control.setLayoutData((Object)gridData);
        Group propertiesGroup = new Group(tabComposite, 0x400000);
        propertiesGroup.setText(Messages.properties);
        layout = new GridLayout(2, false);
        propertiesGroup.setLayout((Layout)layout);
        propertiesGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_propertyURLCheckbox = UiUtils.createCheckButton((Composite)propertiesGroup, Messages.user_properties, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (!button.getSelection()) {
                    QueryEditor.this.m_propertyURL.setText("");
                }
            }
        });
        gridData = new GridData(1, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        this.m_propertyURLCheckbox.setLayoutData((Object)gridData);
        label = UiUtils.createGridLabel((Composite)propertiesGroup, Messages.properties_with_colon, 1, labelWidth - layout.marginWidth - 3, 0);
        Composite propertiesComposite = new Composite((Composite)propertiesGroup, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        propertiesComposite.setLayout((Layout)layout);
        propertiesComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_propertyURL = UiUtils.createGridText(propertiesComposite, 1, 0, 0, this.m_compoundModifyListener);
        Button browseButton = new Button(propertiesComposite, 8);
        browseButton.setLayoutData((Object)new GridData(4, 4, false, false));
        browseButton.setText(Messages.browse_with_dots);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FileDialog dlg = new FileDialog(QueryEditor.this.getSite().getShell());
                dlg.setFilterExtensions(new String[]{"*.properties"});
                String name = dlg.open();
                if (name == null) {
                    return;
                }
                try {
                    QueryEditor.this.m_propertyURL.setText(TextUtils.notNullString((Object)new URL(name)));
                }
                catch (MalformedURLException e) {
                    try {
                        QueryEditor.this.m_propertyURL.setText(TextUtils.notNullString((Object)new File(name).toURI().toURL()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        });
        this.m_propertyURLCheckbox.addSelectionListener((SelectionListener)new CheckboxSelectionListener(new Control[]{label, this.m_propertyURL, browseButton}));
        Group rmapGroup = new Group(tabComposite, 0x400000);
        rmapGroup.setText(Messages.resource_map);
        layout = new GridLayout(2, false);
        rmapGroup.setLayout((Layout)layout);
        rmapGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_requestURLCheckbox = UiUtils.createCheckButton((Composite)rmapGroup, Messages.use_resource_map, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (!button.getSelection()) {
                    QueryEditor.this.m_requestURL.setText("");
                }
            }
        });
        gridData = new GridData(1, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        this.m_requestURLCheckbox.setLayoutData((Object)gridData);
        label = UiUtils.createGridLabel((Composite)rmapGroup, Messages.rmap_url_with_colon, 1, labelWidth - layout.marginWidth - 3, 0);
        Composite rmapComposite = new Composite((Composite)rmapGroup, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        rmapComposite.setLayout((Layout)layout);
        rmapComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_requestURL = UiUtils.createGridText(rmapComposite, 1, 0, 0, this.m_compoundModifyListener);
        browseButton = new Button(rmapComposite, 8);
        browseButton.setLayoutData((Object)new GridData(4, 4, false, false));
        browseButton.setText(Messages.browse_with_dots);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FileDialog dlg = new FileDialog(QueryEditor.this.getSite().getShell());
                dlg.setFilterExtensions(new String[]{"*.rmap"});
                String name = dlg.open();
                if (name == null) {
                    return;
                }
                try {
                    QueryEditor.this.m_requestURL.setText(TextUtils.notNullString((Object)new URL(name)));
                }
                catch (MalformedURLException e) {
                    try {
                        QueryEditor.this.m_requestURL.setText(TextUtils.notNullString((Object)new File(name).toURI().toURL()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        });
        this.m_requestURLCheckbox.addSelectionListener((SelectionListener)new CheckboxSelectionListener(new Control[]{label, this.m_requestURL, browseButton}));
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getPropertiesTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.properties);
        this.m_properties = new Properties(tabComposite, 0);
        this.m_properties.addPropertiesModifyListener(this.m_compoundModifyListener);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private AdvisorNodeBuilder getSelectedNode() {
        int idx = this.m_nodeTable.getTable().getSelectionIndex();
        return idx >= 0 ? (AdvisorNodeBuilder)this.m_nodeTable.getElementAt(idx) : null;
    }

    private int getSelectionIndex() {
        return this.m_nodeTable.getTable().getSelectionIndex();
    }

    private Control getXMLTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.xml_content);
        Composite xmlComposite = new Composite(tabComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        xmlComposite.setLayout((Layout)layout);
        xmlComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_xml = UiUtils.createGridText(xmlComposite, 1, 0, 778, null);
        this.m_xml.setLayoutData((Object)new GridData(4, 4, true, true));
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private void initStackControl() {
        this.m_nodeTree.setSelection(this.m_nodeTree.getItem(0));
        this.m_nodesStackLayout.topControl = this.m_nodesHash.get(this.m_nodeTree.getItem(0).getText());
        this.m_nodesStackComposite.layout();
    }

    private void loadComponent(boolean materialize) {
        if (!this.commitChangesToQuery()) {
            return;
        }
        try {
            ResolveJob resolveJob = new ResolveJob(this.m_componentQuery.createComponentQuery(), materialize, this.getSite(), this.m_continueOnError);
            resolveJob.schedule();
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), null, null, (IStatus)e.getStatus());
        }
    }

    private void newNode() {
        if (!this.saveLastNode()) {
            return;
        }
        AdvisorNodeBuilder node = this.addEmptyNode();
        this.refreshList();
        this.selectRow(node);
        this.setDirty(true);
        this.nodeSelectionEvent();
    }

    private void nodeSelectionEvent() {
        this.updateLastNode();
        this.refreshNodeFields();
        this.enableDisableButtonGroup();
        this.initStackControl();
        this.m_namePattern.setFocus();
    }

    private void refreshList() {
        this.m_nodeTable.setInput((Object)this.m_componentQuery.getAdvisoryNodes());
    }

    private void refreshNodeFields() {
        try {
            this.m_suppressModifyListener = true;
            AdvisorNodeBuilder node = this.getSelectedNode();
            if (node == null) {
                node = new AdvisorNodeBuilder();
            }
            this.m_allowCircular.setSelection(node.allowCircularDependency());
            this.m_namePattern.setText(TextUtils.notNullString((Object)node.getNamePattern()));
            this.m_filter.setText(TextUtils.notNullString((Object)node.getFilter()));
            this.m_category.select(this.m_category.indexOf(TextUtils.notNullString((Object)node.getComponentTypeID())));
            this.m_overlayFolder.setText(TextUtils.notNullString((Object)node.getOverlayFolder()));
            this.m_wantedAttributes.setText(TextUtils.notNullString((Object)TextUtils.concat((Collection)node.getAttributes(), (String)",")));
            this.m_prune.setSelection(node.isPrune());
            this.m_mutableLevel.select(this.m_mutableLevel.indexOf(node.getMutableLevel().toString()));
            this.m_sourceLevel.select(this.m_sourceLevel.indexOf(node.getSourceLevel().toString()));
            this.m_skipComponent.setSelection(node.skipComponent());
            this.m_useTargetPlatform.setSelection(node.isUseTargetPlatform());
            this.m_useWorkspace.setSelection(node.isUseWorkspace());
            this.m_useMaterialization.setSelection(node.isUseMaterialization());
            this.m_useResolutionService.setSelection(node.isUseRemoteResolution());
            this.m_branchTagPath.setText(TextUtils.notNullString((Object)VersionSelector.toString((VersionSelector[])node.getBranchTagPath())));
            long revision = node.getRevision();
            this.m_revision.setText(revision == -1L ? "" : Long.toString(revision));
            Date timestamp = node.getTimestamp();
            this.m_timestamp.setText(timestamp == null ? "" : this.m_timestampFormat.format(timestamp));
            VersionRange vs = node.getVersionOverride();
            boolean enableOverride = vs != null;
            this.m_enableOverride.setSelection(enableOverride);
            this.m_versionOverride.setEnabled(enableOverride);
            this.m_versionOverride.refreshValues(vs);
            this.m_nodeProperties.setProperties(node.getProperties());
            this.m_nodeProperties.refreshList();
            Documentation doc = node.getDocumentation();
            this.m_nodeDocumentation.setText(TextUtils.notNullString((Object)(doc == null ? null : doc.toString())));
        }
        finally {
            this.m_suppressModifyListener = false;
        }
    }

    private void refreshQuery() {
        this.setDirty(false);
        this.m_mute = true;
        try {
            ComponentRequest request = this.m_componentQuery.getRootRequest();
            this.m_componentName.setText(TextUtils.notNullString((Object)request.getName()));
            this.m_componentType.select(this.m_componentType.indexOf(TextUtils.notNullString((Object)request.getComponentTypeID())));
            this.m_versionDesignator.refreshValues(request.getVersionRange());
            String string = TextUtils.notNullString((Object)this.m_componentQuery.getPropertiesURL());
            this.m_propertyURL.setText(string);
            this.m_propertyURLCheckbox.setSelection(string.length() > 0);
            this.m_propertyURLCheckbox.notifyListeners(13, new Event());
            string = TextUtils.notNullString((Object)this.m_componentQuery.getResourceMapURL());
            this.m_requestURL.setText(string);
            this.m_requestURLCheckbox.setSelection(string.length() > 0);
            this.m_requestURLCheckbox.notifyListeners(13, new Event());
            this.m_properties.setProperties(this.m_componentQuery.getDeclaredProperties());
            this.m_shortDesc.setText(TextUtils.notNullString((Object)this.m_componentQuery.getShortDesc()));
            Documentation doc = this.m_componentQuery.getDocumentation();
            this.m_documentation.setText(TextUtils.notNullString((Object)(doc == null ? "" : doc.toString())));
            this.refreshList();
            this.m_properties.refreshList();
            this.m_needsRefresh = false;
            this.nodeSelectionEvent();
        }
        finally {
            this.m_mute = false;
        }
    }

    private void removeNode() {
        AdvisorNodeBuilder node = this.getSelectedNode();
        if (node != null) {
            int last_idx = this.getSelectionIndex();
            this.m_componentQuery.removeAdvisorNode(node);
            this.setDirty(true);
            this.m_lastEditedNode = -99;
            this.refreshList();
            if (this.m_componentQuery.getAdvisoryNodes().size() > last_idx) {
                this.m_nodeTable.getTable().setSelection(last_idx);
            } else if (this.m_componentQuery.getAdvisoryNodes().size() > 0) {
                this.m_nodeTable.getTable().setSelection(last_idx - 1);
            } else {
                this.m_nodeTable.getTable().deselectAll();
            }
            this.nodeSelectionEvent();
        }
    }

    private boolean saveLastNode() {
        return this.saveLastNode(EMPTY_ACTIVATOR);
    }

    private boolean saveLastNode(IActivator failureActivator) {
        if (this.m_lastEditedNode != -1 && this.m_lastEditedNode != -99) {
            return this.saveNode(this.m_lastEditedNode, failureActivator);
        }
        return true;
    }

    private boolean saveNode(int nodeIdx, IActivator failureActivator) {
        String tmp;
        AdvisorNodeBuilder node = (AdvisorNodeBuilder)this.m_nodeTable.getElementAt(nodeIdx);
        boolean isNewNode = false;
        if (node == null) {
            node = new AdvisorNodeBuilder();
            isNewNode = true;
        }
        boolean refreshListNeeded = false;
        String patternStr = UiUtils.trimmedValue(this.m_namePattern);
        String category = this.m_category.getItem(this.m_category.getSelectionIndex());
        if (category.length() == 0) {
            category = null;
        }
        String filterStr = UiUtils.trimmedValue(this.m_filter);
        if (patternStr == null && filterStr == null && category == null) {
            failureActivator.activate();
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)Messages.name_pattern_component_type_or_filter_must_be_set);
            return false;
        }
        Pattern pattern = null;
        if (patternStr != null) {
            try {
                pattern = Pattern.compile(patternStr);
            }
            catch (PatternSyntaxException e) {
                failureActivator.activate();
                MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
                return false;
            }
        }
        Filter filter = null;
        if (filterStr != null) {
            try {
                filter = FilterFactory.newInstance((String)filterStr);
            }
            catch (InvalidSyntaxException e) {
                failureActivator.activate();
                MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
                return false;
            }
        }
        if (!(Trivial.equalsAllowNull((Object)pattern, (Object)node.getNamePattern()) && Trivial.equalsAllowNull((Object)category, (Object)node.getComponentTypeID()) && Trivial.equalsAllowNull((Object)filter, (Object)node.getFilter()))) {
            AdvisorNodeBuilder patternEqual = this.m_componentQuery.getNodeByCriteria(pattern, category, filter);
            if (patternEqual != null) {
                failureActivator.activate();
                if (!MessageDialog.openQuestion((Shell)this.getSite().getShell(), null, (String)Messages.overwrite_existing_node_with_same_criteria)) {
                    return false;
                }
                this.m_componentQuery.removeAdvisorNode(patternEqual);
            }
            refreshListNeeded = true;
        }
        node.setNamePattern(pattern);
        node.setFilter(filter);
        node.setComponentTypeID(category);
        node.setAllowCircularDependency(this.m_allowCircular.getSelection());
        boolean override = this.m_enableOverride.getSelection();
        VersionRange versionOverride = null;
        if (override) {
            try {
                versionOverride = this.m_versionOverride.getDirectVersionDesignator();
            }
            catch (CoreException e1) {
                failureActivator.activate();
                ErrorDialog.openError((Shell)this.getSite().getShell(), null, null, (IStatus)e1.getStatus());
                return false;
            }
        }
        try {
            tmp = UiUtils.trimmedValue(this.m_overlayFolder);
            node.setOverlayFolder(tmp == null ? null : URLUtils.normalizeToURL((String)tmp));
        }
        catch (Exception e) {
            failureActivator.activate();
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
            return false;
        }
        node.setSkipComponent(this.m_skipComponent.getSelection());
        node.getAttributes().clear();
        tmp = UiUtils.trimmedValue(this.m_wantedAttributes);
        if (tmp != null) {
            String[] stringArray = tmp.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attribute = stringArray[n2];
                node.addAttribute(attribute);
                ++n2;
            }
        }
        node.setPrune(this.m_prune.getSelection());
        int idx = this.m_mutableLevel.getSelectionIndex();
        node.setMutableLevel(idx >= 0 ? MutableLevel.values()[idx] : null);
        idx = this.m_sourceLevel.getSelectionIndex();
        node.setSourceLevel(idx >= 0 ? SourceLevel.values()[idx] : null);
        node.setUseTargetPlatform(this.m_useTargetPlatform.getSelection());
        node.setUseWorkspace(this.m_useWorkspace.getSelection());
        node.setUseMaterialization(this.m_useMaterialization.getSelection());
        node.setUseRemoteResolution(this.m_useResolutionService.getSelection());
        node.setBranchTagPath(VersionSelector.fromPath((String)UiUtils.trimmedValue(this.m_branchTagPath)));
        tmp = UiUtils.trimmedValue(this.m_revision);
        if (tmp != null) {
            try {
                node.setRevision(Long.parseLong(tmp));
            }
            catch (NumberFormatException e) {
                failureActivator.activate();
                MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)Messages.revision_must_be_a_valid_integer_number);
                return false;
            }
        } else {
            node.setRevision(-1L);
        }
        tmp = UiUtils.trimmedValue(this.m_timestamp);
        if (tmp != null) {
            try {
                node.setTimestamp(this.m_timestampFormat.parse(tmp));
            }
            catch (ParseException e) {
                failureActivator.activate();
                MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)(String.valueOf(Messages.timestamp_must_conform_to_format_with_colon) + this.m_timestampFormat.toPattern()));
                return false;
            }
        } else {
            node.setTimestamp(null);
        }
        node.setVersionOverride(versionOverride);
        this.m_nodeProperties.fillProperties(node.getProperties());
        String doc = UiUtils.trimmedValue(this.m_nodeDocumentation);
        try {
            node.setDocumentation(doc == null ? null : Documentation.parse((String)doc));
        }
        catch (Exception e) {
            failureActivator.activate();
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
            return false;
        }
        if (isNewNode) {
            this.m_componentQuery.addAdvisorNode(node);
            refreshListNeeded = true;
        }
        if (refreshListNeeded) {
            this.refreshList();
            this.nodeSelectionEvent();
        }
        this.enableDisableButtonGroup();
        return true;
    }

    private void saveToPath(IPath path) {
        try {
            SaveRunnable sr = new SaveRunnable((ISaxable)this.m_componentQuery.createComponentQuery(), path);
            this.getSite().getWorkbenchWindow().run(true, true, (IRunnableWithProgress)sr);
            this.setInputWithNotify(sr.getSavedInput());
            this.setDirty(false);
            this.setPartName(path.lastSegment());
            this.firePropertyChange(1);
        }
        catch (InvocationTargetException e) {
            CoreException t = BuckminsterException.wrap((Throwable)e);
            String msg = String.valueOf(Messages.unable_to_save_file_0) + path;
            CorePlugin.getLogger().error((Throwable)t, msg, new Object[0]);
            ErrorDialog.openError((Shell)this.getSite().getShell(), null, (String)msg, (IStatus)t.getStatus());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean selectRow(AdvisorNodeBuilder node) {
        int idx = this.m_componentQuery.getAdvisoryNodes().indexOf(node);
        if (idx == -1) {
            return false;
        }
        this.m_nodeTable.getTable().setSelection(idx);
        return true;
    }

    private void setDirty(boolean flag) {
        if (this.m_mute || this.m_hasChanges == flag) {
            return;
        }
        this.m_hasChanges = flag;
        this.firePropertyChange(257);
    }

    private void swapAndReselect(int idxOffset, int selectionOffset) {
        if (!this.saveLastNode()) {
            return;
        }
        Table table = this.m_nodeTable.getTable();
        int idx = table.getSelectionIndex() + idxOffset;
        if (idx <= 0) {
            return;
        }
        List nl = this.m_componentQuery.getAdvisoryNodes();
        if (idx >= nl.size()) {
            return;
        }
        nl.set(idx - 1, nl.set(idx, (AdvisorNodeBuilder)nl.get(idx - 1)));
        this.refreshList();
        table.select(idx + selectionOffset);
        this.nodeSelectionEvent();
        this.setDirty(true);
    }

    private void updateLastNode() {
        if (this.getSelectionIndex() != -1) {
            this.m_lastSelectedNode = this.getSelectionIndex();
        }
        this.m_lastEditedNode = this.getSelectionIndex();
    }

    class AdvisorNodeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        AdvisorNodeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String lbl;
            AdvisorNodeBuilder node = (AdvisorNodeBuilder)element;
            switch (columnIndex) {
                case 0: {
                    lbl = node.getNamePattern() == null ? "" : node.getNamePattern().toString();
                    break;
                }
                case 1: {
                    lbl = node.getComponentTypeID();
                    break;
                }
                case 2: {
                    lbl = node.getFilter() == null ? "" : node.getFilter().toString();
                    break;
                }
                default: {
                    lbl = null;
                }
            }
            return lbl;
        }
    }

    class CheckboxSelectionListener
    extends SelectionAdapter {
        private Control[] m_controlsToEnable;

        public CheckboxSelectionListener(Control[] controlsToEnable) {
            this.m_controlsToEnable = controlsToEnable;
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            boolean enable = button.getSelection();
            Control[] controlArray = this.m_controlsToEnable;
            int n = this.m_controlsToEnable.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setEnabled(enable);
                ++n2;
            }
        }
    }

    class CompoundModifyListener
    implements VersionDesignatorListener,
    ModifyListener,
    PropertiesModifyListener,
    SelectionListener {
        CompoundModifyListener() {
        }

        public void modifyProperties(PropertiesModifyEvent e) {
            if (!QueryEditor.this.m_suppressModifyListener) {
                QueryEditor.this.setDirty(true);
            }
        }

        public void modifyText(ModifyEvent e) {
            if (!QueryEditor.this.m_suppressModifyListener) {
                QueryEditor.this.setDirty(true);
            }
        }

        public void modifyVersionDesignator(VersionDesignatorEvent e) {
            if (!QueryEditor.this.m_suppressModifyListener) {
                QueryEditor.this.setDirty(true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!QueryEditor.this.m_suppressModifyListener) {
                QueryEditor.this.setDirty(true);
            }
        }
    }
}

