/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.rmap;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.swt.custom.StyleRange;

public class NonRuleBasedDamagerRepairer
implements IPresentationDamager,
IPresentationRepairer {
    private IDocument m_document;
    private TextAttribute m_defaultTextAttribute;

    public NonRuleBasedDamagerRepairer(TextAttribute defaultTextAttribute) {
        if (defaultTextAttribute == null) {
            throw new IllegalArgumentException();
        }
        this.m_defaultTextAttribute = defaultTextAttribute;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion region) {
        this.addRange(presentation, region.getOffset(), region.getLength(), this.m_defaultTextAttribute);
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean documentPartitioningChanged) {
        if (!documentPartitioningChanged) {
            try {
                IRegion info = this.m_document.getLineInformationOfOffset(event.getOffset());
                int start = Math.max(partition.getOffset(), info.getOffset());
                int end = event.getOffset() + (event.getText() == null ? event.getLength() : event.getText().length());
                end = info.getOffset() <= end && end <= info.getOffset() + info.getLength() ? info.getOffset() + info.getLength() : this.endOfLineOf(end);
                end = Math.min(partition.getOffset() + partition.getLength(), end);
                return new Region(start, end - start);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return partition;
    }

    public void setDocument(IDocument document) {
        this.m_document = document;
    }

    protected void addRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
        if (attr != null) {
            presentation.addStyleRange(new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), attr.getStyle()));
        }
    }

    protected int endOfLineOf(int offset) throws BadLocationException {
        IRegion info = this.m_document.getLineInformationOfOffset(offset);
        if (offset <= info.getOffset() + info.getLength()) {
            return info.getOffset() + info.getLength();
        }
        int line = this.m_document.getLineOfOffset(offset);
        try {
            info = this.m_document.getLineInformation(line + 1);
            return info.getOffset() + info.getLength();
        }
        catch (BadLocationException x) {
            return this.m_document.getLength();
        }
    }
}

