/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.rmap;

import org.eclipse.buckminster.ui.editor.rmap.ColorManager;
import org.eclipse.buckminster.ui.editor.rmap.IXMLColorConstants;
import org.eclipse.buckminster.ui.editor.rmap.NonRuleBasedDamagerRepairer;
import org.eclipse.buckminster.ui.editor.rmap.XMLDoubleClickStrategy;
import org.eclipse.buckminster.ui.editor.rmap.XMLScanner;
import org.eclipse.buckminster.ui.editor.rmap.XMLTagScanner;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class XMLConfiguration
extends SourceViewerConfiguration {
    private XMLDoubleClickStrategy m_doubleClickStrategy;
    private XMLTagScanner m_tagScanner;
    private XMLScanner m_scanner;
    private final ColorManager m_colorManager;

    public XMLConfiguration(ColorManager colorManager) {
        this.m_colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.m_doubleClickStrategy == null) {
            this.m_doubleClickStrategy = new XMLDoubleClickStrategy();
        }
        return this.m_doubleClickStrategy;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.m_colorManager.getColor(IXMLColorConstants.XML_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__xml_comment");
        return reconciler;
    }

    protected XMLScanner getXMLScanner() {
        if (this.m_scanner == null) {
            this.m_scanner = new XMLScanner(this.m_colorManager);
            this.m_scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.m_colorManager.getColor(IXMLColorConstants.DEFAULT))));
        }
        return this.m_scanner;
    }

    protected XMLTagScanner getXMLTagScanner() {
        if (this.m_tagScanner == null) {
            this.m_tagScanner = new XMLTagScanner(this.m_colorManager);
            this.m_tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.m_colorManager.getColor(IXMLColorConstants.TAG))));
        }
        return this.m_tagScanner;
    }
}

