/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.ui.general.editor.ITable;
import org.eclipse.buckminster.ui.general.editor.ITableModifyListener;
import org.eclipse.buckminster.ui.general.editor.TableModifyEvent;
import org.eclipse.buckminster.ui.general.editor.TableModifyEventType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Table<T>
implements ITable<T> {
    private List<T> m_data;
    private boolean m_readOnly;
    private List<ITableModifyListener<T>> m_listeners = new ArrayList<ITableModifyListener<T>>();

    public Table(List<T> data) {
        this(data, false);
    }

    public Table(List<T> data, boolean readOnly) {
        this.m_data = data;
        this.m_readOnly = readOnly;
    }

    @Override
    public void addTableModifyListener(ITableModifyListener<T> listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public T getRow(int row) {
        return this.m_data.get(row);
    }

    @Override
    public List<T> getRows() {
        return this.m_data;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void removeRow(int row) {
        T oldTableRow = this.m_data.remove(row);
        this.notifyListeners(TableModifyEventType.REMOVE_ROW, row, oldTableRow);
    }

    @Override
    public void removeTableModifyListener(ITableModifyListener<T> listener) {
        this.m_listeners.remove(listener);
    }

    protected void notifyListeners(TableModifyEventType eventType, int row, T tableRow) {
        TableModifyEvent<T> e = new TableModifyEvent<T>(this, eventType, row, tableRow);
        for (ITableModifyListener<T> listener : this.m_listeners) {
            listener.modifyTable(e);
        }
    }
}

