/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor;

import org.eclipse.buckminster.ui.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class TableRowDialog
extends TitleAreaDialog {
    private final Image m_windowImage;
    private final String m_windowTitle;
    private final Image m_wizardImage;
    private final String m_helpURL;
    private final boolean m_newRow;
    private final boolean m_readOnly;

    public TableRowDialog(Shell parentShell, Image windowImage, String windowTitle, Image wizardImage, String helpURL, boolean newRow, boolean readOnly) {
        super(parentShell);
        this.m_windowImage = windowImage;
        this.m_windowTitle = windowTitle;
        this.m_wizardImage = wizardImage;
        this.m_helpURL = helpURL;
        this.m_newRow = newRow;
        this.m_readOnly = readOnly;
    }

    public boolean isHelpAvailable() {
        return this.m_helpURL != null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_windowTitle);
        if (this.m_windowImage != null) {
            newShell.setImage(this.m_windowImage);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.isReadOnly()) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.enableDisableOkButton();
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.m_wizardImage != null) {
            this.setTitleImage(this.m_wizardImage);
        }
        if (this.isReadOnly()) {
            this.setTitle(Messages.view_row);
            this.setMessage(Messages.view_row_fields);
        } else if (this.m_newRow) {
            this.setTitle(Messages.new_row);
            this.setMessage(Messages.enter_new_row_fields);
        } else {
            this.setTitle(Messages.edit_row);
            this.setMessage(Messages.edit_row_fields);
        }
        return contents;
    }

    protected Control createHelpControl(Composite parent) {
        Control helpControl = super.createHelpControl(parent);
        helpControl.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                if (TableRowDialog.this.m_helpURL != null) {
                    Program.launch((String)TableRowDialog.this.m_helpURL);
                }
            }
        });
        return helpControl;
    }

    protected abstract void enableDisableOkButton();

    protected boolean isReadOnly() {
        return this.m_readOnly;
    }
}

