/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor.simple;

import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.general.editor.simple.ISimpleTable;
import org.eclipse.buckminster.ui.general.editor.simple.SimpleTableRowDialog;
import org.eclipse.buckminster.ui.internal.DynamicTableLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTableEditor<T>
extends Composite {
    private final ISimpleTable<T> m_table;
    private final Image m_windowImage;
    private final String m_windowTitle;
    private final Image m_wizardImage;
    private final String m_helpURL;
    private TableViewer m_tableViewer;
    private Composite m_stackButtonComposite;
    private StackLayout m_stackButtonLayout;
    private Composite m_editButtonBox;
    private Composite m_viewButtonBox;
    private Button m_newButton;
    private Button m_editButton;
    private Button m_viewButton;
    private Button m_removeButton;
    private boolean m_enabled = true;

    public SimpleTableEditor(Composite parent, ISimpleTable<T> table, Image windowImage, String windowTitle, Image wizardImage, String helpURL, int style) {
        super(parent, style);
        this.m_table = table;
        this.m_windowImage = windowImage;
        this.m_windowTitle = windowTitle;
        this.m_wizardImage = wizardImage;
        this.m_helpURL = helpURL;
        this.initComposite();
    }

    public void refresh() {
        this.m_tableViewer.setInput(this.m_table);
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
        this.enableDisableButtonGroup();
    }

    private void createButtonBox(Composite parent) {
        this.m_stackButtonComposite = new Composite(parent, 0);
        this.m_stackButtonComposite.setLayoutData((Object)new GridData(1, 1, false, false));
        this.m_stackButtonLayout = new StackLayout();
        this.m_stackButtonLayout.marginWidth = 0;
        this.m_stackButtonLayout.marginHeight = 0;
        this.m_stackButtonComposite.setLayout((Layout)this.m_stackButtonLayout);
        this.m_editButtonBox = new Composite(this.m_stackButtonComposite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.m_editButtonBox.setLayout((Layout)gridLayout);
        this.m_editButtonBox.setLayoutData((Object)new GridData(1, 1, false, false));
        this.m_newButton = UiUtils.createPushButton(this.m_editButtonBox, Messages.new_label, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleTableEditor.this.newRow();
            }
        });
        this.m_newButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.m_editButton = UiUtils.createPushButton(this.m_editButtonBox, Messages.edit, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleTableEditor.this.editRow(false);
            }
        });
        this.m_editButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.m_removeButton = UiUtils.createPushButton(this.m_editButtonBox, Messages.remove, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleTableEditor.this.removeRow();
            }
        });
        this.m_removeButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.m_viewButtonBox = new Composite(this.m_stackButtonComposite, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.m_viewButtonBox.setLayout((Layout)gridLayout);
        this.m_viewButtonBox.setLayoutData((Object)new GridData(1, 1, false, false));
        this.m_viewButton = UiUtils.createPushButton(this.m_viewButtonBox, Messages.view, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleTableEditor.this.editRow(true);
            }
        });
        this.m_viewButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.enableDisableButtonGroup();
    }

    private void editRow(boolean readOnly) {
        SimpleTableRowDialog<T> dialog = new SimpleTableRowDialog<T>(this.getShell(), this.m_windowImage, this.m_windowTitle, this.m_wizardImage, this.m_helpURL, this.m_table, this.m_tableViewer.getTable().getSelectionIndex(), readOnly);
        if (dialog.open() == 0) {
            this.refresh();
        }
    }

    private void enableDisableButtonGroup() {
        boolean rowSelected;
        boolean bl = rowSelected = this.m_tableViewer.getTable().getSelectionIndex() >= 0;
        if (this.m_enabled && !this.m_table.isReadOnly()) {
            this.m_newButton.setEnabled(true);
            this.m_editButton.setEnabled(rowSelected);
            this.m_removeButton.setEnabled(rowSelected);
            this.m_stackButtonLayout.topControl = this.m_editButtonBox;
        } else {
            this.m_newButton.setEnabled(false);
            this.m_editButton.setEnabled(false);
            this.m_removeButton.setEnabled(false);
            this.m_stackButtonLayout.topControl = this.m_viewButtonBox;
        }
        this.m_viewButton.setEnabled(rowSelected);
        this.m_stackButtonComposite.layout();
    }

    private void initComposite() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(4, 4, true, true));
        Table table = new Table((Composite)this, 68356);
        table.setHeaderVisible(true);
        DynamicTableLayout layout = new DynamicTableLayout(50);
        int tableIdx = 0;
        int idx = 0;
        while (idx < this.m_table.getColumns()) {
            if (this.m_table.getColumnWeights()[idx] > 0) {
                TableColumn tableColumn = new TableColumn(table, 16384, tableIdx);
                tableColumn.setText(this.m_table.getColumnHeaders()[idx]);
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(this.m_table.getColumnWeights()[idx], true));
                ++tableIdx;
            }
            ++idx;
        }
        table.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gridData);
        this.m_tableViewer = new TableViewer(table);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.m_tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.m_tableViewer.setInput(this.m_table);
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SimpleTableEditor.this.enableDisableButtonGroup();
            }
        });
        this.m_tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (SimpleTableEditor.this.m_tableViewer.getTable().getSelectionIndex() >= 0) {
                    SimpleTableEditor.this.editRow(!SimpleTableEditor.this.m_enabled || SimpleTableEditor.this.m_table.isReadOnly());
                }
            }
        });
        this.createButtonBox(this);
    }

    private void newRow() {
        SimpleTableRowDialog<T> dialog = new SimpleTableRowDialog<T>(this.getShell(), this.m_windowImage, this.m_windowTitle, this.m_wizardImage, this.m_helpURL, this.m_table, -1, false);
        if (dialog.open() == 0) {
            this.refresh();
        }
    }

    private void removeRow() {
        this.m_table.removeRow(this.m_tableViewer.getTable().getSelectionIndex());
        this.refresh();
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return SimpleTableEditor.this.m_table.getRows().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Object field = SimpleTableEditor.this.m_table.getEditorField(element, columnIndex);
            return field == null ? "" : field.toString();
        }
    }
}

