/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor.simple;

import java.util.Arrays;
import org.eclipse.buckminster.ui.general.editor.TableRowDialog;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.simple.ISimpleTable;
import org.eclipse.buckminster.ui.general.editor.simple.IWidgetin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTableRowDialog<T>
extends TableRowDialog {
    private final ISimpleTable<T> m_table;
    private final int m_row;
    private final boolean m_newRow;
    private IWidgetin[] m_widgetins;

    public SimpleTableRowDialog(Shell parent, Image windowImage, String windowTitle, Image wizardImage, String helpURL, ISimpleTable<T> table, int row, boolean readOnly) {
        super(parent, windowImage, windowTitle, wizardImage, helpURL, row == -1, readOnly);
        this.m_table = table;
        this.m_row = row;
        this.m_newRow = row == -1;
        this.m_widgetins = new IWidgetin[table.getColumns()];
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            Object[] fields = new Object[this.m_table.getColumns()];
            int i = 0;
            while (i < this.m_table.getColumns()) {
                fields[i] = this.m_widgetins[i].getData();
                ++i;
            }
            try {
                if (this.m_newRow) {
                    this.m_table.addRow(fields);
                } else {
                    this.m_table.setRow(this.m_row, fields);
                }
            }
            catch (ValidatorException e) {
                this.setErrorMessage(e.getMessage());
                this.getButton(0).setEnabled(false);
                return;
            }
        }
        this.setReturnCode(buttonId);
        this.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Listener rowModifyListener = new Listener(){

            public void handleEvent(Event event) {
                SimpleTableRowDialog.this.setErrorMessage(event.text);
                SimpleTableRowDialog.this.enableDisableOkButton();
            }
        };
        Composite textComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 7;
        layout.marginWidth = 10;
        textComposite.setLayout((Layout)layout);
        textComposite.setLayoutData((Object)new GridData(768));
        Object[] fields = null;
        if (!this.m_newRow) {
            fields = this.m_table.toRowArray(this.m_table.getRow(this.m_row));
        } else {
            fields = new Object[this.m_table.getColumns()];
            Arrays.fill(fields, null);
        }
        this.m_widgetins = this.m_table.fillGrid(textComposite, fields);
        int i = 0;
        while (i < this.m_table.getColumns()) {
            this.m_widgetins[i].addListener(954814, rowModifyListener);
            ++i;
        }
        return textComposite;
    }

    @Override
    protected void enableDisableOkButton() {
        if (this.getButton(0) != null) {
            boolean valid = true;
            try {
                int i = 0;
                while (i < this.m_table.getColumns()) {
                    this.m_table.getFieldValidator(i).validate(this.m_widgetins[i].getData());
                    ++i;
                }
            }
            catch (ValidatorException e1) {
                valid = false;
            }
            this.getButton(0).setEnabled(valid);
        }
    }
}

