/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.ui.general.editor.simple.IWidgetin;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Widgetin
implements IWidgetin {
    private Object m_data = null;
    private Map<Integer, List<Listener>> m_listenersMap = new HashMap<Integer, List<Listener>>();

    public void addListener(int eventType, Listener listener) {
        List<Listener> eventListeners = this.m_listenersMap.get(eventType);
        if (eventListeners == null) {
            eventListeners = new ArrayList<Listener>();
            this.m_listenersMap.put(eventType, eventListeners);
        }
        if (!eventListeners.contains(listener)) {
            eventListeners.add(listener);
        }
    }

    public Object getData() {
        return this.m_data;
    }

    public void notifyListeners(int eventType, Event event) {
        List<Listener> eventListeners = this.m_listenersMap.get(eventType);
        if (eventListeners != null) {
            for (Listener listener : eventListeners) {
                listener.handleEvent(event);
            }
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.m_listenersMap.remove(eventType);
    }

    public void setData(Object data) {
        this.m_data = data;
    }
}

