/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor.structured;

import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.structured.IActivator;
import org.eclipse.buckminster.ui.general.editor.structured.IStructuredTable;
import org.eclipse.buckminster.ui.general.editor.structured.StructuredTableEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnePageTableEditor<T>
extends StructuredTableEditor<T> {
    private final boolean m_disableNew;
    private final boolean m_disableRemove;

    public OnePageTableEditor(Composite parent, IStructuredTable<T> table, boolean swapButtonsFlag, boolean disableNew, boolean disableRemove, int style) {
        super(parent, table, swapButtonsFlag, style);
        this.m_disableNew = disableNew;
        this.m_disableRemove = disableRemove;
    }

    public OnePageTableEditor(Composite parent, IStructuredTable<T> table, boolean swapButtonsFlag, int style) {
        this(parent, table, swapButtonsFlag, false, false, style);
    }

    public void cancelRow() {
        this.enableDisableButtonGroup();
        this.refreshRow();
    }

    @Override
    public void refresh() {
        this.refreshTable();
        this.enableDisableButtonGroup();
        this.refreshRow();
    }

    public boolean save() {
        return this.save(null);
    }

    public boolean save(IActivator activator) {
        if (this.getTableViewer().getTable().getSelectionIndex() >= 0) {
            try {
                this.saveRow();
            }
            catch (ValidatorException e) {
                if (activator != null) {
                    activator.activate();
                }
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.error, (String)e.getMessage());
                this.getTableViewer().getTable().select(this.getLastSelectedRow());
                return false;
            }
            this.enableDisableButtonGroup();
        }
        return true;
    }

    public boolean show(T row, String tab) {
        int stackIdx = this.getTable().getStackKeys().indexOf(tab);
        if (stackIdx == -1) {
            return false;
        }
        if (!this.selectRow(row)) {
            return false;
        }
        this.refreshRow();
        this.setStackOption(stackIdx);
        return true;
    }

    @Override
    protected void createTableButtons(Composite parent) {
        Composite buttonBox = new Composite(parent, 0);
        buttonBox.setLayoutData((Object)new GridData(4, 4, false, false));
        FillLayout layout = new FillLayout(512);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.spacing = 3;
        buttonBox.setLayout((Layout)layout);
        Composite buttonBox1 = new Composite(buttonBox, 0);
        layout = new FillLayout(256);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonBox1.setLayout((Layout)layout);
        this.setNewButton(UiUtils.createPushButton(buttonBox1, Messages.new_label, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OnePageTableEditor.this.newRow();
            }
        }));
        this.setRemoveButton(UiUtils.createPushButton(buttonBox1, Messages.remove, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OnePageTableEditor.this.removeRow();
            }
        }));
        if (this.isSwapButtonAllowed()) {
            Composite buttonBox2 = new Composite(buttonBox, 0);
            layout = new FillLayout(256);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            buttonBox2.setLayout((Layout)layout);
            this.setMoveUpButton(UiUtils.createPushButton(buttonBox2, Messages.move_up, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OnePageTableEditor.this.swapAndReselect(0, -1);
                }
            }));
            this.setMoveDownButton(UiUtils.createPushButton(buttonBox2, Messages.move_down, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OnePageTableEditor.this.swapAndReselect(1, 0);
                }
            }));
        }
    }

    @Override
    protected Composite createTableGroupComposite(Composite parent) {
        Composite componentTableGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        componentTableGroup.setLayout((Layout)gl);
        componentTableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        return componentTableGroup;
    }

    @Override
    protected void editRow(boolean newRow, boolean readOnly) {
    }

    @Override
    protected void enableDisableButtonGroup() {
        Table table = this.getTableViewer().getTable();
        int top = table.getItemCount();
        int idx = table.getSelectionIndex();
        if (this.isEnabled() && !this.getTable().isReadOnly()) {
            this.getNewButton().setEnabled(!this.m_disableNew);
            this.getRemoveButton().setEnabled(!this.m_disableRemove && idx >= 0);
            if (this.isSwapButtonAllowed()) {
                this.getMoveUpButton().setEnabled(idx > 0);
                this.getMoveDownButton().setEnabled(idx >= 0 && idx < top - 1);
            }
        } else {
            this.getNewButton().setEnabled(false);
            this.getRemoveButton().setEnabled(false);
            if (this.isSwapButtonAllowed()) {
                this.getMoveUpButton().setEnabled(false);
                this.getMoveDownButton().setEnabled(false);
            }
        }
        if (this.isEnabled()) {
            this.enableFields(idx >= 0);
        } else {
            this.enableFields(false);
        }
    }

    @Override
    protected void initComposite() {
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        this.setLayoutData(gridData);
        this.createTableGroup(this);
        this.createStackOptions(this);
        this.createStack(this);
        this.fillStackOptions();
    }

    @Override
    protected void newRow() {
        if (this.getSelectionIndex() >= 0 && !this.save()) {
            return;
        }
        Object row = this.getTable().addEmptyRow();
        this.refreshTable();
        this.selectRow(row);
        this.updateLastRow();
        this.enableDisableButtonGroup();
        this.refreshRow();
        this.focusStackComposite();
    }

    @Override
    protected boolean rowSelectionEvent() {
        if (!this.save()) {
            return false;
        }
        this.enableDisableButtonGroup();
        this.refreshRow();
        return true;
    }
}

