/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor.structured;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.ui.general.editor.ITableModifyListener;
import org.eclipse.buckminster.ui.general.editor.Table;
import org.eclipse.buckminster.ui.general.editor.TableModifyEvent;
import org.eclipse.buckminster.ui.general.editor.TableModifyEventType;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.structured.FieldModifyEvent;
import org.eclipse.buckminster.ui.general.editor.structured.IFieldModifyListener;
import org.eclipse.buckminster.ui.general.editor.structured.IStructuredTable;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StructuredTable<T>
extends Table<T>
implements IStructuredTable<T> {
    protected final CompoundFieldModifyListener FIELD_LISTENER = new CompoundFieldModifyListener();
    private List<String> m_stackKeys = new ArrayList<String>();
    private Map<String, Control> m_stackMap = new HashMap<String, Control>();
    private List<IFieldModifyListener> m_fieldListeners = new ArrayList<IFieldModifyListener>();
    private boolean m_suppressFieldListener = false;

    public StructuredTable(List<T> data, boolean readOnly) {
        super(data, readOnly);
        this.addTableModifyListener(new ITableModifyListener<T>(){

            @Override
            public void modifyTable(TableModifyEvent<T> e) {
                if (e.getEventType() == TableModifyEventType.REMOVE_ROW) {
                    StructuredTable.this.notifyFieldListeners(e);
                }
            }
        });
    }

    @Override
    public T addEmptyRow() {
        T tableRow = this.createNewRow();
        this.getRows().add(tableRow);
        return tableRow;
    }

    public void addFieldModifyListener(IFieldModifyListener listener) {
        if (!this.m_fieldListeners.contains(listener)) {
            this.m_fieldListeners.add(listener);
        }
    }

    @Override
    public void fillStackComposite(Composite stackComposite) {
        this.clearStackMapping();
        this.fillStack(stackComposite);
    }

    @Override
    public Control getStackControl(String stackKey) {
        return this.m_stackMap.get(stackKey);
    }

    @Override
    public List<String> getStackKeys() {
        return this.m_stackKeys;
    }

    @Override
    public int getTableViewerColumns() {
        return this.getTableViewerColumnHeaders().length;
    }

    @Override
    public void refreshRow(int rowIdx) {
        T builder = rowIdx == -1 ? this.createNewRow() : this.getRow(rowIdx);
        this.m_suppressFieldListener = true;
        this.refreshRow(builder);
        this.m_suppressFieldListener = false;
    }

    public void removeFieldModifyListener(IFieldModifyListener listener) {
        this.m_fieldListeners.remove(listener);
    }

    @Override
    public void save(int rowIdx) throws ValidatorException {
        if (rowIdx == -1) {
            T tableRow = this.createNewRow();
            this.getRows().add(tableRow);
            try {
                this.setRowValues(tableRow);
            }
            catch (ValidatorException e) {
                this.getRows().remove(tableRow);
                throw e;
            }
            this.notifyListeners(TableModifyEventType.ADD_ROW, this.getRows().size() - 1, tableRow);
        } else {
            Object tableRow = this.getRows().get(rowIdx);
            this.setRowValues(tableRow);
            this.notifyListeners(TableModifyEventType.UPDATE_ROW, rowIdx, tableRow);
        }
    }

    @Override
    public boolean swapRows(int rowIdx, int idxOffset) {
        int idx = rowIdx + idxOffset;
        if (idx <= 0) {
            return false;
        }
        List data = this.getRows();
        if (idx >= data.size()) {
            return false;
        }
        data.set(idx - 1, data.set(idx, data.get(idx - 1)));
        int newIdx = rowIdx + idxOffset;
        if (idxOffset == 0) {
            newIdx = rowIdx - 1;
        }
        this.notifyListeners(TableModifyEventType.SWAP_ROW, newIdx, data.get(newIdx));
        this.notifyListeners(TableModifyEventType.SWAP_ROW, rowIdx, data.get(rowIdx));
        return true;
    }

    protected void addStackMapping(String key, Control control) {
        this.m_stackKeys.add(key);
        this.m_stackMap.put(key, control);
    }

    protected abstract T createNewRow();

    protected abstract void fillStack(Composite var1);

    protected void notifyFieldListeners(Object originalEvent) {
        FieldModifyEvent e = new FieldModifyEvent(originalEvent);
        for (IFieldModifyListener listener : this.m_fieldListeners) {
            listener.modifyField(e);
        }
    }

    protected abstract void refreshRow(T var1);

    protected abstract void setRowValues(T var1) throws ValidatorException;

    private void clearStackMapping() {
        this.m_stackKeys.clear();
        this.m_stackMap.clear();
    }

    class CompoundFieldModifyListener
    implements ModifyListener,
    SelectionListener,
    ITableModifyListener {
        CompoundFieldModifyListener() {
        }

        public void modifyTable(TableModifyEvent e) {
            StructuredTable.this.notifyFieldListeners(e);
        }

        public void modifyText(ModifyEvent e) {
            if (!StructuredTable.this.m_suppressFieldListener) {
                StructuredTable.this.notifyFieldListeners(e);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!StructuredTable.this.m_suppressFieldListener) {
                StructuredTable.this.notifyFieldListeners(e);
            }
        }
    }
}

