/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor.structured;

import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.structured.IStructuredTable;
import org.eclipse.buckminster.ui.internal.DynamicTableLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StructuredTableEditor<T>
extends Composite {
    private static final int DONT_SAVE = -99;
    private final IStructuredTable<T> m_table;
    private final boolean m_swapButtonsFlag;
    private TableViewer m_tableViewer;
    private int m_lastSelectedRow = -1;
    private int m_lastEditedRow = -1;
    private Composite m_stackButtonComposite;
    private StackLayout m_stackButtonLayout;
    private Composite m_editButtonBox;
    private Composite m_viewButtonBox;
    private Button m_newButton;
    private Button m_editButton;
    private Button m_viewButton;
    private Button m_removeButton;
    private Button m_moveUpButton;
    private Button m_moveDownButton;
    private Tree m_stackOptions;
    private StackLayout m_stackLayout;
    private Composite m_stackComposite;
    private boolean m_enabled = true;

    public StructuredTableEditor(Composite parent, IStructuredTable<T> table, boolean swapButtonsFlag, int style) {
        super(parent, style);
        this.m_table = table;
        this.m_swapButtonsFlag = swapButtonsFlag;
        this.initComposite();
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public abstract void refresh();

    public boolean selectRow(T row) {
        int idx = this.m_table.getRows().indexOf(row);
        if (idx == -1) {
            return false;
        }
        this.m_tableViewer.getTable().setSelection(idx);
        this.updateLastRow();
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
        this.enableDisableButtonGroup();
    }

    protected void createStack(Composite parent) {
        this.m_stackComposite = new Composite(parent, 0);
        this.m_stackComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_stackLayout = new StackLayout();
        this.m_stackLayout.marginWidth = 0;
        this.m_stackLayout.marginHeight = 0;
        this.m_stackComposite.setLayout((Layout)this.m_stackLayout);
        this.m_table.fillStackComposite(this.m_stackComposite);
    }

    protected void createStackOptions(Composite parent) {
        this.m_stackOptions = new Tree(parent, 2048);
        this.m_stackOptions.setLayoutData((Object)new GridData(4, 4, false, true));
        this.m_stackOptions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item != null) {
                    TreeItem item = (TreeItem)e.item;
                    ((StructuredTableEditor)StructuredTableEditor.this).m_stackLayout.topControl = StructuredTableEditor.this.m_table.getStackControl(item.getText());
                    StructuredTableEditor.this.m_stackComposite.layout();
                    StructuredTableEditor.this.focusStackComposite();
                }
            }
        });
    }

    protected void createTableButtons(Composite parent) {
        this.m_stackButtonComposite = new Composite(parent, 0);
        this.m_stackButtonComposite.setLayoutData((Object)new GridData(1, 1, false, false));
        this.m_stackButtonLayout = new StackLayout();
        this.m_stackButtonLayout.marginWidth = 0;
        this.m_stackButtonLayout.marginHeight = 0;
        this.m_stackButtonComposite.setLayout((Layout)this.m_stackButtonLayout);
        this.m_editButtonBox = new Composite(this.m_stackButtonComposite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.m_editButtonBox.setLayout((Layout)gridLayout);
        this.m_editButtonBox.setLayoutData((Object)new GridData(1, 1, false, false));
        this.m_newButton = UiUtils.createPushButton(this.m_editButtonBox, Messages.new_label, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredTableEditor.this.newRow();
            }
        });
        this.m_newButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.m_editButton = UiUtils.createPushButton(this.m_editButtonBox, Messages.edit, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredTableEditor.this.editRow(false, false);
            }
        });
        this.m_editButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.m_removeButton = UiUtils.createPushButton(this.m_editButtonBox, Messages.remove, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredTableEditor.this.removeRow();
            }
        });
        this.m_removeButton.setLayoutData((Object)new GridData(4, 1, true, false));
        if (this.m_swapButtonsFlag) {
            this.m_moveUpButton = UiUtils.createPushButton(this.m_editButtonBox, Messages.move_up, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StructuredTableEditor.this.swapAndReselect(0, -1);
                }
            });
            this.m_moveUpButton.setLayoutData((Object)new GridData(4, 1, true, false));
            this.m_moveDownButton = UiUtils.createPushButton(this.m_editButtonBox, Messages.move_down, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StructuredTableEditor.this.swapAndReselect(1, 0);
                }
            });
            this.m_moveDownButton.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        this.m_viewButtonBox = new Composite(this.m_stackButtonComposite, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.m_viewButtonBox.setLayout((Layout)gridLayout);
        this.m_viewButtonBox.setLayoutData((Object)new GridData(1, 1, false, false));
        this.m_viewButton = UiUtils.createPushButton(this.m_viewButtonBox, Messages.view, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredTableEditor.this.editRow(false, true);
            }
        });
        this.m_viewButton.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    protected void createTableGroup(Composite parent) {
        Composite componentTableGroup = this.createTableGroupComposite(parent);
        Table table = new Table(componentTableGroup, 68356);
        table.setHeaderVisible(true);
        DynamicTableLayout layout = new DynamicTableLayout(50);
        int tableIdx = 0;
        int idx = 0;
        while (idx < this.m_table.getTableViewerColumns()) {
            if (this.m_table.getTableViewerColumnWeights()[idx] > 0) {
                TableColumn tableColumn = new TableColumn(table, 16384, tableIdx);
                tableColumn.setText(this.m_table.getTableViewerColumnHeaders()[idx]);
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(this.m_table.getTableViewerColumnWeights()[idx], true));
                ++tableIdx;
            }
            ++idx;
        }
        table.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gridData);
        this.m_tableViewer = new TableViewer(table);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.m_tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.m_tableViewer.setInput(this.m_table);
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredTableEditor.this.rowSelection();
            }
        });
        this.m_tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (StructuredTableEditor.this.m_tableViewer.getTable().getSelectionIndex() >= 0) {
                    StructuredTableEditor.this.editRow(false, !StructuredTableEditor.this.m_enabled || StructuredTableEditor.this.m_table.isReadOnly());
                }
            }
        });
        this.createTableButtons(componentTableGroup);
    }

    protected abstract Composite createTableGroupComposite(Composite var1);

    protected abstract void editRow(boolean var1, boolean var2);

    protected void enableDisableButtonGroup() {
        Table table = this.getTableViewer().getTable();
        int top = table.getItemCount();
        int idx = this.getSelectionIndex();
        if (this.isEnabled() && !this.m_table.isReadOnly()) {
            this.m_newButton.setEnabled(true);
            this.m_editButton.setEnabled(idx >= 0);
            this.m_removeButton.setEnabled(idx >= 0);
            if (this.isSwapButtonAllowed()) {
                this.m_moveUpButton.setEnabled(idx > 0);
                this.m_moveDownButton.setEnabled(idx >= 0 && idx < top - 1);
            }
            this.m_stackButtonLayout.topControl = this.m_editButtonBox;
        } else {
            this.m_newButton.setEnabled(false);
            this.m_editButton.setEnabled(false);
            this.m_removeButton.setEnabled(false);
            if (this.isSwapButtonAllowed()) {
                this.m_moveUpButton.setEnabled(false);
                this.m_moveDownButton.setEnabled(false);
            }
            this.m_stackButtonLayout.topControl = this.m_viewButtonBox;
        }
        this.m_viewButton.setEnabled(idx >= 0);
        this.m_stackButtonComposite.layout();
    }

    protected void enableFields(boolean enabled) {
        this.m_table.enableFields(enabled);
    }

    protected void fillStackOptions() {
        for (String stackKey : this.m_table.getStackKeys()) {
            TreeItem item = new TreeItem(this.m_stackOptions, 0);
            item.setText(stackKey);
        }
    }

    protected void focusStackComposite() {
        Control focusControl = (Control)this.m_stackLayout.topControl.getData("focusControl");
        if (focusControl != null) {
            focusControl.setFocus();
        }
    }

    protected Button getEditButton() {
        return this.m_editButton;
    }

    protected int getLastEditedRow() {
        return this.m_lastEditedRow;
    }

    protected int getLastSelectedRow() {
        return this.m_lastSelectedRow;
    }

    protected Button getMoveDownButton() {
        return this.m_moveDownButton;
    }

    protected Button getMoveUpButton() {
        return this.m_moveUpButton;
    }

    protected Button getNewButton() {
        return this.m_newButton;
    }

    protected Button getRemoveButton() {
        return this.m_removeButton;
    }

    protected int getSelectionIndex() {
        return this.m_tableViewer.getTable().getSelectionIndex();
    }

    protected IStructuredTable<T> getTable() {
        return this.m_table;
    }

    protected TableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    protected Button getViewButton() {
        return this.m_viewButton;
    }

    protected abstract void initComposite();

    protected boolean isSwapButtonAllowed() {
        return this.m_swapButtonsFlag;
    }

    protected abstract void newRow();

    protected void refreshRow() {
        this.m_table.refreshRow(this.getSelectionIndex());
        if (this.m_stackOptions.getSelectionCount() == 0) {
            this.setStackOption(0);
        }
    }

    protected void refreshTable() {
        this.m_table.refresh();
        this.m_tableViewer.setInput(this.m_table);
        if (this.getSelectionIndex() == -1 && this.m_table.getRows().size() > 0) {
            if (this.m_lastSelectedRow == -1) {
                this.m_tableViewer.getTable().setSelection(0);
            } else {
                if (this.m_lastSelectedRow >= this.m_table.getRows().size()) {
                    this.m_lastSelectedRow = this.m_table.getRows().size() - 1;
                }
                this.m_tableViewer.getTable().setSelection(this.m_lastSelectedRow);
            }
        }
        this.updateLastRow();
    }

    protected void removeRow() {
        int row = this.getSelectionIndex();
        if (row != -1) {
            this.m_table.removeRow(row);
            this.m_lastEditedRow = -99;
            this.refresh();
        }
    }

    protected abstract boolean rowSelectionEvent();

    protected void saveRow() throws ValidatorException {
        if (this.m_lastEditedRow == -99) {
            return;
        }
        this.m_table.save(this.m_lastEditedRow);
        this.refresh();
        this.enableDisableButtonGroup();
    }

    protected void setEditButton(Button editButton) {
        this.m_editButton = editButton;
    }

    protected void setMoveDownButton(Button moveDownButton) {
        this.m_moveDownButton = moveDownButton;
    }

    protected void setMoveUpButton(Button moveUpButton) {
        this.m_moveUpButton = moveUpButton;
    }

    protected void setNewButton(Button newButton) {
        this.m_newButton = newButton;
    }

    protected void setRemoveButton(Button removeButton) {
        this.m_removeButton = removeButton;
    }

    protected void setStackOption(int idx) {
        String stackKey = this.m_table.getStackKeys().get(idx);
        this.m_stackOptions.setSelection(this.m_stackOptions.getItem(idx));
        this.m_stackLayout.topControl = this.m_table.getStackControl(stackKey);
        this.m_stackComposite.layout();
    }

    protected void setViewButton(Button viewButton) {
        this.m_viewButton = viewButton;
    }

    protected void swapAndReselect(int idxOffset, int selectionOffset) {
        if (this.m_table.swapRows(this.getSelectionIndex(), idxOffset)) {
            this.refresh();
            Table table = this.m_tableViewer.getTable();
            int idx = table.getSelectionIndex() + idxOffset;
            table.select(idx + selectionOffset);
            this.enableDisableButtonGroup();
        }
    }

    protected void updateLastRow() {
        if (this.getSelectionIndex() != -1) {
            this.m_lastSelectedRow = this.getSelectionIndex();
        }
        this.m_lastEditedRow = this.getSelectionIndex();
    }

    private void rowSelection() {
        if (this.rowSelectionEvent()) {
            this.updateLastRow();
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return StructuredTableEditor.this.m_table.getRows().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Object field = StructuredTableEditor.this.m_table.getTableViewerField(element, columnIndex);
            return field == null ? "" : field.toString();
        }
    }
}

