/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor.structured;

import org.eclipse.buckminster.ui.general.editor.TableRowDialog;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.structured.IStructuredTable;
import org.eclipse.buckminster.ui.general.editor.structured.StructuredTableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoPagesTableEditor<T>
extends StructuredTableEditor<T> {
    private final Image m_windowImage;
    private final String m_windowTitle;
    private final Image m_wizardImage;
    private final String m_helpURL;

    public TwoPagesTableEditor(Composite parent, IStructuredTable<T> table, boolean swapButtonsFlag, Image windowImage, String windowTitle, Image wizardImage, String helpURL, int style) {
        super(parent, table, swapButtonsFlag, style);
        this.m_windowImage = windowImage;
        this.m_windowTitle = windowTitle;
        this.m_wizardImage = wizardImage;
        this.m_helpURL = helpURL;
    }

    @Override
    public void refresh() {
        this.refreshTable();
        this.enableDisableButtonGroup();
    }

    public boolean show(T row) {
        return this.selectRow(row);
    }

    @Override
    protected Composite createTableGroupComposite(Composite parent) {
        Composite componentTableGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        componentTableGroup.setLayout((Layout)gl);
        componentTableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        return componentTableGroup;
    }

    @Override
    protected void editRow(boolean newRow, boolean readOnly) {
        new EditRowDialog(this.getShell(), this.m_windowImage, this.m_windowTitle, this.m_wizardImage, this.m_helpURL, newRow, readOnly).open();
    }

    @Override
    protected void initComposite() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        this.setLayoutData(gridData);
        this.createTableGroup(this);
    }

    @Override
    protected void newRow() {
        this.getTableViewer().getTable().deselectAll();
        this.updateLastRow();
        this.editRow(true, false);
    }

    @Override
    protected boolean rowSelectionEvent() {
        this.enableDisableButtonGroup();
        return true;
    }

    class EditRowDialog
    extends TableRowDialog {
        public EditRowDialog(Shell parentShell, Image windowImage, String windowTitle, Image wizardImage, String helpURL, boolean newRow, boolean readOnly) {
            super(parentShell, windowImage, windowTitle, wizardImage, helpURL, newRow, readOnly);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                try {
                    TwoPagesTableEditor.this.saveRow();
                }
                catch (ValidatorException e) {
                    this.setErrorMessage(e.getMessage());
                    return;
                }
            }
            this.setReturnCode(buttonId);
            this.close();
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite rowComposite = new Composite(composite, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 10;
            layout.marginHeight = 10;
            rowComposite.setLayout((Layout)layout);
            GridData gridData = new GridData(4, 4, true, true);
            rowComposite.setLayoutData((Object)gridData);
            TwoPagesTableEditor.this.createStackOptions(rowComposite);
            TwoPagesTableEditor.this.createStack(rowComposite);
            TwoPagesTableEditor.this.fillStackOptions();
            TwoPagesTableEditor.this.refreshRow();
            TwoPagesTableEditor.this.focusStackComposite();
            return rowComposite;
        }

        protected void enableDisableOkButton() {
            if (this.isReadOnly()) {
                this.getButton(0).setEnabled(true);
            }
        }
    }
}

