/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.internal;

import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.ui.internal.SaxableEditorInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.internal.provisional.p2.core.Version;

public class CSpecEditorInput
extends SaxableEditorInput {
    private final CSpec m_cspec;

    public CSpecEditorInput(CSpec cspec) {
        this.m_cspec = cspec;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof CSpecEditorInput && ((CSpecEditorInput)other).m_cspec.equals((Object)this.m_cspec);
    }

    public boolean exists() {
        return true;
    }

    public ICSpecData getCSpec() {
        return this.m_cspec;
    }

    public String getName() {
        StringBuilder bld = new StringBuilder();
        bld.append(this.m_cspec.getName());
        Version version = this.m_cspec.getVersion();
        if (version != null) {
            bld.append(':');
            bld.append(VersionHelper.getHumanReadable((Version)version));
        }
        bld.append(".cspec");
        return bld.toString();
    }

    public String getToolTipText() {
        return this.getName();
    }

    public int hashCode() {
        return this.m_cspec.hashCode();
    }

    protected ISaxable getContent() throws CoreException {
        return this.m_cspec;
    }
}

