/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.prefs;

import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiPlugin;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ConsolePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ColorFieldEditor m_messageColorEditor;
    private ColorFieldEditor m_errorColorEditor;
    private BooleanFieldEditor m_showOnMessage;
    private BooleanFieldEditor m_showOnError;
    private BooleanFieldEditor m_restrictOutput;
    private IntegerFieldEditor m_highWaterMark;

    public ConsolePreferencePage() {
        super(1);
        this.setDescription(Messages.buckminster_console_preferences);
        this.setPreferenceStore(UiPlugin.getDefault().getBuckminsterPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        this.m_highWaterMark.setEnabled(this.m_restrictOutput.getBooleanValue(), this.getFieldEditorParent());
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        IPreferenceStore store = this.getPreferenceStore();
        this.createVerticalSeparator(composite);
        this.m_restrictOutput = new BooleanFieldEditor("pref_console_limit_output", Messages.limit_console_output, composite);
        this.addField((FieldEditor)this.m_restrictOutput);
        this.m_highWaterMark = new IntegerFieldEditor("pref_console_high_water_mark", Messages.console_buffer_size_bracket_characters_bracket_with_colon, composite);
        this.m_highWaterMark.setValidRange(1001, 0x7FFFFFFE);
        this.addField((FieldEditor)this.m_highWaterMark);
        this.m_highWaterMark.setEnabled(store.getBoolean("pref_console_limit_output"), composite);
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.m_highWaterMark.getTextControl(composite).addFocusListener((FocusListener)focusListener);
        this.createVerticalSeparator(composite);
        this.m_showOnMessage = new BooleanFieldEditor("pref_console_show_on_message", Messages.show_SVN_console_automatically_when_command_is_run, composite);
        this.addField((FieldEditor)this.m_showOnMessage);
        this.m_showOnError = new BooleanFieldEditor("pref_console_show_on_error", Messages.show_SVN_console_automatically_when_an_error_is_encountered, composite);
        this.addField((FieldEditor)this.m_showOnError);
        this.createVerticalSeparator(composite);
        this.createLabel(composite, Messages.console_text_color_settings_with_colon);
        this.m_messageColorEditor = this.createColorFieldEditor("pref_console_message_color", Messages.message_with_colon, composite);
        this.addField((FieldEditor)this.m_messageColorEditor);
        this.m_errorColorEditor = this.createColorFieldEditor("pref_console_error_color", Messages.error_with_colon, composite);
        this.addField((FieldEditor)this.m_errorColorEditor);
    }

    private ColorFieldEditor createColorFieldEditor(String preferenceName, String label, Composite parent) {
        ColorFieldEditor editor = new ColorFieldEditor(preferenceName, label, parent);
        editor.setPage((DialogPage)this);
        editor.setPreferenceStore(this.getPreferenceStore());
        return editor;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Label createVerticalSeparator(Composite parent) {
        Label label = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.heightHint = 5;
        label.setLayoutData((Object)data);
        return label;
    }
}

