/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.prefs;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumFieldEditor
extends FieldEditor {
    private Combo m_combo;
    private Enum<?> m_value;
    private final Enum<?>[] m_enumValues;

    public EnumFieldEditor(String name, String labelText, Enum<?>[] enumValues, Composite parent) {
        this.m_enumValues = enumValues;
        this.init(name, labelText);
        this.createControl(parent);
    }

    public Combo getControl(Composite parent) {
        if (this.m_combo == null) {
            this.m_combo = new Combo(parent, 8);
            int top = this.m_enumValues.length;
            int idx = 0;
            while (idx < top) {
                this.m_combo.add(this.m_enumValues[idx].toString(), idx);
                ++idx;
            }
            this.m_combo.setFont(parent.getFont());
            this.m_combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    Enum oldValue = EnumFieldEditor.this.m_value;
                    EnumFieldEditor.this.m_value = EnumFieldEditor.this.getValueForName(EnumFieldEditor.this.m_combo.getText());
                    EnumFieldEditor.this.setPresentsDefaultValue(false);
                    EnumFieldEditor.this.fireValueChanged("field_editor_value", oldValue, EnumFieldEditor.this.m_value);
                }
            });
        }
        return this.m_combo;
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns - 1;
            numColumns = 1;
        }
        ((GridData)this.m_combo.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        control = this.getControl(parent);
        gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getInt(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultInt(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.m_value == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.m_value.ordinal());
    }

    protected Enum<?> getValueForName(String name) {
        int idx = this.m_enumValues.length;
        while (--idx >= 0) {
            Enum<?> enumValue = this.m_enumValues[idx];
            if (!enumValue.toString().equals(name)) continue;
            return enumValue;
        }
        return null;
    }

    protected void updateComboForValue(int ordinal) {
        int max = this.m_enumValues.length;
        if (ordinal < 0 || ordinal >= max) {
            if (this.m_enumValues.length == 0) {
                return;
            }
            this.m_value = this.m_enumValues[0];
        } else {
            this.m_value = this.m_enumValues[ordinal];
        }
        this.m_combo.setText(this.m_value.toString());
    }
}

