/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.prefs;

import org.eclipse.buckminster.ui.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class PasswordFieldEditor
extends StringFieldEditor {
    private static final String BUCKMINSTER_NODE = "buckminster";
    private String m_keyRingRealm;
    private String m_oldValue;
    private Text m_textField;
    private int m_textLimit = UNLIMITED;
    private int m_validateStrategy = 0;

    public PasswordFieldEditor(String name, String labelText, Composite parent, String keyRingRealm) {
        this(name, labelText, UNLIMITED, parent, keyRingRealm);
    }

    public PasswordFieldEditor(String name, String labelText, int width, Composite parent, String keyRingRealm) {
        this(name, labelText, width, 0, parent, keyRingRealm);
    }

    public PasswordFieldEditor(String name, String labelText, int width, int strategy, Composite parent, String keyRingRealm) {
        super(name, labelText, width, strategy, parent);
        this.m_keyRingRealm = keyRingRealm;
    }

    public String getStringValue() {
        if (this.m_textField != null) {
            return this.m_textField.getText();
        }
        return this.getPasswordFromKeyRing();
    }

    public Text getTextControl(Composite parent) {
        if (this.m_textField == null) {
            this.m_textField = new Text(parent, 0x400804);
            this.m_textField.setFont(parent.getFont());
            switch (this.m_validateStrategy) {
                case 0: {
                    this.m_textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent e) {
                            PasswordFieldEditor.this.valueChanged();
                        }
                    });
                    break;
                }
                case 1: {
                    this.m_textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            PasswordFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this.m_textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            PasswordFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent e) {
                            PasswordFieldEditor.this.valueChanged();
                            PasswordFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
                }
            }
            this.m_textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    PasswordFieldEditor.this.m_textField = null;
                }
            });
            if (this.m_textLimit > 0) {
                this.m_textField.setTextLimit(this.m_textLimit);
            }
        } else {
            this.checkParent((Control)this.m_textField, parent);
        }
        return this.m_textField;
    }

    public void setTextLimit(int limit) {
        this.m_textLimit = limit;
        if (this.m_textField != null) {
            this.m_textField.setTextLimit(limit);
        }
    }

    public void setValidateStrategy(int value) {
        Assert.isTrue((value == 1 || value == 0 ? 1 : 0) != 0);
        this.m_validateStrategy = value;
    }

    protected void doLoad() {
        if (this.m_textField != null) {
            String value = this.getPasswordFromKeyRing();
            this.m_textField.setText(value);
            this.m_oldValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this.m_textField != null) {
            String value = "";
            this.m_textField.setText(value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.setPasswordToKeyRing(this.m_textField.getText());
    }

    protected void valueChanged() {
        String newValue;
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid();
        this.refreshValidState();
        if (this.isValid() != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid());
        }
        if (!(newValue = this.m_textField.getText()).equals(this.m_oldValue)) {
            this.fireValueChanged("field_editor_value", this.m_oldValue, newValue);
            this.m_oldValue = newValue;
        }
    }

    private String getPasswordFromKeyRing() {
        ISecurePreferences info = SecurePreferencesFactory.getDefault().node(BUCKMINSTER_NODE).node(this.m_keyRingRealm);
        try {
            return info.get(this.getPreferenceName(), "");
        }
        catch (StorageException e) {
            return "";
        }
    }

    private void setPasswordToKeyRing(String password) {
        ISecurePreferences info = SecurePreferencesFactory.getDefault().node(BUCKMINSTER_NODE).node(this.m_keyRingRealm);
        try {
            info.put(this.getPreferenceName(), password, true);
            info.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.cannot_save_password, e);
        }
    }
}

