/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.prefs;

import java.util.ArrayList;
import org.eclipse.buckminster.core.resolver.ResolverFactoryMaintainer;
import org.eclipse.buckminster.runtime.BuckminsterPreferences;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class ResolutionResolverListEditor
extends FieldEditor {
    private String m_value;
    private Button m_addButton;
    private Button m_moveDownButton;
    private Button m_moveUpButton;
    private ListViewer m_queryResolvers;
    private ListViewer m_queryResolversToAdd;
    private String[] m_registeredResolverFactories;
    private Button m_removeButton;
    private Group m_resolveOrderGroup;

    public ResolutionResolverListEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    public Control getControl(Composite parent, int numColumns) {
        if (this.m_resolveOrderGroup == null) {
            this.m_resolveOrderGroup = new Group(parent, 0);
            this.m_resolveOrderGroup.setLayout((Layout)new GridLayout(3, false));
            this.m_resolveOrderGroup.setLayoutData((Object)new GridData(4, 4, true, true, numColumns, 1));
            this.m_resolveOrderGroup.setText(Messages.order_of_resolution);
            this.m_queryResolvers = new ListViewer((Composite)this.m_resolveOrderGroup, 2048);
            this.m_queryResolvers.getList().setLayoutData((Object)new GridData(4, 4, true, true));
            this.m_queryResolvers.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.m_queryResolvers.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.m_queryResolvers.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ResolutionResolverListEditor.this.enableDisableUpDownButtons(true);
                }
            });
            Composite buttonBox = new Composite((Composite)this.m_resolveOrderGroup, 0);
            buttonBox.setLayout((Layout)new GridLayout(1, true));
            buttonBox.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
            this.m_addButton = UiUtils.createPushButton(buttonBox, Messages.add_with_arrow_left, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResolutionResolverListEditor.this.addResolver();
                }
            });
            this.m_addButton.setLayoutData((Object)new GridData(4, 4, true, false));
            this.m_removeButton = UiUtils.createPushButton(buttonBox, Messages.remove_with_arrow_right, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResolutionResolverListEditor.this.removeResolver();
                }
            });
            this.m_removeButton.setLayoutData((Object)new GridData(4, 4, true, false));
            this.m_moveUpButton = UiUtils.createPushButton(buttonBox, Messages.move_up, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResolutionResolverListEditor.this.swapAndReselect(0, -1);
                }
            });
            this.m_moveUpButton.setLayoutData((Object)new GridData(4, 4, true, false));
            this.m_moveDownButton = UiUtils.createPushButton(buttonBox, Messages.move_down, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResolutionResolverListEditor.this.swapAndReselect(1, 0);
                }
            });
            this.m_moveDownButton.setLayoutData((Object)new GridData(4, 4, true, false));
            this.m_queryResolversToAdd = new ListViewer((Composite)this.m_resolveOrderGroup, 2048);
            this.m_queryResolversToAdd.getList().setLayoutData((Object)new GridData(4, 4, true, true));
            this.m_queryResolversToAdd.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.m_queryResolversToAdd.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.m_queryResolversToAdd.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ResolutionResolverListEditor.this.enableDisableUpDownButtons(false);
                }
            });
        }
        return this.m_resolveOrderGroup;
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.m_resolveOrderGroup.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getControl(parent, numColumns);
    }

    protected void doLoad() {
        this.loadLists(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        ResolverFactoryMaintainer.getInstance().setDefaultResolutionOrder();
        this.loadLists(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doStore() {
        String value = BuckminsterPreferences.createQueryResolverSortOrder((String[])(this.m_queryResolvers == null ? this.getRegisteredResolverFactories() : this.m_queryResolvers.getList().getItems()));
        IPreferenceStore store = this.getPreferenceStore();
        String prefName = this.getPreferenceName();
        if (value == null) {
            store.setToDefault(prefName);
            BuckminsterPreferences.setCustomQueryResolverSortOrder((boolean)false);
        } else {
            if (value.equals(store.getString(prefName))) {
                return;
            }
            store.setValue(prefName, value);
            BuckminsterPreferences.setCustomQueryResolverSortOrder((boolean)true);
        }
    }

    void addResolver() {
        this.moveItem(this.m_queryResolversToAdd, this.m_queryResolvers);
    }

    void enableDisableUpDownButtons(boolean fromResolvers) {
        List addList;
        String oldValue = this.m_value;
        List list = this.m_queryResolvers.getList();
        int top = list.getItemCount();
        int idx = list.getSelectionIndex();
        if (fromResolvers) {
            String string = this.m_value = idx >= 0 ? list.getItem(idx) : null;
            if (!Trivial.equalsAllowNull((Object)oldValue, (Object)this.m_value)) {
                this.fireValueChanged("field_editor_value", oldValue, this.m_value);
            }
        }
        this.m_addButton.setEnabled((addList = this.m_queryResolversToAdd.getList()).getItemCount() > 0 && addList.getSelectionIndex() >= 0);
        this.m_moveUpButton.setEnabled(idx > 0);
        this.m_removeButton.setEnabled(idx >= 0);
        this.m_moveDownButton.setEnabled(idx >= 0 && idx < top - 1);
    }

    void removeResolver() {
        this.moveItem(this.m_queryResolvers, this.m_queryResolversToAdd);
    }

    void swapAndReselect(int idxOffset, int selectionOffset) {
        List list = this.m_queryResolvers.getList();
        int idx = list.getSelectionIndex() + idxOffset;
        if (idx <= 0) {
            return;
        }
        String[] items = list.getItems();
        if (idx >= items.length) {
            return;
        }
        String moved = items[idx - 1];
        items[idx - 1] = items[idx];
        items[idx] = moved;
        list.setItems(items);
        list.select(idx + selectionOffset);
        this.enableDisableUpDownButtons(true);
    }

    private String[] getPossibleResolverAdditions() {
        String[] registered = this.getRegisteredResolverFactories();
        String[] current = this.m_queryResolvers.getList().getItems();
        ArrayList<String> possible = null;
        String[] stringArray = registered;
        int n = registered.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            boolean found = false;
            String[] stringArray2 = current;
            int n3 = current.length;
            int n4 = 0;
            while (n4 < n3) {
                String currName = stringArray2[n4];
                if (currName.equals(name)) {
                    found = true;
                    break;
                }
                ++n4;
            }
            if (!found) {
                if (possible == null) {
                    possible = new ArrayList<String>();
                }
                possible.add(name);
            }
            ++n2;
        }
        return possible == null ? Trivial.EMPTY_STRING_ARRAY : possible.toArray(new String[possible.size()]);
    }

    private synchronized String[] getRegisteredResolverFactories() {
        if (this.m_registeredResolverFactories == null) {
            this.m_registeredResolverFactories = ResolverFactoryMaintainer.getRegisterFactoryIDs();
        }
        return this.m_registeredResolverFactories;
    }

    private void loadLists(String prefValue) {
        String[] resolvers = prefValue == null || prefValue.length() == 0 ? Trivial.EMPTY_STRING_ARRAY : prefValue.split(",");
        this.m_queryResolvers.setInput((Object)resolvers);
        this.m_queryResolvers.getList().select(0);
        this.m_queryResolversToAdd.setInput((Object)this.getPossibleResolverAdditions());
        this.enableDisableUpDownButtons(true);
    }

    private void moveItem(ListViewer from, ListViewer to) {
        List list = from.getList();
        int idx = list.getSelectionIndex();
        if (idx < 0) {
            return;
        }
        to.add((Object)list.getItem(idx));
        list.remove(idx);
        int top = list.getItemCount();
        if (idx >= top) {
            idx = top - 1;
        }
        if (idx >= 0) {
            list.select(idx);
        }
        this.enableDisableUpDownButtons(true);
    }
}

