/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.providers;

import java.util.List;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.IResolution;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.generic.model.tree.BasicTreeParentDataNode;
import org.eclipse.buckminster.generic.model.tree.ITreeDataNode;
import org.eclipse.buckminster.generic.ui.utils.UiUtils;
import org.eclipse.buckminster.opml.IOPML;
import org.eclipse.buckminster.opml.IOutline;
import org.eclipse.buckminster.opml.OutlineType;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiPlugin;
import org.eclipse.buckminster.ui.adapters.ComponentReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class BuckminsterLabelProvider
extends ColumnLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private Image m_projectImage;
    private Image m_folderImage;
    private Image m_fileImage;
    private Image m_cspecImage;
    private Image m_componentImage;
    private Image m_rssImage;
    private Image m_htmlImage;
    private Image m_dependantImage;
    private Image m_dependencyImage;

    public void dispose() {
        if (this.m_projectImage != null) {
            this.m_projectImage.dispose();
        }
        if (this.m_folderImage != null) {
            this.m_folderImage.dispose();
        }
        if (this.m_fileImage != null) {
            this.m_fileImage.dispose();
        }
        if (this.m_cspecImage != null) {
            this.m_cspecImage.dispose();
        }
        if (this.m_componentImage != null) {
            this.m_componentImage.dispose();
        }
        if (this.m_htmlImage != null) {
            this.m_htmlImage.dispose();
        }
        if (this.m_dependencyImage != null) {
            this.m_dependencyImage.dispose();
        }
        if (this.m_dependantImage != null) {
            this.m_dependantImage.dispose();
        }
        super.dispose();
    }

    public Image getImage(Object selected) {
        Object element = selected;
        if (selected instanceof ITreeDataNode) {
            element = ((ITreeDataNode)element).getData();
        }
        if (element instanceof IProject) {
            return this.getProjectImage();
        }
        if (element instanceof IFolder) {
            return this.getFolderImage();
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            ImageDescriptor imageDescriptor = UiUtils.getImageDescriptor((IFile)file);
            return imageDescriptor == null ? this.getFileImage() : UiUtils.getImage((ImageDescriptor)imageDescriptor);
        }
        if (element instanceof ICSpecData) {
            return this.getCspecImage();
        }
        if (element instanceof IResolution) {
            return this.getComponentImage();
        }
        if (element instanceof IOPML) {
            return this.getFolderImage();
        }
        if (element instanceof IOutline) {
            List outlines = ((IOutline)element).getOutlines();
            if (((IOutline)element).getType() == OutlineType.UNKNOWN || ((IOutline)element).getType() == OutlineType.TEXT || outlines != null && outlines.size() > 0) {
                return this.getFolderImage();
            }
            if (((IOutline)element).getType() == OutlineType.LINK) {
                return this.getHtmlImage();
            }
            return this.getRssImage();
        }
        if (element instanceof ComponentReference) {
            return ((ComponentReference)element).getMode() == ComponentReference.Mode.IN ? this.getDependantImage() : this.getDependencyImage();
        }
        if (selected instanceof BasicTreeParentDataNode) {
            return this.getFolderImage();
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof ITreeDataNode) {
            element = ((ITreeDataNode)element).getData();
        }
        if (element instanceof IResource) {
            return new StyledString(((IResource)element).getName());
        }
        if (element instanceof IResolution) {
            Version version;
            Resolution r = (Resolution)element;
            StyledString bld = new StyledString(r.getName());
            String type = r.getComponentTypeId();
            if (type != null) {
                bld.append(" : ", StyledString.DECORATIONS_STYLER);
                bld.append(type, StyledString.DECORATIONS_STYLER);
            }
            if ((version = r.getVersion()) != null) {
                bld.append(" - ", StyledString.DECORATIONS_STYLER);
                bld.append(VersionHelper.getHumanReadable((Version)version), StyledString.DECORATIONS_STYLER);
            }
            return bld;
        }
        if (element instanceof ComponentReference) {
            ComponentReference ref = (ComponentReference)element;
            StyledString bld = new StyledString(ref.getComponentName());
            ComponentRequest req = ref.getComponentRequest();
            if (req.getComponentTypeID() != null) {
                bld.append(" : ", StyledString.DECORATIONS_STYLER);
                bld.append(req.getComponentTypeID(), StyledString.DECORATIONS_STYLER);
            }
            if (req.getVersionRange() != null) {
                bld.append(" - ", StyledString.DECORATIONS_STYLER);
                bld.append(req.getVersionRange().toString(), StyledString.DECORATIONS_STYLER);
            }
            return bld;
        }
        if (element instanceof ICSpecData) {
            return new StyledString(Messages.component_specification_and_cspec_in_paranthesis);
        }
        if (element instanceof IOPML) {
            return new StyledString(Messages.component_information);
        }
        if (element instanceof IOutline) {
            IOutline outline = (IOutline)element;
            return new StyledString(outline.getText());
        }
        return new StyledString(element.toString());
    }

    public String getText(Object element) {
        return this.getStyledText(element).toString();
    }

    private Image getComponentImage() {
        if (this.m_componentImage == null) {
            this.m_componentImage = UiPlugin.getImageDescriptor("icons/component.png").createImage();
        }
        return this.m_componentImage;
    }

    private Image getCspecImage() {
        if (this.m_cspecImage == null) {
            this.m_cspecImage = UiPlugin.getImageDescriptor("icons/cspec.png").createImage();
        }
        return this.m_cspecImage;
    }

    private Image getDependantImage() {
        if (this.m_dependantImage == null) {
            this.m_dependantImage = UiPlugin.getImageDescriptor("icons/dependent.png").createImage();
        }
        return this.m_dependantImage;
    }

    private Image getDependencyImage() {
        if (this.m_dependencyImage == null) {
            this.m_dependencyImage = UiPlugin.getImageDescriptor("icons/dependency.png").createImage();
        }
        return this.m_dependencyImage;
    }

    private Image getFileImage() {
        if (this.m_fileImage == null) {
            this.m_fileImage = UiPlugin.getImageDescriptor("icons/file_obj.gif").createImage();
        }
        return this.m_fileImage;
    }

    private Image getFolderImage() {
        if (this.m_folderImage == null) {
            this.m_folderImage = UiPlugin.getImageDescriptor("icons/fldr_obj.gif").createImage();
        }
        return this.m_folderImage;
    }

    private Image getHtmlImage() {
        if (this.m_htmlImage == null) {
            this.m_htmlImage = UiUtils.getImageDescriptor((String)"file.html").createImage();
        }
        return this.m_htmlImage;
    }

    private Image getProjectImage() {
        if (this.m_projectImage == null) {
            this.m_projectImage = UiPlugin.getImageDescriptor("icons/prj_obj.gif").createImage();
        }
        return this.m_projectImage;
    }

    private Image getRssImage() {
        if (this.m_rssImage == null) {
            this.m_rssImage = UiPlugin.getImageDescriptor("icons/rsslink.gif").createImage();
        }
        return this.m_rssImage;
    }
}

