/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.generic.model.tree.BasicTreeDataNode;
import org.eclipse.buckminster.generic.model.tree.BasicTreeParentDataNode;
import org.eclipse.buckminster.generic.model.tree.ITreeDataNode;
import org.eclipse.buckminster.generic.model.tree.ITreeParentDataNode;
import org.eclipse.buckminster.generic.model.tree.ITreeRootNode;
import org.eclipse.buckminster.generic.model.tree.PendingTreeDataNode;
import org.eclipse.buckminster.generic.ui.model.tree.UISafeTreeRootDataNode;
import org.eclipse.buckminster.generic.ui.providers.TreeDataNodeContentProvider;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.adapters.ResolutionDataNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewSite;

public class ResolutionsTreeContentProvider
extends TreeDataNodeContentProvider {
    Mode m_mode;

    public ResolutionsTreeContentProvider() {
        this(Mode.ALL);
    }

    public ResolutionsTreeContentProvider(Mode mode) {
        this.m_mode = mode;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        ITreeDataNode[] children;
        if (oldInput == newInput && !(newInput instanceof IViewSite)) {
            return;
        }
        super.inputChanged(viewer, oldInput, newInput);
        ITreeParentDataNode root = this.getHiddenRoot();
        if (root == null) {
            this.initialize();
            root = this.getHiddenRoot();
        }
        if (newInput instanceof List) {
            root.removeAllChildren();
            List resolutions = (List)newInput;
            if (resolutions.size() < 1) {
                return;
            }
            for (Resolution r : resolutions) {
                root.addChild((ITreeDataNode)new ResolutionDataNode(r));
            }
            return;
        }
        if (!(!(newInput instanceof Resolution) || (children = root.getChildren()).length > 0 && children[0] instanceof ResolutionDataNode && newInput.equals(((ResolutionDataNode)children[0]).getData()))) {
            root.removeAllChildren();
            root.addChild((ITreeDataNode)new ResolutionDataNode((Resolution)newInput));
        }
        if (newInput instanceof ITreeDataNode) {
            root.removeAllChildren();
            root.addChild((ITreeDataNode)newInput);
        }
        if (newInput instanceof IViewSite) {
            root.removeAllChildren();
            if (this.m_mode == Mode.ALL) {
                AllResolutionsNode pending = new AllResolutionsNode();
                root.addChild((ITreeDataNode)pending);
                pending.schedule(Messages.getting_resolutions);
            } else {
                root.addChild((ITreeDataNode)new BasicTreeDataNode((Object)Messages.nothing_to_display_with_dot));
            }
        }
    }

    protected void initialize() {
        UISafeTreeRootDataNode hiddenRoot = new UISafeTreeRootDataNode((Object)Messages.resolutions);
        this.setHiddenRoot((ITreeRootNode)hiddenRoot);
    }

    public static class AllResolutionsNode
    extends PendingTreeDataNode {
        public ITreeDataNode[] createNode(IProgressMonitor monitor) {
            ArrayList resolutions;
            monitor.worked(1);
            try {
                resolutions = WorkspaceInfo.getAllResolutions();
            }
            catch (CoreException e) {
                resolutions = new ArrayList(0);
                e.printStackTrace();
            }
            int size = resolutions.size();
            if (size == 0) {
                ITreeDataNode[] empty = new ITreeDataNode[]{new BasicTreeDataNode((Object)Messages.no_components_found)};
                return empty;
            }
            ITreeDataNode[] result = new ITreeDataNode[2];
            BasicTreeParentDataNode ws = new BasicTreeParentDataNode((Object)Messages.workspace_components);
            BasicTreeParentDataNode tp = new BasicTreeParentDataNode((Object)Messages.target_platform_components);
            result[0] = ws;
            result[1] = tp;
            for (Resolution r : resolutions) {
                ResolutionDataNode rd = new ResolutionDataNode(r);
                if ("eclipse.platform".equals(r.getProvider().getReaderTypeId())) {
                    tp.addChild((ITreeDataNode)rd);
                } else {
                    ws.addChild((ITreeDataNode)rd);
                }
                monitor.worked(1);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        ALL,
        SINGLE;

    }
}

