/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.views;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.query.IComponentQuery;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.ui.InvokeAction;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiPlugin;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.ViewCSpecAction;
import org.eclipse.buckminster.ui.actions.OpenQueryAction;
import org.eclipse.buckminster.ui.actions.ViewChosenCSpecAction;
import org.eclipse.buckminster.ui.dialogs.AboutDialog;
import org.eclipse.buckminster.ui.internal.ResolveJob;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;

public class BuckminsterView
extends ViewPart {
    private CTabFolder m_tabFolder;
    private TreeViewer m_treeViewer;
    private Text m_infoText;
    private IWorkspaceRoot m_workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private BuckminsterFileFilter m_fileFilter;
    private Image m_bmImage;
    private IAction m_openEditorAction;
    private IAction m_viewCSpecAction;
    private IAction m_openCQueryAction;
    private IAction m_viewPreferencesAction;
    private IAction m_viewAboutAction;
    private IAction m_invokeActionAction;
    private IAction m_viewCspecAction;
    private IAction m_publishAction;
    private IAction m_resolveToWizardAction;
    private IAction m_resolveAndMaterializeAction;

    public BuckminsterView() {
        this.m_workspaceRoot.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                BuckminsterView.this.refreshTree();
            }
        });
        this.m_fileFilter = new BuckminsterFileFilter();
        this.m_bmImage = UiPlugin.getImageDescriptor("images/buckminster_logo.png").createImage();
    }

    private void changeInfo() {
        IResource resource = this.getResourceSelection();
        String info = "";
        if (resource != null) {
            info = this.getProjectInfo(resource.getProject());
        }
        this.m_infoText.setText(info);
    }

    private void createActions() {
        this.m_openEditorAction = new Action(Messages.open){

            public void run() {
                IResource resource = BuckminsterView.this.getResourceSelection();
                if (resource != null && resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    IWorkbenchPage workbenchPage = BuckminsterView.this.getSite().getWorkbenchWindow().getActivePage();
                    try {
                        IEditorRegistry editorRegistry = BuckminsterView.this.getViewSite().getWorkbenchWindow().getWorkbench().getEditorRegistry();
                        IEditorDescriptor editorDescriptor = editorRegistry.getDefaultEditor(file.getName());
                        String editorId = editorDescriptor.getId();
                        if (editorId != null) {
                            IDE.openEditor((IWorkbenchPage)workbenchPage, (IEditorInput)new FileEditorInput(file), (String)editorId);
                        }
                    }
                    catch (PartInitException e) {
                        UiUtils.openError(BuckminsterView.this.getViewSite().getShell(), Messages.unable_to_open_editor, e);
                    }
                }
            }
        };
        this.m_viewCSpecAction = new Action(Messages.view_the_cspec_of_a_component){

            public void run() {
                ViewChosenCSpecAction action = new ViewChosenCSpecAction();
                action.init(BuckminsterView.this.getWorkbenchWindow());
                action.selectionChanged((IAction)this, BuckminsterView.this.m_treeViewer.getSelection());
                action.run((IAction)this);
                action.dispose();
            }
        };
        this.m_viewCSpecAction.setImageDescriptor(UiPlugin.getImageDescriptor("icons/cspec.png"));
        this.m_openCQueryAction = new Action(Messages.open_a_component_query){

            public void run() {
                OpenQueryAction action = new OpenQueryAction();
                action.init(BuckminsterView.this.getWorkbenchWindow());
                action.selectionChanged((IAction)this, BuckminsterView.this.m_treeViewer.getSelection());
                action.run((IAction)this);
                action.dispose();
            }
        };
        this.m_openCQueryAction.setImageDescriptor(UiPlugin.getImageDescriptor("icons/cquery.png"));
        this.m_viewPreferencesAction = new Action(Messages.preferences){

            public void run() {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)BuckminsterView.this.getWorkbenchWindow().getShell(), null, (String[])BuckminsterPreferences.getIds(), null);
                dialog.open();
            }
        };
        this.m_viewAboutAction = new Action(Messages.about){

            public void run() {
                AboutDialog dialog = new AboutDialog(BuckminsterView.this.getWorkbenchWindow().getShell());
                dialog.open();
            }
        };
        this.m_invokeActionAction = new Action(Messages.invoke_action){

            public void run() {
                InvokeAction action = new InvokeAction();
                action.setActivePart((IAction)this, BuckminsterView.this.getWorkbenchWindow().getActivePage().getActivePart());
                action.selectionChanged((IAction)this, BuckminsterView.this.m_treeViewer.getSelection());
                action.run((IAction)this);
            }
        };
        this.m_viewCspecAction = new Action(Messages.view_cspec){

            public ImageDescriptor getImageDescriptor() {
                return UiPlugin.getImageDescriptor("icons/cspec.png");
            }

            public void run() {
                ViewCSpecAction action = new ViewCSpecAction();
                action.setActivePart((IAction)this, BuckminsterView.this.getWorkbenchWindow().getActivePage().getActivePart());
                action.selectionChanged((IAction)this, BuckminsterView.this.m_treeViewer.getSelection());
                action.run((IAction)this);
            }
        };
        this.m_publishAction = new Action(Messages.publish){

            public ImageDescriptor getImageDescriptor() {
                return UiPlugin.getImageDescriptor("icons/publish.png");
            }

            public void run() {
            }
        };
        this.m_resolveToWizardAction = new Action(Messages.resolve_to_wizard){

            public ImageDescriptor getImageDescriptor() {
                return UiPlugin.getImageDescriptor("icons/resolve.png");
            }

            public void run() {
                BuckminsterView.this.loadComponent(false);
            }
        };
        this.m_resolveAndMaterializeAction = new Action(Messages.resolve_and_materialize){

            public ImageDescriptor getImageDescriptor() {
                return UiPlugin.getImageDescriptor("icons/resolve.png");
            }

            public void run() {
                BuckminsterView.this.loadComponent(true);
            }
        };
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BuckminsterView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.m_treeViewer.getControl());
        this.m_treeViewer.getControl().setMenu(menu);
    }

    private void createInfo(Composite parent) {
        Label label = UiUtils.createGridLabel(parent, Messages.info_with_colon, 0, 0, 0);
        label.setForeground(parent.getDisplay().getSystemColor(9));
        this.m_infoText = UiUtils.createGridText(parent, 0, 0, 74);
        GridData layoutData = (GridData)this.m_infoText.getLayoutData();
        layoutData.heightHint = 80;
    }

    private void createMenu() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.add(this.m_viewPreferencesAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add(this.m_viewAboutAction);
    }

    private void createNavigator(Composite parent) {
        Tree tree = new Tree(parent, 0);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_treeViewer = new TreeViewer(tree);
        this.m_treeViewer.setContentProvider((IContentProvider)new NavigatorContentProvider());
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new NavigatorLabelProvider());
        this.m_treeViewer.setInput((Object)this.m_workspaceRoot);
        this.m_treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BuckminsterView.this.m_openEditorAction.run();
            }
        });
        this.m_treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuckminsterView.this.changeInfo();
            }
        });
    }

    public void createPartControl(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        topComposite.setLayout((Layout)layout);
        topComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createActions();
        this.createMenu();
        this.createToolbar();
        this.m_tabFolder = new CTabFolder(topComposite, 1024);
        this.m_tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem navigatorTab = new CTabItem(this.m_tabFolder, 0);
        navigatorTab.setText(Messages.navigator);
        navigatorTab.setControl(this.getNavigatorTabControl((Composite)this.m_tabFolder));
        CTabItem repositoryTab = new CTabItem(this.m_tabFolder, 0);
        repositoryTab.setText(Messages.repository);
        repositoryTab.setControl(this.getRepositoryTabControl((Composite)this.m_tabFolder));
        this.m_tabFolder.setSelection(navigatorTab);
        Label imageLabel = new Label(topComposite, 0);
        imageLabel.setAlignment(0x1000000);
        imageLabel.setImage(this.m_bmImage);
        imageLabel.setLayoutData((Object)new GridData(1, 1024, false, false));
        this.createContextMenu();
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add(this.m_viewCSpecAction);
        mgr.add(this.m_openCQueryAction);
    }

    private void fillContextMenu(IMenuManager menuMgr) {
        IResource selectedResource = this.getResourceSelection();
        if (selectedResource == null) {
            return;
        }
        if (selectedResource instanceof IFile) {
            menuMgr.add(this.m_openEditorAction);
            MenuManager subMenuMgr = new MenuManager(Messages.open_with);
            OpenWithMenu openWithMenu = new OpenWithMenu(this.getWorkbenchWindow().getActivePage(), (IAdaptable)selectedResource);
            subMenuMgr.add((IContributionItem)openWithMenu);
            menuMgr.add((IContributionItem)subMenuMgr);
            String fileExt = ((IFile)selectedResource).getFileExtension();
            if (Arrays.asList("cspec", "cquery", "bom").contains(fileExt)) {
                menuMgr.add((IContributionItem)new Separator());
                menuMgr.add(this.m_publishAction);
            }
            if (Arrays.asList("cquery").contains(fileExt)) {
                menuMgr.add(this.m_resolveToWizardAction);
                menuMgr.add(this.m_resolveAndMaterializeAction);
            }
        }
        if (selectedResource instanceof IProject) {
            menuMgr.add(this.m_invokeActionAction);
            menuMgr.add(this.m_viewCspecAction);
        }
    }

    private Control getNavigatorTabControl(Composite parent) {
        Composite tabComposite = this.getTabComposite(parent);
        this.createNavigator(tabComposite);
        this.createInfo(tabComposite);
        return tabComposite;
    }

    private String getProjectInfo(IProject project) {
        boolean knownProject = this.isProjectKnown(project);
        if (knownProject) {
            return Messages.buckminster_understands_project_metadata;
        }
        return Messages.buckminster_does_not_understand_project_metadata;
    }

    private Control getRepositoryTabControl(Composite parent) {
        Composite tabComposite = this.getTabComposite(parent);
        Link newAccountLink = new Link(tabComposite, 0);
        newAccountLink.setText("<A>" + Messages.create_new_repository_identity + "</A>");
        newAccountLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"www.cloudsmith.com");
            }
        });
        return tabComposite;
    }

    private IResource getResourceSelection() {
        Object selected;
        ISelection selection = this.m_treeViewer.getSelection();
        if (selection != null && selection instanceof TreeSelection && (selected = ((TreeSelection)selection).getFirstElement()) instanceof IResource) {
            return (IResource)selected;
        }
        return null;
    }

    private Composite getTabComposite(Composite parent) {
        Composite tabComposite = new Composite(parent, 0);
        tabComposite.setLayout((Layout)new GridLayout(1, true));
        tabComposite.setBackground(parent.getDisplay().getSystemColor(1));
        tabComposite.setBackgroundMode(2);
        return tabComposite;
    }

    private IWorkbenchWindow getWorkbenchWindow() {
        return this.getViewSite().getWorkbenchWindow();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isProjectKnown(IProject project) {
        try {
            String[] natureIds;
            String[] stringArray = natureIds = project.getDescription().getNatureIds();
            int n = natureIds.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String natureId = stringArray[n2];
                if (natureId.endsWith("PluginNature")) return true;
                if (natureId.endsWith("FeatureNature")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            UiUtils.openError(this.getViewSite().getShell(), Messages.project_is_not_open, e);
        }
        return false;
    }

    private void loadComponent(boolean materialize) {
        IResource resource = this.getResourceSelection();
        if (resource instanceof IFile) {
            File file = resource.getLocation().toFile();
            ComponentQueryBuilder componentQuery = new ComponentQueryBuilder();
            FileInputStream stream = null;
            if (file.length() == 0L) {
                String defaultName = file.getName();
                if (defaultName.startsWith("bmqtmp-")) {
                    defaultName = "";
                } else {
                    int lastDot = defaultName.lastIndexOf(46);
                    if (lastDot > 0) {
                        defaultName = defaultName.substring(0, lastDot);
                    }
                }
                componentQuery.setRootRequest((IComponentRequest)new ComponentRequest(defaultName, null, null));
            } else {
                try {
                    stream = new FileInputStream(file);
                    componentQuery.initFrom((IComponentQuery)ComponentQuery.fromStream((URL)file.toURI().toURL(), null, (InputStream)stream, (boolean)true));
                }
                catch (Exception e) {
                    UiUtils.openError(this.getViewSite().getShell(), Messages.unable_to_read_cquery, e);
                }
            }
            if ("cquery".equalsIgnoreCase(resource.getFileExtension())) {
                try {
                    ResolveJob resolveJob = new ResolveJob(componentQuery.createComponentQuery(), materialize, this.getSite(), false);
                    resolveJob.schedule();
                }
                catch (CoreException e) {
                    UiUtils.openError(this.getViewSite().getShell(), null, e);
                }
            }
        }
    }

    private void refreshTree() {
        this.getViewSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                BuckminsterView.this.m_treeViewer.refresh();
            }
        });
    }

    public void setFocus() {
        this.m_tabFolder.setFocus();
    }

    class ActionsNode
    extends TreeNode {
        private CSpec m_cspec;

        public ActionsNode(CSpec cspec) {
            this.m_cspec = cspec;
        }

        public TreeNode[] getChildren() {
            try {
                this.m_cspec.getAttributesProducedByActions(false);
            }
            catch (CoreException e) {
                UiUtils.openError(BuckminsterView.this.getViewSite().getShell(), Messages.unable_to_get_child_nodes, e);
            }
            return null;
        }

        public String getName() {
            return Messages.actions;
        }

        public Object getValue() {
            return this.m_cspec;
        }
    }

    class BuckminsterFileFilter {
        public static final String CONTENT_TYPES_POINT = "org.eclipse.core.runtime.contentTypes";
        public static final String BUCKMINSTER_CORE_PLUGIN = "org.eclipse.buckminster.core";
        private List<String> m_fileExts = new ArrayList<String>();

        public BuckminsterFileFilter() {
            IConfigurationElement[] elems;
            IConfigurationElement[] iConfigurationElementArray = elems = Platform.getExtensionRegistry().getConfigurationElementsFor(CONTENT_TYPES_POINT);
            int n = elems.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elem = iConfigurationElementArray[n2];
                if (BUCKMINSTER_CORE_PLUGIN.equals(elem.getContributor().getName())) {
                    String[] fileExt = elem.getAttribute("file-extensions").split(",");
                    this.m_fileExts.addAll(Arrays.asList(fileExt));
                }
                ++n2;
            }
            this.m_fileExts.add("cquery");
        }

        public boolean matchesFile(IFile member) {
            for (String fileExt : this.m_fileExts) {
                if (!member.getName().endsWith(fileExt)) continue;
                return true;
            }
            return false;
        }
    }

    static class BuckminsterPreferences {
        private static final String BUCKMINSTER_PLUGIN_PREFIX = "org.eclipse.buckminster";
        private static final String PREFERENCES_POINT = "org.eclipse.ui.preferencePages";
        private static List<String> s_preferenceIds;

        static {
            IConfigurationElement[] elems;
            s_preferenceIds = new ArrayList<String>();
            IConfigurationElement[] iConfigurationElementArray = elems = Platform.getExtensionRegistry().getConfigurationElementsFor(PREFERENCES_POINT);
            int n = elems.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elem = iConfigurationElementArray[n2];
                String contributor = elem.getContributor().getName();
                if (contributor.startsWith(BUCKMINSTER_PLUGIN_PREFIX)) {
                    s_preferenceIds.add(elem.getAttribute("id"));
                }
                ++n2;
            }
        }

        BuckminsterPreferences() {
        }

        public static String[] getIds() {
            return s_preferenceIds.toArray(new String[0]);
        }
    }

    class CqueryNode
    extends TreeNode {
        private IFile m_cqueryFile;

        public CqueryNode(IFile cqueryFile) {
            this.m_cqueryFile = cqueryFile;
        }

        public String getName() {
            return Messages.component_query;
        }

        public Object getValue() {
            return this.m_cqueryFile;
        }
    }

    class CspecNode
    extends TreeNode {
        private ICSpecData m_cspec;

        public CspecNode(ICSpecData cspec) {
            this.m_cspec = cspec;
        }

        public String getName() {
            return Messages.component_specification;
        }

        public Object getValue() {
            return this.m_cspec;
        }
    }

    class NavigatorContentProvider
    implements ITreeContentProvider {
        NavigatorContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IContainer) {
                try {
                    IResource[] members;
                    ArrayList<IResource> filteredMembers = new ArrayList<IResource>();
                    IResource[] iResourceArray = members = ((IContainer)parentElement).members();
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        if (!(member instanceof IFile) || BuckminsterView.this.m_fileFilter.matchesFile((IFile)member)) {
                            filteredMembers.add(member);
                        }
                        ++n2;
                    }
                    return filteredMembers.toArray();
                }
                catch (CoreException e) {
                    UiUtils.openError(BuckminsterView.this.getViewSite().getShell(), Messages.unable_to_get_child_nodes, e);
                }
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return ((IWorkspaceRoot)inputElement).getProjects();
        }

        public Object getParent(Object element) {
            return ((IResource)element).getParent();
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children == null ? false : children.length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class NavigatorLabelProvider
    implements ILabelProvider {
        private List<ILabelProviderListener> m_listeners = new ArrayList<ILabelProviderListener>();
        private Image m_projectImage = UiPlugin.getImageDescriptor("icons/prj_obj.gif").createImage();
        private Image m_folderImage = UiPlugin.getImageDescriptor("icons/fldr_obj.gif").createImage();
        private Image m_fileImage = UiPlugin.getImageDescriptor("icons/file_obj.gif").createImage();

        public void addListener(ILabelProviderListener listener) {
            this.m_listeners.add(listener);
        }

        public void dispose() {
        }

        public Image getImage(Object element) {
            if (element instanceof IProject) {
                return this.m_projectImage;
            }
            if (element instanceof IFolder) {
                return this.m_folderImage;
            }
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                IEditorRegistry editorRegistry = BuckminsterView.this.getWorkbenchWindow().getWorkbench().getEditorRegistry();
                ImageDescriptor imageDescriptor = editorRegistry.getImageDescriptor(file.getName());
                return imageDescriptor == null ? this.m_fileImage : new Image((Device)Display.getDefault(), imageDescriptor.getImageData());
            }
            return null;
        }

        public String getText(Object element) {
            return ((IResource)element).getName();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
            this.m_listeners.remove(listener);
        }
    }

    class ProjectNode
    extends TreeNode {
        private IProject m_project;

        public ProjectNode(IProject project) {
            this.m_project = project;
        }

        public TreeNode[] getChildren() {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>();
            try {
                CSpec cspec = WorkspaceInfo.getCSpec((IResource)this.m_project);
                cspec.getAttributesProducedByActions(false);
                TreeNode child = new CspecNode((ICSpecData)cspec);
                child.setParent(this);
                children.add(child);
                IResource[] iResourceArray = this.m_project.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IFile && resource.getName().endsWith("cquery")) {
                        child = new CqueryNode((IFile)resource);
                        child.setParent(this);
                        children.add(child);
                        break;
                    }
                    ++n2;
                }
                if (cspec.getAttributesProducedByActions(false).size() > 0) {
                    child = new ActionsNode(cspec);
                    child.setParent(this);
                    children.add(child);
                }
            }
            catch (CoreException e) {
                UiUtils.openError(BuckminsterView.this.getViewSite().getShell(), Messages.unable_to_get_child_nodes, e);
            }
            return children.toArray(new TreeNode[0]);
        }

        public String getName() {
            return this.m_project.getName();
        }

        public Object getValue() {
            return this.m_project;
        }
    }

    class RootNode
    extends TreeNode {
        RootNode() {
        }

        public TreeNode[] getChildren() {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            ArrayList<ProjectNode> children = new ArrayList<ProjectNode>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                ProjectNode child = new ProjectNode(project);
                child.setParent(this);
                children.add(child);
                ++n2;
            }
            return children.toArray(new TreeNode[0]);
        }
    }

    abstract class TreeNode {
        private TreeNode m_parent = null;

        TreeNode() {
        }

        public TreeNode[] getChildren() {
            return null;
        }

        public String getName() {
            return "";
        }

        public TreeNode getParent() {
            return this.m_parent;
        }

        public Object getValue() {
            return null;
        }

        public boolean hasChildren() {
            TreeNode[] children = this.getChildren();
            return children == null ? false : this.getChildren().length > 0;
        }

        public void setParent(TreeNode parent) {
            this.m_parent = parent;
        }
    }
}

