/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.views;

import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.generic.model.tree.ITreeParentDataNode;
import org.eclipse.buckminster.generic.ui.GenericUiPlugin;
import org.eclipse.buckminster.generic.ui.actions.IBrowseable;
import org.eclipse.buckminster.generic.ui.actions.IBrowseableFeed;
import org.eclipse.buckminster.generic.ui.actions.ViewInBrowserAction;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiPlugin;
import org.eclipse.buckminster.ui.ViewCSpecAction;
import org.eclipse.buckminster.ui.providers.BuckminsterLabelProvider;
import org.eclipse.buckminster.ui.providers.ResolutionsTreeContentProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class ComponentBrowserView
extends ViewPart {
    protected TreeViewer m_viewer;
    private Action m_refreshAction;
    private Action doubleClickAction;
    private ViewInBrowserAction m_viewInBrowser;
    private ViewInBrowserAction m_viewInExternalBrowser;
    private ViewInBrowserAction m_viewFeedInBrowser;

    public void createPartControl(Composite parent) {
        this.m_viewer = new TreeViewer(parent, 770);
        this.m_viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new BuckminsterLabelProvider()));
        this.m_viewer.setSorter((ViewerSorter)new NameSorter());
        this.m_viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object o = event.getElement();
                if (o instanceof ITreeParentDataNode) {
                    ((ITreeParentDataNode)o).onOpen();
                }
            }
        });
        this.m_viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.m_viewer);
    }

    public boolean isAutoExpand() {
        return false;
    }

    public void setFocus() {
        this.m_viewer.getControl().setFocus();
    }

    protected ResolutionsTreeContentProvider getContentProvider() {
        return new ResolutionsTreeContentProvider();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.m_viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        manager.add((IContributionItem)new Separator("default"));
        if (obj instanceof IAdaptable) {
            if (((IAdaptable)obj).getAdapter(IBrowseableFeed.class) != null) {
                manager.add((IAction)this.m_viewFeedInBrowser);
            }
            if (((IAdaptable)obj).getAdapter(IBrowseable.class) != null) {
                manager.add((IAction)this.m_viewInBrowser);
                manager.add((IAction)this.m_viewInExternalBrowser);
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.m_refreshAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.m_refreshAction);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ComponentBrowserView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.m_viewer.getControl());
        this.m_viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_viewer);
    }

    private void hookDoubleClickAction() {
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ComponentBrowserView.this.doubleClickAction.run();
            }
        });
    }

    private void makeActions() {
        this.m_viewInBrowser = new ViewInBrowserAction((Viewer)this.m_viewer, true, Messages.content, false);
        this.m_viewInExternalBrowser = new ViewInBrowserAction((Viewer)this.m_viewer, false, Messages.content, false);
        this.m_viewFeedInBrowser = new ViewInBrowserAction((Viewer)this.m_viewer, false, Messages.feed, true);
        this.m_refreshAction = new Action(){

            public void run() {
                ComponentBrowserView.this.m_viewer.setInput((Object)ComponentBrowserView.this.getViewSite());
            }
        };
        this.m_refreshAction.setText(Messages.refresh);
        this.m_refreshAction.setToolTipText(Messages.refresh_component_explorer);
        this.m_refreshAction.setImageDescriptor(GenericUiPlugin.getImageDescriptor((String)"icons/refresh.gif"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = ComponentBrowserView.this.m_viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof IAdaptable) {
                    IObjectActionDelegate delegate;
                    ICSpecData cspec = (ICSpecData)((IAdaptable)obj).getAdapter(CSpec.class);
                    if (cspec != null) {
                        ViewCSpecAction vca = new ViewCSpecAction();
                        vca.setActivePart((IAction)this, ComponentBrowserView.this.getSite().getPart());
                        vca.selectionChanged((IAction)this, selection);
                        vca.run((IAction)this);
                        return;
                    }
                    IBrowseableFeed feed = (IBrowseableFeed)((IAdaptable)obj).getAdapter(IBrowseableFeed.class);
                    if (feed != null && (delegate = UiPlugin.getDefault().getOpenRssFeedAction()) != null) {
                        delegate.setActivePart((IAction)this, (IWorkbenchPart)ComponentBrowserView.this);
                        delegate.selectionChanged((IAction)this, (ISelection)new StructuredSelection((Object)feed));
                        delegate.run((IAction)this);
                        return;
                    }
                    IBrowseable site = (IBrowseable)((IAdaptable)obj).getAdapter(IBrowseable.class);
                    if (site != null) {
                        ComponentBrowserView.this.m_viewInBrowser.run();
                        return;
                    }
                }
            }
        };
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

