/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.wizards;

import org.eclipse.buckminster.ui.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public abstract class NewBMFileWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private String m_fileName;
    protected ISelection m_selection;
    private String m_extension;

    protected NewBMFileWizardPage(ISelection selection, String fileName, String extension) {
        super("wizardPage");
        this.m_selection = selection;
        this.m_fileName = fileName;
        this.m_extension = extension;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(Messages.container_with_hotkey);
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBMFileWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(Messages.browse_with_dots);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewBMFileWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.file_name_with_hotkey);
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBMFileWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        String fileName = this.fileText.getText();
        if (!fileName.endsWith("." + this.m_extension)) {
            fileName = String.valueOf(fileName) + "." + this.m_extension;
        }
        return fileName;
    }

    private void dialogChanged() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.fileText.getText();
        if (this.getContainerName().length() == 0) {
            this.updateStatus(Messages.file_container_must_be_specified);
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus(Messages.file_container_must_exist);
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(Messages.project_must_be_writable);
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(Messages.file_name_must_be_specified);
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus(Messages.file_name_must_be_valid);
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase(this.m_extension)) {
            this.updateStatus(NLS.bind((String)Messages.file_extension_must_be_0, (Object)this.m_extension));
            return;
        }
        this.updateStatus(null);
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.select_new_file_container);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void initialize() {
        if (this.m_selection != null && !this.m_selection.isEmpty() && this.m_selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.m_selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IProjectNature) {
                obj = ((IProjectNature)obj).getProject();
            }
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        this.fileText.setText(this.m_fileName);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

