/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.UnresolvedNode;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.resolver.IResolver;
import org.eclipse.buckminster.core.resolver.MainResolver;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.SaveRunnable;
import org.eclipse.buckminster.ui.UiPlugin;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.internal.DynamicTableLayout;
import org.eclipse.buckminster.ui.wizards.AbstractQueryPage;
import org.eclipse.buckminster.ui.wizards.QueryWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.SaveAsDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverNodePage
extends AbstractQueryPage {
    TableViewer m_dependenciesTable;
    private Group m_detailGroup;
    private Image m_grayDotImage;
    private Image m_grayDotWithRedExclamationImage;
    private Image m_greenDotImage;
    private Font m_itemItalicFont;
    private final HashMap<Resolution, Integer> m_masterDups = new HashMap();
    private Tree m_masterTree;
    private Composite m_masterTreeComposite;
    private final HashMap<Resolution, BOMNode> m_parentWhenFirstSeen = new HashMap();
    private Image m_redDotImage = UiPlugin.getImageDescriptor("images/red_dot_16x16.bmp").createImage();
    private Button m_reresolveButton;
    private Button m_showTargetPlatformButton;
    private Button m_unresolveButton;
    private Image m_yellowDotImage;

    public ResolverNodePage() {
        super("");
        this.m_greenDotImage = UiPlugin.getImageDescriptor("images/green_dot_16x16.bmp").createImage();
        this.m_yellowDotImage = UiPlugin.getImageDescriptor("images/yellow_dot_16x16.bmp").createImage();
        this.m_grayDotImage = UiPlugin.getImageDescriptor("images/gray_dot_16x16.bmp").createImage();
        this.m_grayDotWithRedExclamationImage = UiPlugin.getImageDescriptor("images/gray_dot_with_red_exclamation_16x16.bmp").createImage();
        this.setDescription(Messages.resolution_tree);
    }

    @Override
    public Composite createControls(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        topComposite.setLayout((Layout)new GridLayout());
        topComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm form = new SashForm(topComposite, 512);
        form.setLayout((Layout)new GridLayout());
        form.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createMasterGroup((Composite)form);
        this.createDetailGroup((Composite)form);
        form.setWeights(new int[]{60, 40});
        this.createButtonGroup(topComposite);
        return topComposite;
    }

    public void dispose() {
        this.m_redDotImage.dispose();
        this.m_redDotImage = null;
        this.m_greenDotImage.dispose();
        this.m_greenDotImage = null;
        this.m_grayDotImage.dispose();
        this.m_grayDotImage = null;
        this.m_grayDotWithRedExclamationImage.dispose();
        this.m_grayDotWithRedExclamationImage = null;
        this.m_yellowDotImage.dispose();
        this.m_yellowDotImage = null;
        if (this.m_itemItalicFont != null) {
            this.m_itemItalicFont.dispose();
        }
        this.m_itemItalicFont = null;
        super.dispose();
    }

    @Override
    protected void pageIsShowing() {
        super.pageIsShowing();
        this.resetMaster();
        BOMNode currentNode = this.getSelectedMasterNode();
        TreeItem found = null;
        TreeItem[] treeItemArray = this.m_masterTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            TreeItem ti = this.findItemWithData(child, currentNode);
            if (ti != null) {
                found = ti;
                break;
            }
            ++n2;
        }
        if (found == null) {
            found = this.m_masterTree.getItems()[0];
        }
        this.m_masterTree.setSelection(new TreeItem[]{found});
        this.masterTreeSelectionEvent(found, false);
        this.updatePageCompletion();
        this.getControl().setVisible(true);
    }

    void masterTreeSelectionEvent(TreeItem ti, boolean checkEvent) {
        try {
            boolean isResolved;
            BOMNode node = (BOMNode)ti.getData();
            Resolution resolution = node.getResolution();
            boolean bl = isResolved = resolution != null;
            if (isResolved) {
                ICSpecData cspec = resolution.getCSpec();
                this.m_dependenciesTable.setInput((Object)cspec.getDependencies());
                this.m_detailGroup.setText(NLS.bind((String)Messages.dependencies_in_0, (Object)node.getViewName()));
            } else {
                this.m_dependenciesTable.setInput(null);
                this.m_detailGroup.setText("");
            }
            BillOfMaterials bom = this.getQueryWizard().getBOM();
            this.m_reresolveButton.setEnabled(!bom.isFullyResolved((Map)this.getContext()));
            this.m_unresolveButton.setEnabled(isResolved);
        }
        catch (CoreException e) {
            this.displayException(e);
        }
    }

    void reresolve() {
        try {
            QueryWizard wizard = this.getQueryWizard();
            BillOfMaterials bom = wizard.getBOM();
            ResolutionContext context = new ResolutionContext(bom.getQuery());
            context.setContinueOnError(true);
            final BillOfMaterials[] bin = new BillOfMaterials[]{bom};
            MainResolver resolver = new MainResolver(context);
            wizard.getContainer().run(true, true, new IRunnableWithProgress((IResolver)resolver){
                private final /* synthetic */ IResolver val$resolver;
                {
                    this.val$resolver = iResolver;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        BillOfMaterials oldBOM = bin[0];
                        BillOfMaterials newBOM = oldBOM.fullyResolve(this.val$resolver, monitor);
                        bin[0] = oldBOM.equals((Object)newBOM) ? null : newBOM;
                    }
                    catch (Throwable t) {
                        throw new InvocationTargetException(t);
                    }
                }
            });
            CorePlugin.logWarningsAndErrors((IStatus)context.getStatus());
            bom = bin[0];
            if (bom != null) {
                wizard.setBOM(bom);
                this.resetMaster();
            }
        }
        catch (Throwable t) {
            this.displayException(BuckminsterException.wrap((Throwable)t));
        }
    }

    void resetMaster() {
        QueryWizard wizard = this.getQueryWizard();
        BillOfMaterials bom = wizard.getBOM();
        try {
            this.m_masterDups.clear();
            this.countDuplicates(null, (BOMNode)bom, wizard.getMaterializationContext().getMaterializationSpec());
            this.m_masterTree.removeAll();
            this.m_masterTree.clearAll(false);
            this.addMasterItem(new TreeItem(this.m_masterTree, 0), null, (BOMNode)bom);
            this.m_reresolveButton.setEnabled(!bom.isFullyResolved((Map)wizard.getContext()));
            this.updatePageCompletion();
        }
        catch (CoreException e) {
            this.displayException(e);
        }
    }

    void saveBOMInFileSystem() {
        FileDialog dlg = new FileDialog(this.getShell(), 8192);
        dlg.setFilterExtensions(new String[]{"*.bom"});
        String location = dlg.open();
        if (location == null) {
            return;
        }
        this.saveToPath((IPath)new Path(location));
    }

    void saveBOMInWorkspace() {
        SaveAsDialog dialog = new SaveAsDialog(this.getShell());
        if (dialog.open() == 1) {
            return;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        this.saveToPath(file.getLocation());
    }

    void unresolveNode() {
        BOMNode node = this.getSelectedMasterNode();
        if (node == null) {
            return;
        }
        if (node instanceof UnresolvedNode) {
            return;
        }
        QueryWizard queryWizard = this.getQueryWizard();
        try {
            queryWizard.setBOM(queryWizard.getBOM().replaceNode((BOMNode)new UnresolvedNode(node.getQualifiedDependency())));
        }
        catch (CoreException e) {
            this.displayException(e);
        }
        this.resetMaster();
    }

    private void addMasterItem(TreeItem ti, BOMNode parent, BOMNode node) throws CoreException {
        Integer nc;
        ti.removeAll();
        ti.setText(node.getViewName());
        ti.setData((Object)node);
        if (node instanceof UnresolvedNode) {
            if (node.isFullyResolved(this.getContext().getComponentQuery(), (Map)this.getContext())) {
                ti.setImage(this.m_yellowDotImage);
            } else {
                ti.setImage(this.m_redDotImage);
            }
            ti.setFont(null);
            return;
        }
        Resolution resolution = node.getResolution();
        if (resolution != null && (nc = this.m_masterDups.get(resolution)) != null && nc > 1 && !this.wasParentWhenFirstSeen(parent, node)) {
            ti.setImage(this.m_grayDotImage);
            ti.setFont(this.m_itemItalicFont);
            return;
        }
        ti.setImage(this.m_greenDotImage);
        ti.setFont(null);
        boolean showPlatformTargets = this.m_showTargetPlatformButton.getSelection();
        for (BOMNode child : this.getSortedChildren(node)) {
            Resolution ci = child.getResolution();
            if (!showPlatformTargets && ci != null && "eclipse.platform".equals(ci.getProvider().getReaderTypeId())) continue;
            this.addMasterItem(new TreeItem(ti, 0), node, child);
        }
        ti.setExpanded(true);
    }

    private void countDuplicates(BOMNode parent, BOMNode node, MaterializationSpec mspec) throws CoreException {
        Resolution ci = node.getResolution();
        if (ci == null) {
            return;
        }
        if (!mspec.isExcluded(ci)) {
            int nci;
            Integer nc = this.m_masterDups.get(ci);
            if (nc == null) {
                nci = 0;
                if (parent != null) {
                    this.m_parentWhenFirstSeen.put(ci, parent);
                }
            } else {
                nci = nc;
            }
            this.m_masterDups.put(ci, new Integer(1 + nci));
            if (nci == 0) {
                for (BOMNode child : this.getSortedChildren(node)) {
                    this.countDuplicates(node, child, mspec);
                }
            }
        }
    }

    private void createButtonGroup(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        buttons.setLayoutData((Object)new GridData(4, 1024, true, false));
        Button saveButton = UiUtils.createPushButton(buttons, Messages.save_bom, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResolverNodePage.this.saveBOMInWorkspace();
            }
        });
        saveButton.setLayoutData((Object)new GridData(131072, 128, true, false));
        Button extSaveButton = UiUtils.createPushButton(buttons, Messages.external_save_bom, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResolverNodePage.this.saveBOMInFileSystem();
            }
        });
        extSaveButton.setLayoutData((Object)new GridData(131072, 128, false, false));
    }

    private void createDetailGroup(Composite parent) {
        this.m_detailGroup = new Group(parent, 0);
        this.m_detailGroup.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 100;
        this.m_detailGroup.setLayoutData((Object)gd);
        Table table = new Table((Composite)this.m_detailGroup, 2820);
        String[] columnNames = new String[]{Messages.name, Messages.version_designator, Messages.category};
        int[] columnWeights = new int[]{20, 10, 10};
        table.setHeaderVisible(true);
        DynamicTableLayout layout = new DynamicTableLayout(150);
        int idx = 0;
        while (idx < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, 16384, idx);
            tableColumn.setText(columnNames[idx]);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(columnWeights[idx], true));
            ++idx;
        }
        table.setLayout((Layout)layout);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_dependenciesTable = new TableViewer(table);
        this.m_dependenciesTable.setLabelProvider((IBaseLabelProvider)new RequestLabelProvider());
        this.m_dependenciesTable.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    private void createMasterGroup(Composite parent) {
        FontData[] fda;
        Group masterGroup = new Group(parent, 0);
        masterGroup.setLayout((Layout)new GridLayout(3, false));
        masterGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        masterGroup.setText(Messages.component_specification_selection);
        this.m_masterTreeComposite = new Composite((Composite)masterGroup, 0);
        this.m_masterTreeComposite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 100;
        gd.horizontalSpan = 3;
        this.m_masterTreeComposite.setLayoutData((Object)gd);
        this.m_masterTree = new Tree(this.m_masterTreeComposite, 2820);
        this.m_masterTree.setLayout((Layout)new GridLayout());
        this.m_masterTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_masterTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ResolverNodePage.this.masterTreeSelectionEvent((TreeItem)se.item, false);
            }
        });
        Font f = this.m_masterTreeComposite.getFont();
        FontData[] fontDataArray = fda = f.getFontData();
        int n = fda.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setStyle(2);
            ++n2;
        }
        this.m_itemItalicFont = new Font((Device)Display.getCurrent(), fda);
        Composite modifiersComposite = new Composite((Composite)masterGroup, 0);
        modifiersComposite.setLayout((Layout)new GridLayout(3, false));
        modifiersComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_showTargetPlatformButton = UiUtils.createCheckButton(modifiersComposite, Messages.show_target_platform_components, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ResolverNodePage.this.resetMaster();
            }
        });
        this.m_reresolveButton = UiUtils.createPushButton(modifiersComposite, Messages.re_resolve, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ResolverNodePage.this.reresolve();
            }
        });
        this.m_unresolveButton = UiUtils.createPushButton(modifiersComposite, Messages.unresolved_node, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ResolverNodePage.this.unresolveNode();
            }
        });
    }

    private TreeItem findItemWithData(TreeItem ti, BOMNode node) {
        if (ti.getData() == node) {
            return ti;
        }
        TreeItem[] treeItemArray = ti.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            TreeItem answer = this.findItemWithData(child, node);
            if (answer != null) {
                return answer;
            }
            ++n2;
        }
        return null;
    }

    private BOMNode getSelectedMasterNode() {
        TreeItem[] tia = this.m_masterTree.getSelection();
        return tia.length > 0 ? (BOMNode)tia[0].getData() : null;
    }

    private Collection<BOMNode> getSortedChildren(BOMNode parent) throws CoreException {
        Collection<Object> children = parent.getChildren();
        if (children.size() > 1) {
            TreeMap<String, BOMNode> sortedMap = new TreeMap<String, BOMNode>();
            for (BOMNode child : children) {
                sortedMap.put(child.getViewName(), child);
            }
            children = sortedMap.values();
        }
        return children;
    }

    private void saveToPath(IPath path) {
        QueryWizard wizard = this.getQueryWizard();
        IWizardContainer container = wizard.getContainer();
        try {
            SaveRunnable sr = new SaveRunnable((ISaxable)wizard.getBOM(), path);
            container.run(true, true, (IRunnableWithProgress)sr);
            wizard.getMaterializationSpec().setURL(path.toFile().toURI().toString());
        }
        catch (InterruptedException sr) {
        }
        catch (Exception e) {
            CoreException t = BuckminsterException.wrap((Throwable)e);
            String msg = NLS.bind((String)Messages.unable_to_save_file_0, (Object)path);
            CorePlugin.getLogger().error((Throwable)t, msg, new Object[0]);
            ErrorDialog.openError((Shell)this.getShell(), null, (String)msg, (IStatus)t.getStatus());
        }
    }

    private void updatePageCompletion() {
        boolean complete;
        String errorMsg = null;
        QueryWizard qw = this.getQueryWizard();
        BillOfMaterials bom = qw.getBOM();
        try {
            boolean bl = complete = bom != null;
            if (complete && !bom.isFullyResolved((Map)qw.getContext())) {
                complete = qw.getContext().isContinueOnError();
            }
        }
        catch (CoreException e) {
            complete = false;
            this.displayException(e);
        }
        if (!complete) {
            errorMsg = Messages.a_selected_specification_is_unresolved;
        }
        this.setPageComplete(complete);
        this.setErrorMessage(errorMsg);
    }

    private boolean wasParentWhenFirstSeen(BOMNode parent, BOMNode node) throws CoreException {
        if (parent == null) {
            return true;
        }
        Resolution resolution = node.getResolution();
        return resolution == null ? false : this.m_parentWhenFirstSeen.get(resolution) == parent;
    }

    class RequestLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        RequestLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String lbl;
            ComponentRequest rq = (ComponentRequest)element;
            switch (columnIndex) {
                case 0: {
                    lbl = rq.getName();
                    break;
                }
                case 1: {
                    VersionRange vd = rq.getVersionRange();
                    lbl = vd == null ? "" : VersionHelper.getHumanReadable((VersionRange)vd);
                    break;
                }
                default: {
                    lbl = rq.getComponentTypeID();
                }
            }
            return lbl;
        }
    }
}

