/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.wizards;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.materializer.AbstractMaterializer;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.core.mspec.IMaterializationNode;
import org.eclipse.buckminster.core.mspec.builder.MaterializationNodeBuilder;
import org.eclipse.buckminster.core.mspec.builder.MaterializationSpecBuilder;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.SaveRunnable;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.internal.DynamicTableLayout;
import org.eclipse.buckminster.ui.wizards.AbstractQueryPage;
import org.eclipse.buckminster.ui.wizards.QueryWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SaveAsDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetrieveAndBindPage
extends AbstractQueryPage {
    private Button m_advancedButton;
    private TableViewer m_componentTable;
    private Combo m_globalConflictResolutionCombo;
    private Text m_globalInstallLocation;
    private Combo m_globalMaterializer;
    private Label m_globalWorkspaceLocationLabel;
    private Text m_globalWorkspaceLocation;
    private Button m_globalWorkspaceLocationBrowse;
    private Group m_settingsGroup;
    private Button m_skipButton;
    private Button m_useDefaultsButton;

    private static void setTextValue(Text text, Object value) {
        String txt = "";
        if (value != null) {
            txt = value.toString().trim();
        }
        text.setText(txt);
    }

    public RetrieveAndBindPage() {
        super("");
        this.setDescription(Messages.all_specifications_resolved);
    }

    @Override
    public Composite createControls(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        topComposite.setLayout((Layout)new GridLayout());
        topComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createComponentTableGroup(topComposite);
        this.createSettingsGroup(topComposite);
        this.createButtonGroup(topComposite);
        return topComposite;
    }

    @Override
    protected void pageIsShowing() {
        super.pageIsShowing();
        QueryWizard wizard = this.getQueryWizard();
        try {
            TableViewer tv = this.getComponentTable();
            BillOfMaterials bom = wizard.getBOM();
            tv.setInput((Object)bom.findAll(null));
            tv.getTable().select(0);
            this.setGlobalValues();
            this.setSelectedComponentValues(this.getSelectedComponent());
        }
        catch (CoreException e) {
            this.displayException(e);
        }
    }

    Resolution getSelectedComponent() {
        IStructuredSelection selection = (IStructuredSelection)this.m_componentTable.getSelection();
        return selection != null && selection.size() == 1 ? (Resolution)selection.getFirstElement() : null;
    }

    void saveMSPECInFileSystem() {
        FileDialog dlg = new FileDialog(this.getShell(), 8192);
        dlg.setFilterExtensions(new String[]{"*.mspec"});
        String location = dlg.open();
        if (location == null) {
            return;
        }
        this.saveToPath((IPath)new Path(location));
    }

    void saveMSPECInWorkspace() {
        SaveAsDialog dialog = new SaveAsDialog(this.getShell());
        if (dialog.open() == 1) {
            return;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        this.saveToPath(file.getLocation());
    }

    private String browseForLocation(Resolution node) {
        DirectoryDialog dd = new DirectoryDialog(this.getShell());
        String dir = dd.open();
        return dir;
    }

    private void createButtonGroup(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        buttons.setLayoutData((Object)new GridData(4, 1024, true, false));
        Button saveButton = UiUtils.createPushButton(buttons, Messages.save_mspec, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieveAndBindPage.this.saveMSPECInWorkspace();
            }
        });
        saveButton.setLayoutData((Object)new GridData(131072, 128, true, false));
        Button extSaveButton = UiUtils.createPushButton(buttons, Messages.external_save_mspec, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieveAndBindPage.this.saveMSPECInFileSystem();
            }
        });
        extSaveButton.setLayoutData((Object)new GridData(131072, 128, false, false));
    }

    private void createComponentTableGroup(Composite parent) {
        Group globalSettings = new Group(parent, 0);
        globalSettings.setText(Messages.global_settings);
        globalSettings.setLayout((Layout)new GridLayout(3, false));
        globalSettings.setLayoutData((Object)new GridData(4, 4, true, false));
        UiUtils.createGridLabel((Composite)globalSettings, Messages.destination_type_with_colon, 1, 0, 0);
        this.m_globalMaterializer = UiUtils.createGridCombo((Composite)globalSettings, 1, 0, null, null, 76);
        UiUtils.createEmptyLabel((Composite)globalSettings);
        this.m_globalMaterializer.setItems(AbstractMaterializer.getMaterializerIDs((boolean)true));
        this.m_globalMaterializer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Combo combo = (Combo)se.getSource();
                int idx = combo.getSelectionIndex();
                String materializerId = idx >= 0 ? combo.getItem(idx) : null;
                RetrieveAndBindPage.this.setGlobalMaterializer(materializerId);
            }
        });
        this.m_globalInstallLocation = UiUtils.createLabeledText((Composite)globalSettings, Messages.location_with_colon, false, 0, new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                Text fld = (Text)me.getSource();
                String txt = UiUtils.trimmedValue(fld);
                RetrieveAndBindPage.this.setGlobalInstallLocation((IPath)(txt == null ? null : new Path(txt)));
            }
        });
        this.m_globalInstallLocation.setLayoutData((Object)new GridData(4, 4, true, false));
        UiUtils.createPushButton((Composite)globalSettings, Messages.browse_with_dots, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                String newLoc = RetrieveAndBindPage.this.browseForLocation(RetrieveAndBindPage.this.getSelectedComponent());
                if (newLoc != null) {
                    RetrieveAndBindPage.this.m_globalInstallLocation.setText(newLoc);
                }
            }
        });
        this.m_globalWorkspaceLocationLabel = UiUtils.createGridLabel((Composite)globalSettings, Messages.workspace_with_dots, 1, 0, 0);
        this.m_globalWorkspaceLocation = UiUtils.createGridText((Composite)globalSettings, 1, 0, 0, new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                Text fld = (Text)me.getSource();
                String txt = UiUtils.trimmedValue(fld);
                RetrieveAndBindPage.this.setGlobalWorkspaceLocation((IPath)(txt == null ? null : new Path(txt)));
            }
        });
        this.m_globalWorkspaceLocationBrowse = UiUtils.createPushButton((Composite)globalSettings, Messages.browse_with_dots, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                String newLoc = RetrieveAndBindPage.this.browseForLocation(RetrieveAndBindPage.this.getSelectedComponent());
                if (newLoc != null) {
                    RetrieveAndBindPage.this.m_globalWorkspaceLocation.setText(newLoc);
                }
            }
        });
        UiUtils.createGridLabel((Composite)globalSettings, Messages.on_non_empty_install_location_with_colon, 1, 0, 0);
        this.m_globalConflictResolutionCombo = UiUtils.createGridCombo((Composite)globalSettings, 1, 0, null, null, 76);
        UiUtils.createEmptyLabel((Composite)globalSettings);
        ConflictResolution[] conflictResolutionArray = ConflictResolution.values();
        int n = conflictResolutionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConflictResolution value = conflictResolutionArray[n2];
            this.m_globalConflictResolutionCombo.add(value.toString());
            ++n2;
        }
        this.m_globalConflictResolutionCombo.select(0);
        this.m_globalConflictResolutionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                RetrieveAndBindPage.this.globalConflictResolutionEvent(((Combo)se.getSource()).getSelectionIndex());
            }
        });
        Group componentTableGroup = new Group(parent, 0);
        componentTableGroup.setLayout((Layout)new GridLayout());
        componentTableGroup.setText(Messages.selected_components_with_colon);
        componentTableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Table table = new Table((Composite)componentTableGroup, 2820);
        String[] columnNames = new String[]{Messages.name, Messages.version, Messages.present, Messages.bound};
        int[] columnWeights = new int[]{20, 10, 5, 5};
        table.setHeaderVisible(true);
        DynamicTableLayout layout = new DynamicTableLayout(150);
        int idx = 0;
        while (idx < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, 16384, idx);
            tableColumn.setText(columnNames[idx]);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(columnWeights[idx], true));
            ++idx;
        }
        table.setLayout((Layout)layout);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_componentTable = new TableViewer(table);
        this.m_componentTable.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
        this.m_componentTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_componentTable.setSorter((ViewerSorter)new ResolutionViewerSorter());
        this.m_componentTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    try {
                        RetrieveAndBindPage.this.setSelectedComponentValues((Resolution)selection.getFirstElement());
                    }
                    catch (CoreException e) {
                        RetrieveAndBindPage.this.displayException(e);
                    }
                }
            }
        });
    }

    private void createSettingsGroup(Composite parent) {
        this.m_settingsGroup = new Group(parent, 0);
        this.m_settingsGroup.setLayout((Layout)new GridLayout(3, false));
        this.m_settingsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_skipButton = UiUtils.createCheckButton((Composite)this.m_settingsGroup, Messages.skip_this_component, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Button b = (Button)se.getSource();
                RetrieveAndBindPage.this.skipEvent(b.getSelection());
            }
        });
        this.m_skipButton.setSelection(false);
        this.m_useDefaultsButton = UiUtils.createCheckButton((Composite)this.m_settingsGroup, Messages.use_defaults, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Button b = (Button)se.getSource();
                RetrieveAndBindPage.this.useDefaultEvent(b.getSelection());
            }
        });
        this.m_useDefaultsButton.setSelection(true);
        this.m_advancedButton = UiUtils.createPushButton((Composite)this.m_settingsGroup, Messages.advanced_with_dots, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                RetrieveAndBindPage.this.displayResolutionDetails();
            }
        });
    }

    private void displayResolutionDetails() {
        Resolution resolution = this.getSelectedComponent();
        if (resolution == null) {
            return;
        }
        try {
            ResolutionDetails resolutionDetails = new ResolutionDetails(this.getShell(), resolution);
            if (resolutionDetails.open() == 0) {
                this.getQueryWizard().invalidateMaterializationContext();
                this.updatePageCompletion();
            }
        }
        catch (CoreException e) {
            this.displayException(e);
        }
    }

    private TableViewer getComponentTable() {
        return this.m_componentTable;
    }

    private MaterializationNodeBuilder getMaterializationNode(Resolution resolution) throws CoreException {
        QueryWizard wizard = this.getQueryWizard();
        ComponentIdentifier cname = resolution.getComponentIdentifier();
        MaterializationSpecBuilder mspec = wizard.getMaterializationSpec();
        MaterializationNodeBuilder node = mspec.getMatchingNodeBuilder((IComponentName)cname);
        if (node == null) {
            node = mspec.addNodeBuilder();
            node.setNamePattern(Pattern.compile("^\\Q" + cname.getName() + "\\E$"));
            node.setComponentTypeID(cname.getComponentTypeID());
        }
        wizard.invalidateMaterializationContext();
        return node;
    }

    private List<Resolution> getTableInput() {
        return (List)this.getComponentTable().getInput();
    }

    private void globalConflictResolutionEvent(int ordinal) {
        QueryWizard wizard = this.getQueryWizard();
        MaterializationContext context = wizard.getMaterializationContext();
        MaterializationSpec mspec = context.getMaterializationSpec();
        ConflictResolution cr = ConflictResolution.values()[ordinal];
        if (!cr.equals((Object)mspec.getConflictResolution())) {
            wizard.getMaterializationSpec().setConflictResolution(cr);
            wizard.invalidateMaterializationContext();
        }
    }

    private void saveToPath(IPath path) {
        QueryWizard wizard = this.getQueryWizard();
        IWizardContainer container = wizard.getContainer();
        try {
            MaterializationSpecBuilder mspecBuilder = wizard.getMaterializationSpec();
            IPath parent = path.removeLastSegments(1);
            String name = path.lastSegment();
            if (mspecBuilder.getURL() == null) {
                String bomName = name.endsWith(".mspec") ? String.valueOf(name.substring(0, name.length() - 5)) + "bom" : String.valueOf(name) + ".bom";
                IPath bomPath = parent.append(bomName);
                SaveRunnable sr = new SaveRunnable((ISaxable)wizard.getBOM(), bomPath);
                container.run(true, true, (IRunnableWithProgress)sr);
                mspecBuilder.setURL(bomName);
            }
            SaveRunnable sr = new SaveRunnable((ISaxable)mspecBuilder.createMaterializationSpec(), path);
            container.run(true, true, (IRunnableWithProgress)sr);
        }
        catch (InterruptedException mspecBuilder) {
        }
        catch (Exception e) {
            CoreException t = BuckminsterException.wrap((Throwable)e);
            String msg = NLS.bind((String)Messages.unable_to_save_file_0, (Object)path);
            CorePlugin.getLogger().error((Throwable)t, msg, new Object[0]);
            ErrorDialog.openError((Shell)this.getShell(), null, (String)msg, (IStatus)t.getStatus());
        }
    }

    private void setGlobalInstallLocation(IPath path) {
        try {
            QueryWizard wizard = this.getQueryWizard();
            MaterializationContext context = wizard.getMaterializationContext();
            if (!Trivial.equalsAllowNull((Object)context.getMaterializationSpec().getInstallLocation(), (Object)path)) {
                wizard.getMaterializationSpec().setInstallLocation(path);
                wizard.invalidateMaterializationContext();
                this.getComponentTable().setInput((Object)wizard.getBOM().findAll(null));
                this.setSelectedComponentValues(this.getSelectedComponent());
            }
        }
        catch (CoreException e) {
            this.displayException(e);
        }
    }

    private void setGlobalMaterializer(String materializer) {
        try {
            QueryWizard wizard = this.getQueryWizard();
            MaterializationContext context = wizard.getMaterializationContext();
            if (!Trivial.equalsAllowNull((Object)context.getMaterializationSpec().getMaterializerID(), (Object)materializer)) {
                if (materializer != null && materializer.length() == 0) {
                    materializer = null;
                }
                wizard.getMaterializationSpec().setMaterializerID(materializer);
                wizard.invalidateMaterializationContext();
                this.getComponentTable().setInput((Object)wizard.getBOM().findAll(null));
                this.setSelectedComponentValues(this.getSelectedComponent());
                this.setGlobalValues();
            }
        }
        catch (CoreException e) {
            this.displayException(e);
        }
    }

    private void setGlobalValues() throws CoreException {
        MaterializationContext context = this.getQueryWizard().getMaterializationContext();
        MaterializationSpec mspec = context.getMaterializationSpec();
        int matIdx = 0;
        String materializer = mspec.getMaterializerID();
        if (materializer != null && (matIdx = this.m_globalMaterializer.indexOf(materializer)) < 0) {
            matIdx = 0;
        }
        this.m_globalMaterializer.select(matIdx);
        IPath p = mspec.getInstallLocation();
        this.m_globalInstallLocation.setText(p == null ? "" : p.toOSString());
        if ("workspace".equals(materializer)) {
            p = mspec.getWorkspaceLocation();
            this.m_globalWorkspaceLocation.setText(p == null ? "" : p.toOSString());
            this.m_globalWorkspaceLocationLabel.setEnabled(true);
            this.m_globalWorkspaceLocation.setEnabled(true);
            this.m_globalWorkspaceLocationBrowse.setEnabled(true);
        } else {
            this.m_globalWorkspaceLocationLabel.setEnabled(false);
            this.m_globalWorkspaceLocation.setEnabled(false);
            this.m_globalWorkspaceLocationBrowse.setEnabled(false);
        }
        ConflictResolution cr = mspec.getConflictResolution();
        if (cr == null) {
            cr = ConflictResolution.getDefault();
        }
        this.m_globalConflictResolutionCombo.select(cr.ordinal());
    }

    private void setGlobalWorkspaceLocation(IPath path) {
        try {
            QueryWizard wizard = this.getQueryWizard();
            MaterializationContext context = wizard.getMaterializationContext();
            if (!Trivial.equalsAllowNull((Object)context.getMaterializationSpec().getWorkspaceLocation(), (Object)path)) {
                wizard.getMaterializationSpec().setWorkspaceLocation(path);
                wizard.invalidateMaterializationContext();
                this.getComponentTable().setInput((Object)wizard.getBOM().findAll(null));
                this.setSelectedComponentValues(this.getSelectedComponent());
            }
        }
        catch (CoreException e) {
            this.displayException(e);
        }
    }

    private void setSelectedComponentValues(Resolution resolution) throws CoreException {
        if (resolution == null) {
            UiUtils.setChildrenVisible((Composite)this.m_settingsGroup, false);
            this.updatePageCompletion();
            return;
        }
        MaterializationContext context = this.getQueryWizard().getMaterializationContext();
        MaterializationSpec mspec = context.getMaterializationSpec();
        IMaterializationNode node = mspec.getMatchingNode(resolution);
        boolean useDefaults = node == null;
        boolean skip = !useDefaults && node.isExclude();
        boolean canMaterialize = resolution.isMaterializable();
        this.m_settingsGroup.setText(resolution.getRequest().getViewName());
        this.m_skipButton.setSelection(skip);
        this.m_useDefaultsButton.setSelection(useDefaults);
        this.m_useDefaultsButton.setEnabled(!skip && canMaterialize);
        this.m_advancedButton.setEnabled(!skip && !useDefaults && canMaterialize);
        this.updatePageCompletion();
    }

    private void skipEvent(boolean skip) {
        Resolution resolution = this.getSelectedComponent();
        if (resolution == null) {
            return;
        }
        try {
            MaterializationContext context = this.getQueryWizard().getMaterializationContext();
            IMaterializationNode node = context.getMaterializationSpec().getMatchingNode(resolution);
            if (skip) {
                if (node == null || !node.isExclude()) {
                    this.getMaterializationNode(resolution).setExclude(true);
                }
            } else if (node != null && node.isExclude()) {
                this.useDefaultEvent(true);
                return;
            }
            this.setSelectedComponentValues(resolution);
        }
        catch (CoreException e) {
            this.displayException(e);
        }
    }

    private void updatePageCompletion() throws CoreException {
        this.setErrorMessage(null);
        this.setPageComplete(false);
        MaterializationContext context = this.getQueryWizard().getMaterializationContext();
        MaterializationSpec mspec = context.getMaterializationSpec();
        List<Resolution> resolutions = this.getTableInput();
        Collections.sort(resolutions, new ResolutionComparator());
        for (Resolution resolution : resolutions) {
            if (!resolution.isMaterializable() || mspec.isExcluded(resolution)) continue;
            String id = resolution.getRequest().getViewName();
            IPath destination = context.getArtifactLocation(resolution);
            File f = destination.toFile();
            if (!f.isAbsolute()) {
                this.setErrorMessage(NLS.bind((String)Messages.the_location_0_for_1_is_not_an_absolute_path, (Object)f, (Object)id));
                return;
            }
            if (!f.exists() || mspec.getConflictResolution(resolution) != ConflictResolution.FAIL || resolution.isMaterialized(destination)) continue;
            if (f.isFile()) {
                this.setErrorMessage(NLS.bind((String)Messages.the_location_0_for_1_already_exists_as_a_file, (Object)f, (Object)id));
                return;
            }
            if (f.list().length == 0) continue;
            this.setErrorMessage(NLS.bind((String)Messages.the_location_0_for_1_exists_but_is_not_empty, (Object)f, (Object)id));
            return;
        }
        this.setPageComplete(true);
    }

    private void useDefaultEvent(boolean flag) {
        Resolution resolution = this.getSelectedComponent();
        if (resolution != null) {
            try {
                QueryWizard wizard = this.getQueryWizard();
                ComponentRequest rq = resolution.getRequest();
                MaterializationSpecBuilder bld = wizard.getMaterializationSpec();
                MaterializationNodeBuilder node = bld.getMatchingNodeBuilder((IComponentName)rq);
                if (flag) {
                    if (node != null) {
                        bld.getNodes().remove(node);
                        wizard.invalidateMaterializationContext();
                    }
                } else if (node == null) {
                    this.getMaterializationNode(resolution);
                }
                this.setSelectedComponentValues(resolution);
            }
            catch (CoreException e) {
                this.displayException(e);
            }
        }
    }

    class ComponentLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ComponentLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String lbl;
            MaterializationContext context = RetrieveAndBindPage.this.getQueryWizard().getMaterializationContext();
            Resolution resolution = (Resolution)element;
            ComponentRequest request = resolution.getRequest();
            switch (columnIndex) {
                case 0: {
                    lbl = request.getViewName();
                    break;
                }
                case 1: {
                    VersionMatch vm = resolution.getVersionMatch();
                    lbl = vm == null ? "" : vm.toString();
                    break;
                }
                case 2: {
                    try {
                        if (!context.getMaterializationSpec().isExcluded(resolution) && resolution.isMaterializable()) {
                            if (resolution.isMaterialized(context.getArtifactLocation(resolution))) {
                                lbl = Messages.yes;
                                break;
                            }
                            lbl = Messages.no;
                            break;
                        }
                        lbl = Messages.not_available_abbreviation;
                    }
                    catch (Exception e) {
                        lbl = Messages.error_in_capitals;
                        CorePlugin.getLogger().error((Throwable)e, e.getMessage(), new Object[0]);
                    }
                    break;
                }
                default: {
                    try {
                        if (!context.getMaterializationSpec().isExcluded(resolution) && resolution.isMaterializable()) {
                            if (WorkspaceInfo.getResources((IComponentIdentifier)resolution.getCSpec().getComponentIdentifier()).length > 0) {
                                lbl = Messages.yes;
                                break;
                            }
                            lbl = Messages.no;
                            break;
                        }
                        lbl = Messages.not_available_abbreviation;
                        break;
                    }
                    catch (Exception e) {
                        lbl = Messages.error_in_capitals;
                        CorePlugin.getLogger().error(e.getMessage(), new Object[]{e});
                    }
                }
            }
            return lbl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResolutionComparator
    implements Comparator<Resolution> {
        ResolutionComparator() {
        }

        @Override
        public int compare(Resolution o1, Resolution o2) {
            int result = o1.getRequest().getViewName().compareTo(o2.getRequest().getViewName());
            if (result == 0) {
                Version vsA = o1.getVersion();
                Version vsB = o2.getVersion();
                if (vsA != null) {
                    result = vsB == null ? 1 : vsA.compareTo((Object)vsB);
                } else if (vsB != null) {
                    result = -1;
                }
            }
            return result;
        }
    }

    class ResolutionDetails
    extends TitleAreaDialog {
        private Combo m_conflictResolution;
        private Text m_defaultSuffix;
        private Label m_defaultSuffixLabel;
        private Button m_expandButton;
        private Text m_installLocation;
        private Text m_leafArtifact;
        private Combo m_materializer;
        private Text m_resourcePath;
        private Label m_resourcePathLabel;
        private Button m_unpackButton;
        private Text m_workspaceLocation;
        private Button m_workspaceLocationBrowse;
        private Label m_workspaceLocationLabel;
        private final String m_title;
        private final MaterializationNodeBuilder m_node;

        public ResolutionDetails(Shell parentShell, Resolution resolution) throws CoreException {
            super(parentShell);
            this.m_node = RetrieveAndBindPage.this.getMaterializationNode(resolution);
            this.m_title = resolution.getRequest().getViewName();
        }

        protected Control createContents(Composite parent) {
            Control contents = super.createContents(parent);
            String materializer = this.m_node.getMaterializerID();
            int matIdx = 0;
            if (materializer != null && (matIdx = this.m_materializer.indexOf(materializer)) < 0) {
                matIdx = 0;
            }
            this.m_materializer.select(matIdx);
            ConflictResolution nodeRes = this.m_node.getConflictResolution();
            this.m_conflictResolution.select(nodeRes == null ? 0 : nodeRes.ordinal() + 1);
            RetrieveAndBindPage.setTextValue(this.m_resourcePath, this.m_node.getResourcePath());
            RetrieveAndBindPage.setTextValue(this.m_installLocation, this.m_node.getInstallLocation());
            RetrieveAndBindPage.setTextValue(this.m_leafArtifact, this.m_node.getLeafArtifact());
            RetrieveAndBindPage.setTextValue(this.m_workspaceLocation, this.m_node.getWorkspaceLocation());
            this.m_unpackButton.setSelection(this.m_node.isUnpack());
            this.m_expandButton.setSelection(this.m_node.isExpand());
            RetrieveAndBindPage.setTextValue(this.m_defaultSuffix, this.m_node.getSuffix());
            this.setTitle(this.m_title);
            this.updateMaterializerView();
            this.updateUnpackView();
            return contents;
        }

        protected Control createDialogArea(Composite parent) {
            Control dialogParent = super.createDialogArea(parent);
            Composite myParent = new Composite((Composite)dialogParent, 0);
            myParent.setLayout((Layout)new GridLayout(5, false));
            myParent.setLayoutData((Object)new GridData(4, 4, true, false));
            UiUtils.createGridLabel(myParent, Messages.destination_type_with_colon, 2, 0, 0);
            this.m_materializer = UiUtils.createGridCombo(myParent, 2, 0, null, null, 76);
            UiUtils.createEmptyLabel(myParent).setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.m_materializer.setItems(AbstractMaterializer.getMaterializerIDs((boolean)true));
            this.m_materializer.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    ResolutionDetails.this.updateMaterializerView();
                }
            });
            this.m_installLocation = UiUtils.createGridLabeledText(myParent, Messages.parnet_folder_with_colon, 2, 2, false, 0, null);
            UiUtils.createPushButton(myParent, Messages.browse_with_dots, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    DirectoryDialog dd = new DirectoryDialog(ResolutionDetails.this.getShell());
                    String newLoc = dd.open();
                    if (newLoc != null) {
                        ResolutionDetails.this.m_installLocation.setText(newLoc);
                    }
                }
            }).setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.m_leafArtifact = UiUtils.createGridLabeledText(myParent, Messages.leaf_artifact_with_colon, 2, 3, false, 0, null);
            UiUtils.createGridLabel(myParent, Messages.on_non_empty_install_location_with_colon, 2, 0, 0);
            this.m_conflictResolution = UiUtils.createGridCombo(myParent, 2, 0, null, null, 76);
            UiUtils.createEmptyLabel(myParent).setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.m_conflictResolution.add("");
            ConflictResolution[] conflictResolutionArray = ConflictResolution.values();
            int n = conflictResolutionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConflictResolution value = conflictResolutionArray[n2];
                this.m_conflictResolution.add(value.toString());
                ++n2;
            }
            this.m_unpackButton = UiUtils.createCheckButton(myParent, Messages.unpack, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    ResolutionDetails.this.updateUnpackView();
                }
            });
            this.m_expandButton = UiUtils.createCheckButton(myParent, Messages.expand, null);
            this.m_defaultSuffixLabel = UiUtils.createGridLabel(myParent, Messages.default_suffix_with_colon, 1, 0, 0);
            this.m_defaultSuffix = UiUtils.createGridText(myParent, 2, 0, 0);
            this.m_workspaceLocationLabel = UiUtils.createGridLabel(myParent, Messages.workspace_with_colon, 2, 0, 0);
            this.m_workspaceLocation = UiUtils.createGridText(myParent, 2, 0, 0);
            this.m_workspaceLocationBrowse = UiUtils.createPushButton(myParent, Messages.browse_with_dots, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    DirectoryDialog dd = new DirectoryDialog(ResolutionDetails.this.getShell());
                    String newLoc = dd.open();
                    if (newLoc != null) {
                        ResolutionDetails.this.m_workspaceLocation.setText(newLoc);
                    }
                }
            });
            this.m_workspaceLocationBrowse.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.m_resourcePathLabel = UiUtils.createGridLabel(myParent, Messages.project_name_with_colon, 2, 0, 0);
            this.m_resourcePath = UiUtils.createGridText(myParent, 3, 0, 0);
            return dialogParent;
        }

        protected void okPressed() {
            String tmp = UiUtils.trimmedValue(this.m_installLocation);
            this.m_node.setInstallLocation(tmp == null ? null : Path.fromOSString((String)tmp));
            tmp = UiUtils.trimmedValue(this.m_leafArtifact);
            this.m_node.setLeafArtifact(tmp == null ? null : Path.fromOSString((String)tmp));
            int idx = this.m_materializer.getSelectionIndex();
            this.m_node.setMaterializerID(idx <= 0 ? null : this.m_materializer.getItem(idx));
            idx = this.m_conflictResolution.getSelectionIndex();
            this.m_node.setConflictResolution(idx <= 0 ? null : ConflictResolution.values()[idx - 1]);
            if (this.m_unpackButton.getSelection()) {
                this.m_node.setUnpack(true);
                this.m_node.setExpand(this.m_expandButton.getSelection());
                this.m_node.setSuffix(UiUtils.trimmedValue(this.m_defaultSuffix));
            } else {
                this.m_node.setUnpack(false);
            }
            if (this.isUsingWorkspace()) {
                tmp = UiUtils.trimmedValue(this.m_resourcePath);
                this.m_node.setResourcePath(tmp == null ? null : Path.fromOSString((String)tmp));
                tmp = UiUtils.trimmedValue(this.m_workspaceLocation);
                this.m_node.setWorkspaceLocation(tmp == null ? null : Path.fromOSString((String)tmp));
            }
            super.okPressed();
        }

        private boolean isUsingWorkspace() {
            boolean useWorkspace;
            String id;
            int idx = this.m_materializer.getSelectionIndex();
            String string = id = idx >= 0 ? this.m_materializer.getItem(idx) : "";
            if (id.length() == 0) {
                int globalIdx = RetrieveAndBindPage.this.m_globalMaterializer.getSelectionIndex();
                String globalId = globalIdx >= 0 ? RetrieveAndBindPage.this.m_globalMaterializer.getItem(globalIdx) : "";
                useWorkspace = "workspace".equals(globalId);
            } else {
                useWorkspace = "workspace".equals(id);
            }
            return useWorkspace;
        }

        private void updateMaterializerView() {
            boolean useWorkspace = this.isUsingWorkspace();
            this.m_resourcePathLabel.setEnabled(useWorkspace);
            this.m_resourcePath.setEnabled(useWorkspace);
            this.m_workspaceLocationLabel.setEnabled(useWorkspace);
            this.m_workspaceLocation.setEnabled(useWorkspace);
            this.m_workspaceLocationBrowse.setEnabled(useWorkspace);
        }

        private void updateUnpackView() {
            boolean unpack = this.m_unpackButton.getSelection();
            this.m_expandButton.setEnabled(unpack);
            this.m_defaultSuffixLabel.setEnabled(unpack);
            this.m_defaultSuffix.setEnabled(unpack);
        }
    }

    static class ResolutionViewerSorter
    extends ViewerSorter {
        private final ResolutionComparator m_nodeComparator = new ResolutionComparator();

        ResolutionViewerSorter() {
        }

        public int compare(Viewer viewer, Object a, Object b) {
            return this.m_nodeComparator.compare((Resolution)a, (Resolution)b);
        }
    }
}

