/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.wizards;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.helpers.AccessibleByteArrayOutputStream;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.mspec.builder.MaterializationSpecBuilder;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.parser.IParserFactory;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.MainResolver;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.wizards.AbstractQueryPage;
import org.eclipse.buckminster.ui.wizards.QueryWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectBOMPage
extends AbstractQueryPage {
    private Label m_topComponentLabel;
    private Text m_fileNameText;
    private Text m_topComponent;
    private Button m_loadButton;
    private URL m_bomOrMSpecURL;

    public SelectBOMPage(IStructuredSelection selection) {
        super("");
        IPath location;
        Object selected;
        if (selection != null && selection.size() == 1 && (selected = selection.getFirstElement()) instanceof IFile && (location = ((IFile)selected).getLocation()) != null) {
            try {
                this.m_bomOrMSpecURL = location.toFile().toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public void pageIsShowing() {
        QueryWizard qw = this.getQueryWizard();
        if (this.m_bomOrMSpecURL != null && !qw.hasBOM()) {
            this.loadBomOrMSpec();
            if (this.m_bomOrMSpecURL != null) {
                this.m_fileNameText.setText(this.m_bomOrMSpecURL.toString());
            }
        }
    }

    public void setErrorMessage(String message) {
        QueryWizard qw = this.getQueryWizard();
        if (message != null) {
            this.m_bomOrMSpecURL = null;
            qw.resetBOM();
        }
        super.setErrorMessage(message);
        if (qw.hasBOM()) {
            if (!this.isPageComplete()) {
                try {
                    this.m_topComponent.setText(qw.getBOM().getViewName());
                    this.m_topComponentLabel.setVisible(true);
                    this.m_topComponent.setVisible(true);
                    this.setPageComplete(true);
                }
                catch (CoreException e) {
                    this.displayException(e);
                    qw.resetBOM();
                }
            }
        } else if (this.isPageComplete()) {
            this.m_topComponentLabel.setVisible(false);
            this.m_topComponent.setVisible(false);
            this.setPageComplete(false);
        }
    }

    protected Composite createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lbl = new Label(composite, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        lbl.setText(Messages.enter_url_of_mspec_bom_cquery);
        lbl.setToolTipText(Messages.enter_url_that_appoints_mspec_bom_cquery);
        this.m_fileNameText = new Text(composite, 2048);
        this.m_fileNameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                SelectBOMPage.this.setBomOrMSpecFile(UiUtils.trimmedValue((Text)me.widget));
            }
        });
        Button browseButton = UiUtils.createPushButton(composite, Messages.browse_with_dots, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FileDialog dlg = new FileDialog(SelectBOMPage.this.getShell());
                dlg.setFilterExtensions(new String[]{"*.mspec", "*.cquery", "*.bom"});
                String name = dlg.open();
                if (name != null) {
                    SelectBOMPage.this.m_fileNameText.setText(name);
                }
            }
        });
        browseButton.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.m_loadButton = UiUtils.createPushButton(composite, Messages.load, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                SelectBOMPage.this.loadBomOrMSpec();
            }
        });
        this.m_loadButton.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.m_loadButton.setEnabled(false);
        this.m_topComponentLabel = new Label(composite, 0);
        this.m_topComponentLabel.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.m_topComponentLabel.setText(Messages.top_component_of_loaded_bom);
        this.m_topComponentLabel.setVisible(false);
        this.m_topComponent = new Text(composite, 2048);
        this.m_topComponent.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.m_topComponent.setEditable(false);
        this.m_topComponent.setVisible(false);
        this.setControl((Control)composite);
        this.setPageComplete(false);
        return composite;
    }

    void loadBomOrMSpec() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    URL urlToParse = SelectBOMPage.this.m_bomOrMSpecURL;
                    InputStream input = null;
                    monitor.beginTask(null, 100);
                    try {
                        try {
                            BillOfMaterials bom;
                            ComponentQuery cquery;
                            MaterializationSpec mspec;
                            IParserFactory pf;
                            QueryWizard wizard;
                            AccessibleByteArrayOutputStream byteBld;
                            block15: {
                                MaterializationSpecBuilder mspecBld;
                                block14: {
                                    byteBld = new AccessibleByteArrayOutputStream();
                                    wizard = SelectBOMPage.this.getQueryWizard();
                                    mspecBld = wizard.getMaterializationSpec();
                                    DownloadManager.readInto((URL)urlToParse, null, (OutputStream)byteBld, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                                    input = byteBld.getInputStream();
                                    pf = CorePlugin.getDefault().getParserFactory();
                                    mspec = null;
                                    String path = urlToParse.getPath();
                                    if (!path.endsWith(".cquery") && !path.endsWith(".bom")) {
                                        try {
                                            mspec = (MaterializationSpec)pf.getMaterializationSpecParser(true).parse(urlToParse.toString(), input);
                                        }
                                        catch (CoreException e) {
                                            if (!urlToParse.getPath().endsWith(".mspec")) break block14;
                                            throw e;
                                        }
                                    }
                                }
                                MonitorUtils.worked((IProgressMonitor)monitor, (int)5);
                                if (mspec != null) {
                                    mspecBld.initFrom(mspec);
                                    urlToParse = mspec.getResolvedURL();
                                    byteBld.reset();
                                    DownloadManager.readInto((URL)urlToParse, null, (OutputStream)byteBld, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                                } else {
                                    mspecBld.setURL(urlToParse.toString());
                                    MonitorUtils.worked((IProgressMonitor)monitor, (int)20);
                                }
                                input = byteBld.getInputStream();
                                cquery = null;
                                if (!urlToParse.getPath().endsWith(".bom")) {
                                    try {
                                        cquery = ComponentQuery.fromStream((URL)urlToParse, null, (InputStream)input, (boolean)true);
                                    }
                                    catch (CoreException e) {
                                        if (!urlToParse.getPath().endsWith(".cquery")) break block15;
                                        throw e;
                                    }
                                }
                            }
                            MonitorUtils.worked((IProgressMonitor)monitor, (int)5);
                            if (cquery != null) {
                                ResolutionContext ctx = mspec == null ? new ResolutionContext(cquery) : new ResolutionContext(mspec, cquery);
                                MainResolver resolver = new MainResolver(ctx);
                                resolver.getContext().setContinueOnError(true);
                                bom = resolver.resolve(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)40));
                            } else {
                                input = byteBld.getInputStream();
                                bom = (BillOfMaterials)pf.getBillOfMaterialsParser(true).parse(urlToParse.toString(), input);
                                MonitorUtils.worked((IProgressMonitor)monitor, (int)40);
                            }
                            wizard.setBOM(bom);
                            MonitorUtils.worked((IProgressMonitor)monitor, (int)10);
                        }
                        catch (Throwable e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(input);
                        monitor.done();
                        throw throwable;
                    }
                    IOUtils.close((Closeable)input);
                    monitor.done();
                }
            });
            this.setErrorMessage(null);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            this.displayException(BuckminsterException.wrap((Throwable)e));
        }
    }

    void setBomOrMSpecFile(String bomFile) {
        URL url;
        URL oldBomOrMSPecURL = this.m_bomOrMSpecURL;
        this.m_bomOrMSpecURL = null;
        if (bomFile == null) {
            this.setErrorMessage(null);
            this.m_loadButton.setEnabled(false);
            return;
        }
        try {
            url = URLUtils.normalizeToURL((String)bomFile);
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException e) {
            this.setErrorMessage(Messages.invalid_url_or_filename);
            this.m_loadButton.setEnabled(false);
            return;
        }
        File file = FileUtils.getFile((URL)url);
        if (file == null) {
            String path = url.getPath();
            if (path == null || path.length() == 0 || path.endsWith("/")) {
                this.setErrorMessage(Messages.url_path_is_not_valid);
                this.m_loadButton.setEnabled(false);
            } else {
                this.m_bomOrMSpecURL = url;
                this.m_loadButton.setEnabled(true);
                this.setErrorMessage(null);
            }
        } else {
            this.m_loadButton.setEnabled(false);
            if (file.isFile() && file.canRead()) {
                this.m_bomOrMSpecURL = url;
                if (!oldBomOrMSPecURL.toExternalForm().equals(this.m_bomOrMSpecURL.toExternalForm())) {
                    this.loadBomOrMSpec();
                }
            } else {
                this.setErrorMessage(Messages.file_does_not_exist);
            }
        }
    }
}

