/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jarprocessor;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.buckminster.jarprocessor.JarInfo;
import org.eclipse.buckminster.jarprocessor.ProducerThread;
import org.eclipse.buckminster.jarprocessor.RecursivePack200;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursivePacker
extends RecursivePack200 {
    private final boolean m_useRedunantGZipping;

    public RecursivePacker(List<String> defaultArgs, boolean useRedundantGZipping) {
        super(defaultArgs);
        this.m_useRedunantGZipping = useRedundantGZipping;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean pack(File jarFile) throws CoreException {
        GZIPOutputStream gZIPOutputStream;
        FileInputStream fileInputStream;
        block9: {
            Logger log = Buckminster.getLogger();
            String fileName = jarFile.getAbsolutePath();
            Object var4_4 = null;
            Closeable closeable = null;
            try {
                JarInfo jarInfo;
                ZipInputStream zipInputStream;
                block13: {
                    block11: {
                        block12: {
                            block10: {
                                zipInputStream = new ZipInputStream(new FileInputStream(jarFile));
                                jarInfo = JarInfo.getJarInfo(null, fileName, zipInputStream);
                                if (jarInfo.hasClasses() || jarInfo.isNested() && !jarInfo.isExcludeChildrenPack()) break block10;
                                log.debug("Packer: Skipping %s since it contains no classes and no nested jars to pack", new Object[]{fileName});
                                break block11;
                            }
                            if (!jarInfo.isExcludePack()) break block12;
                            log.debug("Packer: Skipping %s since is excluded", new Object[]{fileName});
                            break block11;
                        }
                        if (!jarInfo.isSigned() || jarInfo.isConditioned()) break block13;
                        log.debug("Packer: Skipping %s since is signed but not conditioned", new Object[]{fileName});
                    }
                    IOUtils.close((Closeable)zipInputStream);
                    IOUtils.close(closeable);
                    return false;
                }
                IOUtils.close((Closeable)zipInputStream);
                fileInputStream = new FileInputStream(jarFile);
                FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(fileName) + ".pack.gz");
                gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
                if (jarInfo.isNested() && !jarInfo.isExcludeChildrenPack()) {
                    this.nestedPack(fileInputStream, jarInfo, gZIPOutputStream);
                    break block9;
                }
                this.pack(jarInfo, fileInputStream, gZIPOutputStream);
            }
            catch (IOException e) {
                try {
                    throw BuckminsterException.fromMessage((Throwable)e, (String)"Unable to pack %s", (Object[])new Object[]{fileName});
                }
                catch (Throwable throwable) {
                    void var4_7;
                    IOUtils.close((Closeable)var4_7);
                    IOUtils.close(closeable);
                    throw throwable;
                }
            }
        }
        IOUtils.close((Closeable)fileInputStream);
        IOUtils.close((Closeable)gZIPOutputStream);
        return true;
    }

    private void nestedPack(final InputStream input, final JarInfo jarInfo, OutputStream packedOut) throws CoreException {
        ProducerThread pumper = new ProducerThread("Pack200 pumper"){

            protected void internalRun(OutputStream writer) throws Exception {
                ZipInputStream jarIn = new ZipInputStream(input);
                RecursivePacker.this.processNestedJars(jarIn, jarInfo, writer);
            }
        };
        pumper.start();
        try {
            this.pack(jarInfo, pumper.getReaderStream(), packedOut);
        }
        catch (IOException e) {
            pumper.drain(jarInfo, e);
        }
        pumper.drain(jarInfo, null);
    }

    private void processNestedJars(ZipInputStream jarIn, JarInfo jarInfo, OutputStream output) throws Exception {
        ZipEntry entry;
        ZipOutputStream jarOut = new ZipOutputStream(output);
        boolean packChildren = !jarInfo.isExcludeChildrenPack();
        while ((entry = jarIn.getNextEntry()) != null) {
            JarInfo nested;
            String name = entry.getName();
            if (packChildren && name.endsWith(".jar") && (nested = jarInfo.getNestedInfo(name)) != null) {
                if (nested.hasClasses() && (!nested.isSigned() || nested.isConditioned())) {
                    if (this.m_useRedunantGZipping) {
                        jarOut.putNextEntry(RecursivePacker.createEntry(entry, String.valueOf(name) + ".pack.gz"));
                        GZIPOutputStream gzipOut = new GZIPOutputStream(jarOut);
                        this.nestedPack(jarIn, nested, gzipOut);
                        gzipOut.finish();
                        continue;
                    }
                    jarOut.putNextEntry(RecursivePacker.createEntry(entry, String.valueOf(name) + ".pack"));
                    this.nestedPack(jarIn, nested, jarOut);
                    continue;
                }
                jarOut.putNextEntry(RecursivePacker.createEntry(entry));
                this.processNestedJars(jarIn, nested, jarOut);
                continue;
            }
            jarOut.putNextEntry(RecursivePacker.createEntry(entry));
            if (entry.isDirectory()) continue;
            IOUtils.copy((InputStream)jarIn, (OutputStream)jarOut, null);
        }
        jarOut.finish();
    }
}

