/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.installer;

import java.net.URI;
import java.util.Arrays;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.installer.FeatureQuery;
import org.eclipse.buckminster.installer.Install;
import org.eclipse.buckminster.installer.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.console.ProvisioningHelper;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.LatestIUVersionQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.CompositeQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;

public class ListSite
extends AbstractCommand {
    private URI m_site;

    static IInstallableUnit[] getRootIUs(URI site, IProgressMonitor monitor) throws SimpleErrorExitException {
        Collector roots = new Collector();
        if (site == null) {
            IProfile runningInstanceProfile = ProvisioningHelper.getProfile((String)"_SELF_");
            if (runningInstanceProfile != null) {
                roots = runningInstanceProfile.query((Query)new CompositeQuery(new Query[]{new FeatureQuery(), new LatestIUVersionQuery()}), roots, monitor);
            }
        } else {
            roots = ProvisioningHelper.getInstallableUnits((URI)site, (Query)new CompositeQuery(new Query[]{new FeatureQuery(), new LatestIUVersionQuery()}), (Collector)roots, (IProgressMonitor)monitor);
        }
        return (IInstallableUnit[])roots.toArray(IInstallableUnit.class);
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        int len = unparsed.length;
        if (len > 1) {
            throw new SimpleErrorExitException(Messages.too_many_arguments);
        }
        if (len == 1) {
            this.m_site = Install.normalizeToURI(unparsed[0]);
        }
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(null, -1);
        System.out.println(Messages.feature_listing_heading);
        Object[] roots = ListSite.getRootIUs(this.m_site, monitor);
        Arrays.sort(roots);
        Object[] objectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Object iu = objectArray[n2];
            System.out.print("  ");
            String id = iu.getId();
            if (id.endsWith(".feature.group")) {
                id = id.substring(0, id.length() - 14);
            }
            System.out.print(id);
            String label = iu.getProperty("org.eclipse.equinox.p2.name");
            if (label != null) {
                System.out.print(" (");
                System.out.print(label);
                System.out.println(")");
            }
            ++n2;
        }
        return 0;
    }
}

