/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.generic.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractAction
extends Action {
    private final Viewer m_viewer;

    public AbstractAction(Viewer viewer) {
        this.m_viewer = viewer;
    }

    protected ISelection getSelection() {
        return this.m_viewer.getSelection();
    }

    protected Shell getShell() {
        return this.m_viewer.getControl().getShell();
    }

    protected IStructuredSelection getStructuredSelection() {
        return (IStructuredSelection)this.m_viewer.getSelection();
    }

    protected Viewer getViewer() {
        return this.m_viewer;
    }

    protected boolean showConfirm(String title, String question) {
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)question);
    }

    protected void showError(String title, String message) {
        ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)new Status(4, "org.eclipse.buckminster.generic.ui.actions", message));
    }

    protected void showError(String title, String message, Throwable e) {
        ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)new Status(4, "org.eclipse.buckminster.generic.ui.actions", e.getMessage(), e));
    }

    protected void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
    }
}

