/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cmdline;

public class OptionDescriptor {
    private final Character m_shortName;
    private final String m_longName;
    private final int m_type;

    public OptionDescriptor(char shortName, String longName, int type) {
        this(shortName == '\u0000' ? null : Character.valueOf(shortName), longName, type);
    }

    public OptionDescriptor(Character shortName, String longName, int type) {
        this.m_shortName = shortName;
        this.m_longName = longName;
        this.m_type = type;
    }

    public OptionDescriptor(String longName, int type) {
        this(null, longName, type);
    }

    public String getLongName() {
        return this.m_longName;
    }

    public Character getShortName() {
        return this.m_shortName;
    }

    public int getType() {
        return this.m_type;
    }

    public boolean isAcceptableName(String name, boolean isLongName, boolean exact) {
        if (!isLongName) {
            return this.m_shortName == null ? false : this.m_shortName.charValue() == name.charAt(0);
        }
        if (this.m_longName == null) {
            return false;
        }
        return exact ? this.m_longName.equals(name) : this.m_longName.startsWith(name);
    }
}

