/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.engine;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.mail.MailMessage;
import org.eclipse.buckminster.aggregator.Aggregator;
import org.eclipse.buckminster.aggregator.Contact;
import org.eclipse.buckminster.aggregator.Contribution;
import org.eclipse.buckminster.aggregator.MappedRepository;
import org.eclipse.buckminster.aggregator.engine.CategoriesGenerator;
import org.eclipse.buckminster.aggregator.engine.MirrorGenerator;
import org.eclipse.buckminster.aggregator.engine.RepositoryVerifier;
import org.eclipse.buckminster.aggregator.engine.SourceCompositeGenerator;
import org.eclipse.buckminster.aggregator.engine.VerificationFeatureGenerator;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.Headless;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionedName;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Builder
extends AbstractCommand
implements IApplication {
    public static final String ALL_CONTRIBUTED_CONTENT_FEATURE = "all.contributed.content.feature.group";
    public static final String PDE_TARGET_PLATFORM_NAMESPACE = "A.PDE.Target.Platform";
    public static final Version ALL_CONTRIBUTED_CONTENT_VERSION = Version.createOSGi((int)1, (int)0, (int)0);
    public static final String COMPOSITE_ARTIFACTS_TYPE = "org.eclipse.equinox.p2.artifact.repository.compositeRepository";
    public static final String COMPOSITE_METADATA_TYPE = "org.eclipse.equinox.p2.metadata.repository.compositeRepository";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String NAMESPACE_OSGI_BUNDLE = "osgi.bundle";
    public static final String PROFILE_ID = "GalileoTest";
    public static final String REPO_FOLDER_VERIFICATION = "verification";
    public static final String REPO_FOLDER_FINAL = "final";
    public static final String REPO_FOLDER_INTERIM = "interim";
    public static final String REPO_FOLDER_TEMP = "temp";
    public static final String REPO_FOLDER_AGGREGATE = "aggregate";
    public static final String SIMPLE_ARTIFACTS_TYPE = "org.eclipse.equinox.p2.artifact.repository.simpleRepository";
    public static final String SIMPLE_METADATA_TYPE = "org.eclipse.equinox.p2.metadata.repository.simpleRepository";
    public static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmm");
    static final String FEATURE_GROUP_SUFFIX = ".feature.group";
    static final IArtifactKey[] NO_ARTIFACT_KEYS = new IArtifactKey[0];
    private static final String BUNDLE_ECF_FS_PROVIDER = "org.eclipse.ecf.provider.filetransfer";
    private static final String BUNDLE_EXEMPLARY_SETUP = "org.eclipse.equinox.p2.exemplarysetup";
    private static final String BUNDLE_UPDATESITE = "org.eclipse.equinox.p2.updatesite";
    private static final String BUNDLE_CORE = "org.eclipse.equinox.p2.core";
    private static final String BUNDLE_ENGINE = "org.eclipse.equinox.p2.engine";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final String PROP_P2_DATA_AREA = "eclipse.p2.data.area";
    private static final String PROP_P2_PROFILE = "eclipse.p2.profile";
    private static final Project PROPERTY_REPLACER = new Project();
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HHmm");
    private static final OptionDescriptor optAction;
    private static final OptionDescriptor optBuildModel;
    private static final OptionDescriptor optBuildId;
    private static final OptionDescriptor optBuildRoot;
    private static final OptionDescriptor optProduction;
    private static final OptionDescriptor optMockEmailCc;
    private static final OptionDescriptor optEmailFrom;
    private static final OptionDescriptor optEmailFromName;
    private static final OptionDescriptor optMockEmailTo;
    private static final OptionDescriptor optLogURL;
    private static final OptionDescriptor optSmtpHost;
    private static final OptionDescriptor optSmtpPort;
    private static final OptionDescriptor optSubjectPrefix;
    private Aggregator aggregator;
    private String buildID;
    private String buildLabel;
    private String buildMasterEmail;
    private String buildMasterName;
    private File buildModelLocation;
    private File buildRoot;
    private List<InstallableUnit> categoryIUs;
    private String emailFrom;
    private String emailFromName;
    private String logURL;
    private String mockEmailCC;
    private String mockEmailTo;
    private boolean mirrorReferences = false;
    private Pattern referenceIncludePattern;
    private Pattern referenceExcludePattern;
    private boolean production = false;
    private ResourceSet resourceSet;
    private boolean sendmail = false;
    private String smtpHost;
    private int smtpPort;
    private String subjectPrefix;
    private final Set<IInstallableUnit> unitsToAggregate = new HashSet<IInstallableUnit>();
    private Set<IInstallableUnit> unverifiedUnits;
    private HashMap<MappedRepository, List<VersionedName>> exclusions;
    ActionType action = ActionType.BUILD;
    private CompositeMetadataRepository sourceComposite;
    private String preservedDataArea;
    private String preservedProfile;
    private Map<VersionedName, Version> replacements;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$buckminster$aggregator$engine$Builder$ActionType;

    static {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        PROPERTY_REPLACER.initProperties();
        DATE_FORMAT.setTimeZone(utc);
        TIME_FORMAT.setTimeZone(utc);
        TIMESTAMP_FORMAT.setTimeZone(utc);
        optAction = new OptionDescriptor("action", 3);
        optBuildModel = new OptionDescriptor("buildModel", 3);
        optBuildId = new OptionDescriptor("buildId", 3);
        optBuildRoot = new OptionDescriptor("buildRoot", 3);
        optProduction = new OptionDescriptor("production", 1);
        optMockEmailCc = new OptionDescriptor("mockEmailCc", 3);
        optEmailFrom = new OptionDescriptor("emailFrom", 3);
        optEmailFromName = new OptionDescriptor("emailFromName", 3);
        optMockEmailTo = new OptionDescriptor("mockEmailTo", 3);
        optLogURL = new OptionDescriptor("logURL", 3);
        optSmtpHost = new OptionDescriptor("smtpHost", 3);
        optSmtpPort = new OptionDescriptor("smtpPort", 3);
        optSubjectPrefix = new OptionDescriptor("subjectPrefix", 3);
    }

    public static final java.net.URI createURI(File repoLocation) throws CoreException {
        IPath path;
        if (repoLocation != null && (path = Path.fromOSString((String)repoLocation.getPath())).isAbsolute()) {
            try {
                String pathStr = path.removeTrailingSeparator().toPortableString();
                if (!pathStr.startsWith("/")) {
                    pathStr = "/" + pathStr;
                }
                return new java.net.URI("file", null, pathStr, null);
            }
            catch (URISyntaxException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        throw BuckminsterException.fromMessage((String)"File %s is not an absolute path", (Object[])new Object[]{repoLocation});
    }

    public static String getExceptionMessages(Throwable e) {
        StringBuilder bld = new StringBuilder();
        Builder.getExceptionMessages(e, bld);
        return bld.toString();
    }

    public static IInstallableUnit getIU(IMetadataRepository mdr, String id, String version) {
        InstallableUnitQuery query = (version = Trivial.trim((String)version)) == null ? new InstallableUnitQuery(id) : new InstallableUnitQuery(id, Version.create((String)version));
        Collector c = mdr.query((Query)query, new Collector(), null);
        IInstallableUnit[] result = (IInstallableUnit[])c.toArray(IInstallableUnit.class);
        return result.length > 0 ? result[0] : null;
    }

    private static void deleteAndCheck(File folder, String fileName) throws CoreException {
        File file = new File(folder, fileName);
        file.delete();
        if (file.exists()) {
            throw BuckminsterException.fromMessage((String)"Unable to delete file %s\n", (Object[])new Object[]{file.getAbsolutePath()});
        }
    }

    private static void deleteMetadataRepository(IMetadataRepositoryManager mdrMgr, File repoFolder) throws CoreException {
        java.net.URI repoURI = Builder.createURI(repoFolder);
        mdrMgr.removeRepository(repoURI);
        Builder.deleteAndCheck(repoFolder, "compositeContent.jar");
        Builder.deleteAndCheck(repoFolder, "compositeContent.xml");
        Builder.deleteAndCheck(repoFolder, "content.jar");
        Builder.deleteAndCheck(repoFolder, "content.xml");
    }

    private static synchronized Bundle getBundle(PackageAdmin packageAdmin, String symbolicName) {
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            Bundle bundle = bundles[i];
            if ((bundle.getState() & 3) == 0) {
                return bundle;
            }
            ++i;
        }
        return null;
    }

    private static void getExceptionMessages(Throwable e, StringBuilder bld) {
        bld.append(e.getClass().getName());
        bld.append(": ");
        if (e.getMessage() != null) {
            bld.append(e.getMessage());
        }
        if (e instanceof CoreException) {
            e = ((CoreException)e).getStatus().getException();
        } else {
            Throwable t = e.getCause();
            Throwable throwable = e = t == e ? null : t;
        }
        if (e != null) {
            bld.append("\nCaused by: ");
            Builder.getExceptionMessages(e, bld);
        }
    }

    private static void send(String host, int port, EmailAddress from, List<EmailAddress> toList, EmailAddress cc, String subject, String message) throws IOException {
        MailMessage mailMessage = new MailMessage(host, port);
        mailMessage.from(from.toString());
        for (EmailAddress to : toList) {
            mailMessage.to(to.toString());
        }
        if (cc != null) {
            mailMessage.cc(cc.toString());
        }
        mailMessage.setSubject(subject);
        mailMessage.setHeader("Date", DateUtils.getDateForHeader());
        mailMessage.setHeader("Content-Type", "text/plain; charset=us-ascii");
        PrintStream out = mailMessage.getPrintStream();
        out.print(message);
        mailMessage.sendAndClose();
    }

    private static boolean startEarly(PackageAdmin packageAdmin, String bundleName) throws BundleException {
        Bundle bundle = Builder.getBundle(packageAdmin, bundleName);
        if (bundle == null) {
            return false;
        }
        bundle.start(1);
        return true;
    }

    private static boolean stopBundle(PackageAdmin packageAdmin, String bundleName) throws BundleException {
        Bundle bundle = Builder.getBundle(packageAdmin, bundleName);
        if (bundle == null || bundle.getState() != 32) {
            return false;
        }
        bundle.stop(1);
        return true;
    }

    public void addMappingExclusion(MappedRepository repository, VersionedName versionedName, Version replacement) {
        List<VersionedName> exclInRepo = null;
        if (this.exclusions == null) {
            this.exclusions = new HashMap();
            this.replacements = new HashMap<VersionedName, Version>();
        } else {
            exclInRepo = this.exclusions.get(repository);
        }
        if (exclInRepo == null) {
            exclInRepo = new ArrayList<VersionedName>();
            this.exclusions.put(repository, exclInRepo);
        }
        exclInRepo.add(versionedName);
        this.replacements.put(versionedName, replacement);
    }

    public boolean excludeFromVerification(IInstallableUnit iu) {
        IRequiredCapability[] iRequiredCapabilityArray = iu.getRequiredCapabilities();
        int n = iRequiredCapabilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRequiredCapability rq = iRequiredCapabilityArray[n2];
            if (PDE_TARGET_PLATFORM_NAMESPACE.equals(rq.getNamespace())) {
                if (this.unverifiedUnits == null) {
                    this.unverifiedUnits = new HashSet<IInstallableUnit>();
                }
                this.unverifiedUnits.add(iu);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    public String getBuildID() {
        return this.buildID;
    }

    public File getBuildModelLocation() {
        return this.buildModelLocation;
    }

    public File getBuildRoot() {
        return this.buildRoot;
    }

    public List<InstallableUnit> getCategoryIUs() {
        return this.categoryIUs;
    }

    public Map<VersionedName, Version> getReplacementMap() {
        return this.replacements == null ? Collections.emptyMap() : this.replacements;
    }

    public CompositeMetadataRepository getSourceComposite() {
        return this.sourceComposite;
    }

    public java.net.URI getSourceCompositeURI() throws CoreException {
        return Builder.createURI(new File(this.buildRoot, REPO_FOLDER_INTERIM));
    }

    public File getTempRepositoryFolder() {
        return new File(this.buildRoot, REPO_FOLDER_TEMP);
    }

    public Set<IInstallableUnit> getUnitsToAggregate() {
        return this.unitsToAggregate;
    }

    public Set<IInstallableUnit> getUnverifiedUnits() {
        return this.unverifiedUnits == null ? Collections.emptySet() : this.unverifiedUnits;
    }

    public boolean isCleanBuild() {
        return this.action == ActionType.CLEAN_BUILD;
    }

    public boolean isMapVerbatim(MappedRepository repo) {
        return !repo.isMapExclusive() && !repo.isMirrorArtifacts() && Trivial.trim((String)repo.getCategoryPrefix()) == null && (this.exclusions == null || !this.exclusions.containsKey(repo) || !"p2".equals(repo.getNature()));
    }

    public boolean isMatchedReference(String reference) {
        Matcher m;
        if ((reference = Trivial.trim((String)reference)) == null) {
            return false;
        }
        if (this.referenceIncludePattern != null && !(m = this.referenceIncludePattern.matcher(reference)).matches()) {
            return false;
        }
        return this.referenceExcludePattern == null || !(m = this.referenceExcludePattern.matcher(reference)).matches();
    }

    public boolean isMirrorReferences() {
        return this.mirrorReferences;
    }

    public boolean isProduction() {
        return this.production;
    }

    public boolean isTopLevelCategory(IInstallableUnit iu) {
        return iu != null && "true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.category")) && !"true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.group"));
    }

    public boolean isVerifyOnly() {
        return this.action == ActionType.VERIFY;
    }

    /*
     * Exception decompiling
     */
    public int run(boolean fromIDE, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void sendEmail(Contribution contrib, List<String> errors) {
        boolean useMock;
        boolean bl = useMock = this.mockEmailTo != null;
        if (!this.production && !useMock || !this.sendmail) {
            return;
        }
        Logger log = Buckminster.getLogger();
        try {
            ArrayList<EmailAddress> recipients;
            EmailAddress buildMaster = new EmailAddress(this.buildMasterEmail, this.buildMasterName);
            EmailAddress emailFromAddr = this.emailFrom != null ? new EmailAddress(this.emailFrom, this.emailFromName) : buildMaster;
            ArrayList<EmailAddress> toList = new ArrayList<EmailAddress>();
            if (contrib == null) {
                toList.add(buildMaster);
            } else {
                for (Contact contact : contrib.getContacts()) {
                    toList.add(new EmailAddress(contact.getEmail(), contact.getName()));
                }
            }
            StringBuilder msgBld = new StringBuilder();
            msgBld.append("The following error");
            if (errors.size() > 1) {
                msgBld.append('s');
            }
            msgBld.append(" occured when building ");
            msgBld.append(this.buildLabel);
            msgBld.append(":\n\n");
            for (String error : errors) {
                msgBld.append(error);
                msgBld.append("\n\n");
            }
            if (this.logURL != null) {
                msgBld.append("Check the log file for more information: ");
                msgBld.append(this.logURL);
                msgBld.append('\n');
            }
            if (useMock) {
                msgBld.append("\nThis is a mock mail. Real recipients would have been:\n");
                for (EmailAddress to : toList) {
                    msgBld.append("  ");
                    msgBld.append(to);
                    msgBld.append('\n');
                }
            }
            String msgContent = msgBld.toString();
            if (this.subjectPrefix == null) {
                this.subjectPrefix = this.buildLabel;
            }
            String subject = String.format("[%s] Failed for build %s", this.subjectPrefix, this.buildID);
            msgBld.setLength(0);
            msgBld.append("Sending email to: ");
            for (EmailAddress to : toList) {
                msgBld.append(to);
                msgBld.append(',');
            }
            msgBld.append(buildMaster);
            if (useMock) {
                msgBld.append(" *** Using mock: ");
                if (this.mockEmailTo != null) {
                    msgBld.append(this.mockEmailTo);
                    if (this.mockEmailCC != null) {
                        msgBld.append(',');
                        msgBld.append(this.mockEmailTo);
                    }
                } else {
                    msgBld.append(this.mockEmailCC);
                }
                msgBld.append(" ***");
            }
            log.info(msgBld.toString(), new Object[0]);
            log.info("From: %s", new Object[]{emailFromAddr});
            log.info("Subject: %s", new Object[]{subject});
            log.info("Message content: %s", new Object[]{msgContent});
            EmailAddress ccRecipient = null;
            if (useMock) {
                recipients = this.mockRecipients();
                ccRecipient = this.mockCCRecipient();
            } else {
                recipients = toList;
                if (contrib != null) {
                    ccRecipient = buildMaster;
                }
            }
            Builder.send(this.smtpHost, this.smtpPort, emailFromAddr, recipients, ccRecipient, subject, msgContent);
        }
        catch (IOException e) {
            log.error((Throwable)e, "Failed to send email: %s", new Object[]{e.getMessage()});
        }
    }

    public void setAction(ActionType action) {
        this.action = action;
    }

    public void setBuildID(String buildId) {
        this.buildID = buildId;
    }

    public void setBuildModelLocation(File buildModelLocation) {
        this.buildModelLocation = buildModelLocation;
    }

    public void setBuildRoot(File buildRoot) {
        this.buildRoot = buildRoot;
    }

    public void setCategoryIUs(List<InstallableUnit> categoryIUs) {
        this.categoryIUs = categoryIUs;
    }

    public void setEmailFrom(String emailFrom) {
        this.emailFrom = emailFrom;
    }

    public void setEmailFromName(String emailFromName) {
        this.emailFromName = emailFromName;
    }

    public void setLogLevel(int level) {
        Logger.setConsoleLevelThreshold((int)level);
    }

    public void setLogURL(String logURL) {
        this.logURL = logURL;
    }

    public void setMirrorReferences(boolean mirrorReferences) {
        this.mirrorReferences = mirrorReferences;
    }

    public void setMockEmailCC(String mockEmailCc) {
        this.mockEmailCC = mockEmailCc;
    }

    public void setMockEmailTo(String mockEmailTo) {
        this.mockEmailTo = mockEmailTo;
    }

    public void setProduction(boolean production) {
        this.production = production;
    }

    public void setReferenceExcludePattern(String pattern) {
        this.referenceExcludePattern = (pattern = Trivial.trim((String)pattern)) == null ? null : Pattern.compile(pattern);
    }

    public void setReferenceIncludePattern(String pattern) {
        this.referenceIncludePattern = (pattern = Trivial.trim((String)pattern)) == null ? null : Pattern.compile(pattern);
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public void setSourceComposite(CompositeMetadataRepository sourceComposite) {
        this.sourceComposite = sourceComposite;
    }

    public void setSubjectPrefix(String subjectPrefix) {
        this.subjectPrefix = subjectPrefix;
    }

    public Object start(IApplicationContext context) throws Exception {
        String logLevel = null;
        int pos = 0;
        String[] args = (String[])context.getArguments().get("application.args");
        int idx = 1;
        while (idx < args.length) {
            if (("-loglevel".equalsIgnoreCase(args[idx]) || "--loglevel".equalsIgnoreCase(args[idx])) && idx + 1 < args.length) {
                logLevel = args[idx + 1];
                pos = 2;
            }
            ++idx;
        }
        String[] allArgs = new String[args.length + pos + 1];
        if (logLevel != null) {
            allArgs[0] = "--loglevel";
            allArgs[1] = logLevel;
        }
        allArgs[pos++] = REPO_FOLDER_AGGREGATE;
        System.arraycopy(args, 0, allArgs, pos, args.length);
        ArrayList<OptionDescriptor> opts = new ArrayList<OptionDescriptor>();
        this.getOptionDescriptors(opts);
        while (pos < allArgs.length) {
            String arg = allArgs[pos];
            if (arg.length() > 2 && arg.charAt(0) == '-' && arg.charAt(1) != '-') {
                arg = arg.substring(1);
                for (OptionDescriptor opt : opts) {
                    if (!opt.getLongName().equalsIgnoreCase(arg)) continue;
                    allArgs[pos] = "--" + arg;
                    break;
                }
            }
            ++pos;
        }
        context.getArguments().put("application.args", allArgs);
        Headless headless = new Headless();
        return headless.start(context);
    }

    public void stop() {
    }

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        super.getOptionDescriptors(appendHere);
        appendHere.add(optAction);
        appendHere.add(optBuildId);
        appendHere.add(optBuildModel);
        appendHere.add(optBuildRoot);
        appendHere.add(optProduction);
        appendHere.add(optMockEmailCc);
        appendHere.add(optEmailFrom);
        appendHere.add(optEmailFromName);
        appendHere.add(optMockEmailTo);
        appendHere.add(optLogURL);
        appendHere.add(optSmtpHost);
        appendHere.add(optSmtpPort);
        appendHere.add(optSubjectPrefix);
    }

    protected void handleOption(Option option) throws Exception {
        if (option.is(optAction)) {
            this.action = ActionType.valueOf(option.getValue().toUpperCase());
        } else if (option.is(optBuildId)) {
            this.setBuildID(option.getValue());
        } else if (option.is(optBuildModel)) {
            File buildModel = new File(option.getValue());
            if (!buildModel.canRead()) {
                throw new IllegalArgumentException(String.format("Unable to read %s", buildModel));
            }
            this.setBuildModelLocation(buildModel);
        } else if (option.is(optBuildRoot)) {
            this.setBuildRoot(new File(option.getValue()));
        } else if (option.is(optEmailFrom)) {
            this.setEmailFrom(option.getValue());
        } else if (option.is(optEmailFromName)) {
            this.setEmailFromName(option.getValue());
        } else if (option.is(optLogURL)) {
            this.setLogURL(option.getValue());
        } else if (option.is(optMockEmailCc)) {
            this.setMockEmailCC(option.getValue());
        } else if (option.is(optMockEmailTo)) {
            this.setMockEmailTo(option.getValue());
        } else if (option.is(optProduction)) {
            this.setProduction(true);
        } else if (option.is(optSmtpHost)) {
            this.setSmtpHost(option.getValue());
        } else if (option.is(optSmtpPort)) {
            this.setSmtpPort(Integer.parseInt(option.getValue()));
        } else if (option.is(optSubjectPrefix)) {
            this.setSubjectPrefix(option.getValue());
        } else {
            super.handleOption(option);
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        if (unparsed.length > 0) {
            throw new UsageException("too many arguments");
        }
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        if (this.buildModelLocation == null) {
            throw new UsageException("Missing required argument --buildModel <path to model>");
        }
        return this.run(false, monitor);
    }

    private void cleanAll() throws CoreException {
        this.cleanMetadata();
        Buckminster bucky = Buckminster.getDefault();
        IArtifactRepositoryManager arMgr = (IArtifactRepositoryManager)bucky.getService(IArtifactRepositoryManager.class);
        try {
            File destination = new File(this.buildRoot, REPO_FOLDER_FINAL);
            arMgr.removeRepository(Builder.createURI(destination));
            arMgr.removeRepository(Builder.createURI(new File(destination, REPO_FOLDER_AGGREGATE)));
        }
        finally {
            bucky.ungetService((Object)arMgr);
        }
        if (this.buildRoot.exists()) {
            FileUtils.deleteAll((File)this.buildRoot);
            if (this.buildRoot.exists()) {
                throw BuckminsterException.fromMessage((String)"Failed to delete folder %s", (Object[])new Object[]{this.buildRoot.getAbsolutePath()});
            }
        }
    }

    private void cleanMetadata() throws CoreException {
        Buckminster bucky = Buckminster.getDefault();
        IMetadataRepositoryManager mdrMgr = (IMetadataRepositoryManager)bucky.getService(IMetadataRepositoryManager.class);
        try {
            File finalRepo = new File(this.buildRoot, REPO_FOLDER_FINAL);
            Builder.deleteMetadataRepository(mdrMgr, finalRepo);
            Builder.deleteMetadataRepository(mdrMgr, new File(finalRepo, REPO_FOLDER_AGGREGATE));
            File interimRepo = new File(this.buildRoot, REPO_FOLDER_INTERIM);
            Builder.deleteMetadataRepository(mdrMgr, interimRepo);
            Builder.deleteMetadataRepository(mdrMgr, new File(interimRepo, REPO_FOLDER_VERIFICATION));
        }
        finally {
            bucky.ungetService((Object)mdrMgr);
        }
    }

    private EmailAddress mockCCRecipient() throws UnsupportedEncodingException {
        EmailAddress mock = null;
        if (this.mockEmailCC != null) {
            mock = new EmailAddress(this.mockEmailCC, null);
        }
        return mock;
    }

    private List<EmailAddress> mockRecipients() throws UnsupportedEncodingException {
        if (this.mockEmailTo != null) {
            return Collections.singletonList(new EmailAddress(this.mockEmailTo, null));
        }
        return Collections.emptyList();
    }

    private void restartP2Bundles() throws CoreException {
        Buckminster bucky = Buckminster.getDefault();
        PackageAdmin packageAdmin = (PackageAdmin)bucky.getService(PackageAdmin.class);
        try {
            try {
                Builder.stopBundle(packageAdmin, BUNDLE_EXEMPLARY_SETUP);
                Builder.stopBundle(packageAdmin, BUNDLE_ENGINE);
                Builder.stopBundle(packageAdmin, BUNDLE_CORE);
                String p2DataArea = new File(this.buildRoot, "p2").toString();
                this.preservedDataArea = System.setProperty(PROP_P2_DATA_AREA, p2DataArea);
                this.preservedProfile = System.setProperty(PROP_P2_PROFILE, PROFILE_ID);
                if (!Builder.startEarly(packageAdmin, BUNDLE_ECF_FS_PROVIDER)) {
                    throw BuckminsterException.fromMessage((String)"Missing bundle %s", (Object[])new Object[]{BUNDLE_ECF_FS_PROVIDER});
                }
                if (!Builder.startEarly(packageAdmin, BUNDLE_CORE)) {
                    throw BuckminsterException.fromMessage((String)"Missing bundle %s", (Object[])new Object[]{BUNDLE_CORE});
                }
                if (!Builder.startEarly(packageAdmin, BUNDLE_ENGINE)) {
                    throw BuckminsterException.fromMessage((String)"Missing bundle %s", (Object[])new Object[]{BUNDLE_ENGINE});
                }
                if (!Builder.startEarly(packageAdmin, BUNDLE_EXEMPLARY_SETUP)) {
                    throw BuckminsterException.fromMessage((String)"Missing bundle %s", (Object[])new Object[]{BUNDLE_EXEMPLARY_SETUP});
                }
                if (!Builder.startEarly(packageAdmin, BUNDLE_UPDATESITE)) {
                    throw BuckminsterException.fromMessage((String)"Missing bundle %s", (Object[])new Object[]{BUNDLE_UPDATESITE});
                }
            }
            catch (BundleException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        finally {
            bucky.ungetService((Object)packageAdmin);
        }
    }

    private void restoreP2Bundles() throws CoreException {
        Buckminster bucky = Buckminster.getDefault();
        PackageAdmin packageAdmin = (PackageAdmin)bucky.getService(PackageAdmin.class);
        try {
            try {
                Builder.stopBundle(packageAdmin, BUNDLE_EXEMPLARY_SETUP);
                Builder.stopBundle(packageAdmin, BUNDLE_ENGINE);
                Builder.stopBundle(packageAdmin, BUNDLE_CORE);
                if (this.preservedDataArea == null) {
                    System.clearProperty(PROP_P2_DATA_AREA);
                } else {
                    System.setProperty(PROP_P2_DATA_AREA, this.preservedDataArea);
                }
                if (this.preservedProfile == null) {
                    System.clearProperty(PROP_P2_PROFILE);
                } else {
                    System.setProperty(PROP_P2_PROFILE, this.preservedProfile);
                }
                Builder.startEarly(packageAdmin, BUNDLE_CORE);
                Builder.startEarly(packageAdmin, BUNDLE_ENGINE);
                Builder.startEarly(packageAdmin, BUNDLE_EXEMPLARY_SETUP);
            }
            catch (BundleException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        finally {
            bucky.ungetService((Object)packageAdmin);
        }
    }

    private void runCategoriesRepoGenerator(IProgressMonitor monitor) throws CoreException {
        CategoriesGenerator generator = new CategoriesGenerator(this);
        generator.run(monitor);
    }

    private void runCompositeGenerator(IProgressMonitor monitor) throws CoreException {
        SourceCompositeGenerator generator = new SourceCompositeGenerator(this);
        generator.run(monitor);
    }

    private void runMirroring(IProgressMonitor monitor) throws CoreException {
        MirrorGenerator generator = new MirrorGenerator(this);
        generator.run(monitor);
    }

    private void runRepositoryVerifier(IProgressMonitor monitor) throws CoreException {
        RepositoryVerifier ipt = new RepositoryVerifier(this);
        ipt.run(monitor);
    }

    private void runTransformation(Date now) throws CoreException {
        try {
            this.resourceSet = new ResourceSetImpl();
            URI fileURI = URI.createFileURI((String)this.buildModelLocation.getAbsolutePath());
            Resource resource = this.resourceSet.getResource(fileURI, true);
            EList content = resource.getContents();
            if (content.size() != 1) {
                throw BuckminsterException.fromMessage((String)"ECore Resource did not contain one resource. It had %d", (Object[])new Object[]{content.size()});
            }
            this.aggregator = (Aggregator)content.get(0);
            Diagnostic diag = Diagnostician.INSTANCE.validate((EObject)this.aggregator);
            if (diag.getSeverity() == 4) {
                Logger log = Buckminster.getLogger();
                for (Diagnostic childDiag : diag.getChildren()) {
                    log.error(childDiag.getMessage(), new Object[0]);
                }
                throw BuckminsterException.fromMessage((String)"Build model validation failed: %s", (Object[])new Object[]{diag.getMessage()});
            }
            if (this.buildRoot == null) {
                this.setBuildRoot(new File(PROPERTY_REPLACER.replaceProperties(this.aggregator.getBuildRoot())));
            }
            if (!this.buildRoot.isAbsolute()) {
                this.buildRoot = new File(this.buildModelLocation.getParent(), this.buildRoot.getPath());
            }
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    private void runVerificationFeatureGenerator(IProgressMonitor monitor) throws CoreException {
        VerificationFeatureGenerator generator = new VerificationFeatureGenerator(this);
        generator.run(monitor);
    }

    private void verifyContributions() throws CoreException {
        Element masterBuild;
        DocumentBuilder docBld;
        java.net.URI buildModelFolderURI = this.buildModelLocation.getParentFile().toURI();
        DocumentBuilderFactory docBldFact = DocumentBuilderFactory.newInstance();
        try {
            docBld = docBldFact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            Document doc = docBld.parse(this.buildModelLocation);
            masterBuild = doc.getDocumentElement();
            this.sendmail = "true".equalsIgnoreCase(masterBuild.getAttribute("sendmail"));
            this.buildLabel = Trivial.trim((String)masterBuild.getAttribute("label"));
        }
        catch (Exception e) {
            String msg = e instanceof SAXParseException ? String.format("Unable to parse file: %s: Error at line %s: %s", this.buildModelLocation, ((SAXParseException)e).getLineNumber(), e.getMessage()) : String.format("Unable to parse file: %s: %s", this.buildModelLocation, e.getMessage());
            throw BuckminsterException.fromMessage((String)msg, (Object[])new Object[0]);
        }
        ArrayList<File> contributionFiles = new ArrayList<File>();
        Node child = masterBuild.getFirstChild();
        while (child != null) {
            block17: {
                Element elem;
                block18: {
                    if (!(child instanceof Element)) break block17;
                    elem = (Element)child;
                    if (!"contributions".equals(elem.getNodeName())) break block18;
                    String attr = Trivial.trim((String)elem.getAttribute("href"));
                    if (attr == null) break block17;
                    if (attr.endsWith("#/")) {
                        attr = attr.substring(0, attr.length() - 2);
                    }
                    java.net.URI uri = buildModelFolderURI.resolve(java.net.URI.create(attr));
                    contributionFiles.add(new File(uri));
                }
                if ("buildmaster".equals(elem.getNodeName())) {
                    this.buildMasterEmail = Trivial.trim((String)elem.getAttribute("email"));
                    this.buildMasterName = Trivial.trim((String)elem.getAttribute("name"));
                }
            }
            child = child.getNextSibling();
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (File buildFile : contributionFiles) {
            try {
                try {
                    docBld.parse(buildFile);
                }
                catch (Exception e) {
                    String msg = e instanceof SAXParseException ? String.format("Unable to parse file: %s: Error at line %s: %s", buildFile, ((SAXParseException)e).getLineNumber(), e.getMessage()) : String.format("Unable to parse file: %s: %s", buildFile, e.getMessage());
                    Buckminster.getLogger().error((Throwable)e, msg, new Object[0]);
                    errors.add(msg);
                    docBld.reset();
                    continue;
                }
            }
            catch (Throwable throwable) {
                docBld.reset();
                throw throwable;
            }
            docBld.reset();
        }
        if (errors.size() > 0) {
            this.sendEmail(null, errors);
            throw BuckminsterException.fromMessage((String)"Not all contributions could be parsed", (Object[])new Object[0]);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$buckminster$aggregator$engine$Builder$ActionType() {
        if ($SWITCH_TABLE$org$eclipse$buckminster$aggregator$engine$Builder$ActionType != null) {
            return $SWITCH_TABLE$org$eclipse$buckminster$aggregator$engine$Builder$ActionType;
        }
        int[] nArray = new int[ActionType.values().length];
        try {
            nArray[ActionType.BUILD.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActionType.CLEAN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActionType.CLEAN_BUILD.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActionType.VERIFY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$buckminster$aggregator$engine$Builder$ActionType = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActionType {
        CLEAN,
        VERIFY,
        BUILD,
        CLEAN_BUILD;

    }

    private static class EmailAddress {
        private final String address;
        private final String personal;

        EmailAddress(String address, String personal) {
            this.address = address;
            this.personal = personal;
        }

        public String toString() {
            if (this.personal == null) {
                return this.address;
            }
            return String.valueOf(this.personal) + " <" + this.address + ">";
        }
    }
}

