/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.aggregator.Aggregator;
import org.eclipse.buckminster.aggregator.Category;
import org.eclipse.buckminster.aggregator.Contribution;
import org.eclipse.buckminster.aggregator.CustomCategory;
import org.eclipse.buckminster.aggregator.ExclusionRule;
import org.eclipse.buckminster.aggregator.Feature;
import org.eclipse.buckminster.aggregator.MapRule;
import org.eclipse.buckminster.aggregator.MappedRepository;
import org.eclipse.buckminster.aggregator.engine.Builder;
import org.eclipse.buckminster.aggregator.engine.BuilderPhase;
import org.eclipse.buckminster.aggregator.engine.VersionSuffixGenerator;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.aggregator.p2.MetadataRepository;
import org.eclipse.buckminster.aggregator.p2.P2Factory;
import org.eclipse.buckminster.aggregator.p2.RequiredCapability;
import org.eclipse.buckminster.aggregator.p2.impl.InstallableUnitImpl;
import org.eclipse.buckminster.aggregator.p2.impl.ProvidedCapabilityImpl;
import org.eclipse.buckminster.aggregator.p2.impl.RequiredCapabilityImpl;
import org.eclipse.buckminster.aggregator.util.TimeUtils;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.core.VersionedName;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoriesGenerator
extends BuilderPhase {
    private static void assignCategoryVersion(InstallableUnitImpl category) {
        ArrayList<VersionedName> includedBundles = new ArrayList<VersionedName>();
        ArrayList<VersionedName> includedFeatures = new ArrayList<VersionedName>();
        for (RequiredCapability cap : category.getRequiredCapabilityList()) {
            VersionRange range = cap.getRange();
            Version version = range == null ? Version.emptyVersion : range.getMinimum();
            VersionedName vn = new VersionedName(cap.getName(), version);
            if (cap.getName().endsWith(".feature.group")) {
                includedFeatures.add(vn);
                continue;
            }
            includedBundles.add(vn);
        }
        VersionSuffixGenerator suffixGen = new VersionSuffixGenerator();
        Version catVersion = Version.createOSGi((int)0, (int)0, (int)0, (String)suffixGen.generateSuffix(includedFeatures, includedBundles));
        category.setVersion(catVersion);
        EList providedCaps = category.getProvidedCapabilityList();
        providedCaps.clear();
        ProvidedCapabilityImpl providedCap = (ProvidedCapabilityImpl)P2Factory.eINSTANCE.createProvidedCapability();
        providedCap.setName(category.getId());
        providedCap.setNamespace("org.eclipse.equinox.p2.iu");
        providedCap.setVersion(catVersion);
        providedCaps.add(providedCap);
    }

    public CategoriesGenerator(Builder builder) {
        super(builder);
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        Logger log = Buckminster.getLogger();
        long start = TimeUtils.getNow();
        MonitorUtils.begin((IProgressMonitor)monitor, (int)10);
        String info = "Starting generation of categories";
        MonitorUtils.subTask((IProgressMonitor)monitor, (String)info);
        log.info(info, new Object[0]);
        try {
            List<InstallableUnit> results = new ArrayList<InstallableUnit>();
            Aggregator aggregator = this.getBuilder().getAggregator();
            for (CustomCategory category : aggregator.getCustomCategories()) {
                results.add(this.createCategoryIU(category));
            }
            MonitorUtils.worked((IProgressMonitor)monitor, (int)5);
            for (Contribution contrib : aggregator.getContributions(true)) {
                for (MappedRepository repo : contrib.getRepositories(true)) {
                    results.addAll(this.getRepositoryCategories(repo));
                }
            }
            results = this.normalizeCategories(results);
            this.getBuilder().setCategoryIUs(results);
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
        log.info("Done. Took %s", new Object[]{TimeUtils.getFormattedDuration((long)start)});
    }

    private InstallableUnit createCategoryIU(CustomCategory category) {
        P2Factory factory = P2Factory.eINSTANCE;
        InstallableUnitImpl cat = (InstallableUnitImpl)factory.createInstallableUnit();
        cat.setSingleton(true);
        String categoryId = category.getIdentifier();
        cat.setId(categoryId);
        Map props = cat.getPropertyMap().map();
        props.put("org.eclipse.equinox.p2.name", category.getLabel());
        props.put("org.eclipse.equinox.p2.description", category.getDescription());
        props.put("org.eclipse.equinox.p2.type.category", "true");
        EList features = category.getFeatures();
        EList rcs = cat.getRequiredCapabilityList();
        ArrayList<VersionedName> includedBundles = new ArrayList<VersionedName>();
        ArrayList<VersionedName> includedFeatures = new ArrayList<VersionedName>();
        for (Feature feature : features) {
            if (!feature.isBranchEnabled()) continue;
            InstallableUnit iu = feature.getInstallableUnit();
            RequiredCapabilityImpl rc = (RequiredCapabilityImpl)factory.createRequiredCapability();
            rc.setFilter(iu.getFilter());
            rc.setName(iu.getId());
            rc.setNamespace("org.eclipse.equinox.p2.iu");
            rc.setRange(new VersionRange(iu.getVersion(), true, iu.getVersion(), true));
            rcs.add(rc);
            VersionedName vn = new VersionedName(iu.getId(), iu.getVersion());
            if (iu.getId().endsWith(".feature.group")) {
                includedFeatures.add(vn);
                continue;
            }
            includedBundles.add(vn);
        }
        ProvidedCapabilityImpl pc = (ProvidedCapabilityImpl)factory.createProvidedCapability();
        pc.setName(categoryId);
        pc.setNamespace("org.eclipse.equinox.p2.iu");
        VersionSuffixGenerator suffixGen = new VersionSuffixGenerator();
        Version catVersion = Version.createOSGi((int)0, (int)0, (int)0, (String)suffixGen.generateSuffix(includedFeatures, includedBundles));
        pc.setVersion(catVersion);
        cat.setVersion(catVersion);
        cat.getProvidedCapabilityList().add((Object)pc);
        return cat;
    }

    private List<InstallableUnit> getRepositoryCategories(MappedRepository repo) {
        Builder builder = this.getBuilder();
        ArrayList<InstallableUnit> categoryIUs = new ArrayList<InstallableUnit>();
        if (repo.isMapExclusive()) {
            for (Category category : repo.getCategories()) {
                Iterator iu;
                if (!category.isEnabled() || !builder.isTopLevelCategory((IInstallableUnit)(iu = category.getInstallableUnit()))) continue;
                categoryIUs.add((InstallableUnit)iu);
            }
        } else {
            EList mapRules = repo.getMapRules();
            block1: for (InstallableUnit iu : repo.getMetadataRepository().getInstallableUnits()) {
                if (!builder.isTopLevelCategory((IInstallableUnit)iu)) continue;
                for (MapRule mapRule : mapRules) {
                    if (mapRule instanceof ExclusionRule && mapRule.getInstallableUnit() == iu) continue block1;
                }
                categoryIUs.add(iu);
            }
        }
        String categoryPrefix = Trivial.trim((String)repo.getCategoryPrefix());
        if (categoryPrefix != null) {
            String idSuffix = this.makeValidIUSuffix(categoryPrefix);
            StringBuilder prefixConcat = new StringBuilder();
            prefixConcat.append(categoryPrefix);
            prefixConcat.append(' ');
            int prefixLen = prefixConcat.length();
            int idx = categoryIUs.size();
            while (--idx >= 0) {
                InstallableUnit iu = categoryIUs.get(idx);
                InstallableUnitImpl renamedIU = (InstallableUnitImpl)InstallableUnitImpl.importToModel((IInstallableUnit)iu);
                prefixConcat.setLength(prefixLen);
                prefixConcat.append(iu.getProperty("org.eclipse.equinox.p2.name"));
                renamedIU.getPropertyMap().map().put("org.eclipse.equinox.p2.name", prefixConcat.toString());
                renamedIU.setId(String.valueOf(iu.getId()) + idSuffix);
                CategoriesGenerator.assignCategoryVersion(renamedIU);
                categoryIUs.set(idx, (InstallableUnit)renamedIU);
            }
        }
        return categoryIUs;
    }

    private String makeValidIUSuffix(String categoryPrefix) {
        int top = categoryPrefix.length();
        StringBuilder bld = new StringBuilder(top);
        int idx = 0;
        while (idx < top) {
            char c = categoryPrefix.charAt(idx);
            if (c >= 'A' && c <= 'Z') {
                bld.append(c + 32);
            } else if (c == '-' || c == '.' || c == '_' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z') {
                bld.append(c);
            } else if (c == ' ') {
                bld.append('_');
            }
            ++idx;
        }
        return bld.toString();
    }

    private List<InstallableUnit> normalizeCategories(List<InstallableUnit> categoryIUs) {
        Map<VersionedName, Version> replacementMap = this.getBuilder().getReplacementMap();
        HashMap map = new HashMap();
        HashMap<String, InstallableUnit> catMap = new HashMap<String, InstallableUnit>();
        for (InstallableUnit category : categoryIUs) {
            String name = category.getProperty("org.eclipse.equinox.p2.name");
            ArrayList<RequiredCapability> caps = (ArrayList<RequiredCapability>)map.get(name);
            if (caps == null) {
                caps = new ArrayList<RequiredCapability>();
                map.put(name, caps);
            }
            for (RequiredCapability cap : category.getRequiredCapabilityList()) {
                VersionedName vn;
                VersionRange range = cap.getRange();
                if (range != null && range.getMinimum().equals((Object)range.getMaximum()) && replacementMap.containsKey(vn = new VersionedName(cap.getName(), range.getMinimum()))) {
                    Version replacement = replacementMap.get(vn);
                    if (replacement == null) continue;
                    RequiredCapabilityImpl newRq = (RequiredCapabilityImpl)InstallableUnitImpl.importToModel((IRequiredCapability)cap);
                    newRq.setRange(new VersionRange(replacement, true, replacement, true));
                    cap = newRq;
                }
                caps.add(cap);
            }
            InstallableUnit oldCat = catMap.put(name, category);
            if (oldCat == null) continue;
            String oldDesc = oldCat.getProperty("org.eclipse.equinox.p2.description");
            if (oldDesc == null) {
                this.tossCategory(oldCat);
                continue;
            }
            String newDesc = category.getProperty("org.eclipse.equinox.p2.description");
            if (newDesc == null || newDesc.length() < oldDesc.length()) {
                this.tossCategory(category);
                catMap.put(name, oldCat);
                continue;
            }
            if (category.getVersion().compareTo((Object)oldCat.getVersion()) <= 0) continue;
            this.tossCategory(oldCat);
        }
        ArrayList<InstallableUnit> normalized = new ArrayList<InstallableUnit>();
        for (InstallableUnit category : catMap.values()) {
            String name = category.getProperty("org.eclipse.equinox.p2.name");
            List newCaps = (List)map.get(name);
            EList origCaps = category.getRequiredCapabilityList();
            if (origCaps.size() == newCaps.size() && origCaps.containsAll(newCaps)) {
                normalized.add(category);
                continue;
            }
            InstallableUnitImpl newCategory = (InstallableUnitImpl)P2Factory.eINSTANCE.createInstallableUnit();
            newCategory.setId(category.getId());
            newCategory.getPropertyMap().addAll((Collection)category.getPropertyMap());
            newCategory.getRequiredCapabilityList().addAll((Collection)newCaps);
            CategoriesGenerator.assignCategoryVersion(newCategory);
            this.tossCategory(category);
            normalized.add((InstallableUnit)newCategory);
        }
        return normalized;
    }

    private void tossCategory(InstallableUnit category) {
        Logger log = Buckminster.getLogger();
        MetadataRepository parent = (MetadataRepository)((EObject)category).eContainer();
        Builder builder = this.getBuilder();
        for (Contribution contrib : builder.getAggregator().getContributions(true)) {
            for (MappedRepository mappedRepo : contrib.getRepositories(true)) {
                if (mappedRepo.getMetadataRepository() != parent || !builder.isMapVerbatim(mappedRepo)) continue;
                log.debug("Excluding %s from verbatim mapping since category %s has been normalized", new Object[]{mappedRepo.getLocation(), category.getProperty("org.eclipse.equinox.p2.name")});
                builder.addMappingExclusion(mappedRepo, new VersionedName(category.getId(), category.getVersion()), null);
            }
        }
    }
}

