/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.engine;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.aggregator.Aggregator;
import org.eclipse.buckminster.aggregator.Contribution;
import org.eclipse.buckminster.aggregator.MappedRepository;
import org.eclipse.buckminster.aggregator.MetadataRepositoryReference;
import org.eclipse.buckminster.aggregator.PackedStrategy;
import org.eclipse.buckminster.aggregator.engine.Builder;
import org.eclipse.buckminster.aggregator.engine.BuilderPhase;
import org.eclipse.buckminster.aggregator.engine.maven.InstallableUnitMapping;
import org.eclipse.buckminster.aggregator.engine.maven.MavenManager;
import org.eclipse.buckminster.aggregator.engine.maven.MavenRepositoryHelper;
import org.eclipse.buckminster.aggregator.engine.maven.indexer.IMaven2Indexer;
import org.eclipse.buckminster.aggregator.engine.maven.indexer.IndexerUtils;
import org.eclipse.buckminster.aggregator.loader.IRepositoryLoader;
import org.eclipse.buckminster.aggregator.p2.ArtifactKey;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.aggregator.p2.MetadataRepository;
import org.eclipse.buckminster.aggregator.p2.RepositoryReference;
import org.eclipse.buckminster.aggregator.util.GeneralUtils;
import org.eclipse.buckminster.aggregator.util.RepositoryLoaderUtils;
import org.eclipse.buckminster.aggregator.util.ResourceUtils;
import org.eclipse.buckminster.aggregator.util.TimeUtils;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.RawMirrorRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.MatchQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MirrorGenerator
extends BuilderPhase {
    private IMetadataRepositoryManager mdrMgr = null;
    private IArtifactRepositoryManager arMgr = null;
    private Map<MetadataRepositoryReference, IArtifactRepository> arCache;

    static IArtifactDescriptor mirror(IArtifactRepository source, IArtifactRepository dest, IArtifactDescriptor sourceDesc, IArtifactDescriptor targetDesc, IProgressMonitor monitor) throws CoreException {
        if (dest.contains(targetDesc)) {
            return targetDesc;
        }
        RawMirrorRequest request = new RawMirrorRequest(sourceDesc, targetDesc, dest);
        request.setSourceRepository(source);
        request.perform(monitor);
        IStatus result = request.getResult();
        switch (result.getSeverity()) {
            case 1: {
                Buckminster.getLogger().info(result.getMessage(), new Object[0]);
            }
            case 0: {
                if (MirrorGenerator.getArtifactDescriptor(dest, targetDesc.getArtifactKey(), MirrorGenerator.isPacked(targetDesc)) != null) {
                    return targetDesc;
                }
                result = new Status(4, "org.eclipse.buckminster.aggregator.engine", "Zero bytes copied");
                break;
            }
            case 8: {
                Buckminster.getLogger().warning("Aggregation cancelled while mirroring artifact %s", new Object[]{sourceDesc.getArtifactKey()});
                throw new OperationCanceledException();
            }
            default: {
                if (result.getCode() == 1201) {
                    Buckminster.getLogger().warning("  copy failed. Artifact %s is already present", new Object[]{sourceDesc.getArtifactKey()});
                    return targetDesc;
                }
                result = MirrorGenerator.extractRootCause(result);
            }
        }
        throw BuckminsterException.fromMessage((Throwable)result.getException(), (String)"Unable to mirror artifact %s from repository %s: %s", (Object[])new Object[]{sourceDesc.getArtifactKey(), source.getLocation(), result.getMessage()});
    }

    static void mirror(List<ArtifactKey> keysToInstall, IArtifactRepository cache, IArtifactRepository source, IArtifactRepository dest, PackedStrategy strategy, List<String> errors, IProgressMonitor monitor) {
        Logger log = Buckminster.getLogger();
        IArtifactKey[] keys = source.getArtifactKeys();
        MonitorUtils.begin((IProgressMonitor)monitor, (int)(keys.length * 100));
        int numCandidates = keysToInstall.size();
        IArtifactKey[] iArtifactKeyArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactKey key = iArtifactKeyArray[n2];
            boolean found = false;
            int idx = 0;
            while (idx < numCandidates) {
                if (keysToInstall.get(idx).equals(key)) {
                    found = true;
                    break;
                }
                ++idx;
            }
            if (found) {
                log.info("- mirroring artifact %s", new Object[]{key});
                IArtifactRepository sourceForCopy = cache != null && cache.contains(key) ? cache : source;
                PackedStrategy keyStrategy = !"osgi.bundle".equals(key.getClassifier()) ? PackedStrategy.SKIP : strategy;
                try {
                    IArtifactDescriptor[] aDescs = sourceForCopy.getArtifactDescriptors(key);
                    IArtifactDescriptor optimized = null;
                    IArtifactDescriptor canonical = null;
                    IArtifactDescriptor[] iArtifactDescriptorArray = aDescs;
                    int n3 = aDescs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IArtifactDescriptor desc = iArtifactDescriptorArray[n4];
                        if (MirrorGenerator.isPacked(desc)) {
                            optimized = desc;
                        } else {
                            canonical = desc;
                        }
                        ++n4;
                    }
                    if (optimized == null && canonical == null) {
                        throw BuckminsterException.fromMessage((String)"Found no usable descriptor for artifact %s in repository %s", (Object[])new Object[]{key, dest.getLocation()});
                    }
                    if (keyStrategy == PackedStrategy.SKIP && canonical == null) {
                        log.warning("    canonical artifact unavailable, using optimized one instead", new Object[0]);
                        keyStrategy = PackedStrategy.COPY;
                    } else if (keyStrategy != PackedStrategy.SKIP && optimized == null) {
                        keyStrategy = PackedStrategy.SKIP;
                    }
                    switch (keyStrategy) {
                        case SKIP: {
                            if (!MirrorGenerator.checkIfTargetPresent(dest, key, false)) {
                                log.debug("    doing copy of canonical artifact", new Object[0]);
                                MirrorGenerator.mirror(sourceForCopy, dest, canonical, MirrorGenerator.createDestinationDescriptor(key, false), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                            }
                            break;
                        }
                        case COPY: {
                            if (!MirrorGenerator.checkIfTargetPresent(dest, key, true)) {
                                log.debug("    doing copy of optimized artifact", new Object[0]);
                                MirrorGenerator.mirror(sourceForCopy, dest, optimized, MirrorGenerator.createDestinationDescriptor(key, true), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                            }
                            break;
                        }
                        default: {
                            boolean isVerify;
                            if (keyStrategy == PackedStrategy.UNPACK) {
                                if (!MirrorGenerator.checkIfTargetPresent(dest, key, false)) {
                                    log.debug("    doing copy of optimized artifact into canonical target", new Object[0]);
                                    MirrorGenerator.unpack(sourceForCopy, dest, optimized, MirrorGenerator.createDestinationDescriptor(key, false), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                                }
                                break;
                            }
                            boolean bl = isVerify = keyStrategy == PackedStrategy.VERIFY;
                            if (MirrorGenerator.checkIfTargetPresent(dest, key, true)) {
                                if (isVerify) {
                                    break;
                                }
                            } else {
                                log.debug("    doing copy of optimized artifact", new Object[0]);
                                MirrorGenerator.mirror(sourceForCopy, dest, optimized, MirrorGenerator.createDestinationDescriptor(key, true), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)70));
                            }
                            if (isVerify) {
                                log.debug("    unpacking optimized artifact for verification", new Object[0]);
                            } else {
                                if (MirrorGenerator.checkIfTargetPresent(dest, key, false)) break;
                                log.debug("    unpacking optimized artifact", new Object[0]);
                            }
                            MirrorGenerator.unpackToSibling(dest, MirrorGenerator.getArtifactDescriptor(dest, key, true), MirrorGenerator.createDestinationDescriptor(key, false), isVerify, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                            break;
                        }
                    }
                }
                catch (CoreException e) {
                    errors.add(Builder.getExceptionMessages(e));
                    dest.removeDescriptor(key);
                    Buckminster.getLogger().error((Throwable)e, e.getMessage(), new Object[0]);
                }
            }
            ++n2;
        }
        MonitorUtils.done((IProgressMonitor)monitor);
    }

    private static boolean checkIfTargetPresent(IArtifactRepository destination, IArtifactKey key, boolean packed) {
        IArtifactDescriptor found = MirrorGenerator.getArtifactDescriptor(destination, key, packed);
        if (found != null) {
            Buckminster.getLogger().debug("    %s artifact is already present", new Object[]{packed ? "optimized" : "canonical"});
            return true;
        }
        return false;
    }

    private static IArtifactDescriptor createDestinationDescriptor(IArtifactKey key, boolean optimized) {
        ArtifactDescriptor desc = new ArtifactDescriptor(key);
        if (optimized) {
            desc.setProperty("format", "packed");
            desc.setProcessingSteps(new ProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)});
        }
        return desc;
    }

    private static IStatus extractDeeperRootCause(IStatus status) {
        IStatus deeper;
        Throwable t;
        if (status == null) {
            return null;
        }
        if (status.isMultiStatus()) {
            IStatus[] children = ((MultiStatus)status).getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus deeper2 = MirrorGenerator.extractDeeperRootCause(children[i]);
                if (deeper2 != null) {
                    return deeper2;
                }
                ++i;
            }
        }
        if ((t = status.getException()) instanceof CoreException && (deeper = MirrorGenerator.extractDeeperRootCause(((CoreException)t).getStatus())) != null) {
            return deeper;
        }
        return status.getSeverity() == 4 ? status : null;
    }

    private static IStatus extractRootCause(IStatus status) {
        IStatus rootCause = MirrorGenerator.extractDeeperRootCause(status);
        return rootCause == null ? status : rootCause;
    }

    private static IArtifactDescriptor getArtifactDescriptor(IArtifactRepository destination, IArtifactKey key, boolean packed) {
        IArtifactDescriptor[] iArtifactDescriptorArray = destination.getArtifactDescriptors(key);
        int n = iArtifactDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactDescriptor candidate = iArtifactDescriptorArray[n2];
            if (MirrorGenerator.isPacked(candidate) ? packed : !packed) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isPacked(IArtifactDescriptor desc) {
        return desc != null && "packed".equals(desc.getProperty("format")) && ProcessingStepHandler.canProcess((IArtifactDescriptor)desc);
    }

    private static void unpack(IArtifactRepository source, IArtifactRepository target, IArtifactDescriptor optimized, IArtifactDescriptor canonical, IProgressMonitor monitor) throws CoreException {
        CanonicalizeRequest request = new CanonicalizeRequest(optimized, canonical, source, target);
        request.perform(monitor);
        IStatus result = request.getResult();
        if (result.getSeverity() != 4 || result.getCode() == 1201) {
            return;
        }
        result = MirrorGenerator.extractRootCause(result);
        throw BuckminsterException.fromMessage((Throwable)result.getException(), (String)"Unable to unpack artifact %s in repository %s: %s", (Object[])new Object[]{optimized.getArtifactKey(), target.getLocation(), result.getMessage()});
    }

    private static void unpackToSibling(IArtifactRepository target, IArtifactDescriptor optimized, IArtifactDescriptor canonical, boolean verifyOnly, IProgressMonitor monitor) throws CoreException {
        CanonicalizeRequest request = new CanonicalizeRequest(optimized, canonical, target);
        request.perform(monitor);
        IStatus result = request.getResult();
        if (result.getSeverity() != 4 || result.getCode() == 1201) {
            if (verifyOnly) {
                target.removeDescriptor(MirrorGenerator.getArtifactDescriptor(target, canonical.getArtifactKey(), false));
            }
            return;
        }
        result = MirrorGenerator.extractRootCause(result);
        throw BuckminsterException.fromMessage((Throwable)result.getException(), (String)"Unable to unpack artifact %s in repository %s: %s", (Object[])new Object[]{optimized.getArtifactKey(), target.getLocation(), result.getMessage()});
    }

    public MirrorGenerator(Builder builder) {
        super(builder);
    }

    public void addUnverifiedRoots(IProgressMonitor monitor) throws CoreException {
        Builder builder = this.getBuilder();
        Buckminster bucky = Buckminster.getDefault();
        Set<IInstallableUnit> unverifiedRoots = builder.getUnverifiedUnits();
        if (unverifiedRoots.isEmpty()) {
            return;
        }
        final Set<IInstallableUnit> unitsToAggregate = builder.getUnverifiedUnits();
        try {
            CompositeMetadataRepository sourceMdr = builder.getSourceComposite();
            PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)sourceMdr, null, true, false, true, false, false);
            IQueryable slice = slicer.slice(unverifiedRoots.toArray(new IInstallableUnit[unverifiedRoots.size()]), monitor);
            MatchQuery adder = new MatchQuery(){

                public boolean isMatch(Object candidate) {
                    unitsToAggregate.add((IInstallableUnit)candidate);
                    return false;
                }
            };
            slice.query((Query)adder, new Collector(), null);
        }
        finally {
            bucky.ungetService((Object)this.mdrMgr);
        }
    }

    public Set<IArtifactKey> getArtifactKeysToExclude() throws CoreException {
        Builder builder = this.getBuilder();
        Aggregator aggregator = builder.getAggregator();
        HashSet<IArtifactKey> keysToExclude = new HashSet<IArtifactKey>();
        EList contribs = aggregator.getContributions();
        for (Contribution contrib : contribs) {
            for (MappedRepository repo : contrib.getRepositories(true)) {
                if (repo.isMirrorArtifacts()) continue;
                for (InstallableUnit iu : ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo).getInstallableUnits()) {
                    keysToExclude.addAll((Collection<IArtifactKey>)iu.getArtifactList());
                }
            }
        }
        return keysToExclude;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        Logger log = Buckminster.getLogger();
        log.info("Starting mirror generation", new Object[0]);
        long start = TimeUtils.getNow();
        Builder builder = this.getBuilder();
        File destination = new File(builder.getBuildRoot(), "final");
        java.net.URI finalURI = Builder.createURI(destination);
        File aggregateDestination = new File(destination, "aggregate");
        java.net.URI aggregateURI = Builder.createURI(aggregateDestination);
        Buckminster bucky = Buckminster.getDefault();
        this.mdrMgr = (IMetadataRepositoryManager)bucky.getService(IMetadataRepositoryManager.class);
        this.arMgr = (IArtifactRepositoryManager)bucky.getService(IArtifactRepositoryManager.class);
        this.arCache = null;
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        boolean artifactErrors = false;
        try {
            String name;
            MetadataRepository childMdr;
            IArtifactRepository tempAr;
            boolean isCleanBuild = builder.isCleanBuild();
            Aggregator aggregator = builder.getAggregator();
            subMon.setTaskName("Mirroring meta-data and artifacts...");
            MonitorUtils.subTask((IProgressMonitor)subMon, (String)"Initializing");
            IArtifactRepository aggregateAr = null;
            if (!isCleanBuild) {
                this.arMgr.removeRepository(finalURI);
                this.arMgr.removeRepository(aggregateURI);
                aggregateDestination.mkdirs();
                File[] fileArray = destination.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File oldLocation = fileArray[n2];
                    if (!oldLocation.equals(aggregateDestination)) {
                        if (oldLocation.equals(new File(destination, "compositeArtifacts.jar"))) {
                            oldLocation.delete();
                        } else {
                            oldLocation.renameTo(new File(aggregateDestination, oldLocation.getName()));
                        }
                    }
                    ++n2;
                }
                try {
                    aggregateAr = this.arMgr.loadRepository(aggregateURI, (IProgressMonitor)subMon.newChild(5));
                }
                catch (ProvisionException oldLocation) {
                    // empty catch block
                }
            }
            if (aggregateAr == null) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("p2.compressed", Boolean.toString(true));
                properties.put("publishPackFilesAsSiblings", Boolean.toString(true));
                String label = builder.getAggregator().getLabel();
                aggregateAr = this.arMgr.createRepository(aggregateURI, String.valueOf(label) + " artifacts", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            }
            MonitorUtils.worked((IProgressMonitor)subMon, (int)5);
            try {
                tempAr = this.arMgr.loadRepository(Builder.createURI(builder.getTempRepositoryFolder()), (IProgressMonitor)subMon.newChild(1));
            }
            catch (ProvisionException e) {
                tempAr = null;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("p2.compressed", Boolean.toString(true));
            String label = aggregator.getLabel();
            IMetadataRepository aggregateMdr = this.mdrMgr.createRepository(aggregateURI, label, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            MonitorUtils.worked((IProgressMonitor)subMon, (int)5);
            this.addUnverifiedRoots((IProgressMonitor)subMon.newChild(5));
            Set<IInstallableUnit> unitsToAggregate = builder.getUnitsToAggregate();
            Set<IArtifactKey> keysToExclude = this.getArtifactKeysToExclude();
            SubMonitor childMonitor = subMon.newChild(900, 6);
            EList contribs = aggregator.getContributions(true);
            MonitorUtils.begin((IProgressMonitor)childMonitor, (int)(contribs.size() * 100 + 20));
            boolean aggregatedMdrIsEmpty = true;
            boolean aggregatedArIsEmpty = true;
            PackedStrategy packedStrategy = aggregator.getPackedStrategy();
            MavenRepositoryHelper mavenHelper = null;
            if (aggregator.isMavenResult()) {
                ArrayList<InstallableUnitMapping> iusToMaven = new ArrayList<InstallableUnitMapping>();
                for (Contribution contrib : contribs) {
                    SubMonitor contribMonitor = childMonitor.newChild(10);
                    EList repos = contrib.getRepositories(true);
                    ArrayList<String> errors = new ArrayList<String>();
                    MonitorUtils.begin((IProgressMonitor)contribMonitor, (int)(repos.size() * 100));
                    for (MappedRepository repo : repos) {
                        if (!repo.isMirrorArtifacts()) {
                            errors.add(String.format("Repository %s must be set to mirror artifacts if maven result is required", repo.getLocation()));
                            MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)100);
                            continue;
                        }
                        childMdr = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo);
                        ArrayList<InstallableUnit> iusToMirror = null;
                        for (InstallableUnit iu : childMdr.getInstallableUnits()) {
                            if (!unitsToAggregate.contains(iu)) continue;
                            if (iusToMirror == null) {
                                iusToMirror = new ArrayList<InstallableUnit>();
                            }
                            iusToMirror.add(iu);
                        }
                        EList allMavenMappings = contrib.getAllMavenMappings();
                        if (iusToMirror != null) {
                            for (IInstallableUnit iInstallableUnit : iusToMirror) {
                                iusToMaven.add(new InstallableUnitMapping(iInstallableUnit, (List)allMavenMappings));
                            }
                        }
                        MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)100);
                    }
                    if (errors.size() > 0) {
                        artifactErrors = true;
                        builder.sendEmail(contrib, errors);
                    }
                    MonitorUtils.done((IProgressMonitor)contribMonitor);
                }
                mavenHelper = MavenManager.createMavenStructure(iusToMaven);
                if (!(aggregateAr instanceof SimpleArtifactRepository)) {
                    throw BuckminsterException.fromMessage((String)"Unexpected repository implementation: Expected %s, found %s", (Object[])new Object[]{SimpleArtifactRepository.class.getName(), aggregateAr.getClass().getName()});
                }
                SimpleArtifactRepository simpleAr = (SimpleArtifactRepository)aggregateAr;
                simpleAr.setRules(mavenHelper.getMappingRules());
                simpleAr.initializeAfterLoad(aggregateURI);
                if (packedStrategy != PackedStrategy.SKIP && packedStrategy != PackedStrategy.UNPACK && packedStrategy != PackedStrategy.UNPACK_AS_SIBLING) {
                    packedStrategy = PackedStrategy.UNPACK_AS_SIBLING;
                    log.info("Maven result is required, changing packed strategy from %s to %s", new Object[]{aggregator.getPackedStrategy().getName(), packedStrategy.getName()});
                }
            } else {
                Object repos;
                ArrayList<String[]> mappingRules = new ArrayList<String[]>();
                ArrayList referencedArtifacts = new ArrayList();
                for (Contribution contrib : contribs) {
                    SubMonitor contribMonitor = childMonitor.newChild(10);
                    repos = contrib.getRepositories(true);
                    ArrayList<String> errors = new ArrayList<String>();
                    MonitorUtils.begin((IProgressMonitor)contribMonitor, (int)(repos.size() * 100));
                    childMdr = repos.iterator();
                    while (childMdr.hasNext()) {
                        void var39_51;
                        MappedRepository repo = (MappedRepository)childMdr.next();
                        int ticksRemaining = 100;
                        if ("p2".equals(repo.getNature())) {
                            MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)100);
                            continue;
                        }
                        MetadataRepository childMdr2 = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo);
                        Object var39_52 = null;
                        for (InstallableUnit iu : childMdr2.getInstallableUnits()) {
                            if (!unitsToAggregate.contains(iu)) continue;
                            if (var39_51 == null) {
                                ArrayList arrayList = new ArrayList();
                            }
                            var39_51.add(iu);
                        }
                        if (var39_51 != null) {
                            int ticks = 50;
                            IArtifactRepository ar = this.getArtifactRepository((MetadataRepositoryReference)repo, (IProgressMonitor)contribMonitor.newChild(ticks));
                            ticksRemaining -= ticks;
                            for (IInstallableUnit iu : var39_51) {
                                String versionString = iu.getVersion().getOriginal();
                                if (versionString == null) {
                                    versionString = iu.getVersion().toString();
                                }
                                String originalPath = iu.getProperty("original.path");
                                String originalId = iu.getProperty("original.id");
                                if (originalId == null) {
                                    originalId = iu.getId();
                                }
                                IArtifactKey[] iArtifactKeyArray = iu.getArtifacts();
                                int n = iArtifactKeyArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IArtifactKey key = iArtifactKeyArray[n2];
                                    if (repo.isMirrorArtifacts()) {
                                        String location = "${repoUrl}/non-p2/" + repo.getNature() + '/' + key.getClassifier() + '/' + (originalPath != null ? String.valueOf(originalPath) + '/' : "") + originalId + '_' + versionString + '.' + key.getClassifier();
                                        mappingRules.add(new String[]{"(& (classifier=" + GeneralUtils.encodeFilterValue((String)key.getClassifier()) + ") (id=" + GeneralUtils.encodeFilterValue((String)key.getId()) + ") (version=" + GeneralUtils.encodeFilterValue((String)iu.getVersion().toString()) + "))", location});
                                    } else {
                                        IArtifactDescriptor[] iArtifactDescriptorArray = ar.getArtifactDescriptors(key);
                                        int n3 = iArtifactDescriptorArray.length;
                                        int n4 = 0;
                                        while (n4 < n3) {
                                            IArtifactDescriptor desc = iArtifactDescriptorArray[n4];
                                            String ref = ((ArtifactDescriptor)desc).getRepositoryProperty("artifact.reference");
                                            ArtifactDescriptor ad = new ArtifactDescriptor(desc);
                                            ad.setRepositoryProperty("artifact.reference", ref);
                                            referencedArtifacts.add(ad);
                                            ++n4;
                                        }
                                    }
                                    ++n2;
                                }
                            }
                        }
                        MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)ticksRemaining);
                    }
                    if (errors.size() > 0) {
                        artifactErrors = true;
                        builder.sendEmail(contrib, errors);
                    }
                    MonitorUtils.done((IProgressMonitor)contribMonitor);
                }
                if (aggregateAr instanceof SimpleArtifactRepository) {
                    SimpleArtifactRepository simpleAr = (SimpleArtifactRepository)aggregateAr;
                    ArrayList ruleList = new ArrayList(Arrays.asList(simpleAr.getRules()));
                    ruleList.addAll(mappingRules);
                    simpleAr.setRules((String[][])ruleList.toArray((T[])new String[ruleList.size()][]));
                    simpleAr.initializeAfterLoad(aggregateURI);
                    repos = referencedArtifacts.iterator();
                    while (repos.hasNext()) {
                        IArtifactDescriptor ad = (IArtifactDescriptor)repos.next();
                        simpleAr.addDescriptor(ad);
                    }
                    simpleAr.save();
                    aggregatedArIsEmpty = false;
                } else {
                    throw BuckminsterException.fromMessage((String)"Unexpected repository implementation: Expected %s, found %s", (Object[])new Object[]{SimpleArtifactRepository.class.getName(), aggregateAr.getClass().getName()});
                }
            }
            for (Contribution contrib : contribs) {
                SubMonitor contribMonitor = childMonitor.newChild(100);
                EList repos = contrib.getRepositories(true);
                ArrayList<String> errors = new ArrayList<String>();
                MonitorUtils.begin((IProgressMonitor)contribMonitor, (int)(repos.size() * 100));
                for (MappedRepository repo : repos) {
                    String msg;
                    if (builder.isMapVerbatim(repo)) {
                        MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)100);
                        continue;
                    }
                    MetadataRepository childMdr3 = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo);
                    ArrayList<InstallableUnit> iusToMirror = null;
                    ArrayList<ArtifactKey> keysToMirror = null;
                    for (InstallableUnit iu : childMdr3.getInstallableUnits()) {
                        if (!unitsToAggregate.remove(iu)) continue;
                        if (iusToMirror == null) {
                            iusToMirror = new ArrayList<InstallableUnit>();
                        }
                        iusToMirror.add(iu);
                        if (!repo.isMirrorArtifacts()) continue;
                        for (ArtifactKey ak : iu.getArtifactList()) {
                            if (!keysToExclude.add((IArtifactKey)ak)) continue;
                            if (keysToMirror == null) {
                                keysToMirror = new ArrayList<ArtifactKey>();
                            }
                            keysToMirror.add(ak);
                        }
                    }
                    if (iusToMirror != null) {
                        msg = String.format("Mirroring meta-data from from %s", childMdr3.getLocation());
                        log.info(msg, new Object[0]);
                        contribMonitor.subTask(msg);
                        this.mirror(iusToMirror, childMdr3, aggregateMdr, (IProgressMonitor)contribMonitor.newChild(5, 6));
                        aggregatedMdrIsEmpty = false;
                    } else {
                        MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)5);
                    }
                    if (keysToMirror != null) {
                        msg = String.format("Mirroring artifacts from from %s", childMdr3.getLocation());
                        log.info(msg, new Object[0]);
                        contribMonitor.subTask(msg);
                        IArtifactRepository iArtifactRepository = this.getArtifactRepository((MetadataRepositoryReference)repo, (IProgressMonitor)contribMonitor.newChild(1, 6));
                        MirrorGenerator.mirror(keysToMirror, tempAr, iArtifactRepository, aggregateAr, packedStrategy, (List<String>)errors, (IProgressMonitor)contribMonitor.newChild(94, 6));
                        aggregatedArIsEmpty = false;
                        continue;
                    }
                    MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)95);
                }
                if (errors.size() > 0) {
                    artifactErrors = true;
                    builder.sendEmail(contrib, errors);
                }
                MonitorUtils.done((IProgressMonitor)contribMonitor);
            }
            List<InstallableUnit> categories = builder.getCategoryIUs();
            if (!categories.isEmpty()) {
                this.mirror(categories, null, aggregateMdr, (IProgressMonitor)childMonitor.newChild(20));
                aggregatedMdrIsEmpty = false;
            }
            new File(destination, "compositeArtifacts.jar").delete();
            new File(destination, "compositeContent.jar").delete();
            new File(destination, "content.jar").delete();
            new File(destination, "artifacts.jar").delete();
            MonitorUtils.worked((IProgressMonitor)childMonitor, (int)10);
            ArrayList<MappedRepository> reposWithReferencedArtifacts = new ArrayList<MappedRepository>();
            ArrayList<MappedRepository> reposWithReferencedMetadata = new ArrayList<MappedRepository>();
            for (Contribution contrib : aggregator.getContributions(true)) {
                for (MappedRepository repo : contrib.getRepositories(true)) {
                    if (builder.isMapVerbatim(repo)) {
                        reposWithReferencedArtifacts.add(repo);
                        reposWithReferencedMetadata.add(repo);
                        continue;
                    }
                    if (repo.isMirrorArtifacts() || !"p2".equals(repo.getNature())) continue;
                    reposWithReferencedArtifacts.add(repo);
                }
            }
            if (mavenHelper != null) {
                log.info("Adding maven metadata", new Object[0]);
                MavenManager.saveMetadata((URI)URI.createFileURI((String)aggregateDestination.getAbsolutePath()), (InstallableUnitMapping)mavenHelper.getTop());
                IMaven2Indexer indexer = IndexerUtils.getIndexer((String)"nexus");
                if (indexer != null) {
                    log.info("Adding maven index", new Object[0]);
                    indexer.updateLocalIndex(new File(aggregateDestination.getAbsolutePath()).toURI(), false);
                }
                MonitorUtils.worked((IProgressMonitor)childMonitor, (int)10);
                log.info("Done adding maven metadata", new Object[0]);
            }
            if (reposWithReferencedMetadata.isEmpty()) {
                log.info("Making the aggregated metadata repository final at %s", new Object[]{finalURI});
                File oldLocation = new File(aggregateDestination, "content.jar");
                File newLocation = new File(destination, oldLocation.getName());
                oldLocation.renameTo(newLocation);
                this.mdrMgr.removeRepository(aggregateURI);
            } else {
                log.info("Building final metadata composite at %s", new Object[]{finalURI});
                properties = new HashMap();
                properties.put("p2.compressed", Boolean.toString(true));
                name = builder.getAggregator().getLabel();
                this.mdrMgr.removeRepository(finalURI);
                CompositeMetadataRepository compositeMdr = (CompositeMetadataRepository)this.mdrMgr.createRepository(finalURI, name, "org.eclipse.equinox.p2.metadata.repository.compositeRepository", properties);
                for (MappedRepository referenced : reposWithReferencedMetadata) {
                    compositeMdr.addChild(referenced.getMetadataRepository().getLocation());
                }
                if (aggregatedMdrIsEmpty) {
                    this.mdrMgr.removeRepository(aggregateURI);
                    File mdrFile = new File(aggregateDestination, "content.jar");
                    mdrFile.delete();
                } else {
                    compositeMdr.addChild(finalURI.relativize(aggregateURI));
                }
                log.info("Done building final metadata composite", new Object[0]);
            }
            MonitorUtils.worked((IProgressMonitor)childMonitor, (int)10);
            if (reposWithReferencedArtifacts.isEmpty()) {
                log.info("Making the aggregated artifact repository final at %s", new Object[]{finalURI});
                String[] stringArray = aggregateDestination.list();
                int mdrFile = stringArray.length;
                int compositeMdr = 0;
                while (compositeMdr < mdrFile) {
                    name = stringArray[compositeMdr];
                    if (!"content.jar".equals(name)) {
                        File oldLocation = new File(aggregateDestination, name);
                        File newLocation = new File(destination, name);
                        oldLocation.renameTo(newLocation);
                        aggregateDestination.delete();
                    }
                    ++compositeMdr;
                }
                this.arMgr.removeRepository(aggregateURI);
            } else {
                log.info("Building final artifact composite at %s", new Object[]{finalURI});
                properties = new HashMap();
                properties.put("p2.compressed", Boolean.toString(true));
                name = builder.getAggregator().getLabel();
                this.arMgr.removeRepository(finalURI);
                CompositeArtifactRepository compositeAr = (CompositeArtifactRepository)this.arMgr.createRepository(finalURI, String.valueOf(name) + " artifacts", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", properties);
                for (MappedRepository referenced : reposWithReferencedArtifacts) {
                    compositeAr.addChild(referenced.getMetadataRepository().getLocation());
                }
                if (aggregatedArIsEmpty) {
                    this.arMgr.removeRepository(aggregateURI);
                    File arFile = new File(aggregateDestination, "artifacts.jar");
                    arFile.delete();
                } else {
                    compositeAr.addChild(finalURI.relativize(aggregateURI));
                }
                log.info("Done building final artifact composite", new Object[0]);
            }
            String[] content = aggregateDestination.list();
            if (content != null && content.length == 0) {
                aggregateDestination.delete();
            }
            MonitorUtils.done((IProgressMonitor)childMonitor);
        }
        finally {
            bucky.ungetService((Object)this.mdrMgr);
            this.mdrMgr = null;
            bucky.ungetService((Object)this.arMgr);
            this.arMgr = null;
            MonitorUtils.done((IProgressMonitor)subMon);
        }
        log.info("Done. Took %s", new Object[]{TimeUtils.getFormattedDuration((long)start)});
        if (artifactErrors) {
            throw BuckminsterException.fromMessage((String)"Not all artifacts could be mirrored, see log for details", (Object[])new Object[0]);
        }
    }

    private IArtifactRepository getArtifactRepository(MetadataRepositoryReference repo, IProgressMonitor monitor) throws CoreException {
        IArtifactRepository ar;
        if (this.arCache == null) {
            this.arCache = new HashMap<MetadataRepositoryReference, IArtifactRepository>();
        }
        if ((ar = this.arCache.get(repo)) == null) {
            IConfigurationElement config = RepositoryLoaderUtils.getLoaderFor((String)repo.getNature());
            if (config == null) {
                throw BuckminsterException.fromMessage((String)"No loader for %s", (Object[])new Object[]{repo.getNature()});
            }
            IRepositoryLoader repoLoader = (IRepositoryLoader)config.createExecutableExtension("class");
            ar = repoLoader.getArtifactRepository((IMetadataRepository)ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo), monitor);
            this.arCache.put(repo, ar);
        }
        return ar;
    }

    private void mirror(List<InstallableUnit> iusToMirror, MetadataRepository source, IMetadataRepository dest, IProgressMonitor monitor) throws CoreException {
        dest.addInstallableUnits(iusToMirror.toArray(new IInstallableUnit[iusToMirror.size()]));
        Builder builder = this.getBuilder();
        if (source != null && builder.isMirrorReferences()) {
            Logger log = Buckminster.getLogger();
            for (RepositoryReference ref : source.getRepositoryReferences()) {
                String refType;
                java.net.URI location = ref.getLocation();
                String refKey = location.toString();
                String string = refType = ref.getType() == 0 ? "meta-data" : "artifacts";
                if (!builder.isMatchedReference(refKey)) {
                    log.debug("- %s reference %s was ruled out by inclusion/exclusion patterns", new Object[]{refType, refKey});
                    continue;
                }
                if (refKey.endsWith("/site.xml")) {
                    location = java.net.URI.create(refKey.substring(0, refKey.length() - 8));
                }
                log.debug("- mirroring %s reference %s", new Object[]{refType, refKey});
                dest.addReference(location, ref.getNickname(), ref.getType(), 0);
            }
        }
    }

    private static class CanonicalizeRequest
    extends MirrorRequest {
        private IArtifactDescriptor optimizedDescriptor;
        private IArtifactDescriptor canonicalDescriptor;

        public CanonicalizeRequest(IArtifactDescriptor optimizedDescriptor, IArtifactDescriptor canonicalDescriptor, IArtifactRepository targetRepository) {
            this(optimizedDescriptor, canonicalDescriptor, targetRepository, targetRepository);
        }

        public CanonicalizeRequest(IArtifactDescriptor optimizedDescriptor, IArtifactDescriptor canonicalDescriptor, IArtifactRepository sourceRepository, IArtifactRepository targetRepository) {
            super(canonicalDescriptor.getArtifactKey(), targetRepository, null, null);
            this.optimizedDescriptor = optimizedDescriptor;
            this.canonicalDescriptor = canonicalDescriptor;
            this.setSourceRepository(sourceRepository);
        }

        public void perform(IProgressMonitor monitor) {
            this.setResult(this.transfer(this.canonicalDescriptor, this.optimizedDescriptor, monitor));
        }
    }
}

