/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.engine;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.buckminster.aggregator.Aggregator;
import org.eclipse.buckminster.aggregator.Contribution;
import org.eclipse.buckminster.aggregator.MappedRepository;
import org.eclipse.buckminster.aggregator.MetadataRepositoryReference;
import org.eclipse.buckminster.aggregator.engine.Builder;
import org.eclipse.buckminster.aggregator.engine.BuilderPhase;
import org.eclipse.buckminster.aggregator.p2.MetadataRepository;
import org.eclipse.buckminster.aggregator.util.ResourceUtils;
import org.eclipse.buckminster.aggregator.util.TimeUtils;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.repository.IRepository;

public class SourceCompositeGenerator
extends BuilderPhase {
    public SourceCompositeGenerator(Builder builder) {
        super(builder);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        Aggregator buildModel = this.getBuilder().getAggregator();
        EList contribs = buildModel.getContributions(true);
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + contribs.size() * 100));
        String info = "Starting generation of composite repository";
        Logger log = Buckminster.getLogger();
        log.info(info, new Object[0]);
        subMon.setTaskName("Generating composite from all sources...");
        long start = TimeUtils.getNow();
        String name = String.valueOf(this.getBuilder().getAggregator().getLabel()) + " Composite";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", Boolean.toString(true));
        boolean errorsFound = false;
        Buckminster bucky = Buckminster.getDefault();
        IMetadataRepositoryManager mdrMgr = (IMetadataRepositoryManager)bucky.getService(IMetadataRepositoryManager.class);
        Builder builder = this.getBuilder();
        URI locationURI = builder.getSourceCompositeURI();
        mdrMgr.removeRepository(locationURI);
        FileUtils.deleteAll((File)new File(builder.getBuildRoot(), "interim"));
        CompositeMetadataRepository compositeMdr = (CompositeMetadataRepository)mdrMgr.createRepository(locationURI, name, "org.eclipse.equinox.p2.metadata.repository.compositeRepository", properties);
        MonitorUtils.worked((IProgressMonitor)subMon, (int)100);
        for (Contribution contrib : contribs) {
            SubMonitor contribMonitor = subMon.newChild(100);
            EList repos = contrib.getRepositories(true);
            MonitorUtils.begin((IProgressMonitor)contribMonitor, (int)(repos.size() * 200));
            ArrayList<String> errors = new ArrayList<String>();
            for (MappedRepository repo : repos) {
                MetadataRepository mdr = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo);
                try {
                    URI childLocation = mdr.getLocation();
                    log.info("Adding child meta-data repository %s", new Object[]{childLocation});
                    if (!"p2".equals(repo.getNature())) {
                        childLocation = this.createLocalMdr(locationURI, mdr).getLocation();
                    }
                    compositeMdr.addChild(childLocation);
                }
                catch (Exception e) {
                    String msg = Builder.getExceptionMessages(e);
                    errors.add(msg);
                    log.error((Throwable)e, msg, new Object[0]);
                }
                contribMonitor.worked(200);
            }
            MonitorUtils.done((IProgressMonitor)contribMonitor);
            if (!errors.isEmpty()) {
                this.getBuilder().sendEmail(contrib, errors);
                errorsFound = true;
            }
            this.getBuilder().setSourceComposite(compositeMdr);
        }
        bucky.ungetService((Object)mdrMgr);
        MonitorUtils.done((IProgressMonitor)subMon);
        log.info("Done. Took %s", new Object[]{TimeUtils.getFormattedDuration((long)start)});
        if (errorsFound) {
            throw BuckminsterException.fromMessage((String)"CompositeRepository generation was not successful", (Object[])new Object[0]);
        }
    }

    private IRepository createLocalMdr(URI locationBase, MetadataRepository mdr) throws URISyntaxException, NoSuchAlgorithmException {
        URI location = new URI(String.valueOf(locationBase.toString()) + "/transformed/" + this.encode(mdr.getLocation().toString()));
        LocalMetadataRepository localMdr = new LocalMetadataRepository(location, mdr.getName(), mdr.getProperties());
        localMdr.setDescription(mdr.getDescription());
        localMdr.setProvider(mdr.getProvider());
        localMdr.addInstallableUnits((IInstallableUnit[])mdr.getInstallableUnits().toArray((Object[])new IInstallableUnit[mdr.getInstallableUnits().size()]));
        localMdr.setProperty("p2.compressed", "true");
        return localMdr;
    }

    private String encode(String location) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        StringBuilder encoded = new StringBuilder();
        byte[] byArray = digest.digest(location.getBytes());
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            encoded.append(String.format("%02x", b));
            ++n2;
        }
        return encoded.toString();
    }
}

