/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.aggregator.Category;
import org.eclipse.buckminster.aggregator.Configuration;
import org.eclipse.buckminster.aggregator.Contribution;
import org.eclipse.buckminster.aggregator.ExclusionRule;
import org.eclipse.buckminster.aggregator.InstallableUnitType;
import org.eclipse.buckminster.aggregator.MapRule;
import org.eclipse.buckminster.aggregator.MappedRepository;
import org.eclipse.buckminster.aggregator.MappedUnit;
import org.eclipse.buckminster.aggregator.MetadataRepositoryReference;
import org.eclipse.buckminster.aggregator.ValidConfigurationsRule;
import org.eclipse.buckminster.aggregator.engine.Builder;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.aggregator.util.InstallableUnitUtils;
import org.eclipse.buckminster.aggregator.util.ResourceUtils;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.core.VersionedName;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerificationFeatureAction
extends AbstractPublisherAction {
    private final Builder builder;
    private final IMetadataRepository mdr;

    private static Filter createFilter(List<Configuration> configs) {
        List<Configuration> enabledConfigs = VerificationFeatureAction.getEnabledConfigs(configs);
        if (enabledConfigs != null && !enabledConfigs.isEmpty()) {
            StringBuilder filterBld = new StringBuilder();
            if (enabledConfigs.size() > 1) {
                filterBld.append("(|");
            }
            for (Configuration config : enabledConfigs) {
                filterBld.append("(&(osgi.os=");
                filterBld.append(config.getOperatingSystem().getLiteral());
                filterBld.append(")(osgi.ws=");
                filterBld.append(config.getWindowSystem().getLiteral());
                filterBld.append(")(osgi.arch=");
                filterBld.append(config.getArchitecture().getLiteral());
                filterBld.append("))");
            }
            if (enabledConfigs.size() > 1) {
                filterBld.append(')');
            }
            try {
                return FilterFactory.newInstance((String)filterBld.toString());
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static List<Configuration> getEnabledConfigs(List<Configuration> configs) {
        ArrayList<Configuration> enabledConfigs = new ArrayList<Configuration>();
        for (Configuration config : configs) {
            if (!config.isEnabled()) continue;
            enabledConfigs.add(config);
        }
        return enabledConfigs;
    }

    public VerificationFeatureAction(Builder builder, IMetadataRepository mdr) {
        this.builder = builder;
        this.mdr = mdr;
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId("all.contributed.content.feature.group");
        iu.setVersion(Builder.ALL_CONTRIBUTED_CONTENT_VERSION);
        iu.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        iu.addProvidedCapabilities(Collections.singletonList(this.createSelfCapability(iu.getId(), iu.getVersion())));
        HashMap<String, Requirement> required = new HashMap<String, Requirement>();
        boolean errorsFound = false;
        EList contribs = this.builder.getAggregator().getContributions();
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 + contribs.size()));
        try {
            HashSet<String> explicit = new HashSet<String>();
            for (Contribution contrib : this.builder.getAggregator().getContributions(true)) {
                ArrayList<String> errors = new ArrayList<String>();
                for (MappedRepository repository : contrib.getRepositories(true)) {
                    EList allIUs;
                    try {
                        allIUs = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repository).getInstallableUnits();
                    }
                    catch (CoreException e) {
                        errors.add(e.getMessage());
                        continue;
                    }
                    if (repository.isMapExclusive()) {
                        for (MappedUnit mu : repository.getUnits(true)) {
                            if (mu instanceof Category) {
                                this.addCategoryContent(mu.getInstallableUnit(), repository, (List<InstallableUnit>)allIUs, required, errors, explicit);
                                continue;
                            }
                            Filter filter = VerificationFeatureAction.createFilter((List<Configuration>)mu.getValidConfigurations());
                            this.addRequirementFor(repository, mu.getInstallableUnit(), filter, required, errors, explicit, true);
                        }
                        continue;
                    }
                    EList mapRules = repository.getMapRules();
                    block9: for (InstallableUnit riu : allIUs) {
                        InstallableUnitType riuType = InstallableUnitUtils.getType((InstallableUnit)riu);
                        if (riuType != InstallableUnitType.PRODUCT && riuType != InstallableUnitType.FEATURE) continue;
                        Filter filter = null;
                        for (MapRule rule : mapRules) {
                            if (rule.getInstallableUnit() != riu) continue;
                            if (rule instanceof ExclusionRule) {
                                this.builder.addMappingExclusion(repository, new VersionedName(riu.getId(), riu.getVersion()), null);
                                continue block9;
                            }
                            if (!(rule instanceof ValidConfigurationsRule)) continue;
                            filter = VerificationFeatureAction.createFilter((List<Configuration>)((ValidConfigurationsRule)rule).getValidConfigurations());
                        }
                        this.addRequirementFor(repository, riu, filter, required, errors, explicit, false);
                    }
                }
                if (errors.size() > 0) {
                    errorsFound = true;
                    this.builder.sendEmail(contrib, errors);
                }
                MonitorUtils.worked((IProgressMonitor)subMon, (int)1);
            }
            if (errorsFound) {
                Status status = new Status(4, "org.eclipse.buckminster.aggregator.engine", "Features without repositories");
                return status;
            }
            IRequiredCapability[] rcArr = new IRequiredCapability[required.size()];
            int idx = 0;
            for (Requirement rc : required.values()) {
                rcArr[idx++] = rc.capability;
            }
            iu.setRequiredCapabilities(rcArr);
            this.mdr.addInstallableUnits(new IInstallableUnit[]{MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu)});
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            MonitorUtils.done((IProgressMonitor)subMon);
        }
    }

    private void addCategoryContent(InstallableUnit category, MappedRepository repository, List<InstallableUnit> allIUs, Map<String, Requirement> required, List<String> errors, Set<String> explicit) {
        IRequiredCapability[] iRequiredCapabilityArray = category.getRequiredCapabilities();
        int n = iRequiredCapabilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                IRequiredCapability rc = iRequiredCapabilityArray[n2];
                for (InstallableUnit riu : allIUs) {
                    if (!riu.satisfies(rc)) continue;
                    if ("true".equalsIgnoreCase(riu.getProperty("org.eclipse.equinox.p2.type.category"))) {
                        this.addCategoryContent(riu, repository, allIUs, required, errors, explicit);
                        break block6;
                    }
                    String filterStr = rc.getFilter();
                    Filter filter = null;
                    if (filterStr != null) {
                        try {
                            filter = FilterFactory.newInstance((String)filterStr);
                        }
                        catch (InvalidSyntaxException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    this.addRequirementFor(repository, riu, filter, required, errors, explicit, false);
                    break block6;
                }
                String error = String.format("Category %s includes a requirement for %s that cannot be fulfilled", category.getId(), rc);
                errors.add(error);
                Buckminster.getLogger().error(error, new Object[0]);
            }
            ++n2;
        }
    }

    private void addRequirementFor(MappedRepository mr, InstallableUnit iu, Filter filter, Map<String, Requirement> requirements, List<String> errors, Set<String> explicit, boolean isExplicit) {
        Logger log = Buckminster.getLogger();
        String id = iu.getId();
        Version v = iu.getVersion();
        if (this.builder.excludeFromVerification((IInstallableUnit)iu)) {
            log.debug("%s/%s excluded from verification", new Object[]{id, v});
            return;
        }
        VersionRange range = null;
        if (!Version.emptyVersion.equals((Object)v)) {
            range = new VersionRange(v, true, v, true);
        }
        Filter iuFilter = filter;
        String iuFilterStr = Trivial.trim((String)iu.getFilter());
        if (iuFilterStr != null && filter != null) {
            try {
                iuFilter = FilterFactory.newInstance((String)iuFilterStr).addFilterWithAnd(filter);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        if (iuFilter != null) {
            iuFilterStr = iuFilter.toString();
        }
        IRequiredCapability rc = MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, (String)iuFilterStr, (boolean)false, (boolean)false);
        Requirement rq = new Requirement();
        rq.repository = mr;
        rq.capability = rc;
        Requirement old = requirements.put(id, rq);
        if (old == null || old.capability.equals((Object)rc)) {
            if (isExplicit) {
                explicit.add(id);
            }
            return;
        }
        Version oldVersion = old.capability.getRange().getMinimum();
        if (explicit.contains(id)) {
            if (!isExplicit) {
                log.debug("%s/%s excluded since version %s is explicitly mapped", new Object[]{id, v, oldVersion});
                this.builder.addMappingExclusion(mr, new VersionedName(id, v), oldVersion);
                requirements.put(id, old);
            } else {
                String error = v.equals((Object)oldVersion) ? String.format("%s/%s is explicitly mapped more then once but with differnet configurations", id, v) : String.format("%s is explicitly mapped using both version %s and %s", id, v, oldVersion);
                errors.add(error);
                log.error(error, new Object[0]);
            }
            return;
        }
        if (isExplicit) {
            log.debug("%s/%s excluded since version %s is explicitly mapped", new Object[]{id, oldVersion, v});
            this.builder.addMappingExclusion(old.repository, new VersionedName(id, oldVersion), v);
            explicit.add(id);
            return;
        }
        int cmp = v.compareTo((Object)oldVersion);
        if (cmp < 0) {
            this.builder.addMappingExclusion(mr, new VersionedName(id, v), oldVersion);
            log.debug("%s/%s excluded since a higher version (%s) was found", new Object[]{id, v, oldVersion});
            requirements.put(id, old);
        } else {
            this.builder.addMappingExclusion(old.repository, new VersionedName(id, oldVersion), v);
            log.debug("%s/%s excluded since a higher version (%s) was found", new Object[]{id, oldVersion, v});
        }
    }

    static class Requirement {
        MappedRepository repository;
        IRequiredCapability capability;

        Requirement() {
        }
    }
}

