/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.engine;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import org.eclipse.buckminster.aggregator.engine.Builder;
import org.eclipse.buckminster.aggregator.engine.BuilderPhase;
import org.eclipse.buckminster.aggregator.engine.VerificationFeatureAction;
import org.eclipse.buckminster.aggregator.util.TimeUtils;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;

public class VerificationFeatureGenerator
extends BuilderPhase {
    public VerificationFeatureGenerator(Builder builder) {
        super(builder);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        Logger log = Buckminster.getLogger();
        long start = TimeUtils.getNow();
        MonitorUtils.begin((IProgressMonitor)monitor, (String)"Verifying Features", (int)100);
        String info = "Starting generation of verification feature";
        log.info(info, new Object[0]);
        MonitorUtils.subTask((IProgressMonitor)monitor, (String)info);
        String name = String.valueOf(this.getBuilder().getAggregator().getLabel()) + " Verification Feature";
        File globalLocation = new File(this.getBuilder().getBuildRoot(), "interim");
        File location = new File(globalLocation, "verification");
        FileUtils.deleteAll((File)location);
        HashMap properties = new HashMap();
        URI locationURI = Builder.createURI(location);
        Buckminster bucky = Buckminster.getDefault();
        IMetadataRepositoryManager mdrMgr = (IMetadataRepositoryManager)bucky.getService(IMetadataRepositoryManager.class);
        try {
            mdrMgr.removeRepository(locationURI);
            IMetadataRepository mdr = mdrMgr.createRepository(locationURI, name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            PublisherInfo pubInfo = new PublisherInfo();
            pubInfo.setMetadataRepository(mdr);
            Publisher publisher = new Publisher((IPublisherInfo)pubInfo);
            IStatus result = publisher.publish(this.createActions(mdr), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
            if (result.getSeverity() == 4) {
                throw new CoreException(result);
            }
            this.getBuilder().getSourceComposite().addChild(mdr.getLocation());
        }
        finally {
            bucky.ungetService((Object)mdrMgr);
            MonitorUtils.done((IProgressMonitor)monitor);
        }
        log.info("Done. Took %s", new Object[]{TimeUtils.getFormattedDuration((long)start)});
    }

    private IPublisherAction[] createActions(IMetadataRepository mdr) {
        return new IPublisherAction[]{new VerificationFeatureAction(this.getBuilder(), mdr)};
    }
}

