/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dependency.visualizer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.parser.IParser;
import org.eclipse.buckminster.ui.dependency.visualizer.Activator;
import org.eclipse.buckminster.ui.dependency.visualizer.Messages;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.FilterControl;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.HighlightPathControl;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.LayoutControl;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.listener.IViewerSettingChangeListener;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.listener.ViewerSettingChangeEvent;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.DependencyViewer;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.DependencyLabelProvider;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.DependencyTreeContentProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;

public class DependencyVisualizer
extends EditorPart {
    private DependencyViewer graphViewer;
    private BillOfMaterials bom;
    private FormToolkit toolkit;
    private TreeViewer treeViewer;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Form form = this.toolkit.createForm(parent);
        form.setText(Messages.DependencyVisualisation);
        parent = form.getBody();
        parent.setLayout((Layout)new GridLayout(2, false));
        SashForm sashForm = new SashForm(parent, 65792);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sashForm);
        this.createNavigationSection((Composite)sashForm);
        Section graphSection = this.toolkit.createSection((Composite)sashForm, 320);
        sashForm.setWeights(new int[]{25, 70});
        graphSection.setText(Messages.Graph);
        graphSection.setLayout((Layout)new FillLayout());
        this.graphViewer = new DependencyViewer((Composite)graphSection, 0);
        this.graphViewer.setInputAndRoot(Collections.singletonList(this.bom));
        graphSection.setClient(this.graphViewer.getControl());
        this.createActionsSection(parent);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.toolkit = new FormToolkit(site.getShell().getDisplay());
        if (input instanceof IFileEditorInput) {
            IFileEditorInput editorInput = (IFileEditorInput)input;
            try {
                IParser parser = CorePlugin.getDefault().getParserFactory().getBillOfMaterialsParser(true);
                InputStream in = editorInput.getFile().getContents();
                this.bom = (BillOfMaterials)parser.parse(editorInput.getName(), in);
                this.setPartName(this.bom.getViewName());
                in.close();
            }
            catch (CoreException e) {
                Activator.getDefault().log(e);
            }
            catch (IOException e) {
                Activator.getDefault().log(e);
            }
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        this.graphViewer.getControl().setFocus();
    }

    private void createActionsSection(Composite parent) {
        Section actions = this.toolkit.createSection(parent, 354);
        actions.setLayout((Layout)new FillLayout());
        ScrolledComposite scroll = new ScrolledComposite((Composite)actions, 512){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return new Point(this.getMinWidth(), 100);
            }
        };
        this.toolkit.adapt((Composite)scroll);
        Composite actionComposite = this.toolkit.createComposite((Composite)scroll);
        GridLayout layout = new GridLayout(1, true);
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        actionComposite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().applyTo((Control)actionComposite);
        Section filterSection = this.toolkit.createSection(actionComposite, 608);
        filterSection.setText(Messages.Filters);
        filterSection.setLayout((Layout)new GridLayout(1, true));
        filterSection.setClient(this.createFilterComposite(filterSection));
        GridDataFactory.fillDefaults().applyTo((Control)filterSection);
        Section layoutSection = this.toolkit.createSection(actionComposite, 608);
        layoutSection.setLayout((Layout)new FillLayout());
        layoutSection.setText(Messages.Layout);
        layoutSection.setClient(this.createLayoutComposite(layoutSection));
        GridDataFactory.fillDefaults().applyTo((Control)layoutSection);
        Section pathSection = this.toolkit.createSection(actionComposite, 608);
        pathSection.setLayout((Layout)new FillLayout());
        pathSection.setText(Messages.PathHighlighting);
        pathSection.setClient(this.createHighlightComposite(pathSection));
        GridDataFactory.fillDefaults().applyTo((Control)pathSection);
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        scroll.setMinSize(actionComposite.computeSize(-1, -1));
        scroll.setContent((Control)actionComposite);
        scroll.layout();
        actions.setClient((Control)scroll);
        actions.setText(Messages.Settings);
        GridDataFactory.fillDefaults().applyTo((Control)actions);
    }

    private Control createFilterComposite(Section filterSection) {
        FilterControl control = new FilterControl(this.toolkit);
        control.addViewerSettingChangeListener(this.graphViewer);
        control.addViewerSettingChangeListener(new IViewerSettingChangeListener(){

            public void viewerSettingChanged(ViewerSettingChangeEvent event) {
                switch (event.getType()) {
                    case FILTER_ADDED: {
                        DependencyVisualizer.this.treeViewer.addFilter((ViewerFilter)event.getData());
                        break;
                    }
                    case FILTER_REMOVED: {
                        DependencyVisualizer.this.treeViewer.removeFilter((ViewerFilter)event.getData());
                        break;
                    }
                }
            }
        });
        return control.createControl((Composite)filterSection);
    }

    private Control createHighlightComposite(Section layoutSection) {
        HighlightPathControl control = new HighlightPathControl(this.toolkit);
        control.addViewerSettingChangeListener(this.graphViewer);
        return control.createControl((Composite)layoutSection);
    }

    private Control createLayoutComposite(Section layoutSection) {
        LayoutControl control = new LayoutControl(this.toolkit);
        control.addViewerSettingChangeListener(this.graphViewer);
        return control.createControl((Composite)layoutSection);
    }

    private void createNavigationSection(Composite parent) {
        Section navigationSection = this.toolkit.createSection(parent, 354);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)navigationSection);
        navigationSection.setText(Messages.Navigation);
        navigationSection.setLayout((Layout)new FillLayout());
        this.treeViewer = new TreeViewer(this.toolkit.createTree((Composite)navigationSection, 0));
        this.treeViewer.setAutoExpandLevel(1);
        this.treeViewer.setUseHashlookup(true);
        navigationSection.setClient(this.treeViewer.getControl());
        final DependencyTreeContentProvider treeContentProvider = new DependencyTreeContentProvider(this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DependencyLabelProvider());
        ArrayList<BillOfMaterials> input = new ArrayList<BillOfMaterials>();
        input.add(this.bom);
        this.treeViewer.setInput(input);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (treeContentProvider.hasChildren(o)) {
                    if (o instanceof BOMNode) {
                        BOMNode node = (BOMNode)o;
                        DependencyVisualizer.this.graphViewer.setInputAndRoot(Collections.singletonList(node));
                    }
                } else if (event.getSelection() instanceof ITreeSelection) {
                    Object nodeParent;
                    ITreeSelection treeSelection = (ITreeSelection)event.getSelection();
                    TreePath[] paths = treeSelection.getPaths();
                    if (paths == null || paths.length == 0) {
                        DependencyVisualizer.this.graphViewer.setInputAndRoot(Collections.singletonList(DependencyVisualizer.this.bom));
                        DependencyVisualizer.this.graphViewer.setSelection((ISelection)new StructuredSelection((Object)DependencyVisualizer.this.bom), true);
                        return;
                    }
                    TreePath path = paths[0].getParentPath();
                    if (path != null && (nodeParent = path.getLastSegment()) instanceof BOMNode) {
                        BOMNode node = (BOMNode)nodeParent;
                        DependencyVisualizer.this.graphViewer.setInputAndRoot(Collections.singletonList(node));
                        DependencyVisualizer.this.graphViewer.setSelection(event.getSelection(), true);
                    }
                }
            }
        });
    }
}

