/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dependency.visualizer.controls;

import org.eclipse.buckminster.ui.dependency.visualizer.Messages;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.AbstractViewerSettingControl;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.listener.ViewerSettingChangeEvent;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.listener.ViewerSettingType;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.DirectedGraphLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalShift;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.VerticalLayoutAlgorithm;

public class LayoutControl
extends AbstractViewerSettingControl {
    private LayoutAlgorithm currentSelection;

    public LayoutControl(FormToolkit toolkit) {
        super(toolkit);
    }

    public Control createControl(Composite parent) {
        Composite layoutComposite = this.getWidgetToolkit().createComposite(parent);
        layoutComposite.setLayout((Layout)new GridLayout(1, true));
        Button spring = this.getWidgetToolkit().createButton(layoutComposite, Messages.SpringLayout, 16);
        Button directed = this.getWidgetToolkit().createButton(layoutComposite, Messages.DirectedLayout, 16);
        Button grid = this.getWidgetToolkit().createButton(layoutComposite, Messages.GridLayout, 16);
        Button horizontal = this.getWidgetToolkit().createButton(layoutComposite, Messages.HorizontalLayout, 16);
        Button vertical = this.getWidgetToolkit().createButton(layoutComposite, Messages.VerticalLayout, 16);
        Button tree = this.getWidgetToolkit().createButton(layoutComposite, Messages.TreeLayout, 16);
        Button horizontalTree = this.getWidgetToolkit().createButton(layoutComposite, Messages.HorizontalTreeLayout, 16);
        Button radial = this.getWidgetToolkit().createButton(layoutComposite, Messages.RadialLayout, 16);
        tree.setSelection(true);
        LayoutAlgorithm algo = this.addHorizontalShift((LayoutAlgorithm)new SpringLayoutAlgorithm(1));
        spring.addSelectionListener((SelectionListener)new LayoutSelectionListener(algo));
        algo = this.addHorizontalShift(this.addHorizontalShift((LayoutAlgorithm)new DirectedGraphLayoutAlgorithm(1)));
        directed.addSelectionListener((SelectionListener)new LayoutSelectionListener(algo));
        algo = this.addHorizontalShift(this.addHorizontalShift((LayoutAlgorithm)new GridLayoutAlgorithm(1)));
        grid.addSelectionListener((SelectionListener)new LayoutSelectionListener(algo));
        algo = this.addHorizontalShift(this.addHorizontalShift((LayoutAlgorithm)new HorizontalLayoutAlgorithm(1)));
        horizontal.addSelectionListener((SelectionListener)new LayoutSelectionListener(algo));
        algo = this.addHorizontalShift(this.addHorizontalShift((LayoutAlgorithm)new VerticalLayoutAlgorithm(1)));
        vertical.addSelectionListener((SelectionListener)new LayoutSelectionListener(algo));
        this.currentSelection = algo = this.addHorizontalShift(this.addHorizontalShift((LayoutAlgorithm)new TreeLayoutAlgorithm(1)));
        tree.addSelectionListener((SelectionListener)new LayoutSelectionListener(algo));
        algo = this.addHorizontalShift(this.addHorizontalShift((LayoutAlgorithm)new HorizontalTreeLayoutAlgorithm(1)));
        horizontalTree.addSelectionListener((SelectionListener)new LayoutSelectionListener(algo));
        algo = this.addHorizontalShift(this.addHorizontalShift((LayoutAlgorithm)new RadialLayoutAlgorithm(1)));
        radial.addSelectionListener((SelectionListener)new LayoutSelectionListener(algo));
        this.fireViewerSettingsChangedEvent(new ViewerSettingChangeEvent(this, ViewerSettingType.LAYOUT_CHANGED, this.currentSelection, null));
        return layoutComposite;
    }

    private LayoutAlgorithm addHorizontalShift(LayoutAlgorithm layoutAlgorithm) {
        return new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{layoutAlgorithm, new HorizontalShift(1)});
    }

    class LayoutSelectionListener
    extends SelectionAdapter {
        private LayoutAlgorithm algorithm;

        public LayoutSelectionListener(LayoutAlgorithm algorithm) {
            this.algorithm = algorithm;
        }

        public void widgetSelected(SelectionEvent e) {
            if (LayoutControl.this.currentSelection != this.algorithm) {
                LayoutControl.this.currentSelection = this.algorithm;
                LayoutControl.this.fireViewerSettingsChangedEvent(new ViewerSettingChangeEvent(LayoutControl.this, ViewerSettingType.LAYOUT_CHANGED, this.algorithm, LayoutControl.this.currentSelection));
            }
        }
    }
}

