/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dependency.visualizer.viewer;

import java.util.List;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.ui.dependency.visualizer.Messages;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.listener.IViewerSettingChangeListener;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.listener.ViewerSettingChangeEvent;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.DirtyViewCSpecAction;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.DependencyContentProvider;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.DependencyLabelProvider;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.IDependencyVisualizationLabelProvider;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.IRelationshipProvider;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.SimpleDependencyVisualizationLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.layouts.LayoutAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyViewer
extends GraphViewer
implements IViewerSettingChangeListener {
    private IDependencyVisualizationLabelProvider labelProvider;

    public DependencyViewer(Composite composite, int style) {
        super(composite, 0);
        this.setConnectionStyle(2);
        this.labelProvider = new SimpleDependencyVisualizationLabelProvider((ILabelProvider)new DependencyLabelProvider(), this);
        this.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.setContentProvider((IContentProvider)new DependencyContentProvider());
        this.getGraphControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DependencyViewer.this.labelProvider.dispose();
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel;
                Object o;
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    DependencyViewer.this.labelProvider.highlightSelection(null);
                }
                if (selection instanceof IStructuredSelection && (o = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof BOMNode) {
                    BOMNode node = (BOMNode)o;
                    DependencyViewer.this.labelProvider.highlightSelection(node);
                }
            }
        });
        this.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (o instanceof BOMNode) {
                    BOMNode node = (BOMNode)o;
                    DirtyViewCSpecAction action = new DirtyViewCSpecAction();
                    action.run(node.getResolution().getCSpec(), PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
            }
        });
    }

    public void setInputAndRoot(List<? extends BOMNode> input) {
        if (input.size() != 1) {
            throw new IllegalArgumentException(Messages.ListMustContainExactlyOneBom);
        }
        this.labelProvider.clear();
        this.setInput(input);
        BOMNode node = input.get(0);
        this.labelProvider.setRoot(node);
        this.labelProvider.highlightSelection(null);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        IStructuredSelection sel;
        Object o;
        super.setSelection(selection, reveal);
        if (selection.isEmpty()) {
            this.labelProvider.highlightSelection(null);
        }
        if (selection instanceof IStructuredSelection && (o = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof BOMNode) {
            BOMNode node = (BOMNode)o;
            this.labelProvider.highlightSelection(node);
        }
    }

    @Override
    public void viewerSettingChanged(ViewerSettingChangeEvent event) {
        switch (event.getType()) {
            case PATH_HIGHLIGHTING: {
                this.setRelationshipProvider((IRelationshipProvider)event.getData());
                break;
            }
            case FILTER_ADDED: {
                this.addFilter((ViewerFilter)event.getData());
                this.applyLayout();
                break;
            }
            case FILTER_REMOVED: {
                this.removeFilter((ViewerFilter)event.getData());
                this.applyLayout();
                break;
            }
            case LAYOUT_CHANGED: {
                this.setLayoutAlgorithm((LayoutAlgorithm)event.getData());
                this.applyLayout();
            }
        }
    }

    private void setRelationshipProvider(IRelationshipProvider provider) {
        this.labelProvider.setRelationshipProvider(provider);
    }
}

