/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dependency.visualizer.viewer.figures;

import java.text.DateFormat;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.ui.dependency.visualizer.Messages;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.DependencyLabelProvider;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.swt.graphics.Image;

public class BOMNodeTooltipFigure
extends RectangleFigure {
    private BOMNode node;

    public BOMNodeTooltipFigure(BOMNode node) {
        this.node = node;
        this.setBackgroundColor(ColorConstants.tooltipBackground);
        this.setForegroundColor(ColorConstants.tooltipForeground);
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.setBorder((Border)new MarginBorder(5, 5, 5, 5));
        this.add(this.createHeadFigure(), BorderLayout.TOP);
        this.add(this.createBodyFigure(), BorderLayout.CENTER);
    }

    private IFigure createBodyFigure() {
        Figure figure = new Figure();
        figure.setBorder((Border)new SchemeBorder(SchemeBorder.SCHEMES.RIDGED));
        figure.setLayoutManager((LayoutManager)new GridLayout(2, false));
        Resolution resolution = this.node.getResolution();
        if (resolution != null) {
            VersionRange designator;
            Label label = new Label(Messages.Type);
            figure.add((IFigure)label);
            label = new Label(resolution.getComponentTypeId());
            figure.add((IFigure)label);
            if (resolution.getVersion() != null) {
                label = new Label(Messages.Version);
                figure.add((IFigure)label);
                label = new Label(resolution.getVersionMatch().toString());
                figure.add((IFigure)label);
            }
            if ((designator = this.node.getRequest().getVersionRange()) != null) {
                label = new Label(Messages.VersionRange);
                figure.add((IFigure)label);
                label = new Label(designator.toString());
                figure.add((IFigure)label);
            }
            label = new Label(Messages.ReaderType);
            figure.add((IFigure)label);
            label = new Label(this.node.getResolution().getReaderTypeId());
            figure.add((IFigure)label);
            if (resolution.getRepository() != null) {
                label = new Label(Messages.Repository);
                figure.add((IFigure)label);
                label = new Label(this.node.getResolution().getRepository());
                figure.add((IFigure)label);
            }
            if (resolution.getMatchedBranchOrTag() != null) {
                VersionSelector selector = resolution.getMatchedBranchOrTag();
                label = selector.getType() == 0 ? new Label(Messages.Branch) : new Label(Messages.Tag);
                figure.add((IFigure)label);
                label = new Label(resolution.getMatchedBranchOrTag().getName());
                figure.add((IFigure)label);
            }
            if (resolution.getSelectedRevision() != 0L && resolution.getSelectedRevision() != -1L) {
                label = new Label(Messages.SelectedRevision);
                figure.add((IFigure)label);
                label = new Label(Long.toString(resolution.getSelectedRevision()));
                figure.add((IFigure)label);
            }
            if (resolution.getSelectedTimestamp() != null) {
                label = new Label(Messages.SelectedDate);
                figure.add((IFigure)label);
                label = new Label(DateFormat.getInstance().format(resolution.getSelectedTimestamp()));
                figure.add((IFigure)label);
            }
        } else {
            ComponentRequest request = this.node.getRequest();
            Label label = new Label(Messages.Type);
            figure.add((IFigure)label);
            label = new Label(request.getComponentTypeID());
            figure.add((IFigure)label);
            VersionRange designator = this.node.getRequest().getVersionRange();
            if (designator != null) {
                label = new Label(Messages.VersionRange);
                figure.add((IFigure)label);
                label = new Label(designator.toString());
                figure.add((IFigure)label);
            }
            label = new Label(Messages.UnresolvedNode);
            figure.add((IFigure)label);
        }
        return figure;
    }

    private IFigure createHeadFigure() {
        DependencyLabelProvider provider = new DependencyLabelProvider();
        Image image = provider.getImage(this.node);
        String text = provider.getText(this.node);
        Label label = new Label(text, image);
        return label;
    }
}

