/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.ui.dependency.visualizer.connections.ConnectionCategory;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.figures.BOMNodeTooltipFigure;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.IDependencyVisualizationLabelProvider;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.IRelationshipProvider;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.zest.core.viewers.GraphViewer;

public class SimpleDependencyVisualizationLabelProvider
implements IDependencyVisualizationLabelProvider {
    private BOMNode root;
    private BOMNode selection;
    private ILabelProvider baseLabelProvider;
    private IRelationshipProvider relationshipProvider;
    private GraphViewer graphViewer;
    private Map<BOMNode, ConnectionCategory> interestingNodes = new HashMap<BOMNode, ConnectionCategory>();
    private Map<EntityConnectionData, ConnectionCategory> interestingConnections = new HashMap<EntityConnectionData, ConnectionCategory>();
    public Color BLACK = new Color((Device)Display.getDefault(), 0, 0, 0);
    public Color WHITE = new Color((Device)Display.getDefault(), 255, 255, 255);
    public Color USAGE_COLOR = new Color((Device)Display.getDefault(), 100, 100, 250);
    public Color DEPENDENCY_COLOR = new Color((Device)Display.getDefault(), 255, 196, 0);
    public Color PATH_TO_ROOT_COLOR = new Color((Device)Display.getDefault(), 0, 127, 0);
    public Color SELECTION_COLOR = new Color((Device)Display.getDefault(), 255, 255, 0);
    public Color DEFAULT_CONNECTION_COLOR = new Color((Device)Display.getDefault(), 220, 220, 220);
    public Color HIGHLIGHT_CONNECTION_COLOR = new Color((Device)Display.getDefault(), 255, 0, 0);
    public Color UNRESOLVED_NODE_COLOR = new Color((Device)Display.getDefault(), 255, 0, 0);
    public Color ROOT_REQUEST_COLOR = new Color((Device)Display.getDefault(), 180, 255, 180);
    public Color DEFAULT_NODE_COLOR = new Color((Device)Display.getDefault(), 216, 228, 248);
    public Color DEFAULT_BORDER_COLOR = new Color((Device)Display.getDefault(), 0, 255, 0);
    public Color DEFAULT_BORDER_HIGHLIGHT_COLOR = new Color((Device)Display.getDefault(), 255, 255, 0);

    public SimpleDependencyVisualizationLabelProvider(ILabelProvider baseLabelProvider, GraphViewer viewer) {
        this.baseLabelProvider = baseLabelProvider;
        this.graphViewer = viewer;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void clear() {
        this.unreveal(this.selection);
        this.interestingConnections.clear();
        this.interestingNodes.clear();
        this.root = null;
        this.selection = null;
    }

    public void dispose() {
        this.BLACK.dispose();
        this.WHITE.dispose();
        this.DEFAULT_BORDER_COLOR.dispose();
        this.DEFAULT_BORDER_HIGHLIGHT_COLOR.dispose();
        this.DEFAULT_CONNECTION_COLOR.dispose();
        this.DEFAULT_NODE_COLOR.dispose();
        this.DEPENDENCY_COLOR.dispose();
        this.HIGHLIGHT_CONNECTION_COLOR.dispose();
        this.PATH_TO_ROOT_COLOR.dispose();
        this.SELECTION_COLOR.dispose();
        this.UNRESOLVED_NODE_COLOR.dispose();
        this.USAGE_COLOR.dispose();
    }

    public boolean fisheyeNode(Object entity) {
        if (this.root == entity) {
            return true;
        }
        return this.selection == entity;
    }

    public Color getBackgroundColour(Object entity) {
        BOMNode node;
        if (entity instanceof BOMNode && (node = (BOMNode)entity).getResolution() == null) {
            return this.UNRESOLVED_NODE_COLOR;
        }
        if (entity == this.root) {
            return this.ROOT_REQUEST_COLOR;
        }
        if (entity == this.selection) {
            return this.SELECTION_COLOR;
        }
        return this.DEFAULT_NODE_COLOR;
    }

    public Color getBorderColor(Object entity) {
        return this.DEFAULT_BORDER_COLOR;
    }

    public Color getBorderHighlightColor(Object entity) {
        return this.DEFAULT_BORDER_HIGHLIGHT_COLOR;
    }

    public int getBorderWidth(Object entity) {
        return 0;
    }

    public Color getColor(Object rel) {
        ConnectionCategory type = this.interestingConnections.get(rel);
        if (type == null) {
            return this.DEFAULT_CONNECTION_COLOR;
        }
        switch (type) {
            case DEPENDENCY: {
                return this.DEPENDENCY_COLOR;
            }
            case USAGE: {
                return this.USAGE_COLOR;
            }
            case PATH_TO_ROOT: {
                return this.PATH_TO_ROOT_COLOR;
            }
        }
        return this.DEFAULT_CONNECTION_COLOR;
    }

    public int getConnectionStyle(Object rel) {
        if (this.interestingConnections.containsKey(rel)) {
            return 10;
        }
        return 2;
    }

    public Color getForegroundColour(Object entity) {
        ConnectionCategory category = this.interestingNodes.get(entity);
        if (category == null || entity == this.selection || entity == this.root) {
            return this.BLACK;
        }
        switch (category) {
            case PATH_TO_ROOT: {
                return this.WHITE;
            }
        }
        return this.BLACK;
    }

    public Color getHighlightColor(Object rel) {
        return this.HIGHLIGHT_CONNECTION_COLOR;
    }

    public Image getImage(Object element) {
        return this.baseLabelProvider.getImage(element);
    }

    public int getLineWidth(Object rel) {
        if (this.interestingConnections.containsKey(rel)) {
            return 2;
        }
        return -1;
    }

    public Color getNodeHighlightColor(Object entity) {
        if (entity == this.root) {
            return this.ROOT_REQUEST_COLOR;
        }
        if (entity == this.selection) {
            return this.SELECTION_COLOR;
        }
        ConnectionCategory category = this.interestingNodes.get(entity);
        if (category == null) {
            return this.DEFAULT_NODE_COLOR;
        }
        switch (category) {
            case DEPENDENCY: {
                return this.DEPENDENCY_COLOR;
            }
            case USAGE: {
                return this.USAGE_COLOR;
            }
            case PATH_TO_ROOT: {
                return this.PATH_TO_ROOT_COLOR;
            }
        }
        return this.DEFAULT_NODE_COLOR;
    }

    public String getText(Object element) {
        return this.baseLabelProvider.getText(element);
    }

    public IFigure getTooltip(Object entity) {
        if (entity instanceof BOMNode) {
            BOMNode node = (BOMNode)entity;
            return new BOMNodeTooltipFigure(node);
        }
        return null;
    }

    public void highlightSelection(BOMNode nodeSelection) {
        if (nodeSelection == this.selection) {
            return;
        }
        this.highlightSelectionInternal(nodeSelection);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void setRelationshipProvider(IRelationshipProvider provider) {
        this.relationshipProvider = provider;
        this.highlightSelectionInternal(this.selection);
    }

    public void setRoot(BOMNode node) {
        BOMNode previousRoot = this.root;
        this.root = node;
        if (previousRoot != null) {
            this.graphViewer.unReveal((Object)previousRoot);
            this.graphViewer.update((Object)previousRoot, null);
        }
        if (this.root != null) {
            this.graphViewer.reveal((Object)this.root);
            this.graphViewer.update((Object)this.root, null);
        }
    }

    private void highlightSelectionInternal(BOMNode nodeSelection) {
        BOMNode previousSelection = this.selection;
        this.selection = nodeSelection;
        this.unreveal(previousSelection);
        if (nodeSelection == null) {
            return;
        }
        Object[] connections = this.graphViewer.getConnectionElements();
        this.interestingConnections = new HashMap<EntityConnectionData, ConnectionCategory>(this.relationshipProvider.getInterestingRelationships(this.root, nodeSelection, connections));
        this.interestingNodes.clear();
        for (Map.Entry<EntityConnectionData, ConnectionCategory> entry : this.interestingConnections.entrySet()) {
            EntityConnectionData data = entry.getKey();
            BOMNode dest = (BOMNode)data.dest;
            BOMNode source = (BOMNode)data.source;
            this.interestingNodes.put(dest, entry.getValue());
            this.interestingNodes.put(source, entry.getValue());
            this.graphViewer.reveal((Object)dest);
            this.graphViewer.reveal((Object)source);
        }
        ArrayList<Object> objectsToUpdate = new ArrayList<Object>(this.interestingConnections.size() + this.interestingNodes.size());
        objectsToUpdate.addAll(this.interestingConnections.keySet());
        objectsToUpdate.addAll(this.interestingNodes.keySet());
        objectsToUpdate.add(this.root);
        objectsToUpdate.add(nodeSelection);
        this.graphViewer.update(objectsToUpdate.toArray(), null);
    }

    private void unreveal(Object previousSelection) {
        Iterator<BOMNode> nodeIterator = this.interestingNodes.keySet().iterator();
        while (nodeIterator.hasNext()) {
            BOMNode node = nodeIterator.next();
            nodeIterator.remove();
            this.graphViewer.unReveal((Object)node);
            this.graphViewer.update((Object)node, null);
        }
        if (this.root != null) {
            this.graphViewer.update((Object)this.root, null);
        }
        if (previousSelection != null) {
            this.graphViewer.unReveal(previousSelection);
            this.graphViewer.update(previousSelection, null);
        }
        Iterator<EntityConnectionData> connectionIterator = this.interestingConnections.keySet().iterator();
        while (connectionIterator.hasNext()) {
            EntityConnectionData entityConnectionData = connectionIterator.next();
            connectionIterator.remove();
            this.graphViewer.unReveal((Object)entityConnectionData);
            this.graphViewer.update((Object)entityConnectionData, null);
        }
    }
}

