/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.opml.builder;

import java.net.URI;
import java.util.Date;
import org.eclipse.buckminster.opml.IOutline;
import org.eclipse.buckminster.opml.OutlineType;
import org.eclipse.buckminster.opml.builder.BodyBuilder;

public class OutlineBuilder
extends BodyBuilder
implements IOutline {
    private boolean m_breakpoint;
    private String m_category;
    private boolean m_comment;
    private Date m_created;
    private String m_description;
    private URI m_htmlUrl;
    private String m_language;
    private String m_text;
    private String m_title;
    private String m_typeString;
    private URI m_url;
    private String m_version;
    private URI m_xmlUrl;

    public void clear() {
        super.clear();
        this.m_breakpoint = false;
        this.m_category = null;
        this.m_comment = false;
        this.m_created = null;
        this.m_description = null;
        this.m_htmlUrl = null;
        this.m_language = null;
        this.m_text = null;
        this.m_title = null;
        this.m_typeString = null;
        this.m_url = null;
        this.m_version = null;
        this.m_xmlUrl = null;
    }

    public String getCategory() {
        return this.m_category;
    }

    public Date getCreated() {
        return this.m_created;
    }

    public String getDescription() {
        return this.m_description;
    }

    public URI getHtmlUrl() {
        return this.m_htmlUrl;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public String getText() {
        return this.m_text;
    }

    public String getTitle() {
        return this.m_title;
    }

    public OutlineType getType() {
        OutlineType type;
        if (this.m_typeString == null) {
            type = OutlineType.TEXT;
        } else {
            String tmp = this.m_typeString.toUpperCase();
            try {
                if ("TEXT/X-OPML".equals(tmp)) {
                    tmp = "OPML";
                }
                type = OutlineType.valueOf(tmp);
            }
            catch (IllegalArgumentException e) {
                type = OutlineType.UNKNOWN;
            }
        }
        return type;
    }

    public String getTypeString() {
        return this.m_typeString;
    }

    public URI getUrl() {
        return this.m_url;
    }

    public String getVersion() {
        return this.m_version;
    }

    public URI getXmlUrl() {
        return this.m_xmlUrl;
    }

    public void initFrom(IOutline outline) {
        super.initFrom(outline);
        this.m_breakpoint = outline.isBreakpoint();
        this.m_category = outline.getCategory();
        this.m_comment = outline.isComment();
        this.m_created = outline.getCreated();
        this.m_description = outline.getDescription();
        this.m_htmlUrl = outline.getHtmlUrl();
        this.m_language = outline.getLanguage();
        this.m_text = outline.getText();
        this.m_title = outline.getTitle();
        this.m_typeString = outline.getTypeString();
        this.m_url = outline.getUrl();
        this.m_version = outline.getVersion();
        this.m_xmlUrl = outline.getXmlUrl();
    }

    public boolean isBreakpoint() {
        return this.m_breakpoint;
    }

    public boolean isComment() {
        return this.m_comment;
    }

    public void setBreakpoint(boolean breakpoint) {
        this.m_breakpoint = breakpoint;
    }

    public void setCategory(String category) {
        this.m_category = category;
    }

    public void setComment(boolean comment) {
        this.m_comment = comment;
    }

    public void setCreated(Date created) {
        this.m_created = created;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setHtmlUrl(URI htmlUrl) {
        this.m_htmlUrl = htmlUrl;
    }

    public void setLanguage(String language) {
        this.m_language = language;
    }

    public void setText(String text) {
        this.m_text = text;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setTypeString(String type) {
        this.m_typeString = type;
    }

    public void setUrl(URI url) {
        this.m_url = url;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public void setXmlUrl(URI xmlUrl) {
        this.m_xmlUrl = xmlUrl;
    }
}

