/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.ui.manifest;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.DataSetUIElement;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.UIExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

public class UIManifestExplorer {
    private static UIManifestExplorer sm_instance = null;
    private static final String DTP_ODA_UI_EXT_POINT = "org.eclipse.datatools.connectivity.oda.design.ui.dataSource";
    private static final String UI_PROPERTY_PAGE_EXT_PT = "org.eclipse.ui.propertyPages";
    private static final String PAGE_ELEMENT_NAME = "page";
    private Hashtable m_manifests;
    private static String sm_loggerName;
    private static Logger sm_logger;

    public static UIManifestExplorer getInstance() {
        if (sm_instance == null) {
            sm_instance = new UIManifestExplorer();
            sm_instance.refresh();
            sm_loggerName = sm_instance.getClass().getPackage().getName();
            sm_logger = Logger.getLogger(sm_loggerName);
        }
        return sm_instance;
    }

    private UIManifestExplorer() {
    }

    public void refresh() {
        this.m_manifests = new Hashtable();
    }

    public UIExtensionManifest getExtensionManifest(String dataSourceId) throws OdaException {
        UIExtensionManifest manifest = this.getExtensionManifest(dataSourceId, DTP_ODA_UI_EXT_POINT);
        return manifest;
    }

    public DataSetUIElement getDataSetUIElement(String dataSourceId, String dataSetElementID) throws OdaException {
        UIExtensionManifest manifest = this.getExtensionManifest(dataSourceId);
        if (manifest == null) {
            throw new OdaException((Throwable)new IllegalArgumentException(dataSourceId));
        }
        return manifest.getDataSetUIElement(dataSetElementID);
    }

    private UIExtensionManifest getExtensionManifest(String dataSourceId, String extensionPoint) throws OdaException {
        if (dataSourceId == null || dataSourceId.length() == 0) {
            throw new OdaException((Throwable)new IllegalArgumentException(dataSourceId));
        }
        if (extensionPoint == null || extensionPoint.length() == 0) {
            throw new OdaException((Throwable)new IllegalArgumentException(extensionPoint));
        }
        UIExtensionManifest aManifest = (UIExtensionManifest)this.m_manifests.get(dataSourceId);
        if (aManifest != null) {
            return aManifest;
        }
        IExtension[] extensions = UIManifestExplorer.getExtensions(extensionPoint);
        IExtension extension = this.findExtension(dataSourceId, extensions);
        if (extension == null) {
            return null;
        }
        aManifest = new UIExtensionManifest(extension);
        this.m_manifests.put(dataSourceId, aManifest);
        return aManifest;
    }

    private IExtension findExtension(String dataSourceId, IExtension[] extensions) throws OdaException {
        int length = extensions == null ? 0 : extensions.length;
        for (int i = 0; i < length; ++i) {
            IExtension extension = extensions[i];
            String extnDataSourceId = null;
            try {
                IConfigurationElement dataSourceElement = UIManifestExplorer.getNamedElement(extension, "dataSourceUI");
                extnDataSourceId = dataSourceElement.getAttribute("id");
            }
            catch (OdaException ex) {
                sm_logger.log(Level.WARNING, "Ignoring invalid extension.", ex);
                continue;
            }
            if (extnDataSourceId == null || !extnDataSourceId.equalsIgnoreCase(dataSourceId)) continue;
            return extension;
        }
        return null;
    }

    public IConfigurationElement getPropertyPageElement(String odaDataSourceId) {
        String odaUIPluginId = this.getOdaDesignerId(odaDataSourceId);
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtension[] extensions = pluginRegistry.getExtensions(odaUIPluginId);
        for (int i = 0; i < extensions.length; ++i) {
            String extnPointId = extensions[i].getExtensionPointUniqueIdentifier();
            if (!extnPointId.equals(UI_PROPERTY_PAGE_EXT_PT)) continue;
            try {
                IConfigurationElement element = UIManifestExplorer.getNamedElement(extensions[i], PAGE_ELEMENT_NAME);
                if (!odaDataSourceId.equals(element.getAttribute("id"))) continue;
                return element;
            }
            catch (OdaException e) {
                // empty catch block
            }
        }
        return null;
    }

    public String getOdaDesignerId(String odaDataSourceId) {
        UIExtensionManifest manifest;
        try {
            manifest = this.getExtensionManifest(odaDataSourceId);
        }
        catch (Exception e) {
            return null;
        }
        return manifest == null ? null : manifest.getNamespace();
    }

    private static IExtension[] getExtensions(String extPoint) {
        return ManifestExplorer.getExtensions((String)extPoint);
    }

    static IConfigurationElement getNamedElement(IExtension extension, String elementName) throws OdaException {
        return ManifestExplorer.getNamedElement((IExtension)extension, (String)elementName);
    }

    static IConfigurationElement[] getNamedElements(IExtension extension, String elementName) throws OdaException {
        return ManifestExplorer.getNamedElements((IExtension)extension, (String)elementName);
    }
}

