/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.valueexpr;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.valueexpr.AtomicValueExpression;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataTypeMapping;

public class SimpleValueExpression
extends AtomicValueExpression {
    private Object m_value;

    public SimpleValueExpression(Object value) {
        this.m_value = value;
        this.setOdaDataType(SimpleValueExpression.getValueOdaDataType(value));
    }

    public Object getValue() {
        return this.m_value;
    }

    public String getName() {
        return String.valueOf(this.m_value);
    }

    public ExpressionVariable.VariableType getVariableType() {
        return this.m_value instanceof String ? ExpressionVariable.VariableType.QUERY_EXPRESSION : ExpressionVariable.VariableType.INSTANCE_OF;
    }

    public void validateSyntax(ValidationContext context) throws OdaException {
    }

    private static Integer getValueOdaDataType(Object exprValue) {
        int odaDataType = DataTypeMapping.getOdaDataTypeCodeOfObject(exprValue);
        return odaDataType == 0 ? null : Integer.valueOf(odaDataType);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(String.valueOf(this.getClass().getSimpleName()) + " ");
        buffer.append("value: " + this.getValue() == null ? " " : this.getValue().getClass().getSimpleName());
        buffer.append(" " + this.getName());
        return buffer.toString();
    }
}

