/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.internal.core;

import org.eclipse.datatools.sqltools.plan.IExecutionPlanDocument;
import org.eclipse.datatools.sqltools.plan.PlanRequest;
import org.eclipse.datatools.sqltools.plan.internal.IPlanInstance;
import org.eclipse.datatools.sqltools.plan.internal.core.PlanManager;

public class PlanInstance
implements IPlanInstance {
    private Throwable _failThrowable = null;
    private PlanManager _planManager;
    private PlanRequest _planRequest;
    private String _rawPlan;
    private int _status = 0;
    private IExecutionPlanDocument[] _planDocs;

    public PlanInstance(PlanManager planManager, PlanRequest planRequest) {
        this._planManager = planManager;
        this._planRequest = planRequest;
    }

    public void finishFail(Throwable th) {
        this._status = 2;
        this._failThrowable = th;
        if (this._planManager != null) {
            this._planManager.fireFinish(this);
        }
    }

    public void finishSuccess(String rawPlan) {
        this._status = 1;
        this._rawPlan = rawPlan;
        if (this._planManager != null) {
            this._planManager.fireFinish(this);
        }
    }

    public Throwable getFailThrowable() {
        return this._failThrowable;
    }

    public PlanRequest getPlanRequest() {
        return this._planRequest;
    }

    public String getRawPlan() {
        return this._rawPlan;
    }

    public int getStatus() {
        return this._status;
    }

    public boolean isFinished() {
        return this._status != 0;
    }

    public void setPlanRequest(PlanRequest planRequest) {
        this._planRequest = planRequest;
    }

    public void setRawPlan(String plan) {
        this._rawPlan = plan;
    }

    public IExecutionPlanDocument[] getPlanDocuments() {
        return this._planDocs;
    }

    public void setPlanDocuments(IExecutionPlanDocument[] docs) {
        this._planDocs = docs;
    }
}

